/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.block.BlockData;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.block.Block;

public class UndoRegistry {
    protected Map<Long, com.elmakers.mine.bukkit.api.block.BlockData> modified = new HashMap<Long, com.elmakers.mine.bukkit.api.block.BlockData>();
    protected Map<Long, com.elmakers.mine.bukkit.api.block.BlockData> watching = new HashMap<Long, com.elmakers.mine.bukkit.api.block.BlockData>();
    protected Map<Long, Double> reflective = new HashMap<Long, Double>();
    protected Map<Long, Double> breakable = new HashMap<Long, Double>();
    protected Map<Long, Double> breaking = new HashMap<Long, Double>();

    public void registerModified(com.elmakers.mine.bukkit.api.block.BlockData blockData) {
        com.elmakers.mine.bukkit.api.block.BlockData priorState = this.modified.get(blockData.getId());
        if (priorState != null) {
            priorState.setNextState(blockData);
            blockData.setPriorState(priorState);
        }
        this.modified.put(blockData.getId(), blockData);
    }

    public void registerWatched(com.elmakers.mine.bukkit.api.block.BlockData blockData) {
        com.elmakers.mine.bukkit.api.block.BlockData priorState = this.watching.get(blockData.getId());
        if (priorState != null) {
            priorState.setNextState(blockData);
            blockData.setPriorState(priorState);
        }
        this.watching.put(blockData.getId(), blockData);
    }

    public void commitAll() {
        Collection<com.elmakers.mine.bukkit.api.block.BlockData> blocks = this.modified.values();
        this.modified.clear();
        this.watching.clear();
        for (com.elmakers.mine.bukkit.api.block.BlockData block : blocks) {
            block.commit();
        }
    }

    public void commit(com.elmakers.mine.bukkit.api.block.BlockData block) {
        com.elmakers.mine.bukkit.api.block.BlockData currentState = this.modified.get(block.getId());
        if (currentState == block) {
            this.modified.remove(block.getId());
        }
        block.commit();
        this.reflective.remove(block.getId());
        this.breakable.remove(block.getId());
    }

    protected void removeFromModified(com.elmakers.mine.bukkit.api.block.BlockData block) {
        this.removeFromModified(block, block.getPriorState());
        block.unlink();
    }

    protected void removeFromModified(com.elmakers.mine.bukkit.api.block.BlockData block, com.elmakers.mine.bukkit.api.block.BlockData priorState) {
        com.elmakers.mine.bukkit.api.block.BlockData currentState = this.modified.get(block.getId());
        if (currentState == block) {
            if (priorState == null) {
                this.modified.remove(block.getId());
            } else {
                this.modified.put(block.getId(), priorState);
            }
        }
    }

    protected void removeFromWatched(com.elmakers.mine.bukkit.api.block.BlockData block) {
        this.removeFromWatched(block, block.getPriorState());
        block.unlink();
    }

    protected void removeFromWatched(com.elmakers.mine.bukkit.api.block.BlockData block, com.elmakers.mine.bukkit.api.block.BlockData priorState) {
        com.elmakers.mine.bukkit.api.block.BlockData currentState = this.watching.get(block.getId());
        if (currentState == block) {
            if (priorState == null) {
                this.watching.remove(block.getId());
            } else {
                this.watching.put(block.getId(), priorState);
            }
        }
    }

    public void removeBreakable(com.elmakers.mine.bukkit.api.block.BlockData block) {
        this.breakable.remove(block.getId());
    }

    public void removeReflective(com.elmakers.mine.bukkit.api.block.BlockData block) {
        this.reflective.remove(block.getId());
    }

    public Double removeBreaking(com.elmakers.mine.bukkit.api.block.BlockData block) {
        return this.breaking.remove(block.getId());
    }

    public double registerBreaking(Block block, double addAmount) {
        if (block == null) {
            return 0.0;
        }
        long blockId = BlockData.getBlockId(block);
        Double currentAmount = this.breaking.get(blockId);
        currentAmount = currentAmount == null ? addAmount : currentAmount + addAmount;
        currentAmount = Math.min(currentAmount, 1.0);
        this.breaking.put(blockId, currentAmount);
        return currentAmount;
    }

    @Nullable
    public com.elmakers.mine.bukkit.api.block.BlockData getBlockData(Location location) {
        long blockId = BlockData.getBlockId(location.getBlock());
        com.elmakers.mine.bukkit.api.block.BlockData watchedBlock = this.watching.get(blockId);
        if (watchedBlock != null && watchedBlock.getUndoList() != null && watchedBlock.getUndoList().isScheduled()) {
            return watchedBlock;
        }
        com.elmakers.mine.bukkit.api.block.BlockData modifiedBlock = this.modified.get(blockId);
        if (modifiedBlock != null) {
            return modifiedBlock;
        }
        if (watchedBlock != null) {
            return watchedBlock;
        }
        return null;
    }

    public boolean isReflective(Block block) {
        return block != null && this.reflective.containsKey(BlockData.getBlockId(block));
    }

    public boolean isBreakable(Block block) {
        return block != null && this.breakable.containsKey(BlockData.getBlockId(block));
    }

    @Nullable
    public Double getReflective(Block block) {
        return block == null ? null : this.reflective.get(BlockData.getBlockId(block));
    }

    public Map<Long, Double> getReflective() {
        return this.reflective;
    }

    @Nullable
    public Double getBreakable(Block block) {
        return block == null ? null : this.breakable.get(BlockData.getBlockId(block));
    }

    public Map<Long, Double> getBreakable() {
        return this.breakable;
    }

    public void registerReflective(Block block, double amount) {
        if (block == null) {
            return;
        }
        this.reflective.put(BlockData.getBlockId(block), amount);
    }

    public void registerBreakable(Block block, double amount) {
        if (block == null) {
            return;
        }
        this.breakable.put(BlockData.getBlockId(block), amount);
    }

    public void unregisterBreaking(Block block) {
        if (block == null) {
            return;
        }
        this.breaking.remove(BlockData.getBlockId(block));
    }

    public void unregisterBreakable(Block block) {
        if (block == null) {
            return;
        }
        this.breakable.remove(BlockData.getBlockId(block));
    }

    public void unregisterReflective(Block block) {
        if (block == null) {
            return;
        }
        this.reflective.remove(BlockData.getBlockId(block));
    }

    public Map<Long, com.elmakers.mine.bukkit.api.block.BlockData> getModified() {
        return this.modified;
    }

    public Map<Long, com.elmakers.mine.bukkit.api.block.BlockData> getWatching() {
        return this.watching;
    }

    public Map<Long, Double> getBreaking() {
        return this.breaking;
    }

    public Double getBreaking(Block block) {
        return this.breaking.get(BlockData.getBlockId(block));
    }
}

