/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;

public class LightAction
extends BaseSpellAction {
    private int level;
    private boolean async;
    private boolean update;
    private MageController controller;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.controller = context.getController();
        this.async = parameters.getBoolean("async", false);
        this.update = parameters.getBoolean("update", true);
        this.level = parameters.getInt("level", 15);
    }

    @Override
    public SpellResult perform(CastContext context) {
        Location location = context.getTargetLocation();
        context.addWork(5);
        if (!this.controller.createLight(location, this.level, this.async)) {
            return SpellResult.FAIL;
        }
        if (this.update) {
            this.controller.updateLight(location);
            context.addWork(10);
        }
        context.registerForUndo(new LightUndoAction(location, this.update));
        return SpellResult.CAST;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    private class LightUndoAction
    implements Runnable {
        private final Location location;
        private final boolean update;

        public LightUndoAction(Location location, boolean update) {
            this.location = location;
            this.update = update;
        }

        @Override
        public void run() {
            if (this.location != null) {
                LightAction.this.controller.deleteLight(this.location, LightAction.this.async);
                if (this.update) {
                    LightAction.this.controller.updateLight(this.location);
                }
            }
        }
    }
}

