/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class FlyAction
extends BaseSpellAction {
    private static final float defaultFlySpeed = 0.1f;
    private boolean infinite;
    private int duration;
    private Long targetTime;
    private int maxHeightAboveGround;
    private int maxHeight;
    private float flySpeed = 0.0f;
    private boolean wasFlying = false;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.maxHeight = parameters.getInt("max_height", 0);
        this.maxHeightAboveGround = parameters.getInt("max_height_above_ground", -1);
        this.duration = parameters.getInt("duration", 1);
        this.infinite = parameters.getString("duration", "infinite").equals("infinite");
        this.flySpeed = (float)parameters.getDouble("speed", 0.0);
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.targetTime = null;
    }

    @Override
    public void finish(CastContext context) {
        super.finish(context);
        Entity entity = context.getTargetEntity();
        if (entity != null && entity instanceof Player) {
            Player player = (Player)entity;
            this.toggleFlight(player, false);
        }
    }

    private void toggleFlight(Player player, boolean flying) {
        Vector velocity;
        if (player.getGameMode() != GameMode.CREATIVE) {
            player.setAllowFlight(flying);
        }
        if (flying && (velocity = player.getVelocity()).getY() < 0.0) {
            velocity.setY(0);
            player.setVelocity(velocity);
        }
        player.setFlying(flying);
        this.wasFlying = flying;
        if (this.flySpeed > 0.0f) {
            if (flying) {
                player.setFlySpeed(this.flySpeed * 0.1f);
            } else {
                player.setFlySpeed(0.1f);
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        Entity entity = context.getTargetEntity();
        if (entity == null) {
            return SpellResult.ENTITY_REQUIRED;
        }
        if (!(entity instanceof Player)) {
            return SpellResult.PLAYER_REQUIRED;
        }
        Player player = (Player)entity;
        if (this.wasFlying && !player.isFlying()) {
            return SpellResult.CAST;
        }
        if (this.targetTime == null) {
            this.targetTime = System.currentTimeMillis() + (long)this.duration;
        }
        if (this.infinite || System.currentTimeMillis() < this.targetTime) {
            Location currentLocation = player.getLocation();
            boolean aboveHeight = false;
            if (this.maxHeight > 0 && currentLocation.getY() >= (double)this.maxHeight) {
                aboveHeight = true;
            } else if (this.maxHeightAboveGround >= 0) {
                double heightAboveGround;
                double maxHeightThreshold = this.maxHeightAboveGround;
                Block block = currentLocation.getBlock();
                for (heightAboveGround = currentLocation.getY() - (double)((int)currentLocation.getY()); heightAboveGround < maxHeightThreshold && context.isPassthrough(block); heightAboveGround += 1.0) {
                    block = block.getRelative(BlockFace.DOWN);
                }
                if (heightAboveGround >= maxHeightThreshold) {
                    aboveHeight = true;
                }
            }
            this.toggleFlight(player, !aboveHeight);
            return SpellResult.PENDING;
        }
        this.toggleFlight(player, false);
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("duration");
        parameters.add("speed");
        parameters.add("max_height");
        parameters.add("max_height_above_ground");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("max_height") || parameterKey.equals("max_height_above_ground") || parameterKey.equals("speed")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else if (parameterKey.equals("duration")) {
            examples.add("infinite");
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_DURATIONS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }
}

