/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.requirements.Requirement;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.configuration.ConfigurationSection;

public class CheckRequirementsAction
extends CompoundAction {
    private Collection<Requirement> requirements;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.requirements = new ArrayList<Requirement>();
        Collection<ConfigurationSection> requirementConfigurations = ConfigurationUtils.getNodeList(parameters, "requirements");
        if (requirementConfigurations != null) {
            for (ConfigurationSection requirementConfiguration : requirementConfigurations) {
                this.requirements.add(new Requirement(requirementConfiguration));
            }
        }
    }

    protected boolean isAllowed(CastContext context) {
        return context.getController().checkRequirements(context, this.requirements) == null;
    }

    @Override
    public SpellResult step(CastContext context) {
        boolean allowed = this.isAllowed(context);
        ActionHandler actions = this.getHandler("actions");
        if (actions == null || actions.size() == 0) {
            return allowed ? SpellResult.CAST : SpellResult.STOP;
        }
        if (!allowed) {
            return SpellResult.NO_TARGET;
        }
        return this.startActions();
    }
}

