/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.utility.BoundingBox;
import com.elmakers.mine.bukkit.utility.Targeting;
import com.elmakers.mine.bukkit.utility.TextUtils;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public abstract class BaseProjectileAction
extends CompoundAction {
    private long lifetime;
    private boolean setTarget;
    private String projectileEffectsKey;
    private String hitEffectsKey;
    protected boolean track = false;
    private Set<Entity> tracking;
    private long expiration;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.lifetime = parameters.getLong("lifetime", 10000L);
        this.setTarget = parameters.getBoolean("set_target", false);
        this.track = parameters.getBoolean("track_projectile", this.track);
        this.projectileEffectsKey = parameters.getString("projectile_effects", "projectile");
        this.hitEffectsKey = parameters.getString("hit_effects", "hit");
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.expiration = System.currentTimeMillis() + this.lifetime;
        this.tracking = null;
    }

    @Override
    public SpellResult step(CastContext context) {
        if (this.tracking == null || this.tracking.size() == 0) {
            this.tracking = null;
            return SpellResult.CAST;
        }
        if (System.currentTimeMillis() > this.expiration) {
            for (Entity entity : this.tracking) {
                entity.removeMetadata("track", context.getPlugin());
                entity.removeMetadata("damaged", context.getPlugin());
                entity.removeMetadata("hit", context.getPlugin());
                entity.remove();
            }
            context.getMage().sendDebugMessage(ChatColor.DARK_GRAY + "Projectiles expired", 4);
            this.tracking = null;
            return SpellResult.NO_TARGET;
        }
        for (Entity entity : this.tracking) {
            if (entity.isValid() && !entity.hasMetadata("hit")) continue;
            this.tracking.remove(entity);
            Plugin plugin = context.getPlugin();
            Entity targetEntity = null;
            Block targetBlock = null;
            Location targetLocation = entity.getLocation();
            List metadata = entity.getMetadata("hit");
            for (MetadataValue value : metadata) {
                if (!value.getOwningPlugin().equals(plugin)) continue;
                Object o = value.value();
                if (o != null && o instanceof WeakReference) {
                    WeakReference reference = (WeakReference)o;
                    if ((o = reference.get()) == null || !(o instanceof Entity)) break;
                    targetEntity = (Entity)o;
                    targetLocation = targetEntity.getLocation();
                    break;
                }
                if (o == null || !(o instanceof Block)) continue;
                targetBlock = (Block)o;
                break;
            }
            entity.removeMetadata("track", plugin);
            if (targetEntity == null) {
                context.getMage().sendDebugMessage(ChatColor.GRAY + "Projectile missed", 4);
            } else {
                context.getMage().sendDebugMessage(ChatColor.GREEN + "Projectile hit " + ChatColor.GOLD + targetEntity.getType());
            }
            entity.removeMetadata("hit", plugin);
            Location sourceLocation = entity.getLocation();
            Vector direction = entity.getVelocity().normalize();
            sourceLocation.setDirection(direction);
            if (targetBlock != null) {
                context.getMage().sendDebugMessage(ChatColor.GREEN + "Projectile at " + TextUtils.printLocation(entity.getLocation()) + ChatColor.GREEN + " hit block at " + TextUtils.printBlock(targetBlock) + " facing " + TextUtils.printVector(sourceLocation.getDirection()), 13);
                context.setPreviousBlock(sourceLocation.getBlock());
                targetLocation = targetBlock.getLocation();
                Vector startPoint = sourceLocation.toVector();
                Vector endPoint = startPoint.clone().add(direction.clone().normalize().multiply(2));
                BoundingBox hitbox = new BoundingBox(targetLocation.toVector(), 0.001, 0.998, 0.001, 0.998, 0.001, 0.998);
                Vector hit = hitbox.getIntersection(startPoint, endPoint);
                if (hit != null) {
                    targetLocation.setX(hit.getX());
                    targetLocation.setY(hit.getY());
                    targetLocation.setZ(hit.getZ());
                }
            } else {
                context.getMage().sendDebugMessage(ChatColor.GRAY + "Projectile hit at " + TextUtils.printLocation(entity.getLocation()) + " facing " + TextUtils.printVector(sourceLocation.getDirection()), 132);
            }
            this.createActionContext(context, context.getMage().getEntity(), sourceLocation, targetEntity, targetLocation);
            this.actionContext.playEffects(this.hitEffectsKey);
            SpellResult result = this.startActions();
            result = targetEntity != null ? result.min(SpellResult.CAST) : result.min(SpellResult.NO_TARGET);
            context.addResult(result);
            return result;
        }
        return SpellResult.PENDING;
    }

    @Override
    public boolean next(CastContext context) {
        return this.tracking != null && this.tracking.size() > 0;
    }

    protected void track(CastContext context, Entity entity) {
        if (this.tracking == null) {
            this.tracking = new HashSet<Entity>();
        }
        this.tracking.add(entity);
        context.registerForUndo(entity);
        if (this.setTarget) {
            context.setTargetEntity(entity);
        }
        Collection<EffectPlayer> projectileEffects = context.getEffects(this.projectileEffectsKey);
        for (EffectPlayer effectPlayer : projectileEffects) {
            effectPlayer.start(entity.getLocation(), entity, null, null);
        }
        if (this.track) {
            Targeting.track(context.getPlugin(), entity);
        }
    }

    protected SpellResult checkTracking(CastContext context) {
        if (this.tracking == null) {
            return SpellResult.FAIL;
        }
        if (!this.track && !this.hasActions()) {
            if (!context.hasEffects("hit")) {
                this.tracking = null;
            }
            return SpellResult.CAST;
        }
        return SpellResult.NO_TARGET;
    }
}

