/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.protection;

import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.protection.BlockBreakManager;
import com.elmakers.mine.bukkit.protection.BlockBuildManager;
import java.lang.reflect.Method;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class LocketteManager
implements BlockBuildManager,
BlockBreakManager {
    private boolean enabled = false;
    private Method isOwnerMethod = null;
    private Method isProtectedMethod = null;
    private boolean isPro = false;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled && this.isOwnerMethod != null && this.isProtectedMethod != null;
    }

    public void initialize(Plugin plugin) {
        if (this.enabled) {
            String pluginName = "Lockette";
            String apiClass = "org.yi.acru.bukkit.Lockette.Lockette";
            Plugin lockettePlugin = plugin.getServer().getPluginManager().getPlugin("Lockette");
            if (lockettePlugin == null && (lockettePlugin = plugin.getServer().getPluginManager().getPlugin("LockettePro")) != null) {
                pluginName = "LockettePro";
                apiClass = "me.crafter.mc.lockettepro.LocketteProAPI";
                this.isPro = true;
            }
            if (lockettePlugin != null) {
                try {
                    Class<?> locketteClass = Class.forName(apiClass);
                    this.isOwnerMethod = locketteClass.getMethod("isOwner", Block.class, this.isPro ? Player.class : String.class);
                    this.isProtectedMethod = locketteClass.getMethod("isProtected", Block.class);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
                if (this.isOwnerMethod == null || this.isProtectedMethod == null) {
                    plugin.getLogger().info(pluginName + " integration failed, will not integrate.");
                } else {
                    plugin.getLogger().info(pluginName + " found, will check block protection.");
                }
            } else {
                plugin.getLogger().info("Lockette nor LockettePro found, will not integrate.");
            }
        } else {
            plugin.getLogger().info("Lockette/LockettePro integration disabled");
        }
    }

    @Override
    public boolean hasBuildPermission(Player player, Block block) {
        if (this.enabled && block != null && this.isOwnerMethod != null && this.isProtectedMethod != null) {
            try {
                if (!((Boolean)this.isProtectedMethod.invoke(null, block)).booleanValue()) {
                    return true;
                }
                if (player == null) {
                    return false;
                }
                if (DefaultMaterials.isSign(block.getType())) {
                    return false;
                }
                return (Boolean)this.isOwnerMethod.invoke(null, block, this.isPro ? player : player.getName());
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasBreakPermission(Player player, Block block) {
        return this.hasBuildPermission(player, block);
    }
}

