/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class WandOrganizer {
    private final Wand wand;
    private final Mage mage;
    protected static final int inventoryOrganizeNewGroupBuffer = 8;
    protected static final int favoriteCastCountThreshold = 20;
    protected static final int favoriteCountBuffer = 9;
    protected static final int favoritePageBuffer = 4;
    private int currentInventoryIndex = 0;
    private int currentInventoryCount = 0;

    public WandOrganizer(Wand wand, Mage mage) {
        this.wand = wand;
        this.mage = mage;
    }

    public WandOrganizer(Wand wand) {
        this.wand = wand;
        this.mage = null;
    }

    protected void removeHotbar(Map<String, Integer> spells, Map<String, Integer> brushes) {
        if (this.wand.getHotbarCount() == 0) {
            return;
        }
        List<Inventory> hotbars = this.wand.getHotbars();
        for (Inventory hotbar : hotbars) {
            int hotbarSize = hotbar.getSize();
            for (int i = 0; i < hotbarSize; ++i) {
                ItemStack hotbarItem = hotbar.getItem(i);
                if (hotbarItem == null || hotbarItem.getType() == Material.AIR) continue;
                String spellName = Wand.getSpell(hotbarItem);
                if (spellName != null) {
                    SpellKey spellKey = new SpellKey(spellName);
                    spellName = spellKey.getBaseKey();
                }
                if (spellName != null) {
                    spells.remove(spellName);
                    continue;
                }
                String materialKey = Wand.getBrush(hotbarItem);
                if (materialKey == null) continue;
                brushes.remove(materialKey);
            }
        }
    }

    public void organize() {
        Map<String, Integer> spells = this.wand.getSpellInventory();
        Map<String, Integer> brushes = this.wand.getBrushInventory();
        this.removeHotbar(spells, brushes);
        MageController controller = this.wand.getController();
        TreeMap favoriteSpells = new TreeMap();
        TreeMap<String, TreeSet<String>> groupedSpells = new TreeMap<String, TreeSet<String>>();
        for (String string : spells.keySet()) {
            TreeSet<String> spellList;
            Object spellCategory;
            String category;
            MageSpell mageSpell = this.mage == null ? null : this.mage.getSpell(string);
            SpellTemplate spell = mageSpell == null ? controller.getSpellTemplate(string) : mageSpell;
            if (spell == null) continue;
            long castCount = 0L;
            int spellLevel = 1;
            while (mageSpell != null) {
                SpellKey spellKey;
                String key;
                castCount += mageSpell.getCastCount();
                mageSpell = this.mage.hasSpell(key = (spellKey = new SpellKey(string, ++spellLevel)).getKey()) ? this.mage.getSpell(key) : null;
            }
            String string2 = spell.getSpellKey().getBaseKey();
            if (castCount > 20L) {
                List<String> favorites = null;
                if (!favoriteSpells.containsKey(castCount)) {
                    favorites = new ArrayList();
                    favoriteSpells.put(castCount, favorites);
                } else {
                    favorites = (List)favoriteSpells.get(castCount);
                }
                favorites.add(string2);
            }
            String string3 = category = (spellCategory = spell.getCategory()) == null ? null : spellCategory.getKey();
            if (category == null || category.length() == 0) {
                category = "default";
            }
            if ((spellList = (TreeSet<String>)groupedSpells.get(category)) == null) {
                spellList = new TreeSet<String>();
                groupedSpells.put(category, spellList);
            }
            spellList.add(string2);
        }
        TreeMap<String, String> materials = new TreeMap<String, String>();
        if (this.wand.getBrushMode() == WandMode.INVENTORY) {
            for (String materialKey : brushes.keySet()) {
                if (MaterialBrush.isSpecialMaterialKey(materialKey)) {
                    materials.put(" " + materialKey, materialKey);
                    continue;
                }
                materials.put(materialKey, materialKey);
            }
        }
        this.currentInventoryIndex = 0;
        this.currentInventoryCount = 0;
        WandMode wandMode = this.wand.getMode();
        HashSet<String> addedFavorites = new HashSet<String>();
        ArrayList<String> favoriteList = new ArrayList<String>();
        int favoritePageSize = this.wand.getInventorySize() - 4;
        block3: for (List favorites : favoriteSpells.descendingMap().values()) {
            if (addedFavorites.size() >= favoritePageSize) break;
            for (String spellName : favorites) {
                addedFavorites.add(spellName);
                favoriteList.add(spellName);
                if (addedFavorites.size() < favoritePageSize) continue;
                continue block3;
            }
        }
        if (addedFavorites.size() > 0) {
            for (String favorite : favoriteList) {
                int slot = this.getNextSlot();
                spells.put(favorite, slot);
            }
            if (wandMode != WandMode.CHEST && addedFavorites.size() > this.wand.getInventorySize() - 9) {
                this.nextPage();
            }
        } else {
            addedFavorites.clear();
        }
        int inventoryOrganizeNewGroupSize = this.wand.getInventorySize() - 8;
        for (Collection spellGroup : groupedSpells.values()) {
            if (wandMode != WandMode.CHEST && this.currentInventoryCount > inventoryOrganizeNewGroupSize) {
                this.nextPage();
            }
            for (String spellName : spellGroup) {
                if (addedFavorites.contains(spellName)) continue;
                int slot = this.getNextSlot();
                spells.put(spellName, slot);
            }
        }
        if (materials.size() > 0) {
            this.nextPage();
            for (String materialName : materials.values()) {
                brushes.put(materialName, this.getNextSlot());
            }
        }
        this.wand.updateSpellInventory(spells);
        if (materials.size() > 0) {
            this.wand.updateBrushInventory(brushes);
        }
    }

    public void alphabetize() {
        Map<String, Integer> spells = this.wand.getSpellInventory();
        Map<String, Integer> brushes = this.wand.getBrushInventory();
        this.removeHotbar(spells, brushes);
        TreeMap<String, String> materials = new TreeMap<String, String>();
        if (this.wand.getBrushMode() == WandMode.INVENTORY) {
            for (String materialKey : brushes.keySet()) {
                if (MaterialBrush.isSpecialMaterialKey(materialKey)) {
                    materials.put(" " + materialKey, materialKey);
                    continue;
                }
                materials.put(materialKey, materialKey);
            }
        }
        TreeMap<String, String> alphabetized = new TreeMap<String, String>();
        for (String spellKey : spells.keySet()) {
            SpellTemplate spell = this.wand.getController().getSpellTemplate(spellKey);
            if (spell == null) continue;
            alphabetized.put(spell.getName(), spell.getSpellKey().getBaseKey());
        }
        this.currentInventoryIndex = 0;
        this.currentInventoryCount = 0;
        for (String spellName : alphabetized.values()) {
            spells.put(spellName, this.getNextSlot(this.wand.getInventorySize()));
        }
        if (materials.size() > 0) {
            this.nextPage();
            for (String materialName : materials.values()) {
                brushes.put(materialName, this.getNextSlot(this.wand.getInventorySize()));
            }
        }
        this.wand.updateSpellInventory(spells);
        if (materials.size() > 0) {
            this.wand.updateBrushInventory(brushes);
        }
    }

    protected int getNextSlot() {
        return this.getNextSlot(this.wand.getInventorySize() - 4);
    }

    protected int getNextSlot(int nextPageSize) {
        int slot = this.wand.getHotbarSize() + this.currentInventoryCount + this.currentInventoryIndex * this.wand.getInventorySize();
        ++this.currentInventoryCount;
        if (this.currentInventoryCount >= nextPageSize) {
            this.nextPage();
        }
        return slot;
    }

    protected void nextPage() {
        this.currentInventoryCount = 0;
        ++this.currentInventoryIndex;
    }
}

