/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import com.elmakers.mine.bukkit.utility.DirectionUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.Target;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public class SignSpell
extends BlockSpell {
    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        String typeString = parameters.getString("type", "");
        boolean autoGive = parameters.getBoolean("auto_give", false);
        boolean editSign = parameters.getBoolean("edit", false);
        boolean displayName = parameters.getBoolean("display_name", true);
        String prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)parameters.getString("prefix", ""));
        Entity sourceEntity = this.mage.getEntity();
        if (sourceEntity == null) {
            return SpellResult.ENTITY_REQUIRED;
        }
        if (typeString.equals("give") || autoGive && this.isLookingUp()) {
            Player player = this.mage.getPlayer();
            if (player == null) {
                return SpellResult.PLAYER_REQUIRED;
            }
            this.castMessage(this.getMessage("cast_give"));
            this.controller.giveItemToPlayer(player, new ItemStack(Material.SIGN, 4));
            return SpellResult.CAST;
        }
        Target target = this.getTarget();
        Block block = target.getBlock();
        if (target.isValid() && block != null) {
            Block targetBlock = this.getPreviousBlock();
            if (targetBlock == null || !this.hasBuildPermission(targetBlock)) {
                return SpellResult.INSUFFICIENT_PERMISSION;
            }
            this.registerForUndo(targetBlock);
            this.registerForUndo();
            BlockState blockState = null;
            if (targetBlock.getRelative(BlockFace.DOWN).getType() == Material.AIR) {
                targetBlock.setType(Material.WALL_SIGN);
                blockState = targetBlock.getState();
                MaterialData data = blockState.getData();
                if (data instanceof org.bukkit.material.Sign) {
                    org.bukkit.material.Sign signData = (org.bukkit.material.Sign)data;
                    signData.setFacingDirection(block.getFace(targetBlock));
                    blockState.setData((MaterialData)signData);
                }
            } else {
                Material signMaterial = DefaultMaterials.getGroundSignBlock();
                if (signMaterial == null) {
                    return SpellResult.FAIL;
                }
                targetBlock.setType(signMaterial);
                blockState = targetBlock.getState();
                blockState = targetBlock.getState();
                MaterialData data = blockState.getData();
                if (data instanceof org.bukkit.material.Sign) {
                    float yaw;
                    org.bukkit.material.Sign signData = (org.bukkit.material.Sign)data;
                    for (yaw = this.getLocation().getYaw() - 157.5f; yaw < 0.0f; yaw += 360.0f) {
                    }
                    while (yaw >= 360.0f) {
                        yaw -= 360.0f;
                    }
                    signData.setFacingDirection(DirectionUtils.getDirection((int)yaw));
                    blockState.setData((MaterialData)signData);
                }
            }
            if (blockState instanceof Sign) {
                Sign sign = (Sign)blockState;
                String playerName = displayName ? this.controller.getEntityDisplayName(sourceEntity) : this.controller.getEntityName(sourceEntity);
                playerName = prefix + playerName;
                sign.setLine(0, playerName);
                sign.setLine(1, this.getMessage("sign_message"));
                Date currentDate = new Date();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
                sign.setLine(2, dateFormat.format(currentDate));
                sign.setLine(3, timeFormat.format(currentDate));
                sign.update();
                this.controller.updateBlock(targetBlock);
                if (editSign && sourceEntity instanceof Player) {
                    Player player = (Player)sourceEntity;
                    InventoryUtils.openSign(player, targetBlock.getLocation());
                }
                return SpellResult.CAST;
            }
            return SpellResult.FAIL;
        }
        if (target.hasEntity() && target.getEntity() instanceof Player) {
            return SpellResult.CAST;
        }
        return SpellResult.NO_TARGET;
    }
}

