/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.economy.Currency;
import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.wand.WandAction;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.magic.DropActionTask;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class PlayerController
implements Listener {
    private final MagicController controller;
    private int clickCooldown = 150;
    private MaterialAndData enchantBlockMaterial;
    private String enchantClickSpell = "spellshop";
    private String enchantSneakClickSpell = "upgrades";
    private boolean cancelInteractOnLeftClick = true;
    private boolean cancelInteractOnRightClick = false;
    private boolean allowOffhandCasting = true;
    private long lastDropWarn = 0L;

    public PlayerController(MagicController controller) {
        this.controller = controller;
    }

    public void loadProperties(ConfigurationSection properties) {
        this.clickCooldown = properties.getInt("click_cooldown", 0);
        this.enchantBlockMaterial = new MaterialAndData(properties.getString("enchant_block", "enchantment_table"));
        this.enchantClickSpell = properties.getString("enchant_click");
        this.enchantSneakClickSpell = properties.getString("enchant_sneak_click");
        this.cancelInteractOnLeftClick = properties.getBoolean("cancel_interact_on_left_click", true);
        this.cancelInteractOnRightClick = properties.getBoolean("cancel_interact_on_right_click", false);
        this.allowOffhandCasting = properties.getBoolean("allow_offhand_casting", true);
    }

    @EventHandler
    public void onPlayerExpChange(PlayerExpChangeEvent event) {
        Player player = event.getPlayer();
        Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage != null) {
            mage.experienceChanged();
        }
    }

    @EventHandler
    public void onPlayerToggleGlide(EntityToggleGlideEvent event) {
        Entity entity = event.getEntity();
        Mage mage = this.controller.getRegisteredMage(entity);
        if (mage != null && mage.isGlidingAllowed() && !event.isGliding() && !entity.isOnGround()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerEquip(PlayerItemHeldEvent event) {
        boolean isQuickCast;
        if (!this.controller.isLoaded()) {
            return;
        }
        Player player = event.getPlayer();
        PlayerInventory inventory = player.getInventory();
        ItemStack next = inventory.getItem(event.getNewSlot());
        Mage mage = this.controller.getMage(player);
        if (Wand.isSelfDestructWand(next)) {
            mage.sendMessageKey("wand.self_destruct");
            inventory.setItem(event.getNewSlot(), null);
            mage.checkWand();
            return;
        }
        if (NMSUtils.isTemporary(next)) {
            inventory.setItem(event.getNewSlot(), null);
            mage.checkWand();
            return;
        }
        Wand activeWand = mage.getActiveWand();
        boolean isSkill = Wand.isSkill(next);
        if (isSkill && Wand.isQuickCastSkill(next)) {
            mage.useSkill(next);
            event.setCancelled(true);
            return;
        }
        boolean bl = isQuickCast = activeWand != null && activeWand.isQuickCast() && activeWand.isInventoryOpen();
        if (isQuickCast) {
            MageSpell spell = mage.getSpell(Wand.getSpell(next));
            if (spell != null) {
                activeWand.cast(spell);
            }
            event.setCancelled(true);
            return;
        }
        boolean isWand = Wand.isWand(next);
        if (activeWand != null && activeWand.isInventoryOpen()) {
            if (!isWand) {
                mage.activateIcon(activeWand, next);
                int previousSlot = event.getPreviousSlot();
                ItemStack previous = inventory.getItem(previousSlot);
                if (previous != null && previous.equals((Object)activeWand.getItem())) {
                    player.getInventory().setItem(previousSlot, activeWand.getItem());
                }
            }
            event.setCancelled(true);
        } else if (isWand || activeWand != null) {
            mage.checkWandNextTick();
        }
        activeWand = mage.getActiveWand();
        if (activeWand == null && next != null && DefaultMaterials.isFilledMap(next.getType())) {
            mage.setLastHeldMapId(InventoryUtils.getMapId(next));
        }
    }

    @EventHandler
    public void onPlayerSwapItem(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage == null) {
            return;
        }
        Wand activeWand = mage.getActiveWand();
        Wand offhandWand = mage.getOffhandWand();
        if (activeWand == null && offhandWand == null) {
            return;
        }
        if (activeWand != null && activeWand.performAction(activeWand.getSwapAction())) {
            event.setCancelled(true);
        } else if (activeWand != null && activeWand.isInventoryOpen()) {
            activeWand.closeInventory();
            event.setCancelled(true);
        } else if (activeWand != null || offhandWand != null || Wand.isWand(event.getMainHandItem()) || Wand.isWand(event.getOffHandItem())) {
            mage.checkWandNextTick();
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        boolean droppedWand;
        Player player = event.getPlayer();
        Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage == null) {
            return;
        }
        if (mage.getActiveGUI() != null) {
            event.setCancelled(true);
            return;
        }
        Wand activeWand = mage.getActiveWand();
        ItemStack droppedItem = event.getItemDrop().getItemStack();
        boolean cancelEvent = false;
        ItemStack activeItem = activeWand == null ? null : activeWand.getItem();
        ItemMeta activeMeta = activeItem == null ? null : activeItem.getItemMeta();
        ItemMeta droppedMeta = droppedItem.getItemMeta();
        boolean bl = droppedWand = droppedMeta != null && activeMeta != null && activeItem.getItemMeta().equals(droppedItem.getItemMeta());
        if (droppedWand && activeWand.isUndroppable()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.controller.getPlugin(), (Runnable)new DropActionTask(activeWand));
            cancelEvent = true;
        } else if (activeWand != null) {
            if (droppedWand) {
                ItemStack mainhandItem = player.getInventory().getItemInMainHand();
                activeWand.deactivate();
                ItemStack restoredItem = player.getInventory().getItemInMainHand();
                ItemMeta restoredMeta = restoredItem == null ? null : restoredItem.getItemMeta();
                activeMeta = activeWand.getItem().getItemMeta();
                droppedItem.setItemMeta(activeMeta);
                if (Wand.hasActiveWand(player) && restoredItem.getType() != Material.AIR && restoredMeta != null && activeMeta.equals(restoredMeta)) {
                    ItemStack newItem = player.getInventory().getItemInMainHand();
                    if (mainhandItem.getAmount() > 0) {
                        newItem.setAmount(mainhandItem.getAmount());
                        player.getInventory().setItemInMainHand(newItem);
                    } else {
                        player.getInventory().setItemInMainHand(new ItemStack(Material.AIR, 1));
                    }
                }
            } else if (activeWand.isInventoryOpen()) {
                if (!this.controller.isSpellDroppingEnabled()) {
                    cancelEvent = true;
                    boolean isInventoryFull = true;
                    PlayerInventory playerInventory = player.getInventory();
                    for (int i = 0; i < 36; ++i) {
                        ItemStack item = playerInventory.getItem(i);
                        if (item != null && item.getType() != Material.AIR) continue;
                        isInventoryFull = false;
                        break;
                    }
                    if (isInventoryFull) {
                        activeWand.addToInventory(droppedItem);
                    }
                } else {
                    this.controller.removeItemFromWand(activeWand, droppedItem);
                }
            }
        }
        if (!cancelEvent) {
            cancelEvent = InventoryUtils.getMetaBoolean(droppedItem, "undroppable", false);
        }
        if (cancelEvent) {
            if (droppedWand) {
                activeWand.setItem(droppedItem);
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Mage mage = this.controller.getRegisteredMage((Entity)event.getPlayer());
        if (mage == null) {
            return;
        }
        mage.restoreRespawnInventories();
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerInteractArmorStand(PlayerArmorStandManipulateEvent event) {
        Player player = event.getPlayer();
        Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage == null) {
            return;
        }
        Wand wand = mage.checkWand();
        if (wand != null) {
            if (wand.isUndroppable()) {
                event.setCancelled(true);
                return;
            }
            wand.deactivate();
        } else {
            ItemStack mainHand = player.getInventory().getItemInMainHand();
            ItemStack offhand = player.getInventory().getItemInOffHand();
            if (InventoryUtils.getMetaBoolean(mainHand, "undroppable", false) || InventoryUtils.isEmpty(mainHand) && InventoryUtils.getMetaBoolean(offhand, "undroppable", false)) {
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent event) {
        Entity entity = event.getRightClicked();
        EntityData mob = this.controller.getMobByName(entity.getCustomName());
        if (mob == null) {
            return;
        }
        String interactSpell = mob.getInteractSpell();
        if (interactSpell == null || interactSpell.isEmpty()) {
            return;
        }
        Player player = event.getPlayer();
        Mage mage = this.controller.getMage(player);
        event.setCancelled(true);
        MemoryConfiguration config = new MemoryConfiguration();
        config.set("entity", (Object)entity.getUniqueId().toString());
        this.controller.cast(mage, interactSpell, (ConfigurationSection)config, (CommandSender)player, (Entity)player);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        boolean isPlaceable;
        Player player = event.getPlayer();
        Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage == null) {
            return;
        }
        Wand wand = mage.checkWand();
        Entity clickedEntity = event.getRightClicked();
        boolean bl = isPlaceable = clickedEntity instanceof ItemFrame || clickedEntity instanceof ArmorStand;
        if (isPlaceable) {
            if (wand != null) {
                if (wand.isUndroppable()) {
                    event.setCancelled(true);
                    return;
                }
                wand.deactivate();
            } else {
                ItemStack mainHand = player.getInventory().getItemInMainHand();
                ItemStack offhand = player.getInventory().getItemInOffHand();
                if (InventoryUtils.getMetaBoolean(mainHand, "undroppable", false) || InventoryUtils.isEmpty(mainHand) && InventoryUtils.getMetaBoolean(offhand, "undroppable", false)) {
                    event.setCancelled(true);
                    return;
                }
            }
        }
        if (this.controller.isNPC(event.getRightClicked())) {
            if (wand != null) {
                wand.closeInventory();
            }
            mage.checkLastClick(0L);
        } else {
            ItemStack itemInHand = player.getInventory().getItemInMainHand();
            if (Wand.isSpell(itemInHand) || Wand.isBrush(itemInHand) || Wand.isUpgrade(itemInHand)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerAnimate(PlayerAnimationEvent event) {
        Player player = event.getPlayer();
        if (event.getAnimationType() != PlayerAnimationType.ARM_SWING) {
            return;
        }
        Mage mage = this.controller.getMage(player);
        Wand wand = mage.checkWand();
        if (wand == null) {
            return;
        }
        Messages messages = this.controller.getMessages();
        if (!this.controller.hasWandPermission(player)) {
            return;
        }
        if (!this.controller.hasWandPermission(player, wand)) {
            wand.deactivate();
            mage.sendMessage(messages.get("wand.no_permission").replace("$wand", wand.getName()));
            return;
        }
        if (!mage.checkLastClick(this.clickCooldown)) {
            return;
        }
        if (wand.isUpgrade()) {
            return;
        }
        wand.playEffects("swing");
        wand.performAction(wand.getLeftClickAction());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean isSpell;
        boolean isRightClick;
        if (!this.controller.isLoaded()) {
            return;
        }
        Action action = event.getAction();
        boolean isLeftClick = action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK;
        boolean bl = isRightClick = action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK;
        if (!isLeftClick && !isRightClick) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        boolean isSkill = Wand.isSkill(itemInHand);
        boolean bl2 = isSpell = !isSkill && Wand.isSpell(itemInHand);
        if (isSpell || Wand.isBrush(itemInHand) || Wand.isUpgrade(itemInHand)) {
            event.setCancelled(true);
            return;
        }
        boolean isOffhandSkill = false;
        ItemStack itemInOffhand = player.getInventory().getItemInOffHand();
        if (isRightClick) {
            boolean isOffhandSpell;
            isOffhandSkill = Wand.isSkill(itemInOffhand);
            boolean bl3 = isOffhandSpell = !isOffhandSkill && Wand.isSpell(itemInOffhand);
            if (isOffhandSpell || Wand.isBrush(itemInOffhand) || Wand.isUpgrade(itemInOffhand)) {
                event.setCancelled(true);
                return;
            }
        }
        Mage mage = this.controller.getMage(player);
        if (isRightClick) {
            Integer sp = Wand.getSP(itemInHand);
            if (sp != null) {
                if (mage.isAtMaxSkillPoints()) {
                    String limitMessage = this.controller.getMessages().get("sp.limit");
                    limitMessage = limitMessage.replace("$amount", Integer.toString(this.controller.getSPMaximum()));
                    mage.sendMessage(limitMessage);
                } else {
                    mage.addSkillPoints(sp);
                    String balanceMessage = this.controller.getMessages().get("sp.deposited");
                    balanceMessage = balanceMessage.replace("$amount", Integer.toString(sp));
                    balanceMessage = balanceMessage.replace("$balance", Integer.toString(mage.getSkillPoints()));
                    mage.sendMessage(balanceMessage);
                    player.getInventory().setItemInMainHand(null);
                }
                event.setCancelled(true);
                return;
            }
            Double value = Wand.getCurrencyAmount(itemInHand);
            if (value != null) {
                String currencyKey = Wand.getCurrencyType(itemInHand);
                if (mage.isAtMaxCurrency(currencyKey)) {
                    Currency currency = this.controller.getCurrency(currencyKey);
                    String limitMessage = this.controller.getMessages().get("currency." + currencyKey + ".limit", this.controller.getMessages().get("currency.limit"));
                    limitMessage = limitMessage.replace("$amount", Integer.toString((int)Math.ceil(currency.getMaxValue())));
                    limitMessage = limitMessage.replace("$type", this.controller.getMessages().get("currency." + currencyKey + ".name", currencyKey));
                    mage.sendMessage(limitMessage);
                } else {
                    mage.addCurrency(currencyKey, value);
                    player.getInventory().setItemInMainHand(null);
                    String balanceMessage = this.controller.getMessages().get("currency." + currencyKey + ".deposited", this.controller.getMessages().get("currency.deposited"));
                    balanceMessage = balanceMessage.replace("$amount", Integer.toString((int)Math.ceil(value)));
                    balanceMessage = balanceMessage.replace("$balance", Integer.toString((int)Math.ceil(mage.getCurrency(currencyKey))));
                    balanceMessage = balanceMessage.replace("$type", this.controller.getMessages().get("currency." + currencyKey + ".name", currencyKey));
                    mage.sendMessage(balanceMessage);
                }
                event.setCancelled(true);
                return;
            }
        }
        Wand wand = mage.checkWand();
        if (action == Action.RIGHT_CLICK_BLOCK) {
            Material material = event.getClickedBlock().getType();
            boolean bl4 = isRightClick = !this.controller.isInteractable(event.getClickedBlock());
            if (wand != null && DefaultMaterials.isSign(material)) {
                wand.closeInventory();
            }
        }
        if (!isLeftClick && !mage.checkLastClick(this.clickCooldown)) {
            return;
        }
        if (isOffhandSkill && wand != null && wand.getRightClickAction() != WandAction.NONE) {
            isOffhandSkill = false;
        }
        if (isRightClick && (isOffhandSkill || isSkill)) {
            if (isSkill) {
                mage.useSkill(itemInHand);
            } else {
                mage.useSkill(itemInOffhand);
            }
            event.setCancelled(true);
            return;
        }
        if (isRightClick && this.allowOffhandCasting && mage.offhandCast()) {
            if (this.cancelInteractOnLeftClick) {
                event.setCancelled(true);
            }
            return;
        }
        if (itemInHand != null && isRightClick && this.controller.isWearable(itemInHand) && !DefaultMaterials.isSkull(itemInHand.getType())) {
            if (wand != null) {
                wand.deactivate();
            }
            this.controller.onArmorUpdated(mage);
            return;
        }
        if (wand == null) {
            return;
        }
        Messages messages = this.controller.getMessages();
        if (!this.controller.hasWandPermission(player)) {
            return;
        }
        if (!this.controller.hasWandPermission(player, wand)) {
            wand.deactivate();
            mage.sendMessage(messages.get("wand.no_permission").replace("$wand", wand.getName()));
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock != null && clickedBlock.getType() != Material.AIR && this.enchantBlockMaterial != null && this.enchantBlockMaterial.is(clickedBlock)) {
            MageSpell spell = null;
            if (player.isSneaking()) {
                spell = this.enchantSneakClickSpell != null ? mage.getSpell(this.enchantSneakClickSpell) : null;
            } else {
                MageSpell mageSpell = spell = this.enchantClickSpell != null ? mage.getSpell(this.enchantClickSpell) : null;
            }
            if (spell != null) {
                spell.cast();
                event.setCancelled(true);
                return;
            }
        }
        if (isLeftClick && !wand.isUpgrade() && wand.getLeftClickAction() != WandAction.NONE && this.cancelInteractOnLeftClick) {
            event.setCancelled(true);
        }
        if (isRightClick && wand.performAction(wand.getRightClickAction())) {
            if (this.cancelInteractOnRightClick) {
                event.setCancelled(true);
            } else {
                event.setUseInteractedBlock(Event.Result.DENY);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.controller.getMage(player);
        this.controller.checkVanished(player);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerKick(PlayerKickEvent event) {
        this.handlePlayerQuitEvent((PlayerEvent)event);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.handlePlayerQuitEvent((PlayerEvent)event);
    }

    protected void handlePlayerQuitEvent(PlayerEvent event) {
        Player player = event.getPlayer();
        Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage != null) {
            mage.onPlayerQuit(event);
            this.controller.playerQuit(mage);
        }
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        if (this.controller.isNPC((Entity)player)) {
            return;
        }
        Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage != null) {
            mage.onTeleport(event);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerChangeWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (this.controller.isNPC((Entity)player)) {
            return;
        }
        Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage != null) {
            mage.onChangeWorld();
        }
    }

    @EventHandler
    public void onPlayerGameModeChange(PlayerGameModeChangeEvent event) {
        if (event.getNewGameMode() == GameMode.CREATIVE) {
            Wand activeWand;
            Player player = event.getPlayer();
            if (!player.isOnline()) {
                return;
            }
            Mage mage = this.controller.getRegisteredMage((Entity)player);
            if (mage != null && (activeWand = mage.getActiveWand()) != null) {
                activeWand.closeInventory();
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        Player player = event.getPlayer();
        Mage mage = this.controller.getMage(player);
        if (mage.hasStoredInventory()) {
            event.setCancelled(true);
            if (mage.addToStoredInventory(event.getItem().getItemStack())) {
                event.getItem().remove();
                mage.playSoundEffect(Wand.itemPickupSound);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerPrePickupItem(PlayerPickupItemEvent event) {
        Wand activeWand;
        Item item = event.getItem();
        ItemStack pickup = item.getItemStack();
        if (NMSUtils.isTemporary(pickup) || item.hasMetadata("temporary")) {
            item.removeMetadata("temporary", (Plugin)this.controller.getPlugin());
            item.remove();
            event.setCancelled(true);
            return;
        }
        boolean isWand = Wand.isWand(pickup);
        UndoList undoList = this.controller.getEntityUndo((Entity)item);
        if (undoList != null) {
            undoList.remove((Entity)item);
        }
        Player player = event.getPlayer();
        Mage mage = this.controller.getMage(player);
        Messages messages = this.controller.getMessages();
        if (isWand) {
            Wand wand = this.controller.getWand(pickup);
            if (!wand.canUse(player)) {
                if (this.lastDropWarn == 0L || System.currentTimeMillis() - this.lastDropWarn > 10000L) {
                    mage.sendMessage(messages.get("wand.bound").replace("$name", wand.getOwner()));
                }
                this.lastDropWarn = System.currentTimeMillis();
                event.setCancelled(true);
                return;
            }
            this.controller.removeLostWand(wand.getId());
        }
        if ((activeWand = mage.getActiveWand()) != null && activeWand.isModifiable() && (Wand.isSpell(pickup) || Wand.isBrush(pickup) || Wand.isUpgrade(pickup) || Wand.isSP(pickup)) && activeWand.addItem(pickup)) {
            event.getItem().remove();
            event.setCancelled(true);
            return;
        }
        if (!mage.hasStoredInventory() && isWand) {
            mage.checkWandNextTick();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onConsume(PlayerItemConsumeEvent event) {
        Mage mage;
        MageSpell spell;
        ItemStack item = event.getItem();
        if (!item.hasItemMeta()) {
            return;
        }
        String consumeSpell = this.controller.getWandProperty(item = CompatibilityUtils.makeReal(item), "consume_spell", "");
        if (!consumeSpell.isEmpty() && (spell = (mage = this.controller.getMage(event.getPlayer())).getSpell(consumeSpell)) != null) {
            spell.cast();
        }
    }
}

