/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.item;

import com.elmakers.mine.bukkit.api.economy.Currency;
import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.CostReducer;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class Cost
implements com.elmakers.mine.bukkit.api.item.Cost {
    protected Currency currency;
    protected ItemStack item;
    protected boolean itemWildcard;
    protected double amount;

    public Cost(MageController controller, String key, double cost) {
        this.amount = cost;
        this.setType(controller, key);
    }

    protected void setType(MageController controller, String key) {
        this.currency = controller.getCurrency(key);
        if (this.currency == null) {
            if (key.endsWith(":*")) {
                key = key.substring(0, key.length() - 2);
                this.itemWildcard = true;
            } else {
                this.itemWildcard = false;
            }
            this.item = controller.createItem(key, true);
            if (this.item == null) {
                controller.getLogger().warning("Invalid cost type: " + key);
            }
        }
    }

    public Cost(Cost copy) {
        this.item = copy.item;
        this.itemWildcard = copy.itemWildcard;
        this.amount = copy.amount;
        this.currency = copy.currency;
    }

    @Override
    public boolean isEmpty(CostReducer reducer) {
        if (this.item == null && this.currency == null) {
            return true;
        }
        return this.getAmount(reducer) == 0.0;
    }

    @Override
    public boolean has(Mage mage, CasterProperties caster, CostReducer reducer) {
        if (this.item != null) {
            return this.isConsumeFree(reducer) || this.isCostFree(reducer) || mage.hasItem(this.getItemStack(reducer), this.itemWildcard);
        }
        if (this.currency != null) {
            return this.currency.has(mage, caster, this.getAmount(reducer));
        }
        return false;
    }

    @Override
    public boolean has(Mage mage, Wand wand, CostReducer reducer) {
        return this.has(mage, (CasterProperties)wand, reducer);
    }

    @Override
    public boolean has(Mage mage) {
        return this.has(mage, mage.getActiveWand(), null);
    }

    @Override
    public void deduct(Mage mage, CasterProperties caster, CostReducer reducer) {
        if (this.item != null && !this.isConsumeFree(reducer) && !this.isCostFree(reducer)) {
            ItemStack itemStack = this.getItemStack(reducer);
            mage.removeItem(itemStack, this.itemWildcard);
        }
        if (this.currency != null) {
            this.currency.deduct(mage, caster, this.getAmount(reducer));
        }
    }

    @Override
    public void deduct(Mage mage, Wand wand, CostReducer reducer) {
        this.deduct(mage, (CasterProperties)wand, reducer);
    }

    @Override
    public void deduct(Mage mage) {
        this.deduct(mage, mage.getActiveWand(), null);
    }

    @Override
    public boolean give(Mage mage, CasterProperties caster) {
        boolean result = false;
        if (this.item != null) {
            ItemStack itemStack = this.getItemStack();
            mage.giveItem(itemStack);
            result = true;
        }
        if (this.currency != null) {
            result = this.currency.give(mage, caster, this.getAmount()) || result;
        }
        return result;
    }

    @Override
    public double getBalance(Mage mage, CasterProperties caster) {
        if (this.item != null) {
            double balance = 0.0;
            ItemStack itemStack = this.getItemStack();
            Inventory inventory = mage.getInventory();
            for (ItemStack item : inventory.getContents()) {
                if (item == null || !mage.getController().itemsAreEqual(itemStack, item)) continue;
                balance += (double)item.getAmount();
            }
            return balance;
        }
        if (this.currency != null) {
            return this.currency.getBalance(mage, caster);
        }
        return 0.0;
    }

    protected int getRoundedCost(double cost, CostReducer reducer) {
        return (int)Math.ceil(this.getReducedCost(cost, reducer));
    }

    protected double getReducedCost(double cost, CostReducer reducer) {
        double reduction;
        double reducedAmount = cost;
        double d = reduction = reducer == null ? 0.0 : (double)reducer.getCostReduction();
        if (reduction >= 1.0) {
            return 0.0;
        }
        if (reduction != 0.0) {
            reducedAmount = (1.0 - reduction) * reducedAmount;
        }
        if (reducer != null) {
            reducedAmount *= (double)reducer.getCostScale();
        }
        return reducedAmount;
    }

    public int getRoundedAmount() {
        return (int)Math.ceil(this.amount);
    }

    public int getRoundedAmount(CostReducer reducer) {
        return this.getRoundedCost(this.amount, reducer);
    }

    public double getAmount(CostReducer reducer) {
        return this.getReducedCost(this.amount, reducer);
    }

    public double getAmount() {
        return this.amount;
    }

    public boolean isConsumeFree(CostReducer reducer) {
        return reducer != null && reducer.getConsumeReduction() >= 1.0f;
    }

    public boolean isCostFree(CostReducer reducer) {
        return reducer != null && reducer.getCostReduction() >= 1.0f;
    }

    @Override
    public String getDescription(Messages messages) {
        return this.getDescription(messages, null);
    }

    @Override
    public String getDescription(Messages messages, CostReducer reducer) {
        if (this.item != null) {
            return messages.describeItem(this.item);
        }
        if (this.currency != null) {
            return this.currency.getName(messages);
        }
        return "";
    }

    @Override
    public String getFullDescription(Messages messages) {
        return this.getFullDescription(messages, null);
    }

    @Override
    public String getFullDescription(Messages messages, CostReducer reducer) {
        if (this.item != null) {
            return this.getRoundedAmount(reducer) + " " + messages.describeItem(this.item);
        }
        if (this.currency != null) {
            return this.currency.formatAmount(this.getAmount(reducer), messages);
        }
        return "";
    }

    @Override
    public boolean isItem() {
        return this.item != null;
    }

    @Override
    public ItemStack getItemStack() {
        ItemStack item = CompatibilityUtils.getCopy(this.item);
        if (item != null) {
            item.setAmount((int)Math.max(1.0, Math.ceil(this.amount)));
        }
        return item;
    }

    protected ItemStack getItemStack(CostReducer reducer) {
        ItemStack item = CompatibilityUtils.getCopy(this.item);
        if (item != null) {
            item.setAmount(Math.max(1, this.getRoundedCost(item.getAmount(), reducer)));
        }
        return item;
    }

    private boolean isXP() {
        return this.currency != null && this.currency.getKey().equals("xp");
    }

    private boolean isMana() {
        return this.currency != null && this.currency.getKey().equals("mana");
    }

    @Deprecated
    public int getXP(CostReducer reducer) {
        return this.isXP() ? this.getRoundedCost(this.amount, reducer) : 0;
    }

    public int getMana(CostReducer reducer) {
        return this.isMana() ? this.getRoundedCost(this.amount, reducer) : 0;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    @Override
    public void scale(double scale) {
        this.setAmount(this.amount * scale);
    }

    public String toString() {
        if (this.item != null) {
            return this.item.getType().name() + ":" + this.amount;
        }
        if (this.currency != null) {
            return this.currency.getKey() + ":" + this.amount;
        }
        return "Unknown Cost:" + this.amount;
    }

    @Nullable
    public static Cost parseCost(MageController controller, String costString, String defaultType) {
        Cost cost = null;
        if (costString != null && !costString.isEmpty()) {
            String[] pieces = StringUtils.split((String)costString, (char)' ');
            int amount = 0;
            try {
                amount = Integer.parseInt(pieces[0]);
            }
            catch (Exception ex) {
                controller.getLogger().warning("Invalid cost string: " + costString);
            }
            String type = pieces.length > 1 ? pieces[1] : defaultType;
            cost = new Cost(controller, type, amount);
        }
        return cost;
    }

    @Nullable
    private String getFallbackType(String fallbackType) {
        if (this.currency != null && !this.currency.isValid()) {
            return fallbackType;
        }
        return null;
    }

    private boolean checkSupportedType(MageController controller, String fallbackType) {
        String newType = this.getFallbackType(fallbackType);
        if (newType == null) {
            return false;
        }
        this.convert(controller, newType);
        return true;
    }

    @Override
    public boolean checkSupported(MageController controller, String ... fallbackTypes) {
        String fallbackType;
        boolean check;
        boolean modified = false;
        String[] stringArray = fallbackTypes;
        int n = stringArray.length;
        for (int i = 0; i < n && (check = this.checkSupportedType(controller, fallbackType = stringArray[i])); ++i) {
            modified = check;
        }
        return modified;
    }

    @Override
    public void convert(MageController controller, String newType) {
        double newWorth;
        double currentWorth = this.currency != null ? this.currency.getWorth() : 1.0;
        this.setType(controller, newType);
        double d = newWorth = this.currency != null ? this.currency.getWorth() : 1.0;
        if (newWorth > 0.0 && currentWorth > 0.0) {
            this.scale(currentWorth / newWorth);
        }
    }
}

