/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration.skript;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Kleenean;
import com.elmakers.mine.bukkit.api.event.CastEvent;
import com.elmakers.mine.bukkit.api.event.PreCastEvent;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="Caster")
@Description(value={"The caster of a spell event.", "Please note that the attacker can also be a command block or the console, but this expression will not be set in these cases."})
@Examples(value={"on cast:", "    caster is a player", "    health of caster is less than or equal to 2", "    damage targets by 1 heart"})
public class ExprCaster
extends SimpleExpression<Entity> {
    public static void register() {
        Skript.registerExpression(ExprCaster.class, Entity.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] (caster)"});
    }

    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (!ScriptLoader.isCurrentEvent(CastEvent.class) && !ScriptLoader.isCurrentEvent(PreCastEvent.class)) {
            Skript.error((String)"Cannot use 'caster' outside of a cast event", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }

    protected Entity[] get(Event e) {
        return new Entity[]{ExprCaster.getCaster(e)};
    }

    @Nullable
    private static Entity getCaster(Event e) {
        if (e != null && e instanceof CastEvent) {
            return ((CastEvent)e).getMage().getEntity();
        }
        return null;
    }

    public Class<? extends Entity> getReturnType() {
        return Entity.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        if (e == null) {
            return "the caster";
        }
        return Classes.getDebugMessage((Object)this.getSingle(e));
    }

    public boolean isSingle() {
        return true;
    }
}

