/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.annotation.Nullable;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import net.milkbowl.vault.item.ItemInfo;
import net.milkbowl.vault.item.Items;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultController {
    private static VaultController instance;
    private Economy economy;
    private NumberFormat formatter = new DecimalFormat("#0.00");

    public static VaultController getInstance() {
        return instance;
    }

    public static boolean initialize(Plugin callingPlugin, Plugin vaultPlugin) {
        try {
            Economy economy;
            RegisteredServiceProvider ecoProvider = vaultPlugin.getServer().getServicesManager().getRegistration(Economy.class);
            Economy economy2 = economy = ecoProvider == null ? null : (Economy)ecoProvider.getProvider();
            if (economy == null) {
                callingPlugin.getLogger().info("Vault found, descriptive item names available, but no economy found");
            } else {
                callingPlugin.getLogger().info("Vault found, 'currency' cost types and descriptive item names available");
            }
            instance = new VaultController(callingPlugin, economy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            instance = null;
            return false;
        }
        return true;
    }

    public static boolean hasEconomy() {
        if (instance == null) {
            return false;
        }
        return VaultController.instance.economy != null;
    }

    private VaultController(Plugin owner, Economy economy) {
        this.economy = economy;
    }

    public double getBalance(Player player) {
        if (this.economy == null || player == null) {
            return 0.0;
        }
        return this.economy.getBalance((OfflinePlayer)player);
    }

    public boolean has(Player player, double amount) {
        if (this.economy == null || player == null) {
            return false;
        }
        return this.economy.has((OfflinePlayer)player, amount);
    }

    public String format(double amount) {
        if (this.economy == null) {
            return this.formatter.format(amount);
        }
        return this.economy.format(amount);
    }

    public String getCurrency() {
        return this.economy == null ? "" : this.economy.currencyNameSingular();
    }

    public String getCurrencyPlural() {
        return this.economy == null ? "" : this.economy.currencyNamePlural();
    }

    public boolean withdrawPlayer(Player player, double amount) {
        if (this.economy == null || player == null) {
            return false;
        }
        EconomyResponse response = this.economy.withdrawPlayer((OfflinePlayer)player, amount);
        return response.transactionSuccess();
    }

    public boolean depositPlayer(Player player, double amount) {
        if (this.economy == null || player == null) {
            return false;
        }
        EconomyResponse response = this.economy.depositPlayer((OfflinePlayer)player, amount);
        return response.transactionSuccess();
    }

    @Nullable
    public String getItemName(Material material, short data) {
        ItemInfo info = Items.itemByType((Material)material, (short)data);
        return info == null ? null : info.getName();
    }
}

