/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effect;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nullable;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;

public class EffectUtils
extends NMSUtils {
    public static void spawnFireworkEffect(Server server, Location location, FireworkEffect effect, int power) {
        EffectUtils.spawnFireworkEffect(server, location, effect, power, null, 2, 1);
    }

    public static void spawnFireworkEffect(Server server, Location location, FireworkEffect effect, int power, boolean silent) {
        EffectUtils.spawnFireworkEffect(server, location, effect, power, null, 2, 1, silent);
    }

    @Nullable
    public static Entity spawnFireworkEffect(Server server, Location location, FireworkEffect effect, int power, Vector direction, Integer expectedLifespan, Integer ticksFlown) {
        return EffectUtils.spawnFireworkEffect(server, location, effect, power, direction, expectedLifespan, ticksFlown, false);
    }

    @Nullable
    public static Entity spawnFireworkEffect(Server server, Location location, FireworkEffect effect, int power, Vector direction, Integer expectedLifespan, Integer ticksFlown, boolean silent) {
        Entity entity = null;
        try {
            Material fireworkMaterial = DefaultMaterials.getFirework();
            if (fireworkMaterial == null) {
                return null;
            }
            Object world = EffectUtils.getHandle(location.getWorld());
            ItemStack itemStack = new ItemStack(fireworkMaterial);
            FireworkMeta meta = (FireworkMeta)itemStack.getItemMeta();
            meta.addEffect(effect);
            meta.setPower(power);
            itemStack.setItemMeta((ItemMeta)meta);
            Object item = EffectUtils.getHandle(EffectUtils.makeReal(itemStack));
            Object fireworkHandle = class_EntityFireworkConstructor.newInstance(world, location.getX(), location.getY(), location.getZ(), item);
            CompatibilityUtils.setSilent(fireworkHandle, silent);
            if (direction != null) {
                class_Entity_motXField.set(fireworkHandle, direction.getX());
                class_Entity_motYField.set(fireworkHandle, direction.getY());
                class_Entity_motZField.set(fireworkHandle, direction.getZ());
            }
            if (ticksFlown != null) {
                class_Firework_ticksFlownField.set(fireworkHandle, ticksFlown);
            }
            if (expectedLifespan != null) {
                class_Firework_expectedLifespanField.set(fireworkHandle, expectedLifespan);
            }
            if (direction == null) {
                Object fireworkPacket = class_PacketSpawnEntityConstructor.newInstance(fireworkHandle, FIREWORK_TYPE);
                Object fireworkId = class_Entity_getIdMethod.invoke(fireworkHandle, new Object[0]);
                Object watcher = class_Entity_getDataWatcherMethod.invoke(fireworkHandle, new Object[0]);
                Object metadataPacket = class_PacketPlayOutEntityMetadata_Constructor.newInstance(fireworkId, watcher, true);
                Object statusPacket = class_PacketPlayOutEntityStatus_Constructor.newInstance(fireworkHandle, (byte)17);
                Constructor packetDestroyEntityConstructor = class_PacketPlayOutEntityDestroy.getConstructor(int[].class);
                Object destroyPacket = packetDestroyEntityConstructor.newInstance(new Object[]{new int[]{(Integer)fireworkId}});
                Collection players = server.getOnlinePlayers();
                EffectUtils.sendPacket(server, location, players, fireworkPacket);
                EffectUtils.sendPacket(server, location, players, metadataPacket);
                EffectUtils.sendPacket(server, location, players, statusPacket);
                EffectUtils.sendPacket(server, location, players, destroyPacket);
                return null;
            }
            class_World_addEntityMethod.invoke(world, fireworkHandle, CreatureSpawnEvent.SpawnReason.CUSTOM);
            entity = (Entity)class_Entity_getBukkitEntityMethod.invoke(fireworkHandle, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return entity;
    }

    public static FireworkEffect getFireworkEffect(CastContext context, Color color1, Color color2, FireworkEffect.Type fireworkType, Boolean flicker, Boolean trail) {
        return EffectUtils.getFireworkEffect(context, color1, color2, fireworkType, flicker, trail, true);
    }

    public static FireworkEffect getFireworkEffect(CastContext context, Color color1, Color color2, FireworkEffect.Type fireworkType, Boolean flicker, Boolean trail, boolean useWandColor) {
        Mage mage = context.getMage();
        Random random = context.getRandom();
        Color wandColor = mage.getEffectColor();
        if (wandColor != null && useWandColor) {
            color1 = wandColor;
            color2 = wandColor.mixColors(new Color[]{color1, Color.WHITE});
        } else {
            if (color1 == null) {
                color1 = Color.fromRGB((int)random.nextInt(255), (int)random.nextInt(255), (int)random.nextInt(255));
            }
            if (color2 == null) {
                color2 = Color.fromRGB((int)random.nextInt(255), (int)random.nextInt(255), (int)random.nextInt(255));
            }
        }
        if (fireworkType == null) {
            fireworkType = FireworkEffect.Type.values()[random.nextInt(FireworkEffect.Type.values().length)];
        }
        if (flicker == null) {
            flicker = random.nextBoolean();
        }
        if (trail == null) {
            trail = random.nextBoolean();
        }
        return FireworkEffect.builder().flicker(flicker.booleanValue()).withColor(color1).withFade(color2).with(fireworkType).trail(trail.booleanValue()).build();
    }
}

