/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.automata;

import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.automata.Automaton;
import com.elmakers.mine.bukkit.automata.Caster;
import com.elmakers.mine.bukkit.automata.Spawner;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class AutomatonTemplate {
    @Nonnull
    private final MageController controller;
    @Nonnull
    private final ConfigurationSection configuration;
    @Nonnull
    private final String key;
    @Nullable
    private String name;
    private int interval;
    @Nullable
    private Spawner spawner;
    @Nullable
    private Caster caster;
    @Nullable
    private Collection<EffectPlayer> effects;

    public AutomatonTemplate(@Nonnull MageController controller, @Nonnull String key, @Nonnull ConfigurationSection configuration) {
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.controller = controller;
        this.configuration = configuration;
        this.name = configuration.getString("name");
        this.interval = configuration.getInt("interval", 0);
        if (configuration.isList("effects")) {
            this.effects = controller.loadEffects(configuration, "effects");
        } else {
            String effectKey = configuration.getString("effects");
            if (effectKey != null) {
                this.effects = controller.getEffects(effectKey);
                if (this.effects.isEmpty()) {
                    this.effects = null;
                }
            }
        }
        if (configuration.contains("spawn")) {
            this.spawner = new Spawner(controller, this, configuration.getConfigurationSection("spawn"));
        }
        if (configuration.contains("cast")) {
            this.caster = new Caster(this, configuration.getConfigurationSection("cast"));
        }
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public String getName() {
        String name = this.name;
        return name == null ? this.key : name;
    }

    public int getInterval() {
        return this.interval;
    }

    public void tick(Automaton instance) {
        if (this.spawner != null) {
            List<Entity> entities = this.spawner.spawn(instance.getLocation());
            if (entities != null && !entities.isEmpty()) {
                instance.track(entities);
            }
            instance.checkEntities();
        }
        if (this.caster != null) {
            this.caster.cast(instance.getMage());
        }
    }

    public AutomatonTemplate getVariant(ConfigurationSection parameters) {
        ConfigurationSection mergedConfiguration = ConfigurationUtils.cloneConfiguration(this.configuration);
        mergedConfiguration = ConfigurationUtils.addConfigurations(mergedConfiguration, parameters);
        return new AutomatonTemplate(this.controller, this.key, mergedConfiguration);
    }

    @Nullable
    public Collection<EffectPlayer> getEffects() {
        return this.effects;
    }
}

