/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;

public class CheckHealthAction
extends CompoundAction {
    private Double minHealth;
    private Double maxHealth;
    private boolean fullHealth;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        if (parameters.contains("min_health")) {
            this.minHealth = parameters.getDouble("min_health");
        }
        if (parameters.contains("max_health")) {
            this.maxHealth = parameters.getDouble("max_health");
        }
        this.fullHealth = parameters.getBoolean("full_health", false);
    }

    protected boolean isAllowed(CastContext context) {
        Entity targetEntity = context.getTargetEntity();
        if (targetEntity == null || !(targetEntity instanceof Damageable)) {
            return false;
        }
        Damageable damageable = (Damageable)targetEntity;
        if (this.fullHealth && damageable.getHealth() < CompatibilityUtils.getMaxHealth(damageable)) {
            return false;
        }
        if (this.minHealth != null && damageable.getHealth() < this.minHealth) {
            return false;
        }
        return this.maxHealth == null || !(damageable.getHealth() > this.maxHealth);
    }

    @Override
    public SpellResult step(CastContext context) {
        boolean allowed = this.isAllowed(context);
        ActionHandler actions = this.getHandler("actions");
        if (actions == null || actions.size() == 0) {
            return allowed ? SpellResult.CAST : SpellResult.STOP;
        }
        if (!allowed) {
            return SpellResult.NO_TARGET;
        }
        return this.startActions();
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }
}

