/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.protection;

import com.elmakers.mine.bukkit.api.entity.TeamProvider;
import com.elmakers.mine.bukkit.api.protection.BlockBreakManager;
import com.elmakers.mine.bukkit.api.protection.BlockBuildManager;
import com.elmakers.mine.bukkit.api.protection.PVPManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class FactionsManager
implements BlockBuildManager,
BlockBreakManager,
PVPManager,
TeamProvider {
    private boolean enabled = false;
    private Class<?> factionsManager = null;
    private Method factionsCanBuildMethod = null;
    private boolean methodIsBlock = false;
    private Object board = null;
    private Method getFactionAtMethod = null;
    private Method isSafeZoneMethod = null;
    private Method isNoneMethod = null;
    private Method getFlagMethod = null;
    private Constructor<?> flocationConstructor = null;
    private Method psFactoryMethod = null;
    private Class<?> playerClass;
    private Method playerGetMethod;
    private Method playerGetFactionMethod;
    private Method factionGetRelationMethod;
    private Class<?> relationClass;
    private Method relationIsFriendMethod;
    private Method relationIsAllyMethod;
    private Method relationIsMemberMethod;
    private Method relationIsTruceMethod;
    private Object fPlayers;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled && this.factionsManager != null;
    }

    public void initialize(Plugin plugin) {
        if (this.enabled) {
            Plugin factionsPlugin = plugin.getServer().getPluginManager().getPlugin("Factions");
            if (factionsPlugin != null) {
                try {
                    Class<?> psClass = Class.forName("com.massivecraft.massivecore.ps.PS");
                    this.factionsManager = Class.forName("com.massivecraft.factions.engine.EngineMain");
                    this.factionsCanBuildMethod = this.factionsManager.getMethod("canPlayerBuildAt", Object.class, psClass, Boolean.TYPE);
                    this.psFactoryMethod = psClass.getMethod("valueOf", Location.class);
                    Class<?> boardClass = Class.forName("com.massivecraft.factions.entity.BoardColl");
                    Method boardSingleton = boardClass.getMethod("get", new Class[0]);
                    this.board = boardSingleton.invoke(null, new Object[0]);
                    this.getFactionAtMethod = boardClass.getMethod("getFactionAt", psClass);
                    Class<?> factionClass = Class.forName("com.massivecraft.factions.entity.Faction");
                    this.isNoneMethod = factionClass.getMethod("isNone", new Class[0]);
                    if (this.factionsManager == null || this.factionsCanBuildMethod == null || this.psFactoryMethod == null) {
                        this.factionsManager = null;
                        this.factionsCanBuildMethod = null;
                        this.psFactoryMethod = null;
                    }
                    try {
                        this.getFlagMethod = factionClass.getMethod("getFlag", String.class);
                    }
                    catch (Exception ex) {
                        this.isSafeZoneMethod = factionClass.getMethod("isSafeZone", new Class[0]);
                    }
                    try {
                        this.playerClass = Class.forName("com.massivecraft.factions.entity.MPlayer");
                        this.playerGetMethod = this.playerClass.getMethod("get", Object.class);
                        this.playerGetFactionMethod = this.playerClass.getMethod("getFaction", new Class[0]);
                        Class<?> relationParticipator = Class.forName("com.massivecraft.factions.RelationParticipator");
                        this.factionGetRelationMethod = factionClass.getMethod("getRelationTo", relationParticipator);
                        this.relationClass = Class.forName("com.massivecraft.factions.Rel");
                        this.relationIsFriendMethod = this.relationClass.getMethod("isFriend", new Class[0]);
                    }
                    catch (Exception ex) {
                        this.playerClass = null;
                        plugin.getLogger().log(Level.WARNING, "Error binding to Factions, team provider will not work", ex);
                    }
                }
                catch (Throwable ex) {
                    this.psFactoryMethod = null;
                    try {
                        this.factionsManager = Class.forName("com.massivecraft.factions.listeners.FactionsBlockListener");
                        try {
                            this.factionsCanBuildMethod = this.factionsManager.getMethod("playerCanBuildDestroyBlock", Player.class, Location.class, String.class, Boolean.TYPE);
                        }
                        catch (Exception notLoc) {
                            this.methodIsBlock = true;
                            this.factionsCanBuildMethod = this.factionsManager.getMethod("playerCanBuildDestroyBlock", Player.class, Block.class, String.class, Boolean.TYPE);
                        }
                        if (this.factionsManager == null || this.factionsCanBuildMethod == null) {
                            this.factionsManager = null;
                            this.factionsCanBuildMethod = null;
                        } else {
                            plugin.getLogger().info("Factions 1.8.2+ build found");
                        }
                        Class<?> factionClass = Class.forName("com.massivecraft.factions.Faction");
                        this.isSafeZoneMethod = factionClass.getMethod("isSafeZone", new Class[0]);
                        this.isNoneMethod = factionClass.getMethod("isNone", new Class[0]);
                        Class<?> flocationClass = Class.forName("com.massivecraft.factions.FLocation");
                        this.flocationConstructor = flocationClass.getConstructor(Location.class);
                        Class<?> boardClass = Class.forName("com.massivecraft.factions.Board");
                        Method boardSingleton = boardClass.getMethod("getInstance", new Class[0]);
                        this.board = boardSingleton.invoke(null, new Object[0]);
                        this.getFactionAtMethod = boardClass.getMethod("getFactionAt", flocationClass);
                        try {
                            Class<?> fPlayersClass = Class.forName("com.massivecraft.factions.FPlayers");
                            Method fPlayersGetMethod = fPlayersClass.getMethod("getInstance", new Class[0]);
                            this.fPlayers = fPlayersGetMethod.invoke(null, new Object[0]);
                            this.playerClass = Class.forName("com.massivecraft.factions.FPlayer");
                            this.playerGetMethod = fPlayersClass.getMethod("getByPlayer", Player.class);
                            this.playerGetFactionMethod = this.playerClass.getMethod("getFaction", new Class[0]);
                            Class<?> relationParticipator = Class.forName("com.massivecraft.factions.iface.RelationParticipator");
                            this.factionGetRelationMethod = factionClass.getMethod("getRelationTo", relationParticipator);
                            this.relationClass = Class.forName("com.massivecraft.factions.struct.Relation");
                            this.relationIsAllyMethod = this.relationClass.getMethod("isAlly", new Class[0]);
                            this.relationIsTruceMethod = this.relationClass.getMethod("isTruce", new Class[0]);
                            this.relationIsMemberMethod = this.relationClass.getMethod("isMember", new Class[0]);
                        }
                        catch (Exception ex3) {
                            this.playerClass = null;
                            plugin.getLogger().log(Level.WARNING, "Error binding to Factions, team provider will not work", ex3);
                        }
                    }
                    catch (Throwable ex2) {
                        plugin.getLogger().log(Level.WARNING, "Failed to find mcore", ex);
                        plugin.getLogger().log(Level.WARNING, "Failed to find FactionsBlockListener", ex2);
                        this.factionsManager = null;
                        this.factionsCanBuildMethod = null;
                    }
                }
                if (this.factionsManager == null) {
                    plugin.getLogger().info("Factions integration failed.");
                } else {
                    plugin.getLogger().info("Factions found, will integrate for build, friendly fire and safe zone checks.");
                }
            } else {
                plugin.getLogger().info("Factions not found, will not integrate.");
            }
        } else {
            plugin.getLogger().info("Factions integration disabled");
        }
    }

    @Nullable
    private Object getFLocation(Location location) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        if (this.flocationConstructor != null) {
            return this.flocationConstructor.newInstance(location);
        }
        if (this.psFactoryMethod != null) {
            return this.psFactoryMethod.invoke(null, location);
        }
        return null;
    }

    @Nullable
    private Object getFactionAt(Location location) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        if (this.board == null || this.getFactionAtMethod == null) {
            return null;
        }
        Object loc = this.getFLocation(location);
        if (loc == null) {
            return null;
        }
        return this.getFactionAtMethod.invoke(this.board, loc);
    }

    @Override
    public boolean hasBuildPermission(Player player, Block block) {
        if (this.enabled && block != null && this.factionsManager != null && this.factionsCanBuildMethod != null) {
            if (player == null) {
                if (this.isNoneMethod == null || this.board == null) {
                    return false;
                }
                try {
                    Object faction = this.getFactionAt(block.getLocation());
                    return faction == null || (Boolean)this.isNoneMethod.invoke(faction, new Object[0]) != false;
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
            try {
                if (this.psFactoryMethod != null) {
                    Object loc = this.psFactoryMethod.invoke(null, block.getLocation());
                    return loc != null && (Boolean)this.factionsCanBuildMethod.invoke(null, player, loc, false) != false;
                }
                Block checkObject = this.methodIsBlock ? block : block.getLocation();
                return (Boolean)this.factionsCanBuildMethod.invoke(null, player, checkObject, "destroy", true);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasBreakPermission(Player player, Block block) {
        return this.hasBuildPermission(player, block);
    }

    @Override
    public boolean isPVPAllowed(Player player, Location location) {
        if (!this.enabled || location == null || this.factionsManager == null || this.board == null) {
            return true;
        }
        if (this.getFlagMethod != null) {
            try {
                Object faction = this.getFactionAt(location);
                return faction == null || (Boolean)this.getFlagMethod.invoke(faction, "pvp") != false;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                return false;
            }
        }
        if (this.isSafeZoneMethod != null) {
            try {
                Object faction = this.getFactionAt(location);
                return faction == null || (Boolean)this.isSafeZoneMethod.invoke(faction, new Object[0]) == false;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isFriendly(Entity attacker, Entity entity) {
        if (this.playerGetFactionMethod == null || this.playerGetMethod == null || this.factionGetRelationMethod == null) {
            return false;
        }
        if (attacker instanceof Player && entity instanceof Player && this.playerClass != null) {
            try {
                Object player1 = this.playerGetMethod.invoke(this.fPlayers, attacker);
                Object player2 = this.playerGetMethod.invoke(this.fPlayers, entity);
                if (player1 == null || player2 == null) {
                    return false;
                }
                Object faction1 = this.playerGetFactionMethod.invoke(player1, new Object[0]);
                Object faction2 = this.playerGetFactionMethod.invoke(player2, new Object[0]);
                if (((Boolean)this.isNoneMethod.invoke(faction1, new Object[0])).booleanValue() || ((Boolean)this.isNoneMethod.invoke(faction2, new Object[0])).booleanValue()) {
                    return false;
                }
                Object relation = this.factionGetRelationMethod.invoke(faction1, faction2);
                if (this.relationIsFriendMethod != null) {
                    return (Boolean)this.relationIsFriendMethod.invoke(relation, new Object[0]);
                }
                if (this.relationIsMemberMethod == null || this.relationIsAllyMethod == null || this.relationIsTruceMethod == null) {
                    return false;
                }
                if (((Boolean)this.relationIsMemberMethod.invoke(relation, new Object[0])).booleanValue()) {
                    return true;
                }
                if (((Boolean)this.relationIsAllyMethod.invoke(relation, new Object[0])).booleanValue()) {
                    return true;
                }
                if (((Boolean)this.relationIsTruceMethod.invoke(relation, new Object[0])).booleanValue()) {
                    return true;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }
}

