/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.attributes.AttributeProvider;
import com.elmakers.mine.bukkit.api.block.BlockList;
import com.elmakers.mine.bukkit.api.block.BoundingBox;
import com.elmakers.mine.bukkit.api.block.CurrencyItem;
import com.elmakers.mine.bukkit.api.block.UndoQueue;
import com.elmakers.mine.bukkit.api.data.MageData;
import com.elmakers.mine.bukkit.api.data.MageDataCallback;
import com.elmakers.mine.bukkit.api.data.MageDataStore;
import com.elmakers.mine.bukkit.api.data.SpellData;
import com.elmakers.mine.bukkit.api.economy.Currency;
import com.elmakers.mine.bukkit.api.effect.EffectContext;
import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.api.entity.TeamProvider;
import com.elmakers.mine.bukkit.api.event.LoadEvent;
import com.elmakers.mine.bukkit.api.event.PreLoadEvent;
import com.elmakers.mine.bukkit.api.event.SaveEvent;
import com.elmakers.mine.bukkit.api.item.ItemUpdatedCallback;
import com.elmakers.mine.bukkit.api.magic.CastSourceLocation;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.magic.MaterialSetManager;
import com.elmakers.mine.bukkit.api.protection.BlockBreakManager;
import com.elmakers.mine.bukkit.api.protection.BlockBuildManager;
import com.elmakers.mine.bukkit.api.protection.PVPManager;
import com.elmakers.mine.bukkit.api.requirements.Requirement;
import com.elmakers.mine.bukkit.api.requirements.RequirementsProcessor;
import com.elmakers.mine.bukkit.api.spell.CastingCost;
import com.elmakers.mine.bukkit.api.spell.CostReducer;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.WandTemplate;
import com.elmakers.mine.bukkit.automata.Automaton;
import com.elmakers.mine.bukkit.automata.AutomatonTemplate;
import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.block.Schematic;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.bstats.Metrics;
import com.elmakers.mine.bukkit.citizens.CitizensController;
import com.elmakers.mine.bukkit.data.YamlDataFile;
import com.elmakers.mine.bukkit.dynmap.DynmapController;
import com.elmakers.mine.bukkit.economy.CustomCurrency;
import com.elmakers.mine.bukkit.economy.ExperienceCurrency;
import com.elmakers.mine.bukkit.economy.HealthCurrency;
import com.elmakers.mine.bukkit.economy.HungerCurrency;
import com.elmakers.mine.bukkit.economy.ItemCurrency;
import com.elmakers.mine.bukkit.economy.LevelCurrency;
import com.elmakers.mine.bukkit.economy.ManaCurrency;
import com.elmakers.mine.bukkit.economy.SpellPointCurrency;
import com.elmakers.mine.bukkit.economy.VaultCurrency;
import com.elmakers.mine.bukkit.effect.EffectPlayer;
import com.elmakers.mine.bukkit.elementals.ElementalsController;
import com.elmakers.mine.bukkit.entity.ScoreboardTeamProvider;
import com.elmakers.mine.bukkit.essentials.MagicItemDb;
import com.elmakers.mine.bukkit.essentials.Mailer;
import com.elmakers.mine.bukkit.heroes.HeroesManager;
import com.elmakers.mine.bukkit.integration.GenericMetadataNPCSupplier;
import com.elmakers.mine.bukkit.integration.LibsDisguiseManager;
import com.elmakers.mine.bukkit.integration.LightAPIManager;
import com.elmakers.mine.bukkit.integration.LogBlockManager;
import com.elmakers.mine.bukkit.integration.NPCSupplierSet;
import com.elmakers.mine.bukkit.integration.PlaceholderAPIManager;
import com.elmakers.mine.bukkit.integration.SkillAPIManager;
import com.elmakers.mine.bukkit.integration.SkriptManager;
import com.elmakers.mine.bukkit.integration.VaultController;
import com.elmakers.mine.bukkit.integration.mobarena.MobArenaManager;
import com.elmakers.mine.bukkit.item.ItemData;
import com.elmakers.mine.bukkit.magic.AutoSaveTask;
import com.elmakers.mine.bukkit.magic.AutomataUpdateTask;
import com.elmakers.mine.bukkit.magic.BatchUpdateTask;
import com.elmakers.mine.bukkit.magic.ChangeServerTask;
import com.elmakers.mine.bukkit.magic.ConfigCheckTask;
import com.elmakers.mine.bukkit.magic.ConfigurationLoadTask;
import com.elmakers.mine.bukkit.magic.DamageType;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MageClassTemplate;
import com.elmakers.mine.bukkit.magic.MageIdentifier;
import com.elmakers.mine.bukkit.magic.MageParameters;
import com.elmakers.mine.bukkit.magic.MageUpdateTask;
import com.elmakers.mine.bukkit.magic.MagicAttribute;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.magic.MagicRecipe;
import com.elmakers.mine.bukkit.magic.ManaController;
import com.elmakers.mine.bukkit.magic.MaterialSets;
import com.elmakers.mine.bukkit.magic.PhysicsHandler;
import com.elmakers.mine.bukkit.magic.RPCheckTask;
import com.elmakers.mine.bukkit.magic.SimpleMaterialSetManager;
import com.elmakers.mine.bukkit.magic.UndoUpdateTask;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.magic.listener.AnvilController;
import com.elmakers.mine.bukkit.magic.listener.BlockController;
import com.elmakers.mine.bukkit.magic.listener.CraftingController;
import com.elmakers.mine.bukkit.magic.listener.EnchantingController;
import com.elmakers.mine.bukkit.magic.listener.EntityController;
import com.elmakers.mine.bukkit.magic.listener.ExplosionController;
import com.elmakers.mine.bukkit.magic.listener.HangingController;
import com.elmakers.mine.bukkit.magic.listener.InventoryController;
import com.elmakers.mine.bukkit.magic.listener.ItemController;
import com.elmakers.mine.bukkit.magic.listener.LoadSchematicTask;
import com.elmakers.mine.bukkit.magic.listener.MinigamesListener;
import com.elmakers.mine.bukkit.magic.listener.MobController;
import com.elmakers.mine.bukkit.magic.listener.PlayerController;
import com.elmakers.mine.bukkit.maps.MapController;
import com.elmakers.mine.bukkit.protection.CitadelManager;
import com.elmakers.mine.bukkit.protection.FactionsManager;
import com.elmakers.mine.bukkit.protection.GriefPreventionManager;
import com.elmakers.mine.bukkit.protection.LocketteManager;
import com.elmakers.mine.bukkit.protection.MultiverseManager;
import com.elmakers.mine.bukkit.protection.NCPManager;
import com.elmakers.mine.bukkit.protection.PreciousStonesManager;
import com.elmakers.mine.bukkit.protection.ProtectionManager;
import com.elmakers.mine.bukkit.protection.PvPManagerManager;
import com.elmakers.mine.bukkit.protection.TownyManager;
import com.elmakers.mine.bukkit.protection.WorldGuardManager;
import com.elmakers.mine.bukkit.requirements.RequirementsController;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationStore;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.spell.SpellCategory;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.HitboxUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.Messages;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.utility.SafetyUtils;
import com.elmakers.mine.bukkit.utility.SkinUtils;
import com.elmakers.mine.bukkit.utility.SkullLoadedCallback;
import com.elmakers.mine.bukkit.wand.LostWand;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandManaMode;
import com.elmakers.mine.bukkit.wand.WandMode;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import com.elmakers.mine.bukkit.warp.WarpController;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.io.BaseEncoding;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitTask;

public class MagicController
implements MageController {
    private static final String BUILTIN_SPELL_CLASSPATH = "com.elmakers.mine.bukkit.spell.builtin";
    private static final String RP_FILE = "resourcepack";
    private static final String LOST_WANDS_FILE = "lostwands";
    private static final String WARPS_FILE = "warps";
    private static final String SPELLS_DATA_FILE = "spells";
    private static final String AUTOMATA_DATA_FILE = "automata";
    private static final String URL_MAPS_FILE = "imagemaps";
    private MaterialAndData redstoneReplacement = new MaterialAndData(Material.OBSIDIAN);
    @Nonnull
    private MaterialSet buildingMaterials = MaterialSets.empty();
    @Nonnull
    private MaterialSet indestructibleMaterials = MaterialSets.empty();
    @Nonnull
    private MaterialSet restrictedMaterials = MaterialSets.empty();
    @Nonnull
    private MaterialSet destructibleMaterials = MaterialSets.empty();
    @Nonnull
    private MaterialSet interactibleMaterials = MaterialSets.empty();
    @Nonnull
    private MaterialSet containerMaterials = MaterialSets.empty();
    @Nonnull
    private MaterialSet wearableMaterials = MaterialSets.empty();
    @Nonnull
    private MaterialSet meleeMaterials = MaterialSets.empty();
    private boolean backupInventories = true;
    private int undoTimeWindow = 6000;
    private int undoQueueDepth = 256;
    private int pendingQueueDepth = 16;
    private int undoMaxPersistSize = 0;
    private boolean commitOnQuit = false;
    private boolean saveNonPlayerMages = false;
    private String defaultWandPath = "";
    private WandMode defaultWandMode = WandMode.NONE;
    private WandMode defaultBrushMode = WandMode.CHEST;
    private boolean showMessages = true;
    private boolean showCastMessages = false;
    private String messagePrefix = "";
    private String castMessagePrefix = "";
    private boolean soundsEnabled = true;
    private String welcomeWand = "";
    private int messageThrottle = 0;
    private boolean spellDroppingEnabled = false;
    private boolean fillingEnabled = false;
    private int maxFillLevel = 0;
    private boolean essentialsSignsEnabled = false;
    private boolean dynmapUpdate = true;
    private boolean dynmapShowWands = true;
    private boolean dynmapOnlyPlayerSpells = false;
    private boolean dynmapShowSpells = true;
    private boolean createWorldsEnabled = true;
    private float maxDamagePowerMultiplier = 2.0f;
    private float maxConstructionPowerMultiplier = 5.0f;
    private float maxRadiusPowerMultiplier = 2.5f;
    private float maxRadiusPowerMultiplierMax = 4.0f;
    private float maxRangePowerMultiplier = 3.0f;
    private float maxRangePowerMultiplierMax = 5.0f;
    private float maxPower = 100.0f;
    private Map<String, DamageType> damageTypes = new HashMap<String, DamageType>();
    private float maxCostReduction = 0.5f;
    private float maxCooldownReduction = 0.5f;
    private int maxMana = 1000;
    private int maxManaRegeneration = 100;
    private double worthBase = 1.0;
    private double worthSkillPoints = 1.0;
    private String skillPointIcon = null;
    private boolean skillPointItemsEnabled = true;
    private double worthXP = 1.0;
    private CurrencyItem currencyItem = null;
    private boolean spEnabled = true;
    private boolean spEarnEnabled = true;
    private int spMaximum = 0;
    private boolean castCommandCostFree = false;
    private boolean castCommandCooldownFree = false;
    private float castCommandPowerMultiplier = 0.0f;
    private boolean castConsoleCostFree = false;
    private boolean castConsoleCooldownFree = false;
    private float castConsolePowerMultiplier = 0.0f;
    private float costReduction = 0.0f;
    private float cooldownReduction = 0.0f;
    private int autoUndo = 0;
    private int autoSaveTaskId = 0;
    private BukkitTask configCheckTask = null;
    private boolean savePlayerData = true;
    private boolean externalPlayerData = false;
    private boolean asynchronousSaving = true;
    private WarpController warpController = null;
    private Collection<ConfigurationSection> materialColors = null;
    private List<Object> materialVariants = null;
    private ConfigurationSection blockItems = null;
    private ConfigurationSection currencyConfiguration = null;
    private Map<Material, String> blockSkins = new HashMap<Material, String>();
    private Map<EntityType, String> mobSkins = new HashMap<EntityType, String>();
    private Map<EntityType, MaterialAndData> skullItems = new HashMap<EntityType, MaterialAndData>();
    private Map<EntityType, MaterialAndData> skullWallBlocks = new HashMap<EntityType, MaterialAndData>();
    private Map<EntityType, MaterialAndData> skullGroundBlocks = new HashMap<EntityType, MaterialAndData>();
    private Map<EntityType, Material> mobEggs = new HashMap<EntityType, Material>();
    private final Map<String, AutomatonTemplate> automatonTemplates = new HashMap<String, AutomatonTemplate>();
    private final Map<String, com.elmakers.mine.bukkit.wand.WandTemplate> wandTemplates = new HashMap<String, com.elmakers.mine.bukkit.wand.WandTemplate>();
    private final Map<String, MageClassTemplate> mageClasses = new HashMap<String, MageClassTemplate>();
    private final Map<String, SpellTemplate> spells = new HashMap<String, SpellTemplate>();
    private final Map<String, SpellTemplate> spellAliases = new HashMap<String, SpellTemplate>();
    private final Map<String, SpellData> templateDataMap = new HashMap<String, SpellData>();
    private final Map<String, SpellCategory> categories = new HashMap<String, SpellCategory>();
    private final Map<String, MagicAttribute> attributes = new HashMap<String, MagicAttribute>();
    private final Set<String> registeredAttributes = new HashSet<String>();
    private final Map<String, Mage> mages = Maps.newConcurrentMap();
    private final Map<String, Mage> mobMages = new HashMap<String, Mage>();
    private final Map<String, com.elmakers.mine.bukkit.api.magic.Mage> vanished = new HashMap<String, com.elmakers.mine.bukkit.api.magic.Mage>();
    private final Set<com.elmakers.mine.bukkit.api.magic.Mage> pendingConstruction = new HashSet<com.elmakers.mine.bukkit.api.magic.Mage>();
    private final PriorityQueue<com.elmakers.mine.bukkit.api.block.UndoList> scheduledUndo = new PriorityQueue();
    private final Map<String, WeakReference<com.elmakers.mine.bukkit.api.block.Schematic>> schematics = new HashMap<String, WeakReference<com.elmakers.mine.bukkit.api.block.Schematic>>();
    private final Map<String, Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer>> effects = new HashMap<String, Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer>>();
    private MageDataStore mageDataStore = null;
    private Logger logger = null;
    private MagicPlugin plugin = null;
    private final File configFolder;
    private final File dataFolder;
    private final File defaultsFolder;
    private int toggleMessageRange = 1024;
    private int automataUpdateFrequency = 1;
    private int mageUpdateFrequency = 5;
    private int workFrequency = 1;
    private int undoFrequency = 10;
    private int workPerUpdate = 5000;
    private int logVerbosity = 0;
    private boolean showCastHoloText = false;
    private boolean showActivateHoloText = false;
    private int castHoloTextRange = 0;
    private int activateHoloTextRange = 0;
    private boolean urlIconsEnabled = true;
    private boolean autoSpellUpgradesEnabled = true;
    private boolean autoPathUpgradesEnabled = true;
    private boolean spellProgressionEnabled = true;
    private boolean bypassBuildPermissions = false;
    private boolean bypassBreakPermissions = false;
    private boolean bypassPvpPermissions = false;
    private boolean bypassFriendlyFire = false;
    private boolean useScoreboardTeams = false;
    private boolean defaultFriendly = true;
    private boolean protectLocked = true;
    private boolean bindOnGive = false;
    private String extraSchematicFilePath = null;
    private Mailer mailer = null;
    private Material defaultMaterial = Material.DIRT;
    private Set<EntityType> undoEntityTypes = new HashSet<EntityType>();
    private Set<EntityType> friendlyEntityTypes = new HashSet<EntityType>();
    private Map<String, Currency> currencies = new HashMap<String, Currency>();
    private PhysicsHandler physicsHandler = null;
    private Map<String, Map<Long, Automaton>> automata = new HashMap<String, Map<Long, Automaton>>();
    private Map<Long, Automaton> activeAutomata = new HashMap<Long, Automaton>();
    private Map<String, LostWand> lostWands = new HashMap<String, LostWand>();
    private Map<String, Set<String>> lostWandChunks = new HashMap<String, Set<String>>();
    private int metricsLevel = 5;
    private Metrics metrics = null;
    private boolean hasDynmap = false;
    private boolean hasEssentials = false;
    private boolean hasCommandBook = false;
    private String exampleDefaults = null;
    private Collection<String> addExamples = null;
    private boolean initialized = false;
    private boolean loaded = false;
    private String defaultSkillIcon = "stick";
    private int skillInventoryRows = 6;
    private boolean skillsUseHeroes = true;
    private boolean useHeroesMana = true;
    private boolean useHeroesParties = true;
    private boolean skillsUsePermissions = false;
    private String heroesSkillPrefix = "";
    private String skillsSpell = "";
    private boolean isFileLockingEnabled = false;
    private int fileLoadDelay = 0;
    private final Object saveLock = new Object();
    protected static Random random = new Random();
    private CraftingController crafting = null;
    private MobController mobs = null;
    private ItemController items = null;
    private EnchantingController enchanting = null;
    private AnvilController anvil = null;
    private Messages messages = new Messages();
    private MapController maps = null;
    private DynmapController dynmap = null;
    private ElementalsController elementals = null;
    private CitizensController citizens = null;
    private BlockController blockController = null;
    private HangingController hangingController = null;
    private PlayerController playerController = null;
    private EntityController entityController = null;
    private InventoryController inventoryController = null;
    private ExplosionController explosionController = null;
    @Nonnull
    private MageIdentifier mageIdentifier = new MageIdentifier();
    private final SimpleMaterialSetManager materialSetManager = new SimpleMaterialSetManager();
    private boolean citizensEnabled = true;
    private boolean logBlockEnabled = true;
    private boolean libsDisguiseEnabled = true;
    private boolean skillAPIEnabled = true;
    private boolean useSkillAPIMana = false;
    private boolean placeholdersEnabled = true;
    private boolean lightAPIEnabled = true;
    private boolean skriptEnabled = true;
    private ConfigurationSection citadelConfiguration = null;
    private ConfigurationSection mobArenaConfiguration = null;
    private boolean enableResourcePackCheck = true;
    private boolean resourcePackPrompt = false;
    private int resourcePackCheckInterval = 0;
    private int resourcePackCheckTimer = 0;
    private String defaultResourcePack = null;
    private boolean checkedResourcePack = false;
    private String resourcePack = null;
    private byte[] resourcePackHash = null;
    private long resourcePackDelay = 0L;
    private Set<String> resolvingKeys = new LinkedHashSet<String>();
    private boolean hasShopkeepers = false;
    private FactionsManager factionsManager = new FactionsManager();
    private LocketteManager locketteManager = new LocketteManager();
    private WorldGuardManager worldGuardManager = new WorldGuardManager();
    private PvPManagerManager pvpManager = new PvPManagerManager();
    private MultiverseManager multiverseManager = new MultiverseManager();
    private PreciousStonesManager preciousStonesManager = new PreciousStonesManager();
    private TownyManager townyManager = new TownyManager();
    private GriefPreventionManager griefPreventionManager = new GriefPreventionManager();
    private NCPManager ncpManager = new NCPManager();
    private ProtectionManager protectionManager = new ProtectionManager();
    private CitadelManager citadelManager = null;
    private RequirementsController requirementsController = null;
    private HeroesManager heroesManager = null;
    private LibsDisguiseManager libsDisguiseManager = null;
    private SkillAPIManager skillAPIManager = null;
    private PlaceholderAPIManager placeholderAPIManager = null;
    private LightAPIManager lightAPIManager = null;
    private MobArenaManager mobArenaManager = null;
    private LogBlockManager logBlockManager = null;
    private List<BlockBreakManager> blockBreakManagers = new ArrayList<BlockBreakManager>();
    private List<BlockBuildManager> blockBuildManagers = new ArrayList<BlockBuildManager>();
    private List<PVPManager> pvpManagers = new ArrayList<PVPManager>();
    private List<AttributeProvider> attributeProviders = new ArrayList<AttributeProvider>();
    private List<TeamProvider> teamProviders = new ArrayList<TeamProvider>();
    private NPCSupplierSet npcSuppliers = new NPCSupplierSet();
    private Map<String, RequirementsProcessor> requirementProcessors = new HashMap<String, RequirementsProcessor>();

    public MagicController() {
        this.configFolder = null;
        this.dataFolder = null;
        this.defaultsFolder = null;
        this.logger = Logger.getLogger("Magic");
    }

    public MagicController(MagicPlugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        SkinUtils.initialize((Plugin)plugin);
        this.configFolder = plugin.getDataFolder();
        this.configFolder.mkdirs();
        this.dataFolder = new File(this.configFolder, "data");
        this.dataFolder.mkdirs();
        this.defaultsFolder = new File(this.configFolder, "defaults");
        this.defaultsFolder.mkdirs();
    }

    @Override
    @Nullable
    public Mage getRegisteredMage(String mageId) {
        Preconditions.checkNotNull((Object)mageId);
        if (!this.loaded) {
            return null;
        }
        return this.mages.get(mageId);
    }

    @Override
    @Nullable
    public Mage getRegisteredMage(@Nonnull Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        String id = this.mageIdentifier.fromEntity(entity);
        return this.mages.get(id);
    }

    @Nonnull
    protected Mage getMageFromEntity(@Nonnull Entity entity, @Nullable CommandSender commandSender) {
        Preconditions.checkNotNull((Object)entity);
        String id = this.mageIdentifier.fromEntity(entity);
        return this.getMage(id, commandSender, entity);
    }

    @Override
    public Mage getAutomaton(String mageId, String mageName) {
        Preconditions.checkNotNull((Object)mageId);
        Preconditions.checkNotNull((Object)mageName);
        Mage mage = this.getMage(mageId, mageName, null, null);
        mage.setIsAutomaton(true);
        return mage;
    }

    @Override
    public Mage getMage(String mageId, String mageName) {
        Preconditions.checkNotNull((Object)mageId);
        Preconditions.checkNotNull((Object)mageName);
        return this.getMage(mageId, mageName, null, null);
    }

    @Nonnull
    public Mage getMage(@Nonnull String mageId, @Nullable CommandSender commandSender, @Nullable Entity entity) {
        Preconditions.checkState((commandSender != null || entity != null ? 1 : 0) != 0, (Object)"Need to provide either an entity or a command sender for a non-automata mage.");
        return this.getMage(mageId, null, commandSender, entity);
    }

    @Override
    @Nonnull
    public Mage getMage(@Nonnull Player player) {
        Preconditions.checkNotNull((Object)player);
        return this.getMageFromEntity((Entity)player, (CommandSender)player);
    }

    @Override
    @Nonnull
    public Mage getMage(@Nonnull Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        Player commandSender = entity instanceof Player ? (Player)entity : null;
        return this.getMageFromEntity(entity, (CommandSender)commandSender);
    }

    @Override
    @Nonnull
    public Mage getMage(@Nonnull CommandSender commandSender) {
        Preconditions.checkNotNull((Object)commandSender);
        if (commandSender instanceof Player) {
            return this.getMage((Player)commandSender);
        }
        String mageId = this.mageIdentifier.fromCommandSender(commandSender);
        return this.getMage(mageId, commandSender, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected Mage getMage(@Nonnull String mageId, @Nullable String mageName, @Nullable CommandSender commandSender, @Nullable Entity entity) throws PluginNotLoadedException, NoSuchMageException {
        Preconditions.checkNotNull((Object)mageId);
        if (commandSender == null && entity == null) {
            commandSender = Bukkit.getConsoleSender();
        }
        if (!this.loaded) {
            if (entity instanceof Player) {
                this.getLogger().warning("Player data request for " + mageId + " (" + ((Player)commandSender).getName() + ") failed, plugin not loaded yet");
            }
            throw new PluginNotLoadedException();
        }
        Mage apiMage = null;
        if (!this.mages.containsKey(mageId)) {
            boolean isPlayer;
            if (entity instanceof Player && !((Player)entity).isOnline() && !this.isNPC(entity)) {
                this.getLogger().warning("Player data for " + mageId + " (" + entity.getName() + ") loaded while offline!");
                Thread.dumpStack();
                if (this.isFileLockingEnabled) {
                    this.getLogger().warning("Returning dummy Mage to avoid locking issues");
                    return new Mage(mageId, this);
                }
            }
            final Mage mage = new Mage(mageId, this);
            this.mages.put(mageId, mage);
            mage.setName(mageName);
            mage.setCommandSender(commandSender);
            mage.setEntity(entity);
            if (entity instanceof Player) {
                mage.setPlayer((Player)entity);
            }
            boolean bl = isPlayer = (isPlayer = entity instanceof Player) && !this.isNPC(entity);
            if (this.savePlayerData && this.mageDataStore != null) {
                if (isPlayer) {
                    mage.setLoading(true);
                    this.plugin.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = MagicController.this.saveLock;
                            synchronized (object) {
                                MagicController.this.info("Loading mage data for " + mage.getName() + " (" + mage.getId() + ") at " + System.currentTimeMillis());
                                try {
                                    MagicController.this.mageDataStore.load(mage.getId(), new MageDataCallback(){

                                        @Override
                                        public void run(MageData data) {
                                            mage.load(data);
                                            MagicController.this.info(" Finished Loading mage data for " + mage.getName() + " (" + mage.getId() + ") at " + System.currentTimeMillis());
                                        }
                                    });
                                }
                                catch (Exception ex) {
                                    MagicController.this.getLogger().warning("Failed to load mage data for " + mage.getName() + " (" + mage.getId() + ")");
                                    ex.printStackTrace();
                                }
                            }
                        }
                    }, (long)(this.fileLoadDelay * 20 / 1000));
                } else {
                    if (this.saveNonPlayerMages) {
                        this.info("Loading mage data for " + mage.getName() + " (" + mage.getId() + ") synchronously");
                        Object object = this.saveLock;
                        synchronized (object) {
                            try {
                                this.mageDataStore.load(mage.getId(), new MageDataCallback(){

                                    @Override
                                    public void run(MageData data) {
                                        mage.load(data);
                                    }
                                });
                            }
                            catch (Exception ex) {
                                this.getLogger().warning("Failed to load mage data for " + mage.getName() + " (" + mage.getId() + ")");
                                ex.printStackTrace();
                            }
                        }
                    }
                    mage.load(null);
                }
            } else if (this.externalPlayerData && (isPlayer || this.saveNonPlayerMages)) {
                mage.setLoading(true);
            } else {
                mage.load(null);
            }
            apiMage = mage;
        } else {
            Mage mage = apiMage = this.mages.get(mageId);
            mage.setUnloading(false);
            mage.setName(mageName);
            mage.setCommandSender(commandSender);
            mage.setEntity(entity);
            if (entity instanceof Player) {
                mage.setPlayer((Player)entity);
            }
        }
        if (apiMage == null) {
            this.getLogger().warning("getMage returning null mage for " + entity + " and " + commandSender);
            throw new NoSuchMageException(mageId);
        }
        return apiMage;
    }

    @Override
    public void info(String message) {
        this.info(message, 1);
    }

    public void info(String message, int verbosity) {
        if (this.logVerbosity >= verbosity) {
            this.getLogger().info(message);
        }
    }

    public void addSpell(Spell variant) {
        SpellTemplate conflict = this.spells.get(variant.getKey());
        if (conflict != null) {
            this.getLogger().log(Level.WARNING, "Duplicate spell key: '" + conflict.getKey() + "'");
        } else {
            String alias;
            this.spells.put(variant.getKey(), variant);
            SpellData data = this.templateDataMap.get(variant.getSpellKey().getBaseKey());
            if (data == null) {
                data = new SpellData(variant.getSpellKey().getBaseKey());
                this.templateDataMap.put(variant.getSpellKey().getBaseKey(), data);
            }
            if (variant instanceof MageSpell) {
                ((MageSpell)variant).setSpellData(data);
            }
            if ((alias = variant.getAlias()) != null && alias.length() > 0) {
                this.spellAliases.put(alias, variant);
            }
        }
    }

    public float getMaxDamagePowerMultiplier() {
        return this.maxDamagePowerMultiplier;
    }

    public float getMaxConstructionPowerMultiplier() {
        return this.maxConstructionPowerMultiplier;
    }

    public float getMaxRadiusPowerMultiplier() {
        return this.maxRadiusPowerMultiplier;
    }

    public float getMaxRadiusPowerMultiplierMax() {
        return this.maxRadiusPowerMultiplierMax;
    }

    public float getMaxRangePowerMultiplier() {
        return this.maxRangePowerMultiplier;
    }

    public float getMaxRangePowerMultiplierMax() {
        return this.maxRangePowerMultiplierMax;
    }

    public int getAutoUndoInterval() {
        return this.autoUndo;
    }

    public float getMaxPower() {
        return this.maxPower;
    }

    public double getMaxDamageReduction(String protectionType) {
        DamageType damageType = this.damageTypes.get(protectionType);
        return damageType == null ? 0.0 : damageType.getMaxReduction();
    }

    public double getMaxAttackMultiplier(String protectionType) {
        DamageType damageType = this.damageTypes.get(protectionType);
        return damageType == null ? 1.0 : damageType.getMaxAttackMultiplier();
    }

    public double getMaxDefendMultiplier(String protectionType) {
        DamageType damageType = this.damageTypes.get(protectionType);
        return damageType == null ? 1.0 : damageType.getMaxDefendMultiplier();
    }

    @Override
    @Nonnull
    public Set<String> getDamageTypes() {
        return this.damageTypes.keySet();
    }

    @Override
    @Nonnull
    public Set<String> getAttributes() {
        return this.registeredAttributes;
    }

    @Override
    @Nonnull
    public Set<String> getInternalAttributes() {
        return this.attributes.keySet();
    }

    public float getMaxCostReduction() {
        return this.maxCostReduction;
    }

    public float getMaxCooldownReduction() {
        return this.maxCooldownReduction;
    }

    public int getMaxMana() {
        return this.maxMana;
    }

    public int getMaxManaRegeneration() {
        return this.maxManaRegeneration;
    }

    @Override
    public double getWorthBase() {
        return this.worthBase;
    }

    @Override
    public double getWorthXP() {
        return this.worthXP;
    }

    @Override
    public double getWorthSkillPoints() {
        return this.worthSkillPoints;
    }

    @Override
    @Nullable
    public ItemStack getWorthItem() {
        return this.currencyItem == null ? null : this.currencyItem.getItem();
    }

    @Override
    public double getWorthItemAmount() {
        return this.currencyItem == null ? 0.0 : this.currencyItem.getWorth();
    }

    @Override
    @Deprecated
    public CurrencyItem getCurrency() {
        return this.currencyItem;
    }

    @Override
    @Nullable
    public Currency getCurrency(String key) {
        return this.currencies.get(key);
    }

    @Override
    @Nonnull
    public Set<String> getCurrencyKeys() {
        return this.currencies.keySet();
    }

    public int getUndoQueueDepth() {
        return this.undoQueueDepth;
    }

    public int getPendingQueueDepth() {
        return this.pendingQueueDepth;
    }

    @Override
    public String getMessagePrefix() {
        return this.messagePrefix;
    }

    public String getCastMessagePrefix() {
        return this.castMessagePrefix;
    }

    public boolean showCastMessages() {
        return this.showCastMessages;
    }

    public boolean showMessages() {
        return this.showMessages;
    }

    @Override
    public boolean soundsEnabled() {
        return this.soundsEnabled;
    }

    public boolean fillWands() {
        return this.fillingEnabled;
    }

    @Override
    public int getMaxWandFillLevel() {
        return this.maxFillLevel;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public boolean isIndestructible(Location location) {
        return this.isIndestructible(location.getBlock());
    }

    public boolean isIndestructible(Block block) {
        return this.indestructibleMaterials.testBlock(block);
    }

    public boolean isDestructible(Block block) {
        return this.destructibleMaterials.testBlock(block);
    }

    @Deprecated
    protected boolean isRestricted(Material material) {
        return this.restrictedMaterials.testMaterial(material);
    }

    protected boolean isRestricted(Material material, @Nullable Short data) {
        if (this.restrictedMaterials.testMaterial(material)) {
            return true;
        }
        MaterialAndData materialAndData = new MaterialAndData(material, data);
        return this.restrictedMaterials.testMaterialAndData(materialAndData);
    }

    public boolean hasBuildPermission(Player player, Location location) {
        return this.hasBuildPermission(player, location.getBlock());
    }

    public boolean hasBuildPermission(Player player, Block block) {
        if (this.bypassBuildPermissions) {
            return true;
        }
        if (player != null && player.hasPermission("Magic.bypass_build")) {
            return true;
        }
        boolean allowed = true;
        for (BlockBuildManager manager : this.blockBuildManagers) {
            if (manager.hasBuildPermission(player, block)) continue;
            allowed = false;
            break;
        }
        return allowed;
    }

    public boolean hasBreakPermission(Player player, Block block) {
        if (this.bypassBreakPermissions) {
            return true;
        }
        if (player != null && player.hasPermission("Magic.bypass_break")) {
            return true;
        }
        boolean allowed = true;
        for (BlockBreakManager manager : this.blockBreakManagers) {
            if (manager.hasBreakPermission(player, block)) continue;
            allowed = false;
            break;
        }
        return allowed;
    }

    @Override
    public boolean isExitAllowed(Player player, Location location) {
        if (location == null) {
            return true;
        }
        return this.worldGuardManager.isExitAllowed(player, location);
    }

    @Override
    public boolean isPVPAllowed(Player player, Location location) {
        if (location == null) {
            return true;
        }
        if (this.bypassPvpPermissions) {
            return true;
        }
        if (player != null && player.hasPermission("Magic.bypass_pvp")) {
            return true;
        }
        boolean allowed = true;
        for (PVPManager manager : this.pvpManagers) {
            if (manager.isPVPAllowed(player, location)) continue;
            allowed = false;
            break;
        }
        return allowed;
    }

    public void clearCache() {
        this.schematics.clear();
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            if (!(mage instanceof Mage)) continue;
            ((Mage)mage).clearCache();
        }
        this.maps.clearCache();
        this.maps.resetAll();
    }

    @Override
    @Nullable
    public com.elmakers.mine.bukkit.api.block.Schematic loadSchematic(String schematicName) {
        com.elmakers.mine.bukkit.api.block.Schematic cached;
        WeakReference<com.elmakers.mine.bukkit.api.block.Schematic> schematic;
        if (schematicName == null || schematicName.length() == 0) {
            return null;
        }
        if (this.schematics.containsKey(schematicName) && (schematic = this.schematics.get(schematicName)) != null && (cached = (com.elmakers.mine.bukkit.api.block.Schematic)schematic.get()) != null) {
            return cached;
        }
        InputStream inputSchematic = null;
        try {
            File schematicFolder;
            File extraSchematicFile = null;
            File magicSchematicFolder = new File(this.plugin.getDataFolder(), "schematics");
            if (magicSchematicFolder.exists()) {
                extraSchematicFile = new File(magicSchematicFolder, schematicName + ".schematic");
                this.info("Checking for schematic: " + extraSchematicFile.getAbsolutePath(), 2);
                if (!extraSchematicFile.exists()) {
                    extraSchematicFile = null;
                }
            }
            if (extraSchematicFile == null && this.extraSchematicFilePath != null && this.extraSchematicFilePath.length() > 0 && (schematicFolder = new File(this.configFolder, "../" + this.extraSchematicFilePath)).exists()) {
                extraSchematicFile = new File(schematicFolder, schematicName + ".schematic");
                this.info("Checking for external schematic: " + extraSchematicFile.getAbsolutePath(), 2);
            }
            if (extraSchematicFile != null && extraSchematicFile.exists()) {
                inputSchematic = new FileInputStream(extraSchematicFile);
                this.info("Loading file: " + extraSchematicFile.getAbsolutePath());
            } else {
                String fileName = schematicName + ".schematic";
                inputSchematic = this.plugin.getResource("schematics/" + fileName);
                this.info("Loading builtin schematic: " + fileName);
            }
        }
        catch (Exception extraSchematicFile) {
            // empty catch block
        }
        if (inputSchematic == null) {
            this.getLogger().warning("Could not load schematic: " + schematicName);
            return null;
        }
        Schematic schematic2 = new Schematic();
        this.schematics.put(schematicName, new WeakReference<Schematic>(schematic2));
        Thread loadThread = new Thread(new LoadSchematicTask(this, inputSchematic, schematic2));
        loadThread.start();
        return schematic2;
    }

    @Override
    public Collection<String> getBrushKeys() {
        Material[] materials;
        ArrayList<String> names = new ArrayList<String>();
        for (Material material : materials = Material.values()) {
            if (!material.isBlock()) continue;
            names.add(material.name().toLowerCase());
        }
        for (String string : MaterialBrush.SPECIAL_MATERIAL_KEYS) {
            names.add(string.toLowerCase());
        }
        Collection<String> collection = this.getSchematicNames();
        for (String schematic : collection) {
            names.add("schematic:" + schematic);
        }
        return names;
    }

    public Collection<String> getSchematicNames() {
        ArrayList<String> schematicNames;
        block13: {
            schematicNames = new ArrayList<String>();
            try {
                CodeSource codeSource = MagicTabExecutor.class.getProtectionDomain().getCodeSource();
                if (codeSource == null) break block13;
                URL jar = codeSource.getLocation();
                try (ZipInputStream zip = new ZipInputStream(jar.openStream());){
                    ZipEntry entry = zip.getNextEntry();
                    while (entry != null) {
                        String name = entry.getName();
                        if (name.startsWith("schematics/") && name.endsWith(".schematic")) {
                            String schematicName = name.replace(".schematic", "").replace("schematics/", "");
                            schematicNames.add(schematicName);
                        }
                        entry = zip.getNextEntry();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            if (this.extraSchematicFilePath != null && this.extraSchematicFilePath.length() > 0) {
                File schematicFolder = new File(this.configFolder, "../" + this.extraSchematicFilePath);
                for (File schematicFile : schematicFolder.listFiles()) {
                    if (!schematicFile.getName().endsWith(".schematic")) continue;
                    String schematicName = schematicFile.getName().replace(".schematic", "");
                    schematicNames.add(schematicName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return schematicNames;
    }

    public void initialize() {
        this.warpController = new WarpController();
        this.crafting = new CraftingController(this);
        this.mobs = new MobController(this);
        this.items = new ItemController(this);
        this.enchanting = new EnchantingController(this);
        this.anvil = new AnvilController(this);
        this.blockController = new BlockController(this);
        this.hangingController = new HangingController(this);
        this.entityController = new EntityController(this);
        this.playerController = new PlayerController(this);
        this.inventoryController = new InventoryController(this);
        this.explosionController = new ExplosionController(this);
        this.requirementsController = new RequirementsController(this);
        File urlMapFile = this.getDataFile(URL_MAPS_FILE);
        File imageCache = new File(this.dataFolder, "imagemapcache");
        imageCache.mkdirs();
        this.maps = new MapController((Plugin)this.plugin, urlMapFile, imageCache);
        if (EffectPlayer.initialize((Plugin)this.plugin)) {
            this.getLogger().info("EffectLib initialized");
        } else {
            this.getLogger().warning("Failed to initialize EffectLib");
        }
        File magicSchematicFolder = new File(this.plugin.getDataFolder(), "schematics");
        magicSchematicFolder.mkdirs();
        File legacyPathConfig = new File(this.configFolder, "enchanting.yml");
        File pathConfig = new File(this.configFolder, "paths.yml");
        if (!pathConfig.exists() && legacyPathConfig.exists()) {
            this.getLogger().info("Renaming enchanting.yml to paths.yml, please update paths.yml from now on");
            legacyPathConfig.renameTo(pathConfig);
        }
        this.load();
        if (this.checkResourcePack((CommandSender)Bukkit.getConsoleSender(), false) && this.resourcePackCheckInterval > 0 && this.enableResourcePackCheck) {
            int intervalTicks = this.resourcePackCheckInterval * 60 * 20;
            this.resourcePackCheckTimer = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new RPCheckTask(this), (long)intervalTicks, (long)intervalTicks);
        }
    }

    protected void cancelResourcePackChecks() {
        if (this.resourcePackCheckTimer != 0) {
            Bukkit.getScheduler().cancelTask(this.resourcePackCheckTimer);
            this.resourcePackCheckTimer = 0;
        }
    }

    protected void finalizeIntegrationPreSpells() {
        PluginManager pluginManager = this.plugin.getServer().getPluginManager();
        Plugin skillAPIPlugin = pluginManager.getPlugin("SkillAPI");
        if (skillAPIPlugin != null && this.skillAPIEnabled && skillAPIPlugin.isEnabled()) {
            this.skillAPIManager = new SkillAPIManager(this, skillAPIPlugin);
            if (this.skillAPIManager.initialize()) {
                this.getLogger().info("SkillAPI found, attributes can be used in spell parameters. Classes and skills can be used in requirements.");
                if (this.useSkillAPIMana) {
                    this.getLogger().info("SkillAPI mana will be used by spells and wands");
                }
            } else {
                this.skillAPIManager = null;
                this.getLogger().warning("SkillAPI integration failed");
            }
        } else if (!this.skillAPIEnabled) {
            this.skillAPIManager = null;
            this.getLogger().info("SkillAPI integration disabled");
        }
        try {
            Plugin heroesPlugin = pluginManager.getPlugin("Heroes");
            this.heroesManager = heroesPlugin != null ? new HeroesManager((Plugin)this.plugin, heroesPlugin) : null;
        }
        catch (Throwable ex) {
            this.plugin.getLogger().warning(ex.getMessage());
        }
        Plugin vaultPlugin = pluginManager.getPlugin("Vault");
        if (vaultPlugin == null || !vaultPlugin.isEnabled()) {
            this.getLogger().info("Vault not found, 'currency' cost types unavailable");
        } else if (!VaultController.initialize((Plugin)this.plugin, vaultPlugin)) {
            this.getLogger().warning("Vault integration failed");
        }
    }

    protected void finalizeIntegration() {
        Plugin libsDisguisePlugin;
        PluginManager pluginManager = this.plugin.getServer().getPluginManager();
        Plugin minigamesPlugin = pluginManager.getPlugin("Minigames");
        if (minigamesPlugin != null && minigamesPlugin.isEnabled()) {
            pluginManager.registerEvents((Listener)new MinigamesListener(this), (Plugin)this.plugin);
            this.getLogger().info("Minigames found, wands will deactivate before joining a minigame");
        }
        if ((libsDisguisePlugin = pluginManager.getPlugin("LibsDisguises")) == null || !libsDisguisePlugin.isEnabled()) {
            this.getLogger().info("LibsDisguises not found, magic mob disguises will not be available");
        } else if (this.libsDisguiseEnabled) {
            this.libsDisguiseManager = new LibsDisguiseManager((Plugin)this.plugin, libsDisguisePlugin);
            if (this.libsDisguiseManager.initialize()) {
                this.getLogger().info("LibsDisguises found, mob disguises and disguise_restricted features enabled");
            } else {
                this.getLogger().warning("LibsDisguises integration failed");
            }
        } else {
            this.libsDisguiseManager = null;
            this.getLogger().info("LibsDisguises integration disabled");
        }
        Plugin mobArenaPlugin = pluginManager.getPlugin("MobArena");
        if (mobArenaPlugin == null) {
            this.getLogger().info("MobArena not found");
        } else if (this.mobArenaConfiguration.getBoolean("enabled", true)) {
            try {
                this.mobArenaManager = new MobArenaManager(this, mobArenaPlugin, this.mobArenaConfiguration);
                this.getLogger().info("Integrated with MobArena, use \"magic:<itemkey>\" in arena configs for Magic items, magic mobs can be used in monster configurations");
            }
            catch (Throwable ex) {
                this.getLogger().warning("MobArena integration failed, you may need to update the MobArena plugin to use Magic items");
            }
        } else {
            this.getLogger().info("MobArena integration disabled");
        }
        Plugin logBlockPlugin = pluginManager.getPlugin("LogBlock");
        if (logBlockPlugin == null || !logBlockPlugin.isEnabled()) {
            this.getLogger().info("LogBlock not found");
        } else if (this.logBlockEnabled) {
            try {
                this.logBlockManager = new LogBlockManager((Plugin)this.plugin, logBlockPlugin);
                this.getLogger().info("Integrated with LogBlock, engineering magic will be logged");
            }
            catch (Throwable ex) {
                this.getLogger().log(Level.WARNING, "LogBlock integration failed", ex);
            }
        } else {
            this.getLogger().info("LogBlock integration disabled");
        }
        Plugin essentials = pluginManager.getPlugin("Essentials");
        boolean bl = this.hasEssentials = essentials != null && essentials.isEnabled();
        if (this.hasEssentials) {
            if (this.warpController.setEssentials(essentials)) {
                this.getLogger().info("Integrating with Essentials for Recall warps");
            }
            try {
                this.mailer = new Mailer(essentials);
            }
            catch (Exception ex) {
                this.getLogger().warning("Essentials found, but failed to hook up to Mailer");
                this.mailer = null;
            }
        }
        if (this.essentialsSignsEnabled) {
            final MagicController me = this;
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    try {
                        Plugin essentials = me.plugin.getServer().getPluginManager().getPlugin("Essentials");
                        if (essentials != null) {
                            Class<?> essentialsClass = essentials.getClass();
                            Field itemDbField = essentialsClass.getDeclaredField("itemDb");
                            itemDbField.setAccessible(true);
                            Object oldEntry = itemDbField.get(essentials);
                            if (oldEntry == null) {
                                MagicController.this.getLogger().info("Essentials integration failure");
                                return;
                            }
                            if (oldEntry instanceof MagicItemDb) {
                                MagicController.this.getLogger().info("Essentials integration already set up, skipping");
                                return;
                            }
                            if (!oldEntry.getClass().getName().equals("com.earth2me.essentials.ItemDb")) {
                                MagicController.this.getLogger().info("Essentials Item DB class unexepcted: " + oldEntry.getClass().getName() + ", skipping integration");
                                return;
                            }
                            MagicItemDb newEntry = new MagicItemDb(me, essentials);
                            itemDbField.set(essentials, (Object)newEntry);
                            Field confListField = essentialsClass.getDeclaredField("confList");
                            confListField.setAccessible(true);
                            List confList = (List)confListField.get(essentials);
                            confList.remove(oldEntry);
                            confList.add(newEntry);
                            MagicController.this.getLogger().info("Essentials found, hooked up custom item handler");
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
            }, 5L);
        }
        this.hasCommandBook = false;
        try {
            Plugin commandBookPlugin = this.plugin.getServer().getPluginManager().getPlugin("CommandBook");
            if (commandBookPlugin != null && commandBookPlugin.isEnabled()) {
                if (this.warpController.setCommandBook(commandBookPlugin)) {
                    this.getLogger().info("CommandBook found, integrating for Recall warps");
                    this.hasCommandBook = true;
                } else {
                    this.getLogger().warning("CommandBook integration failed");
                }
            }
        }
        catch (Throwable commandBookPlugin) {
            // empty catch block
        }
        this.factionsManager.initialize((Plugin)this.plugin);
        this.worldGuardManager.initialize((Plugin)this.plugin);
        this.pvpManager.initialize((Plugin)this.plugin);
        this.multiverseManager.initialize((Plugin)this.plugin);
        this.preciousStonesManager.initialize((Plugin)this.plugin);
        this.townyManager.initialize((Plugin)this.plugin);
        this.locketteManager.initialize((Plugin)this.plugin);
        this.griefPreventionManager.initialize((Plugin)this.plugin);
        this.ncpManager.initialize((Plugin)this.plugin);
        try {
            Plugin dynmapPlugin = this.plugin.getServer().getPluginManager().getPlugin("dynmap");
            this.dynmap = dynmapPlugin != null && dynmapPlugin.isEnabled() ? new DynmapController((Plugin)this.plugin, dynmapPlugin) : null;
        }
        catch (Throwable ex) {
            this.plugin.getLogger().warning(ex.getMessage());
        }
        if (this.dynmap == null) {
            this.getLogger().info("dynmap not found, not integrating.");
        } else {
            this.getLogger().info("dynmap found, integrating.");
        }
        try {
            Plugin elementalsPlugin = this.plugin.getServer().getPluginManager().getPlugin("Splateds_Elementals");
            this.elementals = elementalsPlugin != null && elementalsPlugin.isEnabled() ? new ElementalsController(elementalsPlugin) : null;
        }
        catch (Throwable ex) {
            this.plugin.getLogger().warning(ex.getMessage());
        }
        if (this.elementals != null) {
            this.getLogger().info("Elementals found, integrating.");
        }
        this.hasShopkeepers = pluginManager.isPluginEnabled("Shopkeepers");
        if (this.hasShopkeepers) {
            this.npcSuppliers.register(new GenericMetadataNPCSupplier("shopkeeper"));
        }
        try {
            Plugin citizensPlugin = this.plugin.getServer().getPluginManager().getPlugin("Citizens");
            if (citizensPlugin != null && citizensPlugin.isEnabled()) {
                this.citizens = new CitizensController(citizensPlugin, this, this.citizensEnabled);
            } else {
                this.citizens = null;
                this.getLogger().info("Citizens not found, Magic trait unavailable.");
            }
        }
        catch (Throwable ex) {
            this.citizens = null;
            this.getLogger().warning("Error integrating with Citizens");
            this.plugin.getLogger().warning(ex.getMessage());
        }
        if (this.citizens != null) {
            this.npcSuppliers.register(this.citizens);
        }
        if (this.placeholdersEnabled) {
            if (pluginManager.isPluginEnabled("PlaceholderAPI")) {
                try {
                    if (this.placeholderAPIManager == null) {
                        this.placeholderAPIManager = new PlaceholderAPIManager(this);
                    }
                }
                catch (Throwable ex) {
                    this.getLogger().log(Level.WARNING, "Error integrating with PlaceholderAPI", ex);
                }
            }
        } else {
            this.getLogger().info("PlaceholderAPI integration disabled.");
        }
        if (this.lightAPIEnabled) {
            if (pluginManager.isPluginEnabled("LightAPI")) {
                try {
                    this.lightAPIManager = new LightAPIManager((Plugin)this.plugin);
                }
                catch (Throwable ex) {
                    this.getLogger().log(Level.WARNING, "Error integrating with LightAPI", ex);
                }
            } else {
                this.getLogger().info("LightAPI not found, Light action will not work");
            }
        } else {
            this.lightAPIManager = null;
            this.getLogger().info("LightAPI integration disabled.");
        }
        if (this.skriptEnabled) {
            if (pluginManager.isPluginEnabled("Skript")) {
                try {
                    new SkriptManager(this);
                }
                catch (Throwable ex) {
                    this.getLogger().log(Level.WARNING, "Error integrating with Skript", ex);
                }
            }
        } else {
            this.getLogger().info("Skript integration disabled.");
        }
        if (this.citadelConfiguration.getBoolean("enabled")) {
            if (pluginManager.isPluginEnabled("Citadel")) {
                try {
                    this.citadelManager = new CitadelManager(this, this.citadelConfiguration);
                }
                catch (Throwable ex) {
                    this.getLogger().log(Level.WARNING, "Error integrating with Citadel", ex);
                }
            }
        } else {
            this.getLogger().info("Citadel integration disabled.");
        }
        this.activateMetrics();
        MageUpdateTask mageTask = new MageUpdateTask(this);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)mageTask, 0L, (long)this.mageUpdateFrequency);
        BatchUpdateTask blockTask = new BatchUpdateTask(this);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)blockTask, 0L, (long)this.workFrequency);
        AutomataUpdateTask automataTaks = new AutomataUpdateTask(this);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)automataTaks, 0L, (long)this.automataUpdateFrequency);
        UndoUpdateTask undoTask = new UndoUpdateTask(this);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)undoTask, 0L, (long)this.undoFrequency);
        this.registerListeners();
    }

    protected void processUndo() {
        com.elmakers.mine.bukkit.api.block.UndoList undo;
        long now = System.currentTimeMillis();
        while (this.scheduledUndo.size() > 0 && now >= (undo = this.scheduledUndo.peek()).getScheduledTime()) {
            this.scheduledUndo.poll();
            undo.undoScheduled();
        }
    }

    protected void processPendingBatches() {
        int remainingWork = this.workPerUpdate;
        if (this.pendingConstruction.isEmpty()) {
            return;
        }
        ArrayList<com.elmakers.mine.bukkit.api.magic.Mage> pending = new ArrayList<com.elmakers.mine.bukkit.api.magic.Mage>(this.pendingConstruction);
        while (remainingWork > 0 && !pending.isEmpty()) {
            int workPerMage = Math.max(10, remainingWork / pending.size());
            Iterator iterator = pending.iterator();
            while (iterator.hasNext()) {
                com.elmakers.mine.bukkit.api.magic.Mage apiMage = (com.elmakers.mine.bukkit.api.magic.Mage)iterator.next();
                if (!(apiMage instanceof Mage)) continue;
                Mage mage = (Mage)apiMage;
                int workPerformed = mage.processPendingBatches(workPerMage);
                if (!mage.hasPendingBatches()) {
                    iterator.remove();
                    this.pendingConstruction.remove(mage);
                } else if (workPerformed < workPerMage) {
                    iterator.remove();
                }
                remainingWork -= workPerformed;
            }
        }
    }

    protected void activateMetrics() {
        final MagicController controller = this;
        this.metrics = null;
        if (this.metricsLevel > 0) {
            try {
                this.metrics = new Metrics(this.plugin);
                if (this.metricsLevel > 1) {
                    this.metrics.addCustomChart(new Metrics.MultiLineChart("Plugin Integration"){

                        @Override
                        public HashMap<String, Integer> getValues(HashMap<String, Integer> valueMap) {
                            valueMap.put("Essentials", controller.hasEssentials ? 1 : 0);
                            valueMap.put("Dynmap", controller.hasDynmap ? 1 : 0);
                            valueMap.put("Factions", controller.factionsManager.isEnabled() ? 1 : 0);
                            valueMap.put("WorldGuard", controller.worldGuardManager.isEnabled() ? 1 : 0);
                            valueMap.put("Elementals", controller.elementalsEnabled() ? 1 : 0);
                            valueMap.put("Citizens", controller.citizens != null ? 1 : 0);
                            valueMap.put("CommandBook", controller.hasCommandBook ? 1 : 0);
                            valueMap.put("PvpManager", controller.pvpManager.isEnabled() ? 1 : 0);
                            valueMap.put("Multiverse-Core", controller.multiverseManager.isEnabled() ? 1 : 0);
                            valueMap.put("Towny", controller.townyManager.isEnabled() ? 1 : 0);
                            valueMap.put("GriefPrevention", controller.griefPreventionManager.isEnabled() ? 1 : 0);
                            valueMap.put("PreciousStones", controller.preciousStonesManager.isEnabled() ? 1 : 0);
                            valueMap.put("Lockette", controller.locketteManager.isEnabled() ? 1 : 0);
                            valueMap.put("NoCheatPlus", controller.ncpManager.isEnabled() ? 1 : 0);
                            return valueMap;
                        }
                    });
                    this.metrics.addCustomChart(new Metrics.MultiLineChart("Features Enabled"){

                        @Override
                        public HashMap<String, Integer> getValues(HashMap<String, Integer> valueMap) {
                            valueMap.put("Crafting", controller.crafting.isEnabled() ? 1 : 0);
                            valueMap.put("Enchanting", controller.enchanting.isEnabled() ? 1 : 0);
                            valueMap.put("SP", controller.isSPEnabled() ? 1 : 0);
                            return valueMap;
                        }
                    });
                }
                if (this.metricsLevel > 2) {
                    this.metrics.addCustomChart(new Metrics.MultiLineChart("Total Casts by Category"){

                        @Override
                        public HashMap<String, Integer> getValues(HashMap<String, Integer> valueMap) {
                            for (SpellCategory category : MagicController.this.categories.values()) {
                                valueMap.put(category.getName(), (int)category.getCastCount());
                            }
                            return valueMap;
                        }
                    });
                }
                if (this.metricsLevel > 3) {
                    this.metrics.addCustomChart(new Metrics.MultiLineChart("Total Casts"){

                        @Override
                        public HashMap<String, Integer> getValues(HashMap<String, Integer> valueMap) {
                            for (SpellTemplate spell : MagicController.this.spells.values()) {
                                if (!(spell instanceof Spell)) continue;
                                valueMap.put(spell.getName(), (int)((Spell)spell).getCastCount());
                            }
                            return valueMap;
                        }
                    });
                }
                this.plugin.getLogger().info("Activated BStats");
            }
            catch (Exception ex) {
                this.plugin.getLogger().warning("Failed to load BStats: " + ex.getMessage());
            }
        }
    }

    protected void registerListeners() {
        PluginManager pm = this.plugin.getServer().getPluginManager();
        pm.registerEvents((Listener)this.crafting, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.mobs, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.enchanting, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.anvil, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.blockController, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.hangingController, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.entityController, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.playerController, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.inventoryController, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.explosionController, (Plugin)this.plugin);
    }

    public Collection<com.elmakers.mine.bukkit.api.magic.Mage> getPending() {
        return this.pendingConstruction;
    }

    public Collection<com.elmakers.mine.bukkit.api.block.UndoList> getPendingUndo() {
        return this.scheduledUndo;
    }

    @Nullable
    public com.elmakers.mine.bukkit.api.block.UndoList getPendingUndo(Location location) {
        return UndoList.getUndoList(location);
    }

    protected void addPending(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        this.pendingConstruction.add(mage);
    }

    public boolean removeMarker(String id, String group) {
        boolean removed = false;
        if (this.dynmap != null && this.dynmapShowWands) {
            return this.dynmap.removeMarker(id, group);
        }
        return removed;
    }

    public boolean addMarker(String id, String group, String title, String world, int x, int y, int z, String description) {
        boolean created = false;
        if (this.dynmap != null && this.dynmapShowWands) {
            created = this.dynmap.addMarker(id, group, title, world, x, y, z, description);
        }
        return created;
    }

    @Override
    public File getConfigFolder() {
        return this.configFolder;
    }

    protected File getDataFile(String fileName) {
        return new File(this.dataFolder, fileName + ".yml");
    }

    @Nullable
    protected ConfigurationSection loadDataFile(String fileName) {
        File dataFile = this.getDataFile(fileName);
        if (!dataFile.exists()) {
            return null;
        }
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)dataFile);
        return configuration;
    }

    protected YamlDataFile createDataFile(String fileName) {
        File dataFile = new File(this.dataFolder, fileName + ".yml");
        YamlDataFile configuration = new YamlDataFile(this.getLogger(), dataFile);
        return configuration;
    }

    protected void notify(CommandSender sender, String message) {
        if (sender != null) {
            sender.sendMessage(message);
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player == sender || !player.hasPermission("Magic.notify")) continue;
            player.sendMessage(message);
        }
    }

    protected void finalizeLoad(ConfigurationLoadTask loader, CommandSender sender) {
        if (!loader.isSuccessful()) {
            this.notify(sender, ChatColor.RED + "An error occurred reloading configurations, please check server logs!");
            if (!this.loaded) {
                this.getLogger().warning("*** An error occurred while loading configurations ***");
                this.getLogger().warning("***         Magic is temporarily disabled          ***");
                this.getLogger().warning("***   Please check the errors above, fix configs   ***");
                this.getLogger().warning("***    And '/magic load' or restart the server     ***");
            }
            return;
        }
        this.schematics.clear();
        EquationStore.clear();
        this.exampleDefaults = loader.getExampleDefaults();
        this.addExamples = loader.getAddExamples();
        this.loadProperties(loader.getMainConfiguration());
        if (!this.initialized) {
            this.finalizeIntegrationPreSpells();
        }
        this.messages.load(loader.getMessages());
        this.loadMaterials(loader.getMaterials());
        this.loadAttributes(loader.getAttributes());
        this.getLogger().info("Loaded " + this.attributes.size() + " attributes");
        this.registerPreLoad();
        this.getLogger().info("Registered currencies: " + StringUtils.join(this.currencies.keySet(), (String)","));
        this.loadEffects(loader.getEffects());
        this.getLogger().info("Loaded " + this.effects.size() + " effect lists");
        this.items.load(loader.getItems());
        this.getLogger().info("Loaded " + this.items.getCount() + " items");
        this.loadSpells(loader.getSpells());
        this.getLogger().info("Loaded " + this.spells.size() + " spells");
        this.loadMageClasses(loader.getClasses());
        this.getLogger().info("Loaded " + this.mageClasses.size() + " classes");
        this.loadAutomatonTemplates(loader.getAutomata());
        this.getLogger().info("Loaded " + this.automatonTemplates.size() + " automata templates");
        this.loadPaths(loader.getPaths());
        this.getLogger().info("Loaded " + this.getPathCount() + " progression paths");
        this.loadWandTemplates(loader.getWands());
        this.getLogger().info("Loaded " + this.getWandTemplates().size() + " wands");
        this.loadMobs(loader.getMobs());
        this.getLogger().info("Loaded " + this.mobs.getCount() + " mob templates");
        this.crafting.load(loader.getCrafting());
        this.getLogger().info("Loaded " + this.crafting.getCount() + " crafting recipes");
        if (!this.initialized) {
            this.finalizeIntegration();
        }
        if (this.worldGuardManager.isEnabled()) {
            this.pvpManagers.add(this.worldGuardManager);
        }
        if (this.pvpManager.isEnabled()) {
            this.pvpManagers.add(this.pvpManager);
        }
        if (this.multiverseManager.isEnabled()) {
            this.pvpManagers.add(this.multiverseManager);
        }
        if (this.preciousStonesManager.isEnabled()) {
            this.pvpManagers.add(this.preciousStonesManager);
        }
        if (this.townyManager.isEnabled()) {
            this.pvpManagers.add(this.townyManager);
        }
        if (this.griefPreventionManager.isEnabled()) {
            this.pvpManagers.add(this.griefPreventionManager);
        }
        if (this.factionsManager.isEnabled()) {
            this.pvpManagers.add(this.factionsManager);
        }
        if (this.worldGuardManager.isEnabled()) {
            this.blockBuildManagers.add(this.worldGuardManager);
        }
        if (this.factionsManager.isEnabled()) {
            this.blockBuildManagers.add(this.factionsManager);
        }
        if (this.locketteManager.isEnabled()) {
            this.blockBuildManagers.add(this.locketteManager);
        }
        if (this.preciousStonesManager.isEnabled()) {
            this.blockBuildManagers.add(this.preciousStonesManager);
        }
        if (this.townyManager.isEnabled()) {
            this.blockBuildManagers.add(this.townyManager);
        }
        if (this.griefPreventionManager.isEnabled()) {
            this.blockBuildManagers.add(this.griefPreventionManager);
        }
        if (this.mobArenaManager != null && this.mobArenaManager.isProtected()) {
            this.blockBuildManagers.add(this.mobArenaManager);
        }
        if (this.worldGuardManager.isEnabled()) {
            this.blockBreakManagers.add(this.worldGuardManager);
        }
        if (this.factionsManager.isEnabled()) {
            this.blockBreakManagers.add(this.factionsManager);
        }
        if (this.locketteManager.isEnabled()) {
            this.blockBreakManagers.add(this.locketteManager);
        }
        if (this.preciousStonesManager.isEnabled()) {
            this.blockBreakManagers.add(this.preciousStonesManager);
        }
        if (this.townyManager.isEnabled()) {
            this.blockBreakManagers.add(this.townyManager);
        }
        if (this.griefPreventionManager.isEnabled()) {
            this.blockBreakManagers.add(this.griefPreventionManager);
        }
        if (this.mobArenaManager != null && this.mobArenaManager.isProtected()) {
            this.blockBreakManagers.add(this.mobArenaManager);
        }
        if (this.citadelManager != null) {
            this.blockBreakManagers.add(this.citadelManager);
        }
        Runnable genericIntegrationTask = new Runnable(){

            @Override
            public void run() {
                MagicController.this.protectionManager.check();
                if (MagicController.this.protectionManager.isEnabled()) {
                    MagicController.this.blockBreakManagers.add(MagicController.this.protectionManager);
                    MagicController.this.blockBuildManagers.add(MagicController.this.protectionManager);
                }
            }
        };
        if (!this.initialized) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, genericIntegrationTask, 1L);
        } else {
            genericIntegrationTask.run();
        }
        this.initialized = true;
        this.crafting.register(this, (Plugin)this.plugin);
        MagicRecipe.FIRST_REGISTER = false;
        LoadEvent loadEvent = new LoadEvent(this);
        Bukkit.getPluginManager().callEvent((Event)loadEvent);
        this.loaded = true;
        Collection allPlayers = this.plugin.getServer().getOnlinePlayers();
        for (Player player : allPlayers) {
            this.getMage(player);
        }
        this.notify(sender, ChatColor.AQUA + "Magic " + ChatColor.DARK_AQUA + "configuration reloaded.");
    }

    private int getPathCount() {
        return WandUpgradePath.getPathKeys().size();
    }

    private void loadPaths(ConfigurationSection pathConfiguration) {
        WandUpgradePath.loadPaths(this, pathConfiguration);
    }

    private void loadAttributes(ConfigurationSection attributeConfiguration) {
        Set keys = attributeConfiguration.getKeys(false);
        this.attributes.clear();
        for (String key : keys) {
            MagicAttribute attribute = new MagicAttribute(key, attributeConfiguration.getConfigurationSection(key));
            this.attributes.put(key, attribute);
        }
    }

    private void loadAutomatonTemplates(ConfigurationSection automataConfiguration) {
        Set keys = automataConfiguration.getKeys(false);
        HashMap<String, ConfigurationSection> templateConfigurations = new HashMap<String, ConfigurationSection>();
        this.automatonTemplates.clear();
        for (String string : keys) {
            ConfigurationSection config = this.resolveConfiguration(string, automataConfiguration, templateConfigurations);
            if (!config.getBoolean("enabled", true)) continue;
            AutomatonTemplate template = new AutomatonTemplate(this, string, config);
            this.automatonTemplates.put(string, template);
        }
        for (Automaton automaton : this.activeAutomata.values()) {
            automaton.pause();
        }
        for (Map map : this.automata.values()) {
            for (Automaton automaton : map.values()) {
                automaton.reload();
            }
        }
        for (Automaton automaton : this.activeAutomata.values()) {
            automaton.resume();
        }
    }

    public boolean isAutomataTemplate(@Nonnull String key) {
        return this.automatonTemplates.containsKey(key);
    }

    @Nonnull
    public Collection<String> getAutomatonTemplateKeys() {
        return this.automatonTemplates.keySet();
    }

    @Nonnull
    public Collection<Automaton> getActiveAutomata() {
        return this.activeAutomata.values();
    }

    public boolean isActive(@Nonnull Automaton automaton) {
        return this.activeAutomata.containsKey(automaton.getId());
    }

    @Nullable
    public Automaton getAutomatonAt(@Nonnull Location location) {
        String chunkId = this.getChunkKey(location);
        if (chunkId == null) {
            return null;
        }
        Map<Long, Automaton> restoreChunk = this.automata.get(chunkId);
        if (restoreChunk == null) {
            return null;
        }
        long blockId = BlockData.getBlockId(location);
        return restoreChunk.get(blockId);
    }

    @Nullable
    public AutomatonTemplate getAutomatonTemplate(String key) {
        return this.automatonTemplates.get(key);
    }

    private void loadEffects(ConfigurationSection effectsNode) {
        this.effects.clear();
        Set effectKeys = effectsNode.getKeys(false);
        for (String effectKey : effectKeys) {
            this.effects.put(effectKey, this.loadEffects(effectsNode, effectKey));
        }
    }

    @Override
    @Nullable
    public Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> loadEffects(ConfigurationSection configuration, String effectKey) {
        if (configuration.isString(effectKey)) {
            return this.getEffects(configuration.getString(effectKey));
        }
        return EffectPlayer.loadEffects((Plugin)this.getPlugin(), configuration, effectKey);
    }

    public void loadConfiguration() {
        this.loadConfiguration(null);
    }

    public void loadConfiguration(CommandSender sender) {
        this.loadConfiguration(sender, false);
    }

    public void loadConfiguration(CommandSender sender, boolean forceSynchronous) {
        ConfigurationLoadTask loadTask = new ConfigurationLoadTask(this, sender);
        if (this.initialized && !forceSynchronous) {
            this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, (Runnable)loadTask);
        } else {
            loadTask.runNow();
        }
    }

    protected void loadSpellData() {
        try {
            ConfigurationSection configNode = this.loadDataFile(SPELLS_DATA_FILE);
            if (configNode == null) {
                return;
            }
            Set keys = configNode.getKeys(false);
            for (String key : keys) {
                ConfigurationSection node = configNode.getConfigurationSection(key);
                SpellKey spellKey = new SpellKey(key);
                SpellData templateData = this.templateDataMap.get(spellKey.getBaseKey());
                if (templateData == null) {
                    templateData = new SpellData(spellKey.getBaseKey());
                    this.templateDataMap.put(templateData.getKey().getBaseKey(), templateData);
                }
                templateData.setCastCount(templateData.getCastCount() + node.getLong("cast_count", 0L));
                templateData.setLastCast(Math.max(templateData.getLastCast(), node.getLong("last_cast", 0L)));
            }
        }
        catch (Exception ex) {
            this.getLogger().warning("Failed to load spell metrics");
        }
    }

    public void load() {
        this.loadConfiguration();
        this.loadSpellData();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                MagicController.this.info("Loading lost wand data");
                MagicController.this.loadLostWands();
                MagicController.this.info("Loading automata data");
                MagicController.this.loadAutomata();
                try {
                    MagicController.this.maps.resetAll();
                    MagicController.this.maps.loadConfiguration();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                MagicController.this.info("Loading warps");
                ConfigurationSection warps = MagicController.this.loadDataFile(MagicController.WARPS_FILE);
                if (warps != null) {
                    MagicController.this.warpController.load(warps);
                    MagicController.this.info("Loaded " + MagicController.this.warpController.getCustomWarps().size() + " warps");
                }
                MagicController.this.getLogger().info("Finished loading data.");
            }
        }, 10L);
    }

    protected void loadLostWands() {
        try {
            ConfigurationSection lostWandConfiguration = this.loadDataFile(LOST_WANDS_FILE);
            if (lostWandConfiguration != null) {
                Set wandIds = lostWandConfiguration.getKeys(false);
                for (String wandId : wandIds) {
                    if (wandId == null || wandId.length() == 0) continue;
                    LostWand lostWand = new LostWand(wandId, lostWandConfiguration.getConfigurationSection(wandId));
                    if (!lostWand.isValid()) {
                        this.getLogger().info("Skipped invalid entry in lostwands.yml file, entry will be deleted. The wand is really lost now!");
                        continue;
                    }
                    this.addLostWand(lostWand);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.info("Loaded " + this.lostWands.size() + " lost wands");
    }

    protected void loadAutomata() {
        int automataCount = 0;
        try {
            ConfigurationSection toggleBlockData = this.loadDataFile(AUTOMATA_DATA_FILE);
            if (toggleBlockData != null) {
                Collection<ConfigurationSection> list = ConfigurationUtils.getNodeList(toggleBlockData, AUTOMATA_DATA_FILE);
                for (ConfigurationSection node : list) {
                    long id;
                    Automaton existing;
                    String chunkId;
                    Automaton automaton = new Automaton(this, node);
                    if (!automaton.isValid() || (chunkId = this.getChunkKey(automaton.getLocation())) == null) continue;
                    Map<Long, Automaton> restoreChunk = this.automata.get(chunkId);
                    if (restoreChunk == null) {
                        restoreChunk = new HashMap<Long, Automaton>();
                        this.automata.put(chunkId, restoreChunk);
                    }
                    if ((existing = restoreChunk.get(id = automaton.getId())) != null) {
                        this.getLogger().warning("Duplicate automata exist at " + automaton.getLocation() + ", one will be removed!");
                        continue;
                    }
                    ++automataCount;
                    restoreChunk.put(id, automaton);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (automataCount > 0) {
            for (World world : Bukkit.getWorlds()) {
                for (Chunk chunk : world.getLoadedChunks()) {
                    this.resumeAutomata(chunk);
                }
            }
        }
        this.info("Loaded " + automataCount + " automata");
    }

    protected void saveWarps(Collection<YamlDataFile> stores) {
        try {
            YamlDataFile warpData = this.createDataFile(WARPS_FILE);
            this.warpController.save((ConfigurationSection)warpData);
            stores.add(warpData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void saveAutomata(Collection<YamlDataFile> stores) {
        try {
            YamlDataFile automataData = this.createDataFile(AUTOMATA_DATA_FILE);
            ArrayList<MemoryConfiguration> nodes = new ArrayList<MemoryConfiguration>();
            for (Map.Entry<String, Map<Long, Automaton>> toggleEntry : this.automata.entrySet()) {
                Collection<Automaton> blocks = toggleEntry.getValue().values();
                if (blocks.size() <= 0) continue;
                for (Automaton block : blocks) {
                    MemoryConfiguration node = new MemoryConfiguration();
                    block.save((ConfigurationSection)node);
                    nodes.add(node);
                }
            }
            automataData.set(AUTOMATA_DATA_FILE, nodes);
            stores.add(automataData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void registerAutomaton(Automaton automaton) {
        String chunkId = this.getChunkKey(automaton.getLocation());
        if (chunkId == null) {
            return;
        }
        Map<Long, Automaton> chunkAutomata = this.automata.get(chunkId);
        if (chunkAutomata == null) {
            chunkAutomata = new HashMap<Long, Automaton>();
            this.automata.put(chunkId, chunkAutomata);
        }
        long id = automaton.getId();
        chunkAutomata.put(id, automaton);
        if (automaton.getLocation().getChunk().isLoaded()) {
            this.activeAutomata.put(id, automaton);
            automaton.resume();
        }
    }

    public boolean unregisterAutomaton(Automaton automaton) {
        boolean removed = false;
        String chunkId = this.getChunkKey(automaton.getLocation());
        long id = automaton.getId();
        Map<Long, Automaton> chunkAutomata = this.automata.get(chunkId);
        if (chunkAutomata != null) {
            boolean bl = removed = chunkAutomata.remove(id) != null;
            if (chunkAutomata.size() == 0) {
                this.automata.remove(chunkId);
            }
        }
        if (this.activeAutomata.remove(id) != null) {
            automaton.pause();
        }
        return removed;
    }

    public void resumeAutomata(Chunk chunk) {
        String chunkKey = this.getChunkKey(chunk);
        Map<Long, Automaton> chunkData = this.automata.get(chunkKey);
        if (chunkData != null) {
            this.activeAutomata.putAll(chunkData);
            for (Automaton automata : chunkData.values()) {
                automata.resume();
            }
        }
    }

    public void pauseAutomata(Chunk chunk) {
        String chunkKey = this.getChunkKey(chunk);
        Map<Long, Automaton> chunkData = this.automata.get(chunkKey);
        if (chunkData != null) {
            for (Automaton automata : chunkData.values()) {
                automata.pause();
            }
            this.activeAutomata.keySet().removeAll(chunkData.keySet());
        }
    }

    public void tickAutomata() {
        for (Automaton automaton : this.activeAutomata.values()) {
            automaton.tick();
        }
    }

    protected void saveSpellData(Collection<YamlDataFile> stores) {
        String lastKey = "";
        try {
            YamlDataFile spellsDataFile = this.createDataFile(SPELLS_DATA_FILE);
            for (SpellData data : this.templateDataMap.values()) {
                lastKey = data.getKey().getBaseKey();
                ConfigurationSection spellNode = spellsDataFile.createSection(lastKey);
                if (spellNode == null) {
                    this.getLogger().warning("Error saving spell data for " + lastKey);
                    continue;
                }
                spellNode.set("cast_count", (Object)data.getCastCount());
                spellNode.set("last_cast", (Object)data.getLastCast());
            }
            stores.add(spellsDataFile);
        }
        catch (Throwable ex) {
            this.getLogger().warning("Error saving spell data for " + lastKey);
            ex.printStackTrace();
        }
    }

    protected void saveLostWands(Collection<YamlDataFile> stores) {
        String lastKey = "";
        try {
            YamlDataFile lostWandsConfiguration = this.createDataFile(LOST_WANDS_FILE);
            for (Map.Entry<String, LostWand> wandEntry : this.lostWands.entrySet()) {
                lastKey = wandEntry.getKey();
                if (lastKey == null || lastKey.length() == 0) continue;
                ConfigurationSection wandNode = lostWandsConfiguration.createSection(lastKey);
                if (wandNode == null) {
                    this.getLogger().warning("Error saving lost wand data for " + lastKey);
                    continue;
                }
                if (!wandEntry.getValue().isValid()) {
                    this.getLogger().warning("Invalid lost and data for " + lastKey);
                    continue;
                }
                wandEntry.getValue().save(wandNode);
            }
            stores.add(lostWandsConfiguration);
        }
        catch (Throwable ex) {
            this.getLogger().warning("Error saving lost wand data for " + lastKey);
            ex.printStackTrace();
        }
    }

    @Nullable
    protected String getChunkKey(Block block) {
        return this.getChunkKey(block.getLocation());
    }

    @Nullable
    protected String getChunkKey(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return null;
        }
        return world.getName() + "|" + (location.getBlockX() >> 4) + "," + (location.getBlockZ() >> 4);
    }

    protected String getChunkKey(Chunk chunk) {
        return chunk.getWorld().getName() + "|" + chunk.getX() + "," + chunk.getZ();
    }

    public boolean addLostWand(LostWand lostWand) {
        this.lostWands.put(lostWand.getId(), lostWand);
        try {
            String chunkKey = this.getChunkKey(lostWand.getLocation());
            if (chunkKey == null) {
                return false;
            }
            Set<String> chunkWands = this.lostWandChunks.get(chunkKey);
            if (chunkWands == null) {
                chunkWands = new HashSet<String>();
                this.lostWandChunks.put(chunkKey, chunkWands);
            }
            chunkWands.add(lostWand.getId());
            if (this.dynmapShowWands) {
                this.addLostWandMarker(lostWand);
            }
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Error loading lost wand id " + lostWand.getId() + " - is it in an unloaded world?", ex);
        }
        return true;
    }

    public boolean addLostWand(Wand wand, Location dropLocation) {
        this.addLostWand(wand.makeLost(dropLocation));
        return true;
    }

    public boolean removeLostWand(String wandId) {
        if (wandId == null || wandId.length() == 0 || !this.lostWands.containsKey(wandId)) {
            return false;
        }
        LostWand lostWand = this.lostWands.get(wandId);
        this.lostWands.remove(wandId);
        String chunkKey = this.getChunkKey(lostWand.getLocation());
        if (chunkKey == null) {
            return false;
        }
        Set<String> chunkWands = this.lostWandChunks.get(chunkKey);
        if (chunkWands != null) {
            chunkWands.remove(wandId);
            if (chunkWands.size() == 0) {
                this.lostWandChunks.remove(chunkKey);
            }
        }
        if (this.dynmapShowWands && this.removeMarker("wand-" + wandId, "Wands")) {
            this.info("Wand removed from map");
        }
        return true;
    }

    public WandMode getDefaultWandMode() {
        return this.defaultWandMode;
    }

    public WandMode getDefaultBrushMode() {
        return this.defaultBrushMode;
    }

    public String getDefaultWandPath() {
        return this.defaultWandPath;
    }

    protected void savePlayerData(Collection<MageData> stores) {
        try {
            for (Map.Entry<String, Mage> mageEntry : this.mages.entrySet()) {
                com.elmakers.mine.bukkit.api.magic.Mage mage = mageEntry.getValue();
                if (!mage.isPlayer() && !this.saveNonPlayerMages) continue;
                if (!mage.isLoading()) {
                    MageData mageData = new MageData(mage.getId());
                    if (!mage.save(mageData)) continue;
                    stores.add(mageData);
                    continue;
                }
                this.getLogger().info("Skipping save of mage, already loading: " + mage.getName());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void save() {
        this.save(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(boolean asynchronous) {
        if (!this.initialized) {
            return;
        }
        this.maps.save(asynchronous);
        final ArrayList<YamlDataFile> saveData = new ArrayList<YamlDataFile>();
        final ArrayList<MageData> saveMages = new ArrayList<MageData>();
        if (this.savePlayerData && this.mageDataStore != null) {
            this.savePlayerData(saveMages);
        }
        this.info("Saving " + saveMages.size() + " players");
        this.saveSpellData(saveData);
        this.saveLostWands(saveData);
        this.saveAutomata(saveData);
        this.saveWarps(saveData);
        if (this.mageDataStore != null) {
            if (asynchronous) {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = MagicController.this.saveLock;
                        synchronized (object) {
                            for (MageData mageData : saveMages) {
                                MagicController.this.mageDataStore.save(mageData, null, false);
                            }
                            for (YamlDataFile config : saveData) {
                                config.save();
                            }
                            MagicController.this.info("Finished saving");
                        }
                    }
                });
            } else {
                Object object = this.saveLock;
                synchronized (object) {
                    for (MageData mageData : saveMages) {
                        this.mageDataStore.save(mageData, null, false);
                    }
                    for (YamlDataFile config : saveData) {
                        config.save();
                    }
                    this.info("Finished saving");
                }
            }
        }
        SaveEvent saveEvent = new SaveEvent(asynchronous);
        Bukkit.getPluginManager().callEvent((Event)saveEvent);
    }

    protected void loadSpells(ConfigurationSection spellConfigs) {
        if (spellConfigs == null) {
            return;
        }
        this.spells.clear();
        this.spellAliases.clear();
        this.categories.clear();
        Set keys = spellConfigs.getKeys(false);
        for (String string : keys) {
            String icon;
            if (string.equals("default") || string.equals("override")) continue;
            ConfigurationSection spellNode = spellConfigs.getConfigurationSection(string);
            Spell newSpell = null;
            try {
                newSpell = MagicController.loadSpell(string, spellNode, this);
            }
            catch (Exception ex) {
                newSpell = null;
                ex.printStackTrace();
            }
            if (newSpell == null) {
                this.getLogger().warning("Magic: Error loading spell " + string);
                continue;
            }
            if (!newSpell.hasIcon() && (icon = spellNode.getString("icon")) != null && !icon.isEmpty()) {
                this.getLogger().info("Couldn't load spell icon '" + icon + "' for spell: " + newSpell.getKey());
            }
            this.addSpell(newSpell);
        }
        for (String string : keys) {
            SpellTemplate template = this.getSpellTemplate(string);
            if (template == null) continue;
            template.loadPrerequisites(spellConfigs.getConfigurationSection(string));
        }
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            if (!(mage instanceof Mage)) continue;
            ((Mage)mage).loadSpells(spellConfigs);
        }
    }

    @Nullable
    public static Spell loadSpell(String name, ConfigurationSection node, MageController controller) {
        Object newObject;
        String className = node.getString("class");
        if (className == null || className.equalsIgnoreCase("action") || className.equalsIgnoreCase("actionspell")) {
            className = "com.elmakers.mine.bukkit.spell.ActionSpell";
        } else if (className.indexOf(46) <= 0) {
            className = "com.elmakers.mine.bukkit.spell.builtin." + className;
        }
        Class<?> spellClass = null;
        try {
            spellClass = Class.forName(className);
        }
        catch (Throwable ex) {
            controller.getLogger().log(Level.WARNING, "Error loading spell: " + className, ex);
            return null;
        }
        if (spellClass.getAnnotation(Deprecated.class) != null) {
            controller.getLogger().warning("Spell " + name + " is using a deprecated spell class " + className + ". This will be removed in the future, please see the default configs for alternatives.");
        }
        try {
            newObject = spellClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable ex) {
            controller.getLogger().log(Level.WARNING, "Error loading spell: " + className, ex);
            return null;
        }
        if (newObject == null || !(newObject instanceof MageSpell)) {
            controller.getLogger().warning("Error loading spell: " + className + ", does it implement MageSpell?");
            return null;
        }
        MageSpell newSpell = (MageSpell)newObject;
        newSpell.initialize(controller);
        newSpell.loadTemplate(name, node);
        com.elmakers.mine.bukkit.api.spell.SpellCategory category = newSpell.getCategory();
        if (category instanceof SpellCategory) {
            ((SpellCategory)category).addSpellTemplate(newSpell);
        }
        return newSpell;
    }

    @Override
    @Nullable
    public String getReflectiveMaterials(com.elmakers.mine.bukkit.api.magic.Mage mage, Location location) {
        return this.worldGuardManager.getReflective(mage.getPlayer(), location);
    }

    @Override
    @Nullable
    public String getDestructibleMaterials(com.elmakers.mine.bukkit.api.magic.Mage mage, Location location) {
        return this.worldGuardManager.getDestructible(mage.getPlayer(), location);
    }

    @Override
    @Deprecated
    public Set<Material> getDestructibleMaterials() {
        return MaterialSets.toLegacyNN(this.destructibleMaterials);
    }

    @Override
    @Nullable
    public Set<String> getSpellOverrides(com.elmakers.mine.bukkit.api.magic.Mage mage, Location location) {
        return this.worldGuardManager.getSpellOverrides(mage.getPlayer(), location);
    }

    protected void loadMaterials(ConfigurationSection materialNode) {
        if (materialNode == null) {
            return;
        }
        this.materialSetManager.loadMaterials(materialNode);
        DefaultMaterials defaultMaterials = DefaultMaterials.getInstance();
        defaultMaterials.initialize(this.materialSetManager);
        defaultMaterials.loadColors(this.materialColors);
        defaultMaterials.loadVariants(this.materialVariants);
        defaultMaterials.loadBlockItems(this.blockItems);
        defaultMaterials.setPlayerSkullItem(this.skullItems.get(EntityType.PLAYER));
        defaultMaterials.setPlayerSkullWallBlock(this.skullWallBlocks.get(EntityType.PLAYER));
        this.buildingMaterials = this.materialSetManager.getMaterialSetEmpty("building");
        this.indestructibleMaterials = this.materialSetManager.getMaterialSetEmpty("indestructible");
        this.restrictedMaterials = this.materialSetManager.getMaterialSetEmpty("restricted");
        this.destructibleMaterials = this.materialSetManager.getMaterialSetEmpty("destructible");
        this.interactibleMaterials = this.materialSetManager.getMaterialSetEmpty("interactible");
        this.containerMaterials = this.materialSetManager.getMaterialSetEmpty("containers");
        this.wearableMaterials = this.materialSetManager.getMaterialSetEmpty("wearable");
        this.meleeMaterials = this.materialSetManager.getMaterialSetEmpty("melee");
        UndoList.attachables = this.materialSetManager.getMaterialSetEmpty("attachable");
        UndoList.attachablesWall = this.materialSetManager.getMaterialSetEmpty("attachable_wall");
        UndoList.attachablesDouble = this.materialSetManager.getMaterialSetEmpty("attachable_double");
    }

    protected void loadProperties(ConfigurationSection properties) {
        block48: {
            if (properties == null) {
                return;
            }
            this.logVerbosity = properties.getInt("log_verbosity", 0);
            if (this.autoSaveTaskId > 0) {
                Bukkit.getScheduler().cancelTask(this.autoSaveTaskId);
                this.autoSaveTaskId = 0;
            }
            if (this.configCheckTask != null) {
                this.configCheckTask.cancel();
                this.configCheckTask = null;
            }
            EffectPlayer.debugEffects(properties.getBoolean("debug_effects", false));
            CompatibilityUtils.USE_MAGIC_DAMAGE = properties.getBoolean("use_magic_damage", CompatibilityUtils.USE_MAGIC_DAMAGE);
            EffectPlayer.setParticleRange(properties.getInt("particle_range", EffectPlayer.PARTICLE_RANGE));
            this.resourcePackPrompt = properties.getBoolean("resource_pack_prompt", false);
            this.enableResourcePackCheck = properties.getBoolean("enable_resource_pack_check", true);
            this.resourcePackCheckInterval = properties.getInt("resource_pack_check_interval", 0);
            this.defaultResourcePack = properties.getString("resource_pack", null);
            this.defaultResourcePack = properties.getString("default_resource_pack", this.defaultResourcePack);
            if (this.addExamples != null && this.addExamples.size() > 0 && !this.defaultResourcePack.isEmpty()) {
                this.defaultResourcePack = properties.getString("add_resource_pack", this.defaultResourcePack);
            }
            if (!properties.getBoolean("enable_resource_pack")) {
                this.defaultResourcePack = null;
            }
            if (this.defaultResourcePack == null || this.defaultResourcePack.isEmpty()) {
                this.resourcePack = null;
                this.resourcePackHash = null;
            }
            this.resourcePackDelay = properties.getLong("resource_pack_delay", 0L);
            this.showCastHoloText = properties.getBoolean("show_cast_holotext", this.showCastHoloText);
            this.showActivateHoloText = properties.getBoolean("show_activate_holotext", this.showCastHoloText);
            this.castHoloTextRange = properties.getInt("cast_holotext_range", this.castHoloTextRange);
            this.activateHoloTextRange = properties.getInt("activate_holotext_range", this.activateHoloTextRange);
            this.urlIconsEnabled = properties.getBoolean("url_icons_enabled", this.urlIconsEnabled);
            this.spellProgressionEnabled = properties.getBoolean("enable_spell_progression", this.spellProgressionEnabled);
            this.autoSpellUpgradesEnabled = properties.getBoolean("enable_automatic_spell_upgrades", this.autoSpellUpgradesEnabled);
            this.autoPathUpgradesEnabled = properties.getBoolean("enable_automatic_spell_upgrades", this.autoPathUpgradesEnabled);
            this.undoQueueDepth = properties.getInt("undo_depth", this.undoQueueDepth);
            this.workPerUpdate = properties.getInt("work_per_update", this.workPerUpdate);
            this.workFrequency = properties.getInt("work_frequency", this.workFrequency);
            this.automataUpdateFrequency = properties.getInt("automata_update_frequency", this.automataUpdateFrequency);
            this.mageUpdateFrequency = properties.getInt("mage_update_frequency", this.mageUpdateFrequency);
            this.undoFrequency = properties.getInt("undo_frequency", this.undoFrequency);
            this.pendingQueueDepth = properties.getInt("pending_depth", this.pendingQueueDepth);
            this.undoMaxPersistSize = properties.getInt("undo_max_persist_size", this.undoMaxPersistSize);
            this.commitOnQuit = properties.getBoolean("commit_on_quit", this.commitOnQuit);
            this.saveNonPlayerMages = properties.getBoolean("save_non_player_mages", this.saveNonPlayerMages);
            this.defaultWandPath = properties.getString("default_wand_path", "");
            Wand.DEFAULT_WAND_TEMPLATE = properties.getString("default_wand", "");
            this.defaultWandMode = Wand.parseWandMode(properties.getString("default_wand_mode", ""), this.defaultWandMode);
            this.defaultBrushMode = Wand.parseWandMode(properties.getString("default_brush_mode", ""), this.defaultBrushMode);
            this.backupInventories = properties.getBoolean("backup_player_inventory", true);
            Wand.brushSelectSpell = properties.getString("brush_select_spell", Wand.brushSelectSpell);
            this.showMessages = properties.getBoolean("show_messages", this.showMessages);
            this.showCastMessages = properties.getBoolean("show_cast_messages", this.showCastMessages);
            this.messageThrottle = properties.getInt("message_throttle", 0);
            this.soundsEnabled = properties.getBoolean("sounds", this.soundsEnabled);
            this.fillingEnabled = properties.getBoolean("fill_wands", this.fillingEnabled);
            Wand.FILL_CREATOR = properties.getBoolean("fill_wand_creator", Wand.FILL_CREATOR);
            Wand.CREATIVE_CHEST_MODE = properties.getBoolean("wand_creative_chest_switch", Wand.CREATIVE_CHEST_MODE);
            this.maxFillLevel = properties.getInt("fill_wand_level", this.maxFillLevel);
            this.welcomeWand = properties.getString("welcome_wand", "");
            this.maxDamagePowerMultiplier = (float)properties.getDouble("max_power_damage_multiplier", (double)this.maxDamagePowerMultiplier);
            this.maxConstructionPowerMultiplier = (float)properties.getDouble("max_power_construction_multiplier", (double)this.maxConstructionPowerMultiplier);
            this.maxRangePowerMultiplier = (float)properties.getDouble("max_power_range_multiplier", (double)this.maxRangePowerMultiplier);
            this.maxRangePowerMultiplierMax = (float)properties.getDouble("max_power_range_multiplier_max", (double)this.maxRangePowerMultiplierMax);
            this.maxRadiusPowerMultiplier = (float)properties.getDouble("max_power_radius_multiplier", (double)this.maxRadiusPowerMultiplier);
            this.maxRadiusPowerMultiplierMax = (float)properties.getDouble("max_power_radius_multiplier_max", (double)this.maxRadiusPowerMultiplierMax);
            this.materialColors = ConfigurationUtils.getNodeList(properties, "material_colors");
            this.materialVariants = ConfigurationUtils.getList(properties, "material_variants");
            this.blockItems = properties.getConfigurationSection("block_items");
            this.currencyConfiguration = properties.getConfigurationSection("custom_currency");
            this.loadBlockSkins(properties.getConfigurationSection("block_skins"));
            this.loadMobSkins(properties.getConfigurationSection("mob_skins"));
            this.loadMobEggs(properties.getConfigurationSection("mob_eggs"));
            this.loadSkulls(properties.getConfigurationSection("skulls"));
            this.loadOtherMaterials(properties);
            this.maxPower = (float)properties.getDouble("max_power", (double)this.maxPower);
            ConfigurationSection damageTypes = properties.getConfigurationSection("damage_types");
            if (damageTypes != null) {
                Set typeKeys = damageTypes.getKeys(false);
                for (Object typeKey : typeKeys) {
                    ConfigurationSection damageType = damageTypes.getConfigurationSection((String)typeKey);
                    this.damageTypes.put((String)typeKey, new DamageType(damageType));
                }
            }
            this.maxCostReduction = (float)properties.getDouble("max_cost_reduction", (double)this.maxCostReduction);
            this.maxCooldownReduction = (float)properties.getDouble("max_cooldown_reduction", (double)this.maxCooldownReduction);
            this.maxMana = properties.getInt("max_mana", this.maxMana);
            this.maxManaRegeneration = properties.getInt("max_mana_regeneration", this.maxManaRegeneration);
            this.worthSkillPoints = properties.getDouble("worth_sp", 1.0);
            this.skillPointIcon = properties.getString("sp_item_icon_url");
            this.skillPointItemsEnabled = properties.getBoolean("sp_items_enabled", true);
            this.worthBase = properties.getDouble("worth_base", 1.0);
            this.worthXP = properties.getDouble("worth_xp", 1.0);
            ConfigurationSection currencies = properties.getConfigurationSection("currency");
            if (currencies != null) {
                Set worthItemKeys = currencies.getKeys(false);
                for (String worthItemKey : worthItemKeys) {
                    ConfigurationSection currencyConfig = currencies.getConfigurationSection(worthItemKey);
                    if (!currencyConfig.getBoolean("enabled", true)) continue;
                    MaterialAndData material = new MaterialAndData(worthItemKey);
                    ItemStack worthItemType = material.getItemStack(1);
                    double worthItemAmount = currencyConfig.getDouble("worth");
                    String worthItemName = currencyConfig.getString("name");
                    String worthItemNamePlural = currencyConfig.getString("name_plural");
                    this.currencyItem = new CurrencyItem(worthItemType, worthItemAmount, worthItemName, worthItemNamePlural);
                    if (worthItemKey.equals("emerald")) continue;
                    break;
                }
            } else {
                this.currencyItem = null;
            }
            SafetyUtils.MAX_VELOCITY = properties.getDouble("max_velocity", 10.0);
            HitboxUtils.setHitboxScale(properties.getDouble("hitbox_scale", 1.0));
            HitboxUtils.setHitboxScaleY(properties.getDouble("hitbox_scale_y", 1.0));
            HitboxUtils.setHitboxSneakScaleY(properties.getDouble("hitbox_sneaking_scale_y", 0.75));
            if (properties.contains("hitboxes")) {
                HitboxUtils.configureHitboxes(properties.getConfigurationSection("hitboxes"));
            }
            if (properties.contains("head_sizes")) {
                HitboxUtils.configureHeadSizes(properties.getConfigurationSection("head_sizes"));
            }
            if (properties.contains("max_height")) {
                HitboxUtils.configureMaxHeights(properties.getConfigurationSection("max_height"));
            }
            this.castCommandCostFree = properties.contains("cast_command_cost_reduction") ? properties.getDouble("cast_command_cost_reduction") > 0.0 : properties.getBoolean("cast_command_cost_free", this.castCommandCostFree);
            this.castCommandCooldownFree = properties.contains("cast_command_cooldown_reduction") ? properties.getDouble("cast_command_cooldown_reduction") > 0.0 : properties.getBoolean("cast_command_cooldown_free", this.castCommandCooldownFree);
            this.castConsoleCostFree = properties.contains("cast_console_cost_reduction") ? properties.getDouble("cast_console_cost_reduction") > 0.0 : properties.getBoolean("cast_console_cost_free", this.castConsoleCostFree);
            this.castConsoleCooldownFree = properties.contains("cast_console_cooldown_reduction") ? properties.getDouble("cast_console_cooldown_reduction") > 0.0 : properties.getBoolean("cast_console_cooldown_free", this.castConsoleCooldownFree);
            this.castCommandPowerMultiplier = (float)properties.getDouble("cast_command_power_multiplier", (double)this.castCommandPowerMultiplier);
            this.castConsolePowerMultiplier = (float)properties.getDouble("cast_console_power_multiplier", (double)this.castConsolePowerMultiplier);
            this.maps.setAnimationAllowed(properties.getBoolean("enable_map_animations", true));
            this.costReduction = (float)properties.getDouble("cost_reduction", (double)this.costReduction);
            this.cooldownReduction = (float)properties.getDouble("cooldown_reduction", (double)this.cooldownReduction);
            this.autoUndo = properties.getInt("auto_undo", this.autoUndo);
            this.spellDroppingEnabled = properties.getBoolean("allow_spell_dropping", this.spellDroppingEnabled);
            this.essentialsSignsEnabled = properties.getBoolean("enable_essentials_signs", this.essentialsSignsEnabled);
            this.logBlockEnabled = properties.getBoolean("logblock_enabled", this.logBlockEnabled);
            this.citizensEnabled = properties.getBoolean("enable_citizens", this.citizensEnabled);
            this.dynmapShowWands = properties.getBoolean("dynmap_show_wands", this.dynmapShowWands);
            this.dynmapShowSpells = properties.getBoolean("dynmap_show_spells", this.dynmapShowSpells);
            this.dynmapOnlyPlayerSpells = properties.getBoolean("dynmap_only_player_spells", this.dynmapOnlyPlayerSpells);
            this.dynmapUpdate = properties.getBoolean("dynmap_update", this.dynmapUpdate);
            this.protectLocked = properties.getBoolean("protected_locked", this.protectLocked);
            this.bindOnGive = properties.getBoolean("bind_on_give", this.bindOnGive);
            this.bypassBuildPermissions = properties.getBoolean("bypass_build", this.bypassBuildPermissions);
            this.bypassBreakPermissions = properties.getBoolean("bypass_break", this.bypassBreakPermissions);
            this.bypassPvpPermissions = properties.getBoolean("bypass_pvp", this.bypassPvpPermissions);
            this.bypassFriendlyFire = properties.getBoolean("bypass_friendly_fire", this.bypassFriendlyFire);
            this.useScoreboardTeams = properties.getBoolean("use_scoreboard_teams", this.useScoreboardTeams);
            this.defaultFriendly = properties.getBoolean("default_friendly", this.defaultFriendly);
            this.extraSchematicFilePath = properties.getString("schematic_files", this.extraSchematicFilePath);
            this.createWorldsEnabled = properties.getBoolean("enable_world_creation", this.createWorldsEnabled);
            this.defaultSkillIcon = properties.getString("default_skill_icon", this.defaultSkillIcon);
            this.skillInventoryRows = properties.getInt("skill_inventory_max_rows", this.skillInventoryRows);
            this.skillsSpell = properties.getString("mskills_spell", this.skillsSpell);
            InventoryUtils.MAX_LORE_LENGTH = properties.getInt("lore_wrap_limit", InventoryUtils.MAX_LORE_LENGTH);
            this.libsDisguiseEnabled = properties.getBoolean("enable_libsdisguises", this.libsDisguiseEnabled);
            this.skillAPIEnabled = properties.getBoolean("skillapi_enabled", this.skillAPIEnabled);
            this.useSkillAPIMana = properties.getBoolean("use_skillapi_mana", this.useSkillAPIMana);
            this.placeholdersEnabled = properties.getBoolean("placeholder_api_enabled", this.placeholdersEnabled);
            this.lightAPIEnabled = properties.getBoolean("light_api_enabled", this.lightAPIEnabled);
            this.skriptEnabled = properties.getBoolean("skript_enabled", this.skriptEnabled);
            this.citadelConfiguration = properties.getConfigurationSection("citadel");
            this.mobArenaConfiguration = properties.getConfigurationSection("mobarena");
            if (this.mobArenaManager != null) {
                this.mobArenaManager.configure(this.mobArenaConfiguration);
            }
            String defaultSpellIcon = properties.getString("default_spell_icon");
            try {
                BaseSpell.DEFAULT_SPELL_ICON = Material.valueOf((String)defaultSpellIcon.toUpperCase());
            }
            catch (Exception ex) {
                this.getLogger().warning("Invalid default_spell_icon: " + defaultSpellIcon);
            }
            this.skillsUseHeroes = properties.getBoolean("skills_use_heroes", this.skillsUseHeroes);
            this.useHeroesParties = properties.getBoolean("use_heroes_parties", this.useHeroesParties);
            this.useHeroesMana = properties.getBoolean("use_heroes_mana", this.useHeroesMana);
            this.heroesSkillPrefix = properties.getString("heroes_skill_prefix", this.heroesSkillPrefix);
            this.skillsUsePermissions = properties.getBoolean("skills_use_permissions", this.skillsUsePermissions);
            this.messagePrefix = properties.getString("message_prefix", this.messagePrefix);
            this.castMessagePrefix = properties.getString("cast_message_prefix", this.castMessagePrefix);
            this.redstoneReplacement = ConfigurationUtils.getMaterialAndData(properties, "redstone_replacement", this.redstoneReplacement);
            this.messagePrefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.messagePrefix);
            this.castMessagePrefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.castMessagePrefix);
            this.worldGuardManager.setEnabled(properties.getBoolean("region_manager_enabled", this.worldGuardManager.isEnabled()));
            this.factionsManager.setEnabled(properties.getBoolean("factions_enabled", this.factionsManager.isEnabled()));
            this.pvpManager.setEnabled(properties.getBoolean("pvp_manager_enabled", this.pvpManager.isEnabled()));
            this.multiverseManager.setEnabled(properties.getBoolean("multiverse_enabled", this.multiverseManager.isEnabled()));
            this.preciousStonesManager.setEnabled(properties.getBoolean("precious_stones_enabled", this.preciousStonesManager.isEnabled()));
            this.preciousStonesManager.setOverride(properties.getBoolean("precious_stones_override", true));
            this.townyManager.setEnabled(properties.getBoolean("towny_enabled", this.townyManager.isEnabled()));
            this.townyManager.setWildernessBypass(properties.getBoolean("towny_wilderness_bypass", true));
            this.locketteManager.setEnabled(properties.getBoolean("lockette_enabled", this.locketteManager.isEnabled()));
            this.griefPreventionManager.setEnabled(properties.getBoolean("grief_prevention_enabled", this.griefPreventionManager.isEnabled()));
            this.ncpManager.setEnabled(properties.getBoolean("ncp_enabled", false));
            Mage.DEFAULT_CLASS = properties.getString("default_mage_class", "");
            this.metricsLevel = properties.getInt("metrics_level", this.metricsLevel);
            Wand.regenWhileInactive = properties.getBoolean("regenerate_while_inactive", Wand.regenWhileInactive);
            if (properties.contains("mana_display")) {
                String manaDisplay = properties.getString("mana_display");
                if (manaDisplay.equalsIgnoreCase("bar") || manaDisplay.equalsIgnoreCase("hybrid")) {
                    Wand.manaMode = WandManaMode.BAR;
                } else if (manaDisplay.equalsIgnoreCase("number")) {
                    Wand.manaMode = WandManaMode.NUMBER;
                } else if (manaDisplay.equalsIgnoreCase("durability")) {
                    Wand.manaMode = WandManaMode.DURABILITY;
                } else if (manaDisplay.equalsIgnoreCase("glow")) {
                    Wand.manaMode = WandManaMode.GLOW;
                } else if (manaDisplay.equalsIgnoreCase("none")) {
                    Wand.manaMode = WandManaMode.NONE;
                }
            }
            if (properties.contains("sp_display")) {
                String spDisplay = properties.getString("sp_display");
                Wand.currencyMode = spDisplay.equalsIgnoreCase("number") ? WandManaMode.NUMBER : WandManaMode.NONE;
            }
            this.spEnabled = properties.getBoolean("sp_enabled", true);
            this.spEarnEnabled = properties.getBoolean("sp_earn_enabled", true);
            this.spMaximum = properties.getInt("sp_max", 9999);
            this.populateEntityTypes(this.undoEntityTypes, properties, "entity_undo_types");
            this.populateEntityTypes(this.friendlyEntityTypes, properties, "friendly_entity_types");
            ActionHandler.setRestrictedActions(properties.getStringList("restricted_spell_actions"));
            String defaultLocationString = properties.getString("default_cast_location");
            try {
                Mage.DEFAULT_CAST_LOCATION = CastSourceLocation.valueOf(defaultLocationString.toUpperCase());
            }
            catch (Exception ex) {
                Mage.DEFAULT_CAST_LOCATION = CastSourceLocation.MAINHAND;
                this.getLogger().warning("Invalid default_cast_location: " + defaultLocationString);
            }
            Mage.DEFAULT_CAST_OFFSET.setZ(properties.getDouble("default_cast_location_offset", Mage.DEFAULT_CAST_OFFSET.getZ()));
            Mage.DEFAULT_CAST_OFFSET.setY(properties.getDouble("default_cast_location_offset_vertical", Mage.DEFAULT_CAST_OFFSET.getY()));
            Mage.OFFHAND_CAST_COOLDOWN = properties.getInt("offhand_cast_cooldown", Mage.OFFHAND_CAST_COOLDOWN);
            Mage.SNEAKING_CAST_OFFSET = properties.getDouble("sneaking_cast_location_offset_vertical", Mage.SNEAKING_CAST_OFFSET);
            Wand.DefaultUpgradeMaterial = ConfigurationUtils.getMaterial(properties, "wand_upgrade_item", Wand.DefaultUpgradeMaterial);
            Wand.SpellGlow = properties.getBoolean("spell_glow", Wand.SpellGlow);
            Wand.LiveHotbarSkills = properties.getBoolean("live_hotbar_skills", Wand.LiveHotbarSkills);
            Wand.LiveHotbar = properties.getBoolean("live_hotbar", Wand.LiveHotbar);
            Wand.LiveHotbarCooldown = properties.getBoolean("live_hotbar_cooldown", Wand.LiveHotbarCooldown);
            Wand.LiveHotbarMana = properties.getBoolean("live_hotbar_mana", Wand.LiveHotbarMana);
            Wand.BrushGlow = properties.getBoolean("brush_glow", Wand.BrushGlow);
            Wand.BrushItemGlow = properties.getBoolean("brush_item_glow", Wand.BrushItemGlow);
            Wand.WAND_KEY = properties.getString("wand_key", "wand");
            Wand.UPGRADE_KEY = properties.getString("wand_upgrade_key", "wand");
            Wand.WAND_SELF_DESTRUCT_KEY = properties.getString("wand_self_destruct_key", "");
            if (Wand.WAND_SELF_DESTRUCT_KEY.isEmpty()) {
                Wand.WAND_SELF_DESTRUCT_KEY = null;
            }
            Wand.HIDE_FLAGS = (byte)properties.getInt("wand_hide_flags", (int)Wand.HIDE_FLAGS);
            Wand.Unbreakable = properties.getBoolean("wand_unbreakable", Wand.Unbreakable);
            Wand.Unstashable = properties.getBoolean("wand_undroppable", properties.getBoolean("wand_unstashable", Wand.Unstashable));
            MaterialBrush.CopyMaterial = ConfigurationUtils.getMaterialAndData(properties, "copy_item", MaterialBrush.CopyMaterial);
            MaterialBrush.EraseMaterial = ConfigurationUtils.getMaterialAndData(properties, "erase_item", MaterialBrush.EraseMaterial);
            MaterialBrush.CloneMaterial = ConfigurationUtils.getMaterialAndData(properties, "clone_item", MaterialBrush.CloneMaterial);
            MaterialBrush.ReplicateMaterial = ConfigurationUtils.getMaterialAndData(properties, "replicate_item", MaterialBrush.ReplicateMaterial);
            MaterialBrush.SchematicMaterial = ConfigurationUtils.getMaterialAndData(properties, "schematic_item", MaterialBrush.SchematicMaterial);
            MaterialBrush.MapMaterial = ConfigurationUtils.getMaterialAndData(properties, "map_item", MaterialBrush.MapMaterial);
            MaterialBrush.DefaultBrushMaterial = ConfigurationUtils.getMaterialAndData(properties, "default_brush_item", MaterialBrush.DefaultBrushMaterial);
            MaterialBrush.configureReplacements(properties.getConfigurationSection("brush_replacements"));
            MaterialBrush.CopyCustomIcon = properties.getString("copy_icon_url", MaterialBrush.CopyCustomIcon);
            MaterialBrush.EraseCustomIcon = properties.getString("erase_icon_url", MaterialBrush.EraseCustomIcon);
            MaterialBrush.CloneCustomIcon = properties.getString("clone_icon_url", MaterialBrush.CloneCustomIcon);
            MaterialBrush.ReplicateCustomIcon = properties.getString("replicate_icon_url", MaterialBrush.ReplicateCustomIcon);
            MaterialBrush.SchematicCustomIcon = properties.getString("schematic_icon_url", MaterialBrush.SchematicCustomIcon);
            MaterialBrush.MapCustomIcon = properties.getString("map_icon_url", MaterialBrush.MapCustomIcon);
            MaterialBrush.DefaultBrushCustomIcon = properties.getString("default_brush_icon_url", MaterialBrush.DefaultBrushCustomIcon);
            BaseSpell.DEFAULT_DISABLED_ICON_URL = properties.getString("disabled_icon_url", BaseSpell.DEFAULT_DISABLED_ICON_URL);
            Wand.DEFAULT_CAST_OFFSET.setZ(properties.getDouble("wand_location_offset", Wand.DEFAULT_CAST_OFFSET.getZ()));
            Wand.DEFAULT_CAST_OFFSET.setY(properties.getDouble("wand_location_offset_vertical", Wand.DEFAULT_CAST_OFFSET.getY()));
            Mage.JUMP_EFFECT_FLIGHT_EXEMPTION_DURATION = properties.getInt("jump_exemption", 0);
            Mage.CHANGE_WORLD_EQUIP_COOLDOWN = properties.getInt("change_world_equip_cooldown", 0);
            Mage.DEACTIVATE_WAND_ON_WORLD_CHANGE = properties.getBoolean("close_wand_on_world_change", false);
            Mage.DEFAULT_SP = properties.getInt("sp_default", 0);
            Wand.inventoryOpenSound = ConfigurationUtils.toSoundEffect(properties.getString("wand_inventory_open_sound"));
            Wand.inventoryCloseSound = ConfigurationUtils.toSoundEffect(properties.getString("wand_inventory_close_sound"));
            Wand.inventoryCycleSound = ConfigurationUtils.toSoundEffect(properties.getString("wand_inventory_cycle_sound"));
            Wand.noActionSound = ConfigurationUtils.toSoundEffect(properties.getString("wand_no_action_sound"));
            Wand.itemPickupSound = ConfigurationUtils.toSoundEffect(properties.getString("wand_pickup_item_sound"));
            this.explosionController.loadProperties(properties);
            this.inventoryController.loadProperties(properties);
            this.entityController.loadProperties(properties);
            this.playerController.loadProperties(properties);
            this.blockController.loadProperties(properties);
            EffectPlayer.SOUNDS_ENABLED = this.soundsEnabled;
            int autoSaveIntervalTicks = properties.getInt("auto_save", 0) * 20 / 1000;
            if (autoSaveIntervalTicks > 1) {
                AutoSaveTask autoSave = new AutoSaveTask(this);
                this.autoSaveTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)autoSave, (long)autoSaveIntervalTicks, (long)autoSaveIntervalTicks);
            }
            this.savePlayerData = properties.getBoolean("save_player_data", true);
            this.externalPlayerData = properties.getBoolean("external_player_data", false);
            if (this.externalPlayerData) {
                this.getLogger().info("Magic is expecting player data to be loaded from an external source");
            } else if (!this.savePlayerData) {
                this.getLogger().info("Magic player data saving is disabled");
            }
            this.asynchronousSaving = properties.getBoolean("save_player_data_asynchronously", true);
            this.isFileLockingEnabled = properties.getBoolean("use_file_locking", false);
            this.fileLoadDelay = properties.getInt("file_load_delay", 0);
            ConfigurationSection mageDataStore = properties.getConfigurationSection("player_data_store");
            if (mageDataStore != null) {
                String dataStoreClassName = mageDataStore.getString("class");
                try {
                    Class<?> dataStoreClass = Class.forName(dataStoreClassName);
                    Object dataStore = dataStoreClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (dataStore == null || !(dataStore instanceof MageDataStore)) {
                        this.getLogger().log(Level.WARNING, "Invalid player_data_store class " + dataStoreClassName + ", does it implement MageDataStore? Player data saving is disabled!");
                        this.mageDataStore = null;
                        break block48;
                    }
                    this.mageDataStore = (MageDataStore)dataStore;
                    this.mageDataStore.initialize(this, mageDataStore);
                }
                catch (Exception ex) {
                    this.getLogger().log(Level.WARNING, "Failed to create player_data_store class from " + dataStoreClassName + " player data saving is disabled!", ex);
                    this.mageDataStore = null;
                }
            } else {
                this.getLogger().log(Level.WARNING, "Missing player_data_store configuration, player data saving disabled!");
                this.mageDataStore = null;
            }
        }
        Wand.DefaultWandMaterial = ConfigurationUtils.getMaterial(properties, "wand_item", Wand.DefaultWandMaterial);
        Wand.EnchantableWandMaterial = ConfigurationUtils.getMaterial(properties, "wand_item_enchantable", Wand.EnchantableWandMaterial);
        this.enchanting.setEnabled(properties.getBoolean("enable_enchanting", this.enchanting.isEnabled()));
        if (this.enchanting.isEnabled()) {
            this.getLogger().info("Wand enchanting is enabled");
        }
        this.crafting.setEnabled(properties.getBoolean("enable_crafting", this.crafting.isEnabled()));
        if (this.crafting.isEnabled()) {
            this.getLogger().info("Wand crafting is enabled");
        }
        this.anvil.load(properties);
        if (this.anvil.isCombiningEnabled()) {
            this.getLogger().info("Wand anvil combining is enabled");
        }
        if (this.anvil.isOrganizingEnabled()) {
            this.getLogger().info("Wand anvil organizing is enabled");
        }
        if (this.isUrlIconsEnabled()) {
            this.getLogger().info("Skin-based spell icons enabled");
        } else {
            this.getLogger().info("Skin-based spell icons disabled");
        }
        int configUpdateInterval = properties.getInt("config_update_interval");
        if (configUpdateInterval > 0) {
            ConfigCheckTask configCheck = new ConfigCheckTask(this);
            this.configCheckTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, (Runnable)configCheck, (long)(configUpdateInterval * 20 / 1000), (long)(configUpdateInterval * 20 / 1000));
        }
        this.protectionManager.initialize((Plugin)this.plugin, properties.getStringList("generic_protection"));
    }

    protected void loadMobEggs(ConfigurationSection skins) {
        this.mobEggs.clear();
        Set keys = skins.getKeys(false);
        for (String key : keys) {
            try {
                EntityType entityType = EntityType.valueOf((String)key.toUpperCase());
                Material material = this.getVersionedMaterial(skins, key);
                if (material == null) continue;
                this.mobEggs.put(entityType, material);
            }
            catch (Exception exception) {}
        }
    }

    protected void loadMobSkins(ConfigurationSection skins) {
        this.mobSkins.clear();
        Set keys = skins.getKeys(false);
        for (String key : keys) {
            try {
                EntityType entityType = EntityType.valueOf((String)key.toUpperCase());
                this.mobSkins.put(entityType, skins.getString(key));
            }
            catch (Exception exception) {}
        }
    }

    protected void loadBlockSkins(ConfigurationSection skins) {
        this.blockSkins.clear();
        Set keys = skins.getKeys(false);
        for (String key : keys) {
            try {
                Material material = Material.getMaterial((String)key.toUpperCase());
                this.blockSkins.put(material, skins.getString(key));
            }
            catch (Exception exception) {}
        }
    }

    @Nullable
    protected Material getVersionedMaterial(ConfigurationSection configuration, String key) {
        Material material = null;
        List<String> candidates = ConfigurationUtils.getStringList(configuration, key);
        for (String candidate : candidates) {
            try {
                material = Material.valueOf((String)candidate.toUpperCase());
                break;
            }
            catch (Exception exception) {
            }
        }
        return material;
    }

    @Nullable
    protected MaterialAndData getVersionedMaterialAndData(ConfigurationSection configuration, String key) {
        List<String> candidates = ConfigurationUtils.getStringList(configuration, key);
        for (String candidate : candidates) {
            MaterialAndData test = new MaterialAndData(candidate);
            if (!test.isValid()) continue;
            return test;
        }
        return null;
    }

    protected void loadOtherMaterials(ConfigurationSection configuration) {
        DefaultMaterials defaultMaterials = DefaultMaterials.getInstance();
        defaultMaterials.setGroundSignBlock(this.getVersionedMaterial(configuration, "ground_sign_block"));
        defaultMaterials.setWallSignBlock(this.getVersionedMaterial(configuration, "wall_sign_block"));
        defaultMaterials.setFirework(this.getVersionedMaterial(configuration, "firework"));
        defaultMaterials.setWallTorch(this.getVersionedMaterialAndData(configuration, "wall_torch"));
        defaultMaterials.setRedstoneTorchOn(this.getVersionedMaterialAndData(configuration, "redstone_torch_on"));
        defaultMaterials.setRedstoneTorchOff(this.getVersionedMaterialAndData(configuration, "redstone_torch_off"));
        defaultMaterials.setRedstoneWallTorchOn(this.getVersionedMaterialAndData(configuration, "redstone_wall_torch_on"));
        defaultMaterials.setRedstoneWallTorchOff(this.getVersionedMaterialAndData(configuration, "redstone_wall_torch_off"));
        defaultMaterials.setMobSpawner(this.getVersionedMaterial(configuration, "mob_spawner"));
        defaultMaterials.setFilledMap(this.getVersionedMaterial(configuration, "filled_map"));
    }

    protected void loadSkulls(ConfigurationSection skulls) {
        this.skullItems.clear();
        this.skullGroundBlocks.clear();
        this.skullWallBlocks.clear();
        Set keys = skulls.getKeys(false);
        for (String key : keys) {
            try {
                ConfigurationSection types = skulls.getConfigurationSection(key);
                EntityType entityType = EntityType.valueOf((String)key.toUpperCase());
                MaterialAndData item = this.parseSkullCandidate(types, "item");
                if (item != null) {
                    this.skullItems.put(entityType, item);
                }
                MaterialAndData floor = this.parseSkullCandidate(types, "ground");
                if (item != null) {
                    this.skullGroundBlocks.put(entityType, floor);
                }
                MaterialAndData wall = this.parseSkullCandidate(types, "wall");
                if (item == null) continue;
                this.skullWallBlocks.put(entityType, wall);
            }
            catch (Exception exception) {}
        }
    }

    @Nullable
    protected MaterialAndData parseSkullCandidate(ConfigurationSection section, String key) {
        List<String> candidates = ConfigurationUtils.getStringList(section, key);
        for (String candidate : candidates) {
            MaterialAndData test = new MaterialAndData(candidate.trim());
            if (!test.isValid()) continue;
            return test;
        }
        return null;
    }

    protected void populateEntityTypes(Set<EntityType> entityTypes, ConfigurationSection configuration, String key) {
        entityTypes.clear();
        if (configuration.contains(key)) {
            List<String> typeStrings = ConfigurationUtils.getStringList(configuration, key);
            for (String typeString : typeStrings) {
                try {
                    entityTypes.add(EntityType.valueOf((String)typeString.toUpperCase()));
                }
                catch (Exception ex) {
                    this.getLogger().warning("Unknown entity type: " + typeString + " in " + key);
                }
            }
        }
    }

    protected void addCurrency(Currency currency) {
        this.currencies.put(currency.getKey(), currency);
    }

    protected void registerPreLoad() {
        this.currencies.clear();
        this.attributeProviders.clear();
        this.teamProviders.clear();
        this.requirementProcessors.clear();
        this.blockBreakManagers.clear();
        this.blockBuildManagers.clear();
        this.pvpManagers.clear();
        PreLoadEvent loadEvent = new PreLoadEvent(this);
        Bukkit.getPluginManager().callEvent((Event)loadEvent);
        this.blockBreakManagers.addAll(loadEvent.getBlockBreakManagers());
        this.blockBuildManagers.addAll(loadEvent.getBlockBuildManagers());
        this.pvpManagers.addAll(loadEvent.getPVPManagers());
        this.attributeProviders.addAll(loadEvent.getAttributeProviders());
        this.teamProviders.addAll(loadEvent.getTeamProviders());
        this.requirementProcessors.putAll(loadEvent.getRequirementProcessors());
        this.addCurrency(new ItemCurrency(this, this.getWorthItem(), this.getWorthItemAmount(), this.currencyItem.getName(), this.currencyItem.getPluralName()));
        this.addCurrency(new ManaCurrency(this));
        this.addCurrency(new ExperienceCurrency(this, this.getWorthXP()));
        this.addCurrency(new HealthCurrency(this));
        this.addCurrency(new HungerCurrency(this));
        this.addCurrency(new LevelCurrency(this));
        this.addCurrency(new ManaCurrency(this));
        this.addCurrency(new SpellPointCurrency(this, this.getWorthSkillPoints()));
        this.addCurrency(new VaultCurrency(this));
        for (Currency currency : loadEvent.getCurrencies()) {
            this.addCurrency(currency);
        }
        Set keys = this.currencyConfiguration.getKeys(false);
        for (String key : keys) {
            this.addCurrency(new CustomCurrency((MageController)this, key, this.currencyConfiguration.getConfigurationSection(key)));
        }
        this.attributeProviders.addAll(loadEvent.getAttributeProviders());
        if (this.skillAPIManager != null) {
            this.attributeProviders.add(this.skillAPIManager);
        }
        if (this.heroesManager != null) {
            this.attributeProviders.add(this.heroesManager);
        }
        this.teamProviders.addAll(loadEvent.getTeamProviders());
        if (this.heroesManager != null && this.useHeroesParties) {
            this.teamProviders.add(this.heroesManager);
        }
        if (this.useScoreboardTeams) {
            this.teamProviders.add(new ScoreboardTeamProvider());
        }
        if (this.factionsManager != null) {
            this.teamProviders.add(this.factionsManager);
        }
        this.requirementProcessors.putAll(loadEvent.getRequirementProcessors());
        if (this.skillAPIManager != null) {
            this.requirementProcessors.put("skillapi", this.skillAPIManager);
        }
        if (this.requirementProcessors.containsKey("magic")) {
            this.getLogger().warning("Something tried to register requirements for the magic type, but that is Magic's job.");
        }
        this.requirementProcessors.put("magic", this.requirementsController);
        this.registeredAttributes.clear();
        this.registeredAttributes.add("bowpull");
        this.registeredAttributes.addAll(this.attributes.keySet());
        for (AttributeProvider provider : this.attributeProviders) {
            Set<String> providerAttributes = provider.getAllAttributes();
            if (providerAttributes == null) continue;
            this.registeredAttributes.addAll(providerAttributes);
        }
        MageParameters.initializeAttributes(this.registeredAttributes);
        MageParameters.setLogger(this.getLogger());
        this.getLogger().info("Registered attributes: " + this.registeredAttributes);
        this.registeredAttributes.remove("bowpull");
    }

    protected void clear() {
        this.initialized = false;
        ArrayList<Mage> saveMages = new ArrayList<Mage>(this.mages.values());
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : saveMages) {
            this.playerQuit(mage);
        }
        this.mages.clear();
        this.mobMages.clear();
        this.vanished.clear();
        this.pendingConstruction.clear();
        this.spells.clear();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected void unregisterPhysicsHandler(Listener listener) {
        BlockPhysicsEvent.getHandlerList().unregister(listener);
        this.physicsHandler = null;
    }

    @Override
    public void scheduleUndo(com.elmakers.mine.bukkit.api.block.UndoList undoList) {
        undoList.setHasBeenScheduled();
        this.scheduledUndo.add(undoList);
    }

    @Override
    public void cancelScheduledUndo(com.elmakers.mine.bukkit.api.block.UndoList undoList) {
        this.scheduledUndo.remove(undoList);
    }

    public boolean hasWandPermission(Player player) {
        return this.hasPermission(player, "Magic.wand.use", true);
    }

    public boolean hasWandPermission(Player player, Wand wand) {
        String pNode;
        if (player.hasPermission("Magic.bypass")) {
            return true;
        }
        if (wand.isSuperPowered() && !player.hasPermission("Magic.wand.use.powered")) {
            return false;
        }
        if (wand.isSuperProtected() && !player.hasPermission("Magic.wand.use.protected")) {
            return false;
        }
        String template = wand.getTemplateKey();
        if (template != null && !template.isEmpty() && !this.hasPermission(player, pNode = "Magic.use." + template, true)) {
            return false;
        }
        Location location = player.getLocation();
        Boolean override = this.worldGuardManager.getWandPermission(player, wand, location);
        return override == null || override != false;
    }

    @Override
    public boolean hasCastPermission(CommandSender sender, SpellTemplate spell) {
        if (sender == null) {
            return true;
        }
        if (sender instanceof Player && ((Player)sender).hasPermission("Magic.bypass")) {
            return true;
        }
        return this.hasPermission(sender, spell.getPermissionNode());
    }

    @Override
    @Nullable
    public Boolean getRegionCastPermission(Player player, SpellTemplate spell, Location location) {
        if (player != null && player.hasPermission("Magic.bypass")) {
            return true;
        }
        return this.worldGuardManager.getCastPermission(player, spell, location);
    }

    @Override
    @Nullable
    public Boolean getPersonalCastPermission(Player player, SpellTemplate spell, Location location) {
        if (player != null && player.hasPermission("Magic.bypass")) {
            return true;
        }
        return this.preciousStonesManager.getCastPermission(player, spell, location);
    }

    @Override
    public boolean inTaggedRegion(Location location, Set<String> tags) {
        return this.worldGuardManager.inTaggedRegion(location, tags);
    }

    public boolean hasPermission(Player player, String pNode, boolean defaultValue) {
        boolean isSet;
        String parentNode;
        boolean isParentSet;
        if (player == null) {
            return true;
        }
        if (pNode.contains(".") && (isParentSet = player.isPermissionSet(parentNode = pNode.substring(0, pNode.lastIndexOf(46) + 1) + "*"))) {
            defaultValue = player.hasPermission(parentNode);
        }
        return (isSet = player.isPermissionSet(pNode)) ? player.hasPermission(pNode) : defaultValue;
    }

    public boolean hasPermission(Player player, String pNode) {
        return this.hasPermission(player, pNode, false);
    }

    @Override
    public boolean hasPermission(CommandSender sender, String pNode) {
        if (!(sender instanceof Player)) {
            return true;
        }
        return this.hasPermission((Player)sender, pNode, false);
    }

    @Override
    public boolean hasPermission(CommandSender sender, String pNode, boolean defaultValue) {
        if (!(sender instanceof Player)) {
            return true;
        }
        return this.hasPermission((Player)sender, pNode, defaultValue);
    }

    public void registerFallingBlock(Entity fallingBlock, Block block) {
        com.elmakers.mine.bukkit.api.block.UndoList undoList = this.getPendingUndo(fallingBlock.getLocation());
        if (undoList != null) {
            undoList.fall(fallingBlock, block);
        }
    }

    @Nullable
    public com.elmakers.mine.bukkit.api.block.UndoList getEntityUndo(Entity entity) {
        com.elmakers.mine.bukkit.api.block.UndoList undoList;
        Projectile projectile;
        ProjectileSource source;
        com.elmakers.mine.bukkit.api.block.UndoList blockList = null;
        if (entity == null) {
            return null;
        }
        blockList = UndoList.getUndoList(entity);
        if (blockList != null) {
            return blockList;
        }
        if (entity instanceof Projectile && (source = (projectile = (Projectile)entity).getShooter()) instanceof Entity && (blockList = UndoList.getUndoList(entity = (Entity)source)) != null) {
            return blockList;
        }
        Mage mage = this.getRegisteredMage(entity);
        if (mage != null && (undoList = mage.getLastUndoList()) != null) {
            long now = System.currentTimeMillis();
            if (undoList.getModifiedTime() > now - (long)this.undoTimeWindow) {
                blockList = undoList;
            }
        }
        return blockList;
    }

    public boolean isBindOnGive() {
        return this.bindOnGive;
    }

    @Override
    public void giveItemToPlayer(Player player, ItemStack itemStack) {
        Mage mage = this.getMage(player);
        mage.giveItem(itemStack);
    }

    @Override
    public boolean commitOnQuit() {
        return this.commitOnQuit;
    }

    public void onShutdown() {
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mobMages.values()) {
            Entity entity = mage.getEntity();
            if (entity == null) continue;
            entity.remove();
        }
        this.mobMages.clear();
    }

    public void undoScheduled() {
        int undid = 0;
        while (!this.scheduledUndo.isEmpty()) {
            com.elmakers.mine.bukkit.api.block.UndoList undoList = this.scheduledUndo.poll();
            undoList.undoScheduled(true);
        }
        if (undid > 0) {
            this.info("Undid " + undid + " pending spells");
        }
    }

    protected void mageQuit(com.elmakers.mine.bukkit.api.magic.Mage mage, final MageDataCallback callback) {
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        final boolean isOpen = wand != null && wand.isInventoryOpen();
        mage.deactivate();
        mage.undoScheduled();
        mage.deactivateClasses();
        if (this.initialized && mage instanceof Mage) {
            final Mage quitMage = (Mage)mage;
            quitMage.setUnloading(true);
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    if (quitMage.isUnloading()) {
                        MagicController.this.finalizeMageQuit(quitMage, callback, isOpen);
                    }
                }
            }, 1L);
        } else {
            this.finalizeMageQuit(mage, callback, isOpen);
        }
    }

    protected void finalizeMageQuit(com.elmakers.mine.bukkit.api.magic.Mage mage, MageDataCallback callback, boolean isOpen) {
        if (!this.externalPlayerData || !mage.isPlayer()) {
            this.removeMage(mage);
        }
        if (!mage.isLoading() && (mage.isPlayer() || this.saveNonPlayerMages) && this.loaded) {
            this.saveMage(mage, this.initialized, callback, isOpen, true);
        } else if (callback != null) {
            callback.run(null);
        }
    }

    protected void playerQuit(com.elmakers.mine.bukkit.api.magic.Mage mage, MageDataCallback callback) {
        this.maps.resend(mage.getName());
        this.mageQuit(mage, callback);
    }

    public void playerQuit(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        this.playerQuit(mage, null);
    }

    @Override
    public void forgetMage(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        if (mage instanceof Mage) {
            ((Mage)mage).setForget(true);
        }
    }

    @Override
    public void removeMage(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        this.removeMage(mage.getId());
    }

    @Override
    public void removeMage(String id) {
        this.mages.remove(id);
        this.mageRemoved(id);
    }

    public void mageRemoved(String id) {
        this.mobMages.remove(id);
        this.vanished.remove(id);
    }

    public void saveMage(com.elmakers.mine.bukkit.api.magic.Mage mage, boolean asynchronous) {
        this.saveMage(mage, asynchronous, null);
    }

    public void saveMage(com.elmakers.mine.bukkit.api.magic.Mage mage, boolean asynchronous, MageDataCallback callback) {
        this.saveMage(mage, asynchronous, null, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveMage(com.elmakers.mine.bukkit.api.magic.Mage mage, boolean asynchronous, final MageDataCallback callback, boolean wandInventoryOpen, final boolean releaseLock) {
        if (!this.savePlayerData) {
            if (callback == null) return;
            callback.run(null);
            return;
        }
        asynchronous = asynchronous && this.asynchronousSaving;
        this.info("Saving player data for " + mage.getName() + " (" + mage.getId() + ") " + (asynchronous ? "" : " synchronously ") + "at " + System.currentTimeMillis());
        final MageData mageData = new MageData(mage.getId());
        if (this.mageDataStore != null && mage.save(mageData)) {
            if (wandInventoryOpen) {
                mageData.setOpenWand(true);
            }
            if (asynchronous) {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = MagicController.this.saveLock;
                        synchronized (object) {
                            try {
                                MagicController.this.mageDataStore.save(mageData, callback, releaseLock);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                });
                return;
            }
            Object object = this.saveLock;
            synchronized (object) {
                try {
                    this.mageDataStore.save(mageData, callback, releaseLock);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return;
            }
        }
        if (!releaseLock || this.mageDataStore == null) return;
        this.getLogger().warning("Player logging out, but data never loaded. Force-releasing lock");
        this.mageDataStore.releaseLock(mageData);
    }

    @Nullable
    public ItemStack removeItemFromWand(Wand wand, ItemStack droppedItem) {
        if (wand == null || droppedItem == null || Wand.isWand(droppedItem)) {
            return null;
        }
        if (Wand.isSpell(droppedItem)) {
            String spellKey = Wand.getSpell(droppedItem);
            wand.removeSpell(spellKey);
            SpellTemplate spell = this.getSpellTemplate(spellKey);
            if (spell != null) {
                Wand.updateSpellItem(this.messages, droppedItem, spell, "", null, null, true);
            }
        } else if (Wand.isBrush(droppedItem)) {
            String brushKey = Wand.getBrush(droppedItem);
            wand.removeBrush(brushKey);
            Wand.updateBrushItem(this.getMessages(), droppedItem, brushKey, null);
        }
        return droppedItem;
    }

    public void onArmorUpdated(final Mage mage) {
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                mage.armorUpdated();
            }
        }, 1L);
    }

    @Override
    public boolean isLocked(Block block) {
        return this.protectLocked && this.containerMaterials.testBlock(block) && CompatibilityUtils.isLocked(block);
    }

    protected boolean addLostWandMarker(LostWand lostWand) {
        Location location = lostWand.getLocation();
        return this.addMarker("wand-" + lostWand.getId(), "Wands", lostWand.getName(), location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ(), lostWand.getDescription());
    }

    public void toggleCastCommandOverrides(com.elmakers.mine.bukkit.api.magic.Mage apiMage, CommandSender sender, boolean override) {
        if (apiMage instanceof Mage) {
            Mage mage = (Mage)apiMage;
            if (sender instanceof BlockCommandSender) {
                mage.setCostFree(override ? this.castCommandCostFree : false);
                mage.setCooldownFree(override ? this.castCommandCooldownFree : false);
                mage.setPowerMultiplier(override ? this.castCommandPowerMultiplier : 1.0f);
            } else {
                mage.setCostFree(override ? this.castConsoleCostFree : false);
                mage.setCooldownFree(override ? this.castConsoleCooldownFree : false);
                mage.setPowerMultiplier(override ? this.castConsolePowerMultiplier : 1.0f);
            }
        }
    }

    public float getCooldownReduction() {
        return this.cooldownReduction;
    }

    public float getCostReduction() {
        return this.costReduction;
    }

    public Material getDefaultMaterial() {
        return this.defaultMaterial;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.wand.LostWand> getLostWands() {
        return new ArrayList<com.elmakers.mine.bukkit.api.wand.LostWand>(this.lostWands.values());
    }

    public Collection<com.elmakers.mine.bukkit.api.magic.Mage> getAutomata() {
        ArrayList<com.elmakers.mine.bukkit.api.magic.Mage> all = new ArrayList<com.elmakers.mine.bukkit.api.magic.Mage>();
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            if (!mage.isAutomaton()) continue;
            all.add(mage);
        }
        return all;
    }

    public boolean cast(com.elmakers.mine.bukkit.api.magic.Mage mage, String spellName, ConfigurationSection parameters, CommandSender sender, Entity entity) {
        SpellTemplate template;
        Location mageLocation;
        Player usePermissions;
        Player player = sender == entity && entity instanceof Player ? (Player)entity : (usePermissions = sender instanceof Player ? (Player)sender : null);
        if (entity == null && sender instanceof Player) {
            entity = (Player)sender;
        }
        Location targetLocation = null;
        if (mage == null) {
            CommandSender mageController;
            Object object = mageController = entity != null && entity instanceof Player ? (Player)entity : sender;
            if (sender != null && sender instanceof BlockCommandSender) {
                targetLocation = ((BlockCommandSender)sender).getBlock().getLocation();
            }
            mage = entity == null ? this.getMage(mageController) : this.getMageFromEntity(entity, mageController);
        }
        if (targetLocation != null && (mageLocation = mage.getLocation()) != null) {
            targetLocation.setPitch(mageLocation.getPitch());
            targetLocation.setYaw(mageLocation.getYaw());
        }
        if ((template = this.getSpellTemplate(spellName)) == null || !template.hasCastPermission((CommandSender)usePermissions)) {
            if (sender != null) {
                sender.sendMessage("Spell " + spellName + " unknown");
            }
            return false;
        }
        MageSpell spell = mage.getSpell(spellName);
        if (spell == null) {
            if (sender != null) {
                sender.sendMessage("Spell " + spellName + " unknown");
            }
            return false;
        }
        this.toggleCastCommandOverrides(mage, sender, true);
        boolean success = false;
        try {
            success = spell.cast(parameters, targetLocation);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.toggleCastCommandOverrides(mage, sender, false);
        return success;
    }

    public void onCast(com.elmakers.mine.bukkit.api.magic.Mage mage, Spell spell, SpellResult result) {
        if (this.dynmapShowSpells && this.dynmap != null && result.isSuccess()) {
            if (this.dynmapOnlyPlayerSpells && (mage == null || !mage.isPlayer())) {
                return;
            }
            this.dynmap.showCastMarker(mage, spell, result);
        }
        if (result.isSuccess() && this.getShowCastHoloText()) {
            mage.showHoloText(mage.getEyeLocation(), spell.getName(), 10000);
        }
    }

    @Override
    public com.elmakers.mine.bukkit.api.magic.Messages getMessages() {
        return this.messages;
    }

    @Override
    public MapController getMaps() {
        return this.maps;
    }

    public String getWelcomeWand() {
        return this.welcomeWand;
    }

    @Override
    public void sendToMages(String message, Location location) {
        this.sendToMages(message, location, this.toggleMessageRange);
    }

    public void sendToMages(String message, Location location, int range) {
        int rangeSquared = range * range;
        if (message != null && message.length() > 0) {
            for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
                if (!mage.isPlayer() || mage.isDead() || !mage.isOnline() || !mage.hasLocation() || !mage.getLocation().getWorld().equals(location.getWorld()) || !(mage.getLocation().toVector().distanceSquared(location.toVector()) < (double)rangeSquared)) continue;
                mage.sendMessage(message);
            }
        }
    }

    @Override
    public boolean isNPC(Entity entity) {
        return this.npcSuppliers.isNPC(entity);
    }

    @Override
    public boolean isStaticNPC(Entity entity) {
        return this.npcSuppliers.isStaticNPC(entity);
    }

    @Override
    public boolean isVanished(Entity entity) {
        if (entity == null) {
            return false;
        }
        Iterator iterator = entity.getMetadata("vanished").iterator();
        if (iterator.hasNext()) {
            MetadataValue meta = (MetadataValue)iterator.next();
            return meta.asBoolean();
        }
        return false;
    }

    @Override
    public void updateBlock(Block block) {
        this.updateBlock(block.getWorld().getName(), block.getX(), block.getY(), block.getZ());
    }

    @Override
    public void updateBlock(String worldName, int x, int y, int z) {
        if (this.dynmap != null && this.dynmapUpdate) {
            this.dynmap.triggerRenderOfBlock(worldName, x, y, z);
        }
    }

    @Override
    public void updateVolume(String worldName, int minx, int miny, int minz, int maxx, int maxy, int maxz) {
        if (this.dynmap != null && this.dynmapUpdate && worldName != null && worldName.length() > 0) {
            this.dynmap.triggerRenderOfVolume(worldName, minx, miny, minz, maxx, maxy, maxz);
        }
    }

    public void update(String worldName, BoundingBox area) {
        if (this.dynmap != null && this.dynmapUpdate && area != null && worldName != null && worldName.length() > 0) {
            this.dynmap.triggerRenderOfVolume(worldName, area.getMin().getBlockX(), area.getMin().getBlockY(), area.getMin().getBlockZ(), area.getMax().getBlockX(), area.getMax().getBlockY(), area.getMax().getBlockZ());
        }
    }

    @Override
    public void update(BlockList blockList) {
        if (blockList != null) {
            this.update(blockList.getWorldName(), blockList.getArea());
        }
    }

    @Override
    public void cleanItem(ItemStack item) {
        InventoryUtils.removeMeta(item, Wand.WAND_KEY);
        InventoryUtils.removeMeta(item, Wand.UPGRADE_KEY);
        InventoryUtils.removeMeta(item, "spell");
        InventoryUtils.removeMeta(item, "skill");
        InventoryUtils.removeMeta(item, "brush");
        InventoryUtils.removeMeta(item, "sp");
    }

    @Override
    public boolean canCreateWorlds() {
        return this.createWorldsEnabled;
    }

    @Override
    public int getMaxUndoPersistSize() {
        return this.undoMaxPersistSize;
    }

    public MagicPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public MagicAPI getAPI() {
        return this.plugin;
    }

    public Collection<? extends com.elmakers.mine.bukkit.api.magic.Mage> getMutableMages() {
        return this.mages.values();
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.magic.Mage> getMages() {
        Collection<Mage> values = this.mages.values();
        return Collections.unmodifiableCollection(values);
    }

    @Override
    @Deprecated
    public Set<Material> getBuildingMaterials() {
        return MaterialSets.toLegacyNN(this.buildingMaterials);
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.magic.Mage> getMobMages() {
        Collection<Mage> values = this.mobMages.values();
        return Collections.unmodifiableCollection(values);
    }

    @Override
    @Deprecated
    public Set<Material> getRestrictedMaterials() {
        return MaterialSets.toLegacyNN(this.restrictedMaterials);
    }

    @Override
    public MaterialSet getBuildingMaterialSet() {
        return this.buildingMaterials;
    }

    @Override
    public MaterialSet getDestructibleMaterialSet() {
        return this.destructibleMaterials;
    }

    @Override
    public MaterialSet getRestrictedMaterialSet() {
        return this.restrictedMaterials;
    }

    @Override
    public int getMessageThrottle() {
        return this.messageThrottle;
    }

    @Override
    public boolean isMage(Entity entity) {
        if (entity == null) {
            return false;
        }
        String id = this.mageIdentifier.fromEntity(entity);
        return this.mages.containsKey(id);
    }

    @Override
    public MaterialSetManager getMaterialSetManager() {
        return this.materialSetManager;
    }

    @Override
    @Deprecated
    public Collection<String> getMaterialSets() {
        return this.getMaterialSetManager().getMaterialSets();
    }

    @Override
    @Nullable
    @Deprecated
    public Set<Material> getMaterialSet(String string) {
        return MaterialSets.toLegacy(this.getMaterialSetManager().fromConfig(string));
    }

    @Override
    public Collection<String> getPlayerNames() {
        ArrayList<String> playerNames = new ArrayList<String>();
        Collection players = this.plugin.getServer().getOnlinePlayers();
        for (Player player : players) {
            if (this.isNPC((Entity)player)) continue;
            playerNames.add(player.getName());
        }
        return playerNames;
    }

    @Override
    public void disablePhysics(int interval) {
        if (this.physicsHandler == null && interval > 0) {
            this.physicsHandler = new PhysicsHandler(this);
            Bukkit.getPluginManager().registerEvents((Listener)this.physicsHandler, (Plugin)this.plugin);
        }
        if (this.physicsHandler != null) {
            this.physicsHandler.setInterval(interval);
        }
    }

    @Override
    public boolean commitAll() {
        boolean undid = false;
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            undid = mage.commit() || undid;
        }
        UndoList.commitAll();
        return undid;
    }

    @Override
    public boolean canTarget(Entity attacker, Entity entity) {
        if (attacker == entity) {
            return true;
        }
        if (this.isFriendly(attacker, entity, false)) {
            return false;
        }
        return this.preciousStonesManager.canTarget(attacker, entity) && this.townyManager.canTarget(attacker, entity);
    }

    @Override
    public boolean isFriendly(Entity attacker, Entity entity) {
        return this.isFriendly(attacker, entity, true);
    }

    public boolean isFriendly(Entity attacker, Entity entity, boolean friendlyByDefault) {
        if (attacker == entity) {
            return true;
        }
        for (TeamProvider provider : this.teamProviders) {
            if (!provider.isFriendly(attacker, entity)) continue;
            return true;
        }
        if (friendlyByDefault) {
            if (!(attacker instanceof Player)) {
                return true;
            }
            if (entity instanceof Player) {
                return this.defaultFriendly;
            }
            if (this.friendlyEntityTypes.contains(entity.getType())) {
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public Location getWarp(String warpName) {
        Location location = null;
        if (this.warpController != null) {
            try {
                location = this.warpController.getWarp(warpName);
            }
            catch (Exception ex) {
                location = null;
            }
        }
        return location;
    }

    public WarpController getWarps() {
        return this.warpController;
    }

    @Override
    @Nullable
    public Location getTownLocation(Player player) {
        return this.townyManager.getTownLocation(player);
    }

    @Override
    @Nullable
    public Map<String, Location> getHomeLocations(Player player) {
        return this.preciousStonesManager.getFieldLocations(player);
    }

    public TownyManager getTowny() {
        return this.townyManager;
    }

    public PreciousStonesManager getPreciousStones() {
        return this.preciousStonesManager;
    }

    @Override
    public boolean sendMail(CommandSender sender, String fromPlayer, String toPlayer, String message) {
        if (this.mailer != null) {
            return this.mailer.sendMail(sender, fromPlayer, toPlayer, message);
        }
        return false;
    }

    @Override
    @Nullable
    public com.elmakers.mine.bukkit.api.block.UndoList undoAny(Block target) {
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            com.elmakers.mine.bukkit.api.block.UndoList undid = mage.undo(target);
            if (undid == null) continue;
            return undid;
        }
        return null;
    }

    @Override
    @Nullable
    public com.elmakers.mine.bukkit.api.block.UndoList undoRecent(Block target, int timeout) {
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            UndoQueue queue = mage.getUndoQueue();
            com.elmakers.mine.bukkit.api.block.UndoList undid = queue.undoRecent(target, timeout);
            if (undid == null) continue;
            return undid;
        }
        return null;
    }

    public CitizensController getCitizens() {
        return this.citizens;
    }

    @Override
    public Wand getWand(ItemStack itemStack) {
        Wand wand = new Wand(this, itemStack);
        return wand;
    }

    @Override
    public Wand getWand(ConfigurationSection config) {
        return new Wand(this, config);
    }

    @Override
    @Nullable
    public Wand createWand(String wandKey) {
        return Wand.createWand(this, wandKey);
    }

    @Override
    @Nonnull
    public Wand createWand(@Nonnull ItemStack itemStack) {
        return Wand.createWand(this, itemStack);
    }

    @Override
    @Nullable
    public com.elmakers.mine.bukkit.wand.WandTemplate getWandTemplate(String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        return this.wandTemplates.get(key);
    }

    @Override
    public Collection<WandTemplate> getWandTemplates() {
        return new ArrayList<WandTemplate>(this.wandTemplates.values());
    }

    @Nullable
    protected ConfigurationSection resolveConfiguration(String key, ConfigurationSection properties, Map<String, ConfigurationSection> configurations) {
        this.resolvingKeys.clear();
        return this.resolveConfiguration(key, properties, configurations, this.resolvingKeys);
    }

    @Nullable
    protected ConfigurationSection resolveConfiguration(String key, ConfigurationSection properties, Map<String, ConfigurationSection> configurations, Set<String> resolving) {
        if (resolving.contains(key)) {
            this.getLogger().log(Level.WARNING, "Circular dependency detected: " + StringUtils.join(resolving, (String)" -> ") + " -> " + key);
            return properties;
        }
        resolving.add(key);
        ConfigurationSection configuration = configurations.get(key);
        if (configuration == null) {
            ConfigurationSection baseConfiguration;
            configuration = properties.getConfigurationSection(key);
            if (configuration == null) {
                return null;
            }
            String inherits = configuration.getString("inherit");
            if (inherits != null && (baseConfiguration = this.resolveConfiguration(inherits, properties, configurations, resolving)) != null) {
                ConfigurationSection newConfiguration = ConfigurationUtils.cloneConfiguration(baseConfiguration);
                ConfigurationUtils.addConfigurations(newConfiguration, configuration);
                newConfiguration.set("hidden", configuration.get("hidden"));
                configuration = newConfiguration;
            }
            configurations.put(key, configuration);
        }
        return configuration;
    }

    public void loadMageClasses(ConfigurationSection properties) {
        this.mageClasses.clear();
        Set classKeys = properties.getKeys(false);
        HashMap<String, ConfigurationSection> templateConfigurations = new HashMap<String, ConfigurationSection>();
        for (String string : classKeys) {
            this.loadMageClassTemplate(string, this.resolveConfiguration(string, properties, templateConfigurations));
        }
        for (String string : classKeys) {
            String parentKey;
            MageClassTemplate template = this.mageClasses.get(string);
            if (template == null || (parentKey = properties.getConfigurationSection(string).getString("parent")) == null) continue;
            MageClassTemplate parent = this.mageClasses.get(parentKey);
            if (parent == null) {
                this.getLogger().warning("Class '" + string + "' has unknown parent: " + parentKey);
                continue;
            }
            template.setParent(parent);
        }
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            if (!(mage instanceof Mage)) continue;
            ((Mage)mage).reloadClasses();
        }
    }

    @Override
    public Set<String> getMageClassKeys() {
        return this.mageClasses.keySet();
    }

    public MageClassTemplate getMageClass(String key) {
        return this.mageClasses.get(key);
    }

    public void loadMageClassTemplate(String key, ConfigurationSection classNode) {
        if (classNode.getBoolean("enabled", true)) {
            this.mageClasses.put(key, new MageClassTemplate(this, key, classNode));
        }
    }

    public void loadWandTemplates(ConfigurationSection properties) {
        this.wandTemplates.clear();
        Set wandKeys = properties.getKeys(false);
        HashMap<String, ConfigurationSection> templateConfigurations = new HashMap<String, ConfigurationSection>();
        for (String key : wandKeys) {
            this.loadWandTemplate(key, this.resolveConfiguration(key, properties, templateConfigurations));
        }
    }

    public void loadMobs(ConfigurationSection properties) {
        this.mobs.clear();
        Set mobKeys = properties.getKeys(false);
        HashMap<String, ConfigurationSection> templateConfigurations = new HashMap<String, ConfigurationSection>();
        for (String key : mobKeys) {
            this.mobs.load(key, this.resolveConfiguration(key, properties, templateConfigurations));
        }
    }

    @Override
    public MageClassTemplate getMageClassTemplate(String key) {
        return this.mageClasses.get(key);
    }

    @Override
    public void loadWandTemplate(String key, ConfigurationSection wandNode) {
        if (wandNode.getBoolean("enabled", true)) {
            this.wandTemplates.put(key, new com.elmakers.mine.bukkit.wand.WandTemplate(this, key, wandNode));
        }
    }

    @Override
    public void unloadWandTemplate(String key) {
        this.wandTemplates.remove(key);
    }

    public Collection<String> getWandTemplateKeys() {
        return this.wandTemplates.keySet();
    }

    @Nullable
    public ConfigurationSection getWandTemplateConfiguration(String key) {
        com.elmakers.mine.bukkit.wand.WandTemplate template = this.getWandTemplate(key);
        return template == null ? null : template.getConfiguration();
    }

    @Override
    public boolean elementalsEnabled() {
        return this.elementals != null;
    }

    @Override
    public boolean createElemental(Location location, String templateName, CommandSender creator) {
        return this.elementals.createElemental(location, templateName, creator);
    }

    @Override
    public boolean isElemental(Entity entity) {
        if (this.elementals == null || entity.getType() != EntityType.FALLING_BLOCK) {
            return false;
        }
        return this.elementals.isElemental(entity);
    }

    @Override
    public boolean damageElemental(Entity entity, double damage, int fireTicks, CommandSender attacker) {
        if (this.elementals == null) {
            return false;
        }
        return this.elementals.damageElemental(entity, damage, fireTicks, attacker);
    }

    @Override
    public boolean setElementalScale(Entity entity, double scale) {
        if (this.elementals == null) {
            return false;
        }
        return this.elementals.setElementalScale(entity, scale);
    }

    @Override
    public double getElementalScale(Entity entity) {
        if (this.elementals == null) {
            return 0.0;
        }
        return this.elementals.getElementalScale(entity);
    }

    @Override
    @Nullable
    public com.elmakers.mine.bukkit.api.spell.SpellCategory getCategory(String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        SpellCategory category = this.categories.get(key);
        if (category == null) {
            category = new SpellCategory(key, this);
            this.categories.put(key, category);
        }
        return category;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.spell.SpellCategory> getCategories() {
        ArrayList<com.elmakers.mine.bukkit.api.spell.SpellCategory> allCategories = new ArrayList<com.elmakers.mine.bukkit.api.spell.SpellCategory>();
        allCategories.addAll(this.categories.values());
        return allCategories;
    }

    @Override
    public Collection<SpellTemplate> getSpellTemplates() {
        return this.getSpellTemplates(false);
    }

    @Override
    public Collection<SpellTemplate> getSpellTemplates(boolean showHidden) {
        ArrayList<SpellTemplate> allSpells = new ArrayList<SpellTemplate>();
        for (SpellTemplate spell : this.spells.values()) {
            if (!showHidden && spell.isHidden()) continue;
            allSpells.add(spell);
        }
        return allSpells;
    }

    @Override
    @Nullable
    public SpellTemplate getSpellTemplate(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        SpellTemplate spell = this.spellAliases.get(name);
        if (spell == null) {
            spell = this.spells.get(name);
        }
        if (spell == null && name.startsWith("heroes*")) {
            if (this.heroesManager == null) {
                return null;
            }
            spell = this.heroesManager.createSkillSpell(this, name.substring(7));
            if (spell != null) {
                this.spells.put(name, spell);
            }
        }
        return spell;
    }

    @Override
    public String getEntityDisplayName(Entity target) {
        return this.getEntityName(target, true);
    }

    @Override
    public String getEntityName(Entity target) {
        return this.getEntityName(target, false);
    }

    protected String getEntityName(Entity target, boolean display) {
        if (target == null) {
            return "Unknown";
        }
        if (target instanceof Player) {
            return display ? ((Player)target).getDisplayName() : ((Player)target).getName();
        }
        if (this.isElemental(target)) {
            return "Elemental";
        }
        if (display) {
            if (target instanceof LivingEntity) {
                LivingEntity li = (LivingEntity)target;
                String customName = li.getCustomName();
                if (customName != null && customName.length() > 0) {
                    return customName;
                }
            } else if (target instanceof Item) {
                ItemMeta meta;
                Item item = (Item)target;
                ItemStack itemStack = item.getItemStack();
                if (itemStack.hasItemMeta() && (meta = itemStack.getItemMeta()).hasDisplayName()) {
                    return meta.getDisplayName();
                }
                MaterialAndData material = new MaterialAndData(itemStack);
                return material.getName();
            }
        }
        return target.getType().name().toLowerCase().replace('_', ' ');
    }

    public boolean getShowCastHoloText() {
        return this.showCastHoloText;
    }

    public boolean getShowActivateHoloText() {
        return this.showActivateHoloText;
    }

    public int getCastHoloTextRange() {
        return this.castHoloTextRange;
    }

    public int getActiveHoloTextRange() {
        return this.activateHoloTextRange;
    }

    public ItemStack getSpellBook(com.elmakers.mine.bukkit.api.spell.SpellCategory category, int count) {
        HashMap<String, ArrayList<SpellTemplate>> categories = new HashMap<String, ArrayList<SpellTemplate>>();
        Collection<SpellTemplate> spellVariants = this.spells.values();
        String categoryKey = category == null ? null : category.getKey();
        for (SpellTemplate spell : spellVariants) {
            com.elmakers.mine.bukkit.api.spell.SpellCategory spellCategory;
            if (spell.isHidden() || spell.getSpellKey().isVariant() || (spellCategory = spell.getCategory()) == null) continue;
            String spellCategoryKey = spellCategory.getKey();
            if (categoryKey != null && !spellCategoryKey.equalsIgnoreCase(categoryKey)) continue;
            ArrayList<SpellTemplate> categorySpells = (ArrayList<SpellTemplate>)categories.get(spellCategoryKey);
            if (categorySpells == null) {
                categorySpells = new ArrayList<SpellTemplate>();
                categories.put(spellCategoryKey, categorySpells);
            }
            categorySpells.add(spell);
        }
        ArrayList categoryKeys = new ArrayList(categories.keySet());
        Collections.sort(categoryKeys);
        CostReducer reducer = null;
        ItemStack bookItem = new ItemStack(Material.WRITTEN_BOOK, count);
        BookMeta book = (BookMeta)bookItem.getItemMeta();
        book.setAuthor(this.messages.get("books.default.author"));
        String title = null;
        title = category != null ? this.messages.get("books.default.title").replace("$category", category.getName()) : this.messages.get("books.all.title");
        book.setTitle(title);
        ArrayList<String> pages = new ArrayList<String>();
        Set<String> paths = WandUpgradePath.getPathKeys();
        for (String key : categoryKeys) {
            category = this.getCategory(key);
            title = this.messages.get("books.default.title").replace("$category", category.getName());
            String description = "" + ChatColor.BOLD + ChatColor.BLUE + title + "\n\n";
            description = description + "" + ChatColor.RESET + ChatColor.DARK_BLUE + category.getDescription();
            pages.add(description);
            List categorySpells = (List)categories.get(key);
            Collections.sort(categorySpells);
            for (SpellTemplate spell : categorySpells) {
                String spellExtendedDescription;
                String usage;
                String string;
                WandUpgradePath checkPath;
                Collection<CastingCost> activeCosts;
                Collection<CastingCost> costs;
                String spellMageCooldownDescription;
                String spellCooldownDescription;
                ArrayList<String> lines = new ArrayList<String>();
                lines.add("" + ChatColor.GOLD + ChatColor.BOLD + spell.getName());
                lines.add("" + ChatColor.RESET);
                String spellDescription = spell.getDescription();
                if (spellDescription != null && spellDescription.length() > 0) {
                    lines.add("" + ChatColor.BLACK + spellDescription);
                    lines.add("");
                }
                if ((spellCooldownDescription = spell.getCooldownDescription()) != null && spellCooldownDescription.length() > 0) {
                    spellCooldownDescription = this.messages.get("cooldown.description").replace("$time", spellCooldownDescription);
                    lines.add("" + ChatColor.DARK_PURPLE + spellCooldownDescription);
                }
                if ((spellMageCooldownDescription = spell.getMageCooldownDescription()) != null && spellMageCooldownDescription.length() > 0) {
                    spellMageCooldownDescription = this.messages.get("cooldown.mage_description").replace("$time", spellMageCooldownDescription);
                    lines.add("" + ChatColor.RED + spellMageCooldownDescription);
                }
                if ((costs = spell.getCosts()) != null) {
                    for (CastingCost castingCost : costs) {
                        if (castingCost.isEmpty(reducer)) continue;
                        lines.add(ChatColor.DARK_PURPLE + this.messages.get("wand.costs_description").replace("$description", castingCost.getFullDescription(this.messages, reducer)));
                    }
                }
                if ((activeCosts = spell.getActiveCosts()) != null) {
                    for (CastingCost cost3 : activeCosts) {
                        if (cost3.isEmpty(reducer)) continue;
                        lines.add(ChatColor.DARK_PURPLE + this.messages.get("wand.active_costs_description").replace("$description", cost3.getFullDescription(this.messages, reducer)));
                    }
                }
                for (String pathKey : paths) {
                    checkPath = WandUpgradePath.getPath(pathKey);
                    if (checkPath.isHidden() || !checkPath.hasSpell(spell.getKey()) && !checkPath.hasExtraSpell(spell.getKey())) continue;
                    lines.add(ChatColor.DARK_BLUE + this.messages.get("spell.available_path").replace("$path", checkPath.getName()));
                    break;
                }
                for (String pathKey : paths) {
                    checkPath = WandUpgradePath.getPath(pathKey);
                    if (!checkPath.requiresSpell(spell.getKey())) continue;
                    lines.add(ChatColor.DARK_RED + this.messages.get("spell.required_path").replace("$path", checkPath.getName()));
                    break;
                }
                if ((string = spell.getDurationDescription(this.messages)) != null) {
                    lines.add(ChatColor.DARK_GREEN + string);
                } else if (spell.showUndoable()) {
                    if (spell.isUndoable()) {
                        String undoable = this.messages.get("spell.undoable", "");
                        if (undoable != null && !undoable.isEmpty()) {
                            lines.add(undoable);
                        }
                    } else {
                        String notUndoable = this.messages.get("spell.not_undoable", "");
                        if (notUndoable != null && !notUndoable.isEmpty()) {
                            lines.add(notUndoable);
                        }
                    }
                }
                if (spell.usesBrush()) {
                    lines.add(ChatColor.DARK_GRAY + this.messages.get("spell.brush"));
                }
                SpellKey baseKey = spell.getSpellKey();
                SpellKey upgradeKey = new SpellKey(baseKey.getBaseKey(), baseKey.getLevel() + 1);
                SpellTemplate upgradeSpell = this.getSpellTemplate(upgradeKey.getKey());
                int spellLevels = 0;
                while (upgradeSpell != null) {
                    ++spellLevels;
                    upgradeKey = new SpellKey(upgradeKey.getBaseKey(), upgradeKey.getLevel() + 1);
                    upgradeSpell = this.getSpellTemplate(upgradeKey.getKey());
                }
                if (spellLevels > 0) {
                    lines.add(ChatColor.DARK_AQUA + this.messages.get("spell.levels_available").replace("$levels", Integer.toString(++spellLevels)));
                }
                if ((usage = spell.getUsage()) != null && usage.length() > 0) {
                    lines.add("" + ChatColor.GRAY + ChatColor.ITALIC + usage + ChatColor.RESET);
                    lines.add("");
                }
                if ((spellExtendedDescription = spell.getExtendedDescription()) != null && spellExtendedDescription.length() > 0) {
                    lines.add("" + ChatColor.BLACK + spellExtendedDescription);
                    lines.add("");
                }
                pages.add(StringUtils.join(lines, (String)"\n"));
            }
        }
        book.setPages(pages);
        bookItem.setItemMeta((ItemMeta)book);
        return bookItem;
    }

    @Override
    public MaterialAndData getRedstoneReplacement() {
        return this.redstoneReplacement;
    }

    @Override
    public boolean isUrlIconsEnabled() {
        return this.urlIconsEnabled;
    }

    @Override
    public Set<EntityType> getUndoEntityTypes() {
        return this.undoEntityTypes;
    }

    @Override
    public String describeItem(ItemStack item) {
        return this.messages.describeItem(item);
    }

    public boolean checkForItem(Player player, ItemStack requireItem, boolean take) {
        boolean foundItem = false;
        ItemStack[] contents = player.getInventory().getContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemStack item = contents[i];
            if (!this.itemsAreEqual(item, requireItem)) continue;
            Wand wand = null;
            if (Wand.isWand(item) && Wand.isBound(item) && !(wand = this.getWand(item)).canUse(player)) continue;
            if (take) {
                player.getInventory().setItem(i, null);
                if (wand != null) {
                    wand.unbind();
                }
            }
            foundItem = true;
            break;
        }
        return foundItem;
    }

    @Override
    public boolean hasItem(Player player, ItemStack requireItem) {
        return this.checkForItem(player, requireItem, false);
    }

    @Override
    public boolean takeItem(Player player, ItemStack requireItem) {
        return this.checkForItem(player, requireItem, true);
    }

    @Override
    public boolean isWand(ItemStack item) {
        return Wand.isWand(item);
    }

    @Override
    public boolean isSkill(ItemStack item) {
        return Wand.isSkill(item);
    }

    @Override
    public boolean isMagic(ItemStack item) {
        return Wand.isSpecial(item);
    }

    @Override
    @Nullable
    public String getWandKey(ItemStack item) {
        if (Wand.isWand(item)) {
            return Wand.getWandTemplate(item);
        }
        return null;
    }

    @Override
    public String getItemKey(ItemStack item) {
        if (item == null) {
            return "";
        }
        if (Wand.isUpgrade(item)) {
            return "upgrade:" + Wand.getWandTemplate(item);
        }
        if (Wand.isWand(item)) {
            return "wand:" + Wand.getWandTemplate(item);
        }
        if (Wand.isSpell(item)) {
            return "spell:" + Wand.getSpell(item);
        }
        if (Wand.isBrush(item)) {
            return "brush:" + Wand.getBrush(item);
        }
        com.elmakers.mine.bukkit.api.item.ItemData mappedItem = this.getItem(item);
        if (mappedItem != null) {
            return mappedItem.getKey();
        }
        MaterialAndData material = new MaterialAndData(item);
        return material.getKey();
    }

    @Override
    @Nullable
    public ItemStack createItem(String magicItemKey) {
        return this.createItem(magicItemKey, false);
    }

    @Override
    @Nullable
    public ItemStack createItem(String magicItemKey, boolean brief) {
        return this.createItem(magicItemKey, null, brief, null);
    }

    @Override
    @Nullable
    public ItemStack createItem(String magicItemKey, com.elmakers.mine.bukkit.api.magic.Mage mage, boolean brief, ItemUpdatedCallback callback) {
        ItemStack itemStack;
        block42: {
            String[] pieces;
            itemStack = null;
            if (magicItemKey == null || magicItemKey.isEmpty()) {
                if (callback != null) {
                    callback.updated(null);
                }
                return null;
            }
            if (magicItemKey.contains("skill:")) {
                String spellKey = magicItemKey.substring(6);
                itemStack = Wand.createSpellItem(spellKey, this, mage, null, false);
                InventoryUtils.setMeta(itemStack, "skill", "true");
                if (callback != null) {
                    callback.updated(itemStack);
                }
                return itemStack;
            }
            int amount = 1;
            if (magicItemKey.contains("@")) {
                pieces = StringUtils.split((String)magicItemKey, (char)'@');
                magicItemKey = pieces[0];
                try {
                    amount = Integer.parseInt(pieces[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            magicItemKey = magicItemKey.replace("|", ":");
            try {
                String wandKey;
                if (magicItemKey.startsWith("book:")) {
                    String bookCategory = magicItemKey.substring(5);
                    com.elmakers.mine.bukkit.api.spell.SpellCategory category = null;
                    if (!bookCategory.isEmpty() && !bookCategory.equalsIgnoreCase("all") && (category = this.getCategory(bookCategory)) == null) {
                        if (callback != null) {
                            callback.updated(null);
                        }
                        return null;
                    }
                    itemStack = this.getSpellBook(category, amount);
                    break block42;
                }
                if (magicItemKey.startsWith("recipe:")) {
                    String recipeKey = magicItemKey.substring(7);
                    itemStack = CompatibilityUtils.getKnowledgeBook();
                    if (itemStack != null) {
                        if (recipeKey.equals("*")) {
                            List<String> keys = this.crafting.getRecipeKeys();
                            for (String key : keys) {
                                CompatibilityUtils.addRecipeToBook(itemStack, (Plugin)this.plugin, key);
                            }
                        } else {
                            CompatibilityUtils.addRecipeToBook(itemStack, (Plugin)this.plugin, recipeKey);
                        }
                    }
                    break block42;
                }
                if (this.skillPointItemsEnabled && magicItemKey.startsWith("sp:")) {
                    String spAmount = magicItemKey.substring(3);
                    itemStack = this.getURLSkull(this.skillPointIcon);
                    ItemMeta meta = itemStack.getItemMeta();
                    meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.get("sp.name")).replace("$amount", spAmount));
                    String spDescription = this.messages.get("sp.description");
                    if (spDescription.length() > 0) {
                        ArrayList<String> lore = new ArrayList<String>();
                        lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)spDescription));
                        meta.setLore(lore);
                    }
                    itemStack.setItemMeta(meta);
                    InventoryUtils.setMeta(itemStack, "sp", spAmount);
                    break block42;
                }
                if (magicItemKey.startsWith("spell:")) {
                    magicItemKey = magicItemKey.replace(":", "|");
                    String spellKey = magicItemKey.substring(6);
                    itemStack = this.createSpellItem(spellKey, brief);
                    break block42;
                }
                if (magicItemKey.startsWith("wand:")) {
                    wandKey = magicItemKey.substring(5);
                    Wand wand = this.createWand(wandKey);
                    if (wand != null) {
                        itemStack = wand.getItem();
                    }
                    break block42;
                }
                if (magicItemKey.startsWith("upgrade:")) {
                    wandKey = magicItemKey.substring(8);
                    Wand wand = this.createWand(wandKey);
                    if (wand != null) {
                        wand.makeUpgrade();
                        itemStack = wand.getItem();
                    }
                    break block42;
                }
                if (magicItemKey.startsWith("brush:")) {
                    String brushKey = magicItemKey.substring(6);
                    itemStack = this.createBrushItem(brushKey);
                    break block42;
                }
                if (magicItemKey.startsWith("item:")) {
                    String itemKey = magicItemKey.substring(5);
                    itemStack = this.createGenericItem(itemKey);
                    break block42;
                }
                pieces = StringUtils.split((String)magicItemKey, (char)':');
                Currency currency = this.currencies.get(pieces[0]);
                if (pieces.length > 1 && currency != null) {
                    int intAmount;
                    String costKey = pieces[0];
                    String costAmount = pieces[1];
                    com.elmakers.mine.bukkit.api.block.MaterialAndData itemType = currency.getIcon();
                    itemStack = itemType == null ? this.getURLSkull(this.skillPointIcon) : itemType.getItemStack(1);
                    ItemMeta meta = itemStack.getItemMeta();
                    String name = this.messages.get("currency." + costKey + ".name", costKey);
                    String itemName = this.messages.get("currency." + costKey + ".item_name", this.messages.get("currency.item_name"));
                    itemName = itemName.replace("$type", name);
                    itemName = itemName.replace("$amount", costAmount);
                    meta.setDisplayName(itemName);
                    try {
                        intAmount = Integer.parseInt(costAmount);
                    }
                    catch (Exception ex) {
                        this.getLogger().warning("Invalid amount in custom cost: " + magicItemKey);
                        if (callback != null) {
                            callback.updated(null);
                        }
                        return null;
                    }
                    String spDescription = this.messages.get("currency." + costKey + ".description", this.messages.get("currency.description"));
                    if (spDescription.length() > 0) {
                        ArrayList<String> lore = new ArrayList<String>();
                        lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)spDescription));
                        meta.setLore(lore);
                    }
                    itemStack.setItemMeta(meta);
                    itemStack = CompatibilityUtils.makeReal(itemStack);
                    InventoryUtils.makeUnbreakable(itemStack);
                    Object currencyNode = InventoryUtils.createNode(itemStack, "currency");
                    InventoryUtils.setMetaInt(currencyNode, "amount", intAmount);
                    InventoryUtils.setMeta(currencyNode, "type", costKey);
                }
                if (itemStack == null && this.items != null) {
                    ItemData itemData = this.items.get(magicItemKey);
                    if (itemData != null) {
                        itemStack = itemData.getItemStack(amount);
                        if (callback != null) {
                            callback.updated(itemStack);
                        }
                        return itemStack;
                    }
                    MaterialAndData item = new MaterialAndData(magicItemKey);
                    if (item.isValid()) {
                        return item.getItemStack(amount, callback);
                    }
                    Wand wand = this.createWand(magicItemKey);
                    if (wand != null) {
                        ItemStack wandItem = wand.getItem();
                        if (wandItem != null) {
                            wandItem.setAmount(amount);
                        }
                        if (callback != null) {
                            callback.updated(wandItem);
                        }
                        return wandItem;
                    }
                    String spellKey = magicItemKey.replace(":", "|");
                    itemStack = this.createSpellItem(spellKey, brief);
                    if (itemStack != null) {
                        itemStack.setAmount(amount);
                        if (callback != null) {
                            callback.updated(itemStack);
                        }
                        return itemStack;
                    }
                    itemStack = this.createBrushItem(magicItemKey);
                    if (itemStack != null) {
                        itemStack.setAmount(amount);
                    }
                }
            }
            catch (Exception ex) {
                this.getLogger().log(Level.WARNING, "Error creating item: " + magicItemKey, ex);
            }
        }
        if (callback != null) {
            callback.updated(itemStack);
        }
        return itemStack;
    }

    @Override
    @Nullable
    public ItemStack createGenericItem(String key) {
        ConfigurationSection template = this.getWandTemplateConfiguration(key);
        if (template == null || !template.contains("icon")) {
            return null;
        }
        MaterialAndData icon = ConfigurationUtils.toMaterialAndData(template.getString("icon"));
        ItemStack item = icon.getItemStack(1);
        ItemMeta meta = item.getItemMeta();
        if (template.contains("name")) {
            meta.setDisplayName(template.getString("name"));
        } else {
            String name = this.messages.get("wands." + key + ".name");
            if (name != null && !name.isEmpty()) {
                meta.setDisplayName(name);
            }
        }
        ArrayList<String> lore = new ArrayList<String>();
        if (template.contains("description")) {
            lore.add(template.getString("description"));
        } else {
            String description = this.messages.get("wands." + key + ".description");
            if (description != null && !description.isEmpty()) {
                lore.add(description);
            }
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.Wand createUpgrade(String wandKey) {
        Wand wand = Wand.createWand(this, wandKey);
        if (!wand.isUpgrade()) {
            wand.makeUpgrade();
        }
        return wand;
    }

    @Override
    @Nullable
    public ItemStack createSpellItem(String spellKey) {
        return Wand.createSpellItem(spellKey, this, null, true);
    }

    @Override
    @Nullable
    public ItemStack createSpellItem(String spellKey, boolean brief) {
        return Wand.createSpellItem(spellKey, this, null, !brief);
    }

    @Override
    @Nullable
    public ItemStack createBrushItem(String brushKey) {
        return Wand.createBrushItem(brushKey, this, null, true);
    }

    @Override
    public boolean itemsAreEqual(ItemStack first, ItemStack second) {
        if (first == null || second == null) {
            return false;
        }
        if (first.getType() != second.getType() || first.getDurability() != second.getDurability()) {
            return false;
        }
        boolean firstIsWand = Wand.isWandOrUpgrade(first);
        boolean secondIsWand = Wand.isWandOrUpgrade(second);
        if (firstIsWand || secondIsWand) {
            if (!firstIsWand || !secondIsWand) {
                return false;
            }
            Wand firstWand = this.getWand(InventoryUtils.getCopy(first));
            Wand secondWand = this.getWand(InventoryUtils.getCopy(second));
            String firstTemplate = firstWand.getTemplateKey();
            String secondTemplate = secondWand.getTemplateKey();
            if (firstTemplate == null || secondTemplate == null) {
                return false;
            }
            return firstTemplate.equalsIgnoreCase(secondTemplate);
        }
        String firstSpellKey = Wand.getSpell(first);
        String secondSpellKey = Wand.getSpell(second);
        if (firstSpellKey != null || secondSpellKey != null) {
            if (firstSpellKey == null || secondSpellKey == null) {
                return false;
            }
            return firstSpellKey.equalsIgnoreCase(secondSpellKey);
        }
        String firstBrushKey = Wand.getBrush(first);
        String secondBrushKey = Wand.getBrush(second);
        if (firstBrushKey != null || secondBrushKey != null) {
            if (firstBrushKey == null || secondBrushKey == null) {
                return false;
            }
            return firstBrushKey.equalsIgnoreCase(secondBrushKey);
        }
        String firstName = first.hasItemMeta() ? first.getItemMeta().getDisplayName() : null;
        String secondName = second.hasItemMeta() ? second.getItemMeta().getDisplayName() : null;
        return Objects.equals(firstName, secondName);
    }

    @Override
    public Set<String> getWandPathKeys() {
        return WandUpgradePath.getPathKeys();
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.WandUpgradePath getPath(String key) {
        return WandUpgradePath.getPath(key);
    }

    @Override
    @Nullable
    public ItemStack deserialize(ConfigurationSection root, String key) {
        ItemStack item;
        ConfigurationSection itemSection = root.getConfigurationSection(key);
        if (itemSection == null) {
            return null;
        }
        if (itemSection.getInt("amount", 0) == 0) {
            itemSection.set("amount", (Object)1);
        }
        if ((item = itemSection.getItemStack("item")) == null) {
            return null;
        }
        if (itemSection.contains("wand")) {
            item = InventoryUtils.makeReal(item);
            Wand.configToItem(itemSection, item);
        } else if (itemSection.contains("spell")) {
            item = InventoryUtils.makeReal(item);
            InventoryUtils.setMeta(item, "spell", itemSection.getString("spell"));
            if (itemSection.contains("skill")) {
                InventoryUtils.setMeta(item, "skill", "true");
            }
        } else if (itemSection.contains("brush")) {
            item = InventoryUtils.makeReal(item);
            InventoryUtils.setMeta(item, "brush", itemSection.getString("brush"));
        }
        return item;
    }

    @Override
    public void serialize(ConfigurationSection root, String key, ItemStack item) {
        ConfigurationSection itemSection = root.createSection(key);
        itemSection.set("item", (Object)item);
        if (Wand.isWandOrUpgrade(item)) {
            ConfigurationSection stateNode = itemSection.createSection("wand");
            Wand.itemToConfig(item, stateNode);
        } else if (Wand.isSpell(item)) {
            itemSection.set("spell", (Object)Wand.getSpell(item));
            if (Wand.isSkill(item)) {
                itemSection.set("skill", (Object)"true");
            }
        } else if (Wand.isBrush(item)) {
            itemSection.set("brush", (Object)Wand.getBrush(item));
        }
    }

    @Override
    public void disableItemSpawn() {
        this.entityController.setDisableItemSpawn(true);
    }

    @Override
    public void enableItemSpawn() {
        this.entityController.setDisableItemSpawn(false);
    }

    @Override
    public void setForceSpawn(boolean force) {
        this.entityController.setForceSpawn(force);
    }

    public HeroesManager getHeroes() {
        return this.heroesManager;
    }

    @Nullable
    public ManaController getManaController() {
        if (this.useHeroesMana && this.heroesManager != null) {
            return this.heroesManager;
        }
        if (this.useSkillAPIMana && this.skillAPIManager != null) {
            return this.skillAPIManager;
        }
        return null;
    }

    public String getDefaultSkillIcon() {
        return this.defaultSkillIcon;
    }

    public int getSkillInventoryRows() {
        return this.skillInventoryRows;
    }

    public boolean usePermissionSkills() {
        return this.skillsUsePermissions;
    }

    public boolean useHeroesSkills() {
        return this.skillsUseHeroes;
    }

    @Override
    public void addFlightExemption(Player player, int duration) {
        this.ncpManager.addFlightExemption(player, duration);
        CompatibilityUtils.addFlightExemption(player, duration * 20 / 1000);
    }

    @Override
    public void addFlightExemption(Player player) {
        this.ncpManager.addFlightExemption(player);
    }

    @Override
    public void removeFlightExemption(Player player) {
        this.ncpManager.removeFlightExemption(player);
    }

    public String getExtraSchematicFilePath() {
        return this.extraSchematicFilePath;
    }

    @Override
    public void warpPlayerToServer(Player player, String server, String warp) {
        Mage mage = this.getMage(player);
        mage.setDestinationWarp(warp);
        this.info("Cross-server warping " + player.getName() + " to warp " + warp, 1);
        this.sendPlayerToServer(player, server);
    }

    @Override
    public void sendPlayerToServer(final Player player, final String server) {
        MageDataCallback callback = new MageDataCallback(){

            @Override
            public void run(MageData data) {
                Bukkit.getScheduler().runTaskLater((Plugin)MagicController.this.plugin, (Runnable)new ChangeServerTask((Plugin)MagicController.this.plugin, player, server), 1L);
            }
        };
        this.info("Moving " + player.getName() + " to server " + server, 1);
        Mage mage = this.getRegisteredMage((Entity)player);
        if (mage != null) {
            this.playerQuit(mage, callback);
        } else {
            callback.run(null);
        }
    }

    @Override
    public boolean isDisguised(Entity entity) {
        return !this.libsDisguiseEnabled || this.libsDisguiseManager == null || entity == null ? false : this.libsDisguiseManager.isDisguised(entity);
    }

    @Override
    public boolean disguise(Entity entity, ConfigurationSection configuration) {
        if (!this.libsDisguiseEnabled || this.libsDisguiseManager == null || entity == null) {
            return false;
        }
        return this.libsDisguiseManager.disguise(entity, configuration);
    }

    @Override
    public boolean isPathUpgradingEnabled() {
        return this.autoPathUpgradesEnabled;
    }

    @Override
    public boolean isSpellUpgradingEnabled() {
        return this.autoSpellUpgradesEnabled;
    }

    @Override
    public boolean isSpellProgressionEnabled() {
        return this.spellProgressionEnabled;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean areLocksProtected() {
        return this.protectLocked;
    }

    public boolean isContainer(Block block) {
        return block != null && this.containerMaterials.testBlock(block);
    }

    public boolean isMeleeWeapon(ItemStack item) {
        return item != null && this.meleeMaterials.testItem(item);
    }

    public boolean isWearable(ItemStack item) {
        return item != null && this.wearableMaterials.testItem(item);
    }

    public boolean isInteractable(Block block) {
        return block != null && this.interactibleMaterials.testBlock(block);
    }

    public boolean isSpellDroppingEnabled() {
        return this.spellDroppingEnabled;
    }

    @Override
    public boolean isSPEnabled() {
        return this.spEnabled;
    }

    @Override
    public boolean isSPEarnEnabled() {
        return this.spEarnEnabled;
    }

    @Override
    public int getSPMaximum() {
        return this.spMaximum;
    }

    @Override
    public boolean isVaultCurrencyEnabled() {
        return VaultController.hasEconomy();
    }

    @Override
    public void deleteMage(final String id) {
        final Mage mage = this.getRegisteredMage(id);
        if (mage != null) {
            this.playerQuit(mage, new MageDataCallback(){

                @Override
                public void run(MageData data) {
                    MagicController.this.info("Deleted mage id " + id);
                    MagicController.this.mageDataStore.delete(id);
                    Player player = mage.getPlayer();
                    if (player != null && player.isOnline()) {
                        MagicController.this.getMage(player);
                    }
                }
            });
        }
    }

    public long getPhysicsTimeout() {
        if (this.physicsHandler != null) {
            return this.physicsHandler.getTimeout();
        }
        return 0L;
    }

    @Override
    @Nullable
    public String getSpell(ItemStack item) {
        return Wand.getSpell(item);
    }

    @Override
    @Nullable
    public String getSpellArgs(ItemStack item) {
        return Wand.getSpellArgs(item);
    }

    @Override
    public Set<String> getMobKeys() {
        return this.mobs.getKeys();
    }

    @Override
    @Nullable
    public Entity spawnMob(String key, Location location) {
        com.elmakers.mine.bukkit.entity.EntityData mobType = this.mobs.get(key);
        if (mobType != null) {
            return mobType.spawn(this, location);
        }
        EntityType entityType = com.elmakers.mine.bukkit.entity.EntityData.parseEntityType(key);
        if (entityType == null) {
            return null;
        }
        return location.getWorld().spawnEntity(location, entityType);
    }

    @Override
    @Nullable
    public EntityData getMob(String key) {
        return this.mobs == null ? null : this.mobs.get(key);
    }

    @Override
    @Nullable
    public EntityData getMobByName(String key) {
        return this.mobs.getByName(key);
    }

    @Override
    public EntityData loadMob(ConfigurationSection configuration) {
        return new com.elmakers.mine.bukkit.entity.EntityData(this, configuration);
    }

    @Override
    public Set<String> getItemKeys() {
        return this.items.getKeys();
    }

    @Override
    public com.elmakers.mine.bukkit.api.item.ItemData getItem(String key) {
        return this.items.get(key);
    }

    @Override
    public com.elmakers.mine.bukkit.api.item.ItemData getItem(ItemStack match) {
        return this.items.get(match);
    }

    @Override
    @Nullable
    public com.elmakers.mine.bukkit.api.item.ItemData getOrCreateItem(String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        return this.items.getOrCreate(key);
    }

    @Override
    @Nullable
    public com.elmakers.mine.bukkit.api.item.ItemData getOrCreateItemOrWand(String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        Wand wand = this.createWand(key);
        if (wand != null) {
            return new ItemData(wand.getItem());
        }
        return this.items.getOrCreate(key);
    }

    @Override
    public void unloadItemTemplate(String key) {
        this.items.remove(key);
    }

    @Override
    public void loadItemTemplate(String key, ConfigurationSection configuration) {
        this.items.loadItem(key, configuration);
    }

    @Override
    @Nullable
    public Double getWorth(ItemStack item) {
        SpellTemplate spell;
        String spellKey = Wand.getSpell(item);
        if (spellKey != null && (spell = this.getSpellTemplate(spellKey)) != null) {
            return spell.getWorth();
        }
        int amount = item.getAmount();
        item.setAmount(1);
        ItemData configuredItem = this.items.get(item);
        item.setAmount(amount);
        if (configuredItem == null) {
            return null;
        }
        return configuredItem.getWorth() * (double)amount;
    }

    public boolean isInventoryBackupEnabled() {
        return this.backupInventories;
    }

    @Override
    @Nullable
    public String getBlockSkin(Material blockType) {
        return this.blockSkins.get(blockType);
    }

    @Override
    @Nonnull
    public Random getRandom() {
        return random;
    }

    @Override
    public boolean sendResourcePackToAllPlayers(CommandSender sender) {
        if (this.resourcePack == null || this.resourcePackHash == null) {
            if (sender != null) {
                sender.sendMessage(ChatColor.RED + "No RP set or RP already set in server.properties, not sending.");
            }
            return false;
        }
        int sent = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.sendResourcePack(player);
            ++sent;
        }
        if (sender != null) {
            sender.sendMessage(ChatColor.AQUA + "Sent current RP to " + sent + " players");
        }
        return true;
    }

    @Override
    public boolean promptResourcePack(Player player) {
        if (this.resourcePack == null || this.resourcePackHash == null) {
            return false;
        }
        if (this.resourcePackPrompt) {
            String message = this.messages.get("resource_pack.prompt");
            if (message != null && !message.isEmpty()) {
                player.sendMessage(message);
            }
            return false;
        }
        return this.sendResourcePack(player);
    }

    @Override
    public boolean sendResourcePack(final Player player) {
        if (this.resourcePack == null || this.resourcePackHash == null) {
            return false;
        }
        String message = this.messages.get("resource_pack.sending");
        if (message != null && !message.isEmpty()) {
            player.sendMessage(message);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                CompatibilityUtils.setResourcePack(player, MagicController.this.resourcePack, MagicController.this.resourcePackHash);
            }
        }, this.resourcePackDelay * 20L / 1000L);
        return true;
    }

    @Override
    public void checkResourcePack(CommandSender sender) {
        this.checkResourcePack(sender, false, true);
    }

    public boolean checkResourcePack(CommandSender sender, boolean quiet) {
        return this.checkResourcePack(sender, quiet, false);
    }

    public boolean checkResourcePack(final CommandSender sender, final boolean quiet, final boolean force) {
        boolean initialLoad;
        final Server server = this.plugin.getServer();
        this.resourcePack = null;
        this.resourcePackHash = null;
        boolean bl = initialLoad = !this.checkedResourcePack;
        if (this.defaultResourcePack == null || this.defaultResourcePack.isEmpty()) {
            if (!quiet) {
                sender.sendMessage("Resource pack in config.yml has been disabled, Magic skipping RP check");
            }
            return false;
        }
        String serverResourcePack = CompatibilityUtils.getResourcePack(server);
        if (serverResourcePack != null) {
            serverResourcePack = serverResourcePack.trim();
        }
        if (serverResourcePack != null && !serverResourcePack.isEmpty()) {
            if (!quiet) {
                sender.sendMessage("Resource pack configured in server.properties, Magic not using RP from config.yml");
            }
            return false;
        }
        this.resourcePack = this.defaultResourcePack;
        this.checkedResourcePack = true;
        if (!quiet) {
            sender.sendMessage("Magic checking resource pack for updates: " + ChatColor.GRAY + this.resourcePack);
        }
        long modifiedTime = 0L;
        String currentSHA = null;
        final YamlConfiguration rpConfig = new YamlConfiguration();
        final File rpFile = new File(this.plugin.getDataFolder(), "data/resourcepack.yml");
        final String rpKey = this.resourcePack.replace(".", "_");
        if (rpFile.exists()) {
            try {
                rpConfig.load(rpFile);
                ConfigurationSection rpSection = rpConfig.getConfigurationSection(rpKey);
                if (rpSection != null) {
                    currentSHA = rpSection.getString("sha1");
                    modifiedTime = rpSection.getLong("modified");
                    if (currentSHA != null && currentSHA.length() < 40) {
                        this.resourcePackHash = BaseEncoding.base64().decode((CharSequence)currentSHA);
                    }
                }
            }
            catch (Exception rpSection) {
                // empty catch block
            }
        }
        final String finalResourcePack = this.resourcePack;
        final long modifiedTimestamp = modifiedTime;
        final String currentHash = currentSHA;
        server.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                ArrayList<String> responses;
                block32: {
                    responses = new ArrayList<String>();
                    String newResourcePackHash = currentHash;
                    try {
                        URL rpURL = new URL(finalResourcePack);
                        HttpURLConnection connection = (HttpURLConnection)rpURL.openConnection();
                        connection.setInstanceFollowRedirects(true);
                        connection.setRequestMethod("HEAD");
                        if (connection.getResponseCode() == 200) {
                            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
                            Date tryParseDate = new Date(1L);
                            boolean hasModifiedTime = false;
                            String lastModified = connection.getHeaderField("Last-Modified");
                            if (lastModified == null || lastModified.isEmpty()) {
                                responses.add(ChatColor.YELLOW + "Server did not return a Last-Modified field, cancelling checks until restart");
                                MagicController.this.cancelResourcePackChecks();
                            } else {
                                try {
                                    tryParseDate = format.parse(lastModified);
                                    hasModifiedTime = true;
                                }
                                catch (ParseException dateFormat) {
                                    MagicController.this.cancelResourcePackChecks();
                                    responses.add("Error parsing resource pack modified time, cancelling checks until restart: " + lastModified);
                                }
                            }
                            Date modifiedDate = tryParseDate;
                            if (modifiedDate.getTime() > modifiedTimestamp || MagicController.this.resourcePackHash == null || force && !hasModifiedTime) {
                                boolean isUnset;
                                boolean bl = isUnset = MagicController.this.resourcePackHash == null;
                                if (modifiedTimestamp <= 0L) {
                                    responses.add(ChatColor.YELLOW + "Checking resource pack for the first time");
                                } else if (isUnset) {
                                    responses.add(ChatColor.YELLOW + "Resource pack hash format changed, downloading for one-time update");
                                } else if (!hasModifiedTime && force) {
                                    responses.add(ChatColor.YELLOW + "Forcing resource pack check with missing modified time, redownloading");
                                } else {
                                    responses.add(ChatColor.YELLOW + "Resource pack modified, redownloading (" + modifiedDate.getTime() + " > " + modifiedTimestamp + ")");
                                }
                                MessageDigest digest = MessageDigest.getInstance("SHA1");
                                try (BufferedInputStream in = new BufferedInputStream(rpURL.openStream());){
                                    int count;
                                    byte[] data = new byte[1024];
                                    while ((count = in.read(data, 0, 1024)) != -1) {
                                        digest.update(data, 0, count);
                                    }
                                }
                                MagicController.access$2702(MagicController.this, digest.digest());
                                newResourcePackHash = BaseEncoding.base64().encode(MagicController.this.resourcePackHash);
                                if (initialLoad) {
                                    responses.add(ChatColor.GREEN + "Resource pack hash set to " + ChatColor.GRAY + newResourcePackHash);
                                } else if (currentHash != null && currentHash.equals(newResourcePackHash)) {
                                    responses.add(ChatColor.GREEN + "Resource pack hash has not changed");
                                } else {
                                    responses.add(ChatColor.YELLOW + "Resource pack hash changed, use " + ChatColor.AQUA + "/magic rpsend" + ChatColor.YELLOW + " to update connected players");
                                }
                                ConfigurationSection rpSection = rpConfig.createSection(rpKey);
                                rpSection.set("sha1", (Object)newResourcePackHash);
                                rpSection.set("modified", (Object)modifiedDate.getTime());
                                rpConfig.save(rpFile);
                                break block32;
                            }
                            responses.add(ChatColor.GREEN + "Resource pack has not changed, using hash " + newResourcePackHash + " (" + modifiedDate.getTime() + " <= " + modifiedTimestamp + ")");
                            break block32;
                        }
                        responses.add(ChatColor.RED + "Could not find resource pack at: " + ChatColor.DARK_RED + finalResourcePack);
                        MagicController.this.cancelResourcePackChecks();
                    }
                    catch (Exception e) {
                        MagicController.this.cancelResourcePackChecks();
                        responses.add("An unexpected error occurred while checking your resource pack, cancelling checks until restart (see logs): " + ChatColor.DARK_RED + finalResourcePack);
                        if (MagicController.this.logVerbosity <= 2) break block32;
                        e.printStackTrace();
                    }
                }
                if (!quiet) {
                    server.getScheduler().runTask((Plugin)MagicController.this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            for (String response : responses) {
                                sender.sendMessage(response);
                            }
                        }
                    });
                }
            }
        });
        return true;
    }

    @Override
    @Nullable
    public Material getMobEgg(EntityType mobType) {
        return this.mobEggs.get(mobType);
    }

    @Override
    @Nullable
    public String getMobSkin(EntityType mobType) {
        return this.mobSkins.get(mobType);
    }

    @Override
    @Nonnull
    public ItemStack getURLSkull(String url) {
        try {
            return this.getURLSkull(new URL(url), "MHF_Question", UUID.randomUUID());
        }
        catch (MalformedURLException e) {
            Bukkit.getLogger().log(Level.WARNING, "Malformed URL: " + url, e);
            return new ItemStack(Material.AIR);
        }
    }

    private ItemStack getURLSkull(URL url, String ownerName, UUID id) {
        MaterialAndData skullType = this.skullItems.get(EntityType.PLAYER);
        if (skullType == null) {
            return new ItemStack(Material.AIR);
        }
        ItemStack skull = skullType.getItemStack(1);
        skull = InventoryUtils.setSkullURLAndName(skull, url, ownerName, id);
        return skull;
    }

    @Override
    public void setSkullOwner(Skull skull, String ownerName) {
        DeprecatedUtils.setOwner(skull, ownerName);
    }

    @Override
    public void setSkullOwner(Skull skull, UUID uuid) {
        DeprecatedUtils.setOwner(skull, uuid);
    }

    @Override
    @Nonnull
    @Deprecated
    public ItemStack getSkull(String ownerName, String itemName) {
        return this.getSkull(ownerName, itemName, null);
    }

    @Override
    @Nonnull
    public ItemStack getSkull(String ownerName, String itemName, final ItemUpdatedCallback callback) {
        MaterialAndData skullType = this.skullItems.get(EntityType.PLAYER);
        if (skullType == null) {
            ItemStack air = new ItemStack(Material.AIR);
            if (callback != null) {
                callback.updated(air);
            }
            return air;
        }
        ItemStack skull = skullType.getItemStack(1);
        ItemMeta meta = skull.getItemMeta();
        if (itemName != null) {
            meta.setDisplayName(itemName);
        }
        skull.setItemMeta(meta);
        SkullLoadedCallback skullCallback = null;
        if (callback != null) {
            skullCallback = new SkullLoadedCallback(){

                @Override
                public void updated(ItemStack itemStack) {
                    callback.updated(itemStack);
                }
            };
        }
        DeprecatedUtils.setSkullOwner(skull, ownerName, skullCallback);
        return skull;
    }

    @Override
    @Nonnull
    public ItemStack getSkull(UUID uuid, String itemName, final ItemUpdatedCallback callback) {
        MaterialAndData skullType = this.skullItems.get(EntityType.PLAYER);
        if (skullType == null) {
            return new ItemStack(Material.AIR);
        }
        ItemStack skull = skullType.getItemStack(1);
        ItemMeta meta = skull.getItemMeta();
        if (itemName != null) {
            meta.setDisplayName(itemName);
        }
        skull.setItemMeta(meta);
        SkullLoadedCallback skullCallback = null;
        if (callback != null) {
            skullCallback = new SkullLoadedCallback(){

                @Override
                public void updated(ItemStack itemStack) {
                    callback.updated(itemStack);
                }
            };
        }
        DeprecatedUtils.setSkullOwner(skull, uuid, skullCallback);
        return skull;
    }

    @Override
    @Nonnull
    public ItemStack getSkull(Player player, String itemName) {
        MaterialAndData skullType = this.skullItems.get(EntityType.PLAYER);
        if (skullType == null) {
            return new ItemStack(Material.AIR);
        }
        ItemStack skull = skullType.getItemStack(1);
        ItemMeta meta = skull.getItemMeta();
        if (itemName != null) {
            meta.setDisplayName(itemName);
        }
        skull.setItemMeta(meta);
        DeprecatedUtils.setSkullOwner(skull, player.getName(), null);
        return skull;
    }

    @Override
    @Nonnull
    @Deprecated
    public ItemStack getSkull(Entity entity, String itemName) {
        if (entity instanceof Player) {
            return this.getSkull((Player)entity, itemName);
        }
        return this.getSkull(entity, itemName, null);
    }

    @Override
    @Nonnull
    public ItemStack getSkull(Entity entity, String itemName, final ItemUpdatedCallback callback) {
        String ownerName = null;
        MaterialAndData skullType = this.skullItems.get(entity.getType());
        if (skullType == null) {
            ownerName = this.getMobSkin(entity.getType());
            skullType = this.skullItems.get(EntityType.PLAYER);
            if (skullType == null || ownerName == null) {
                ItemStack air = new ItemStack(Material.AIR);
                if (callback != null) {
                    callback.updated(air);
                }
                return air;
            }
        }
        if (entity instanceof Player) {
            ownerName = entity.getName();
        }
        ItemStack skull = skullType.getItemStack(1);
        ItemMeta meta = skull.getItemMeta();
        if (itemName != null) {
            meta.setDisplayName(itemName);
        }
        skull.setItemMeta(meta);
        if (ownerName != null) {
            SkullLoadedCallback skullCallback = null;
            if (callback != null) {
                skullCallback = new SkullLoadedCallback(){

                    @Override
                    public void updated(ItemStack itemStack) {
                        callback.updated(itemStack);
                    }
                };
            }
            DeprecatedUtils.setSkullOwner(skull, ownerName, skullCallback);
        } else if (callback != null) {
            callback.updated(skull);
        }
        return skull;
    }

    @Override
    @Nonnull
    public ItemStack getMap(int mapId) {
        short durability = NMSUtils.isCurrentVersion() ? (short)0 : (short)mapId;
        ItemStack mapItem = new ItemStack(DefaultMaterials.getFilledMap(), 1, durability);
        if (NMSUtils.isCurrentVersion()) {
            mapItem = CompatibilityUtils.makeReal(mapItem);
            InventoryUtils.setMetaInt(mapItem, "map", mapId);
        }
        return mapItem;
    }

    @Override
    public void managePlayerData(boolean external, boolean backupInventories) {
        this.savePlayerData = !external;
        this.externalPlayerData = external;
        this.backupInventories = backupInventories;
    }

    public void initializeWorldGuardFlags() {
        this.worldGuardManager.initializeFlags((Plugin)this.plugin);
    }

    @Override
    public String getDefaultWandTemplate() {
        return Wand.DEFAULT_WAND_TEMPLATE;
    }

    @Override
    @Nullable
    public Object getWandProperty(ItemStack item, String key) {
        com.elmakers.mine.bukkit.wand.WandTemplate template;
        Preconditions.checkNotNull((Object)key, (Object)"key");
        if (InventoryUtils.isEmpty(item)) {
            return null;
        }
        Object wandNode = InventoryUtils.getNode(item, Wand.WAND_KEY);
        if (wandNode == null) {
            return null;
        }
        Object value = InventoryUtils.getMetaObject(wandNode, key);
        if (value == null && (template = this.getWandTemplate(InventoryUtils.getMetaString(wandNode, "template"))) != null) {
            value = template.getProperty(key);
        }
        return value;
    }

    @Override
    public <T> T getWandProperty(ItemStack item, String key, T defaultValue) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull(defaultValue, (Object)"defaultValue");
        if (InventoryUtils.isEmpty(item)) {
            return defaultValue;
        }
        Object wandNode = InventoryUtils.getNode(item, Wand.WAND_KEY);
        if (wandNode == null) {
            return defaultValue;
        }
        Class<?> clazz = defaultValue.getClass();
        Object value = InventoryUtils.getMetaObject(wandNode, key);
        if (value != null) {
            if (clazz.isInstance(value)) {
                return (T)clazz.cast(value);
            }
            return defaultValue;
        }
        String tplName = InventoryUtils.getMetaString(wandNode, "template");
        com.elmakers.mine.bukkit.wand.WandTemplate template = this.getWandTemplate(tplName);
        if (template != null) {
            return template.getProperty(key, defaultValue);
        }
        return defaultValue;
    }

    public boolean useHeroesMana() {
        return this.useHeroesMana;
    }

    public boolean useSkillAPIMana() {
        return this.useSkillAPIMana;
    }

    @Nonnull
    public MageIdentifier getMageIdentifier() {
        return this.mageIdentifier;
    }

    public void setMageIdentifier(@Nonnull MageIdentifier mageIdentifier) {
        Preconditions.checkNotNull((Object)mageIdentifier, (Object)"mageIdentifier");
        this.mageIdentifier = mageIdentifier;
    }

    @Override
    public String getHeroesSkillPrefix() {
        return this.heroesSkillPrefix;
    }

    public boolean skillPointItemsEnabled() {
        return this.skillPointItemsEnabled;
    }

    public List<AttributeProvider> getAttributeProviders() {
        return this.attributeProviders;
    }

    public MagicAttribute getAttribute(String attributeKey) {
        return this.attributes.get(attributeKey);
    }

    @Override
    public boolean createLight(Location location, int lightLevel, boolean async) {
        if (this.lightAPIManager == null) {
            return false;
        }
        return this.lightAPIManager.createLight(location, lightLevel, async);
    }

    @Override
    public boolean deleteLight(Location location, boolean async) {
        if (this.lightAPIManager == null) {
            return false;
        }
        return this.lightAPIManager.deleteLight(location, async);
    }

    @Override
    public boolean updateLight(Location location) {
        if (this.lightAPIManager == null) {
            return false;
        }
        return this.lightAPIManager.updateChunks(location);
    }

    @Override
    @Nullable
    public String checkRequirements(@Nonnull CastContext context, @Nullable Collection<Requirement> requirements) {
        if (requirements == null) {
            return null;
        }
        for (Requirement requirement : requirements) {
            String type = requirement.getType();
            RequirementsProcessor processor = this.requirementProcessors.get(type);
            if (processor == null || processor.checkRequirement(context, requirement)) continue;
            String message = processor.getRequirementDescription(context, requirement);
            if (message == null || message.isEmpty()) {
                message = this.messages.get("requirements.unknown");
            }
            return message;
        }
        return null;
    }

    public void registerMagicMob(Mage mage) {
        this.mobMages.put(mage.getId(), mage);
    }

    @Override
    @Nonnull
    public Collection<String> getLoadedExamples() {
        ArrayList<String> examples = new ArrayList<String>();
        if (this.exampleDefaults != null) {
            examples.add(this.exampleDefaults);
        }
        if (this.addExamples != null) {
            examples.addAll(this.addExamples);
        }
        return examples;
    }

    @Override
    public double getBlockDurability(@Nonnull Block block) {
        Integer reinforcement;
        double durability = CompatibilityUtils.getDurability(block.getType());
        if (this.citadelManager != null && (reinforcement = this.citadelManager.getDurability(block.getLocation())) != null) {
            durability += (double)reinforcement.intValue();
        }
        return durability;
    }

    @Override
    @Nonnull
    public String getSkillsSpell() {
        return this.skillsSpell;
    }

    @Override
    @Nonnull
    public Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> getEffects(@Nonnull String effectKey) {
        Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> effectList = this.effects.get(effectKey);
        if (effectList == null) {
            effectList = new ArrayList<com.elmakers.mine.bukkit.api.effect.EffectPlayer>();
        }
        return effectList;
    }

    @Override
    public void playEffects(@Nonnull String effectKey, @Nonnull Location sourceLocation, @Nonnull Location targetLocation) {
        Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> effectPlayers = this.effects.get(effectKey);
        if (effectPlayers == null) {
            return;
        }
        for (com.elmakers.mine.bukkit.api.effect.EffectPlayer player : effectPlayers) {
            player.start(sourceLocation, targetLocation);
        }
    }

    @Override
    public void playEffects(@Nonnull String effectKey, @Nonnull EffectContext context) {
        Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> effectPlayers = this.effects.get(effectKey);
        if (effectPlayers == null) {
            return;
        }
        for (com.elmakers.mine.bukkit.api.effect.EffectPlayer player : effectPlayers) {
            player.start(context);
        }
    }

    public Collection<String> getEffectKeys() {
        return this.effects.keySet();
    }

    public void setVanished(com.elmakers.mine.bukkit.api.magic.Mage mage, boolean isVanished) {
        if (isVanished) {
            this.vanished.put(mage.getId(), mage);
        } else {
            this.vanished.remove(mage.getId());
        }
    }

    public void checkVanished(Player player) {
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.vanished.values()) {
            DeprecatedUtils.hidePlayer((Plugin)this.plugin, player, mage.getPlayer());
        }
    }

    @Override
    public void logBlockChange(@Nonnull com.elmakers.mine.bukkit.api.magic.Mage mage, @Nonnull BlockState priorState, @Nonnull BlockState newState) {
        Entity entity;
        if (this.logBlockManager != null && (entity = mage.getEntity()) != null) {
            this.logBlockManager.logBlockChange(entity, priorState, newState);
        }
    }

    @Override
    public boolean isFileLockingEnabled() {
        return this.isFileLockingEnabled;
    }

    public NPCSupplierSet getNPCSuppliers() {
        return this.npcSuppliers;
    }

    static /* synthetic */ byte[] access$2702(MagicController x0, byte[] x1) {
        x0.resourcePackHash = x1;
        return x1;
    }

    private static class NoSuchMageException
    extends RuntimeException {
        public NoSuchMageException(String mageId) {
            super("Failed to locate mage with id: " + mageId);
        }
    }

    private static class PluginNotLoadedException
    extends RuntimeException {
        private PluginNotLoadedException() {
        }
    }
}

