/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.ActionContext;
import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.action.CastContext;
import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import java.util.ArrayList;
import java.util.List;

public class ParallelAction
extends CompoundAction {
    private List<SubAction> remaining = null;

    @Override
    public void reset(com.elmakers.mine.bukkit.api.action.CastContext context) {
        super.reset(context);
        ActionHandler actions = this.getHandler("actions");
        if (actions != null) {
            this.remaining = new ArrayList<SubAction>();
            for (ActionContext action : actions.getActions()) {
                action.getAction().reset(context);
                this.remaining.add(new SubAction(action, context));
            }
        }
    }

    @Override
    public void finish(com.elmakers.mine.bukkit.api.action.CastContext context) {
        super.finish(context);
        ActionHandler actions = this.getHandler("actions");
        if (actions != null) {
            actions.finish(context);
        }
    }

    @Override
    public SpellResult perform(com.elmakers.mine.bukkit.api.action.CastContext context) {
        SpellResult result = SpellResult.NO_ACTION;
        int startingWork = context.getWorkAllowed();
        ArrayList<SubAction> subActions = new ArrayList<SubAction>(this.remaining);
        this.remaining.clear();
        context.setWorkAllowed(0);
        int splitWork = Math.max(1, startingWork / subActions.size());
        for (SubAction action : subActions) {
            context.setWorkAllowed(context.getWorkAllowed() + splitWork);
            SpellResult actionResult = action.perform();
            context.addResult(actionResult);
            if (actionResult.isStop()) {
                this.remaining.add(action);
            }
            result = result.min(actionResult);
        }
        return result;
    }

    private static class SubAction {
        private ActionContext action;
        private com.elmakers.mine.bukkit.api.action.CastContext context;

        public SubAction(ActionContext action, com.elmakers.mine.bukkit.api.action.CastContext context) {
            this.action = action;
            this.context = new CastContext(context);
        }

        public SpellResult perform() {
            return this.action.perform(this.context);
        }
    }
}

