/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.entity;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.entity.EntityExtraData;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class EntityParrotData
extends EntityExtraData {
    public Enum<?> variant;

    public EntityParrotData() {
    }

    public EntityParrotData(ConfigurationSection parameters, MageController controller) {
        Logger log = controller.getLogger();
        String variantName = parameters.getString("parrot_variant");
        if (variantName != null && !variantName.isEmpty()) {
            this.variant = CompatibilityUtils.getParrotVariant(variantName);
            if (this.variant == null) {
                log.warning("Invalid parrot variant: " + variantName);
            }
        }
    }

    public EntityParrotData(Entity entity) {
        this.variant = CompatibilityUtils.getParrotVariant(entity);
    }

    @Override
    public void apply(Entity entity) {
        if (this.variant != null) {
            CompatibilityUtils.setParrotVariant(entity, this.variant);
        }
    }

    @Override
    public EntityExtraData clone() {
        EntityParrotData copy = new EntityParrotData();
        copy.variant = this.variant;
        return copy;
    }
}

