/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.economy;

import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.economy.BaseMagicCurrency;

public class SpellPointCurrency
extends BaseMagicCurrency {
    private final boolean isValid;

    public SpellPointCurrency(MageController controller, double worth) {
        super(controller, "sp", worth);
        this.isValid = controller.isSPEnabled();
    }

    @Override
    public double getBalance(Mage mage, CasterProperties caster) {
        return mage.getSkillPoints();
    }

    @Override
    public boolean has(Mage mage, CasterProperties caster, double amount) {
        return (double)mage.getSkillPoints() >= amount;
    }

    @Override
    public void deduct(Mage mage, CasterProperties caster, double amount) {
        mage.addSkillPoints(-this.getRoundedAmount(amount));
    }

    @Override
    public boolean give(Mage mage, CasterProperties caster, double amount) {
        if (mage.isAtMaxSkillPoints()) {
            return false;
        }
        mage.addSkillPoints(this.getRoundedAmount(amount));
        return true;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }
}

