/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.api.event;

import com.elmakers.mine.bukkit.api.attributes.AttributeProvider;
import com.elmakers.mine.bukkit.api.economy.Currency;
import com.elmakers.mine.bukkit.api.entity.TeamProvider;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.protection.BlockBreakManager;
import com.elmakers.mine.bukkit.api.protection.BlockBuildManager;
import com.elmakers.mine.bukkit.api.protection.PVPManager;
import com.elmakers.mine.bukkit.api.requirements.RequirementsProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class PreLoadEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private MageController controller;
    private List<AttributeProvider> attributeProviders = new ArrayList<AttributeProvider>();
    private List<TeamProvider> teamProviders = new ArrayList<TeamProvider>();
    private List<Currency> currencies = new ArrayList<Currency>();
    private List<BlockBreakManager> blockBreakManagers = new ArrayList<BlockBreakManager>();
    private List<BlockBuildManager> blockBuildManager = new ArrayList<BlockBuildManager>();
    private List<PVPManager> pvpManagers = new ArrayList<PVPManager>();
    private Map<String, RequirementsProcessor> requirementProcessors = new HashMap<String, RequirementsProcessor>();

    public PreLoadEvent(MageController controller) {
        this.controller = controller;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public MageController getController() {
        return this.controller;
    }

    public void registerAttributeProvider(AttributeProvider provider) {
        this.attributeProviders.add(provider);
    }

    public void registerTeamProvider(TeamProvider provider) {
        this.teamProviders.add(provider);
    }

    public void registerCurrency(Currency currency) {
        this.currencies.add(currency);
    }

    public void registerRequirementsProcessor(String requirementType, RequirementsProcessor processor) {
        if (this.requirementProcessors.containsKey(requirementType)) {
            this.controller.getLogger().warning("Tried to register RequiremensProcessor twice for same type: " + requirementType);
        }
        this.requirementProcessors.put(requirementType, processor);
    }

    public void registerBlockBlockManager(BlockBreakManager manager) {
        this.blockBreakManagers.add(manager);
    }

    public void registerPVPManager(PVPManager manager) {
        this.pvpManagers.add(manager);
    }

    public void registerBlockBuildManager(BlockBuildManager manager) {
        this.blockBuildManager.add(manager);
    }

    public Map<String, RequirementsProcessor> getRequirementProcessors() {
        return this.requirementProcessors;
    }

    public Collection<AttributeProvider> getAttributeProviders() {
        return this.attributeProviders;
    }

    public Collection<TeamProvider> getTeamProviders() {
        return this.teamProviders;
    }

    public Collection<Currency> getCurrencies() {
        return this.currencies;
    }

    public Collection<BlockBreakManager> getBlockBreakManagers() {
        return this.blockBreakManagers;
    }

    public Collection<BlockBuildManager> getBlockBuildManagers() {
        return this.blockBuildManager;
    }

    public Collection<PVPManager> getPVPManagers() {
        return this.pvpManagers;
    }
}

