/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class MessageAction
extends BaseSpellAction {
    private String message = "";
    private String subMessage = "";
    private int fadeIn;
    private int stay;
    private int fadeOut;
    private boolean messageTarget = false;
    private MessageType messageType = MessageType.CHAT;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        String messageTypeString;
        super.prepare(context, parameters);
        this.message = ChatColor.translateAlternateColorCodes((char)'&', (String)parameters.getString("message", ""));
        this.subMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)parameters.getString("sub_message", ""));
        this.fadeIn = parameters.getInt("fade_in", -1);
        this.stay = parameters.getInt("stay", -1);
        this.fadeOut = parameters.getInt("fade_out", -1);
        this.messageTarget = parameters.getBoolean("message_target", false);
        if (parameters.contains("equation")) {
            double value = parameters.getDouble("equation");
            this.message = this.message.replace("$equation", Double.toString(value));
        }
        if ((messageTypeString = parameters.getString("message_type", null)) != null) {
            try {
                this.messageType = MessageType.valueOf(messageTypeString.toUpperCase());
            }
            catch (Exception ex) {
                context.getLogger().warning("Not a valid message_type: " + messageTypeString);
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        if (this.messageTarget) {
            Entity targetEntity = context.getTargetEntity();
            if (targetEntity == null || !(targetEntity instanceof Player)) {
                return SpellResult.NO_TARGET;
            }
            this.sendMessage(context, (Player)targetEntity);
            return SpellResult.CAST;
        }
        Mage mage = context.getMage();
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        this.sendMessage(context, player);
        return SpellResult.CAST;
    }

    private void sendMessage(CastContext context, Player player) {
        String message = context.parameterize(context.getMessage(this.message, this.message));
        message = message.replace("$spell", context.getSpell().getName());
        switch (this.messageType) {
            case CHAT: {
                player.sendMessage(message);
                break;
            }
            case TITLE: {
                String subMessage = context.parameterize(context.getMessage(this.subMessage, this.subMessage));
                CompatibilityUtils.sendTitle(player, message, subMessage, this.fadeIn, this.stay, this.fadeOut);
                break;
            }
            case ACTION_BAR: {
                if (CompatibilityUtils.sendActionBar(player, message)) break;
                player.sendMessage(message);
            }
        }
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("message");
        parameters.add("equation");
        parameters.add("sub_message");
        parameters.add("message_type");
        parameters.add("message_target");
        parameters.add("stay");
        parameters.add("fade_in");
        parameters.add("fade_out");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("message") || parameterKey.equals("sub_message")) {
            examples.add("You cast $spell on $target");
        } else if (parameterKey.equals("equation")) {
            examples.add("intelligence + strength / 20");
        } else if (parameterKey.equals("fade_in") || parameterKey.equals("fade_out") || parameterKey.equals("stay")) {
            examples.add("-1");
            examples.add("10");
            examples.add("20");
            examples.add("70");
        } else if (parameterKey.equals("message_type")) {
            for (MessageType messageType : MessageType.values()) {
                examples.add(messageType.name().toLowerCase());
            }
        } else if (parameterKey.equals("message_target")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    public static enum MessageType {
        CHAT,
        TITLE,
        ACTION_BAR;

    }
}

