/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.data;

import com.elmakers.mine.bukkit.api.data.MageData;
import com.elmakers.mine.bukkit.api.data.MageDataCallback;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.data.ConfigurationMageDataStore;
import com.elmakers.mine.bukkit.data.YamlDataFile;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class YamlMageDataStore
extends ConfigurationMageDataStore {
    private File playerDataFolder;
    private File migratedDataFolder;
    private final Map<String, FileLock> locks = new HashMap<String, FileLock>();

    @Override
    public void initialize(MageController controller, ConfigurationSection configuration) {
        super.initialize(controller, configuration);
        Plugin plugin = controller.getPlugin();
        String playerFolder = configuration.getString("folder", "players");
        String migrateFolder = configuration.getString("migration_folder", "migrated");
        this.playerDataFolder = new File(plugin.getDataFolder(), playerFolder);
        this.playerDataFolder.mkdirs();
        this.migratedDataFolder = new File(plugin.getDataFolder(), migrateFolder);
    }

    @Override
    public void save(MageData mage, MageDataCallback callback) {
        this.save(mage, callback, false);
    }

    @Override
    public void save(MageData mage, MageDataCallback callback, boolean releaseLock) {
        FileLock lock;
        File playerData = new File(this.playerDataFolder, mage.getId() + ".dat");
        YamlDataFile saveFile = new YamlDataFile(this.controller.getLogger(), playerData);
        this.save(mage, (ConfigurationSection)saveFile);
        saveFile.save();
        if (releaseLock && (lock = this.locks.remove(mage.getId())) != null) {
            try {
                lock.release();
                this.controller.info("Released file lock for " + mage.getId() + " at " + System.currentTimeMillis());
            }
            catch (IOException ex) {
                this.controller.getLogger().log(Level.WARNING, "Unable to release file lock for " + mage.getId(), ex);
            }
        }
        if (callback != null) {
            callback.run(mage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void obtainLock(String id) {
        if (this.controller.isFileLockingEnabled()) {
            Map<String, FileLock> map = this.locks;
            synchronized (map) {
                if (this.locks.containsKey(id)) {
                    return;
                }
                try {
                    File lockFile = new File(this.playerDataFolder, id + ".lock");
                    RandomAccessFile file = new RandomAccessFile(lockFile, "rw");
                    FileChannel channel = file.getChannel();
                    this.controller.info("Obtaining lock for " + lockFile.getName() + " at " + System.currentTimeMillis());
                    FileLock lock = channel.lock();
                    this.controller.info("  Obtained lock for " + lockFile.getName() + " at " + System.currentTimeMillis());
                    this.locks.put(id, lock);
                }
                catch (IOException ex) {
                    this.controller.getLogger().log(Level.WARNING, "Unable to obtain file lock for " + id, ex);
                }
            }
        }
    }

    @Override
    public void load(String id, MageDataCallback callback) {
        this.obtainLock(id);
        File playerFile = new File(this.playerDataFolder, id + ".dat");
        if (!playerFile.exists()) {
            callback.run(null);
            return;
        }
        YamlConfiguration saveFile = YamlConfiguration.loadConfiguration((File)playerFile);
        MageData data = this.load(id, (ConfigurationSection)saveFile);
        if (callback != null) {
            callback.run(data);
        }
    }

    @Override
    public void delete(String id) {
        File playerData = new File(this.playerDataFolder, id + ".dat");
        if (playerData.exists()) {
            playerData.delete();
        }
    }

    @Override
    public Collection<String> getAllIds() {
        File[] files;
        ArrayList<String> ids = new ArrayList<String>();
        for (File file : files = this.playerDataFolder.listFiles()) {
            String filename = file.getName();
            int extensionIndex = filename.lastIndexOf(46);
            if (extensionIndex > 0) {
                filename = filename.substring(0, filename.lastIndexOf(46));
            }
            ids.add(filename);
        }
        return ids;
    }

    @Override
    public void migrate(String id) {
        File playerData = new File(this.playerDataFolder, id + ".dat");
        if (playerData.exists()) {
            this.migratedDataFolder.mkdir();
            File migratedData = new File(this.migratedDataFolder, id + ".dat.migrated");
            playerData.renameTo(migratedData);
        }
    }
}

