/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationStore;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationTransform;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.NumberConversions;

public class ModifyLoreAction
extends BaseSpellAction {
    private int digits = 0;
    private List<ModifyLoreLine> modify;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        this.digits = parameters.getInt("digits");
        this.modify = new ArrayList<ModifyLoreLine>();
        Object modifyObject = parameters.get("modify");
        if (modifyObject instanceof ConfigurationSection) {
            ConfigurationSection simple = (ConfigurationSection)modifyObject;
            Set keys = simple.getKeys(true);
            for (String key : keys) {
                ModifyLoreLine property = new ModifyLoreLine(key, simple.get(key));
                this.modify.add(property);
            }
        } else {
            Collection<ConfigurationSection> complex = ConfigurationUtils.getNodeList(parameters, "modify");
            for (ConfigurationSection section : complex) {
                ModifyLoreLine property = new ModifyLoreLine(section);
                this.modify.add(property);
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        if (this.modify == null) {
            return SpellResult.FAIL;
        }
        Entity entity = context.getTargetEntity();
        if (!(entity instanceof Player)) {
            return SpellResult.PLAYER_REQUIRED;
        }
        Player player = (Player)entity;
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null) {
            return SpellResult.NO_TARGET;
        }
        ItemMeta meta = item.getItemMeta();
        ArrayList<String> lore = meta.getLore();
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        int modified = 0;
        for (ModifyLoreLine property : this.modify) {
            boolean found = false;
            for (int i = 0; i < lore.size(); ++i) {
                String line = (String)lore.get(i);
                String originalValue = property.match(line);
                if (originalValue == null || property.value == null) continue;
                String value = "";
                if (property.value instanceof String) {
                    if (property.numeric) {
                        EquationTransform transform = EquationStore.getInstance().getTransform((String)property.value);
                        double currentValue = NumberConversions.toDouble((Object)originalValue);
                        if (transform.isValid()) {
                            transform.setVariable("x", currentValue);
                            double transformedValue = transform.get();
                            if (Double.isNaN(transformedValue)) continue;
                            if (property.max != null) {
                                if (currentValue >= property.max && transformedValue >= property.max) continue;
                                transformedValue = Math.min(transformedValue, property.max);
                            }
                            if (property.min != null) {
                                if (currentValue <= property.min && transformedValue <= property.min) continue;
                                transformedValue = Math.max(transformedValue, property.min);
                            }
                            value = TextUtils.printNumber(transformedValue, this.digits);
                        }
                    } else {
                        value = (String)property.value;
                    }
                } else if (property.value instanceof Number) {
                    value = TextUtils.printNumber(NumberConversions.toDouble((Object)originalValue), this.digits);
                }
                ++modified;
                lore.set(i, property.replace(line, value));
                break;
            }
            if (found || property.defaultValue == null) continue;
            lore.add(property.defaultValue);
            ++modified;
        }
        if (modified == 0) {
            return SpellResult.NO_TARGET;
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("modify");
        parameters.add("digits");
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    private static class ModifyLoreLine {
        public Pattern pattern;
        public Object value;
        public boolean numeric;
        public Double min;
        public Double max;
        public String defaultValue;

        public ModifyLoreLine(String pattern, Object value) {
            this.pattern = Pattern.compile(ChatColor.translateAlternateColorCodes((char)'&', (String)pattern));
            this.value = value;
        }

        public ModifyLoreLine(ConfigurationSection configuration) {
            this(configuration.getString("pattern"), configuration.get("value"));
            this.defaultValue = configuration.getString("default");
            if (this.defaultValue != null) {
                this.defaultValue = ChatColor.translateAlternateColorCodes((char)'&', (String)this.defaultValue);
            }
            if (configuration.contains("min")) {
                this.min = configuration.getDouble("min");
            }
            if (configuration.contains("max")) {
                this.max = configuration.getDouble("max");
            }
            this.numeric = configuration.getBoolean("numeric", true);
        }

        @Nullable
        public String match(String line) {
            Matcher matcher = this.pattern.matcher(line);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            return null;
        }

        @Nonnull
        public String replace(String line, String value) {
            Matcher matcher = this.pattern.matcher(line);
            matcher.find();
            return new StringBuilder(line).replace(matcher.start(1), matcher.end(1), value).toString();
        }
    }
}

