/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.magic.SourceLocation;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class DamageAction
extends BaseSpellAction {
    protected double entityDamage;
    protected double playerDamage;
    protected double elementalDamage;
    private boolean magicDamage;
    private boolean magicEntityDamage;
    private Double percentage;
    private Double knockbackResistance;
    private Double damageMultiplier;
    private double maxDistanceSquared;
    private String damageType;
    private SourceLocation damageSourceLocation;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        double damage = parameters.getDouble("damage", 1.0);
        this.entityDamage = parameters.getDouble("entity_damage", damage);
        this.playerDamage = parameters.getDouble("player_damage", damage);
        this.elementalDamage = parameters.getDouble("elemental_damage", damage);
        this.damageMultiplier = parameters.contains("damage_multiplier") ? Double.valueOf(parameters.getDouble("damage_multiplier")) : null;
        this.percentage = parameters.contains("percentage") ? Double.valueOf(parameters.getDouble("percentage")) : null;
        this.magicDamage = parameters.getBoolean("magic_damage", true);
        this.magicEntityDamage = parameters.getBoolean("magic_entity_damage", this.magicDamage);
        this.knockbackResistance = parameters.contains("knockback_resistance") ? Double.valueOf(parameters.getDouble("knockback_resistance")) : null;
        double maxDistance = parameters.getDouble("damage_max_distance");
        this.maxDistanceSquared = maxDistance * maxDistance;
        this.damageType = parameters.getString("damage_type");
        this.damageSourceLocation = new SourceLocation(parameters.getString("damage_source_location", "BODY"), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpellResult perform(CastContext context) {
        AttributeInstance knockBackAttribute;
        Entity entity = context.getTargetEntity();
        if (entity == null || !(entity instanceof Damageable) || entity.isDead()) {
            return SpellResult.NO_TARGET;
        }
        double damage = 1.0;
        Damageable targetEntity = (Damageable)entity;
        LivingEntity livingTarget = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        context.registerDamaged((Entity)targetEntity);
        Mage mage = context.getMage();
        MageController controller = context.getController();
        double previousKnockbackResistance = 0.0;
        try {
            if (this.knockbackResistance != null && livingTarget != null) {
                knockBackAttribute = livingTarget.getAttribute(Attribute.GENERIC_KNOCKBACK_RESISTANCE);
                previousKnockbackResistance = knockBackAttribute.getBaseValue();
                knockBackAttribute.setBaseValue(this.knockbackResistance.doubleValue());
            }
            if (controller.isElemental(entity)) {
                damage = this.elementalDamage;
                controller.damageElemental(entity, damage * (double)mage.getDamageMultiplier(), 0, mage.getCommandSender());
            } else {
                damage = this.percentage != null ? this.percentage * CompatibilityUtils.getMaxHealth(targetEntity) : (targetEntity instanceof Player ? this.playerDamage : this.entityDamage);
                String multiplierType = this.damageType;
                if (multiplierType == null) {
                    multiplierType = this.magicDamage ? "magic" : "physical";
                }
                double mageMultiplier = mage.getDamageMultiplier(multiplierType);
                damage *= mageMultiplier;
                if (this.maxDistanceSquared > 0.0) {
                    Location entityLocation = this.damageSourceLocation.getLocation(context);
                    double distanceSquared = context.getLocation().distanceSquared(entityLocation);
                    if (distanceSquared > this.maxDistanceSquared) {
                        SpellResult spellResult = SpellResult.NO_TARGET;
                        return spellResult;
                    }
                    if (distanceSquared > 0.0) {
                        damage *= 1.0 - distanceSquared / this.maxDistanceSquared;
                    }
                }
                if (this.damageMultiplier != null) {
                    damage *= this.damageMultiplier.doubleValue();
                    mageMultiplier *= this.damageMultiplier.doubleValue();
                }
                if (this.damageType != null) {
                    Mage targetMage = controller.getRegisteredMage((Entity)targetEntity);
                    String targetAnnotation = "";
                    if (targetMage != null) {
                        targetMage.setLastDamageType(this.damageType);
                    } else {
                        targetAnnotation = "*";
                    }
                    mage.sendDebugMessage(ChatColor.RED + "Damaging (" + ChatColor.DARK_RED + this.damageType + ChatColor.RED + ") x " + ChatColor.DARK_RED + mageMultiplier + ChatColor.RED + " to " + ChatColor.BLUE + targetEntity.getType() + targetAnnotation + ": " + ChatColor.RED + damage, 5);
                    if (mage.isPlayer() && controller.getDamageTypes().contains(this.damageType)) {
                        CompatibilityUtils.magicDamage(targetEntity, damage, mage.getEntity());
                    } else {
                        CompatibilityUtils.damage(targetEntity, damage, mage.getEntity(), this.damageType);
                    }
                } else if (this.magicDamage && (this.magicEntityDamage || targetEntity instanceof Player)) {
                    mage.sendDebugMessage(ChatColor.RED + "Damaging (Magic) x " + ChatColor.DARK_RED + mageMultiplier + ChatColor.RED + " to " + ChatColor.BLUE + targetEntity.getType() + ": " + damage, 5);
                    CompatibilityUtils.magicDamage(targetEntity, damage, mage.getEntity());
                } else {
                    mage.sendDebugMessage(ChatColor.RED + "Damaging x " + ChatColor.DARK_RED + mageMultiplier + ChatColor.RED + " to " + ChatColor.BLUE + targetEntity.getType() + ": " + damage, 5);
                    CompatibilityUtils.damage(targetEntity, damage, mage.getEntity());
                }
                if (damage == (double)((int)damage)) {
                    context.addMessageParameter("damage", Integer.toString((int)damage));
                } else {
                    context.addMessageParameter("damage", Double.toString(damage));
                }
                if (this.damageType != null && !this.damageType.isEmpty()) {
                    String typeDescription = context.getController().getMessages().get("damage_types." + this.damageType, this.damageType);
                    context.addMessageParameter("damage_type", typeDescription);
                }
            }
        }
        finally {
            if (this.knockbackResistance != null && livingTarget != null) {
                knockBackAttribute = livingTarget.getAttribute(Attribute.GENERIC_KNOCKBACK_RESISTANCE);
                knockBackAttribute.setBaseValue(previousKnockbackResistance);
            }
        }
        return SpellResult.CAST;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("damage");
        parameters.add("player_damage");
        parameters.add("entity_damage");
        parameters.add("elemental_damage");
        parameters.add("magic_damage");
        parameters.add("percentage");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("damage") || parameterKey.equals("player_damage") || parameterKey.equals("entity_damage") || parameterKey.equals("elemental_damage")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else if (parameterKey.equals("magic_damage")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("percentage")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_PERCENTAGES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }
}

