/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.warp;

import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.warp.CommandBookWarps;
import com.elmakers.mine.bukkit.warp.EssentialsWarps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class WarpController {
    private CommandBookWarps commandBook;
    private EssentialsWarps essentials;
    private final Map<String, Location> warps = new HashMap<String, Location>();

    public void load(ConfigurationSection warpData) {
        this.warps.clear();
        Set keys = warpData.getKeys(false);
        for (String key : keys) {
            this.warps.put(key, ConfigurationUtils.getLocation(warpData, key));
        }
    }

    public void save(ConfigurationSection warpData) {
        for (Map.Entry<String, Location> warp : this.warps.entrySet()) {
            warpData.set(warp.getKey(), (Object)ConfigurationUtils.fromLocation(warp.getValue()));
        }
    }

    public Collection<String> getCustomWarps() {
        return this.warps.keySet();
    }

    public boolean hasCustomWarp(String warpName) {
        return this.warps.containsKey(warpName);
    }

    public void setWarp(String warpName, Location location) {
        this.warps.put(warpName, location);
    }

    public boolean removeWarp(String warpName) {
        return this.warps.remove(warpName) != null;
    }

    public int importWarps() {
        if (this.commandBook != null) {
            this.warps.putAll(this.commandBook.getWarps());
        }
        if (this.essentials != null) {
            this.warps.putAll(this.essentials.getWarps());
        }
        return this.warps.size();
    }

    @Nullable
    public Location getWarp(String warpName) {
        Location warp = this.warps.get(warpName);
        if (warp == null && this.commandBook != null) {
            warp = this.commandBook.getWarp(warpName);
        }
        if (warp == null && this.essentials != null) {
            warp = this.essentials.getWarp(warpName);
        }
        return warp;
    }

    public boolean setCommandBook(Plugin plugin) {
        this.commandBook = CommandBookWarps.create(plugin);
        return this.commandBook != null;
    }

    public boolean setEssentials(Plugin plugin) {
        this.essentials = EssentialsWarps.create(plugin);
        return this.essentials != null;
    }
}

