/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.attributes.AttributeProvider;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.requirements.Requirement;
import com.elmakers.mine.bukkit.api.requirements.RequirementsProcessor;
import com.elmakers.mine.bukkit.magic.ManaController;
import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.player.PlayerClass;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.manager.AttributeManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SkillAPIManager
implements ManaController,
AttributeProvider,
RequirementsProcessor {
    private final Plugin skillAPIPlugin;
    private final MageController controller;
    private Set<String> attributes = new HashSet<String>();
    private AttributeManager attributeManager;

    public SkillAPIManager(MageController controller, Plugin skillAPIPlugin) {
        this.controller = controller;
        this.skillAPIPlugin = skillAPIPlugin;
    }

    public boolean initialize() {
        if (this.skillAPIPlugin == null) {
            return false;
        }
        if (!(this.skillAPIPlugin instanceof SkillAPI)) {
            return false;
        }
        this.attributeManager = SkillAPI.getAttributeManager();
        if (this.attributeManager == null) {
            this.attributes = null;
            this.controller.getLogger().info("SkillAPI found but but attributes are disabled");
        } else {
            this.attributes = this.attributeManager.getKeys();
            this.controller.getLogger().info("SkillAPI Attributes: " + this.attributes);
        }
        return true;
    }

    @Override
    public Set<String> getAllAttributes() {
        return this.attributes;
    }

    @Override
    @Nullable
    public Double getAttributeValue(String attribute, Player player) {
        if (this.attributes == null || !this.attributes.contains(attribute)) {
            return null;
        }
        PlayerData playerData = SkillAPI.getPlayerData((OfflinePlayer)player);
        return playerData.getAttribute(attribute);
    }

    @Override
    public int getMaxMana(Player player) {
        PlayerData playerData = SkillAPI.getPlayerData((OfflinePlayer)player);
        return (int)playerData.getMaxMana();
    }

    @Override
    public int getManaRegen(Player player) {
        PlayerData playerData = SkillAPI.getPlayerData((OfflinePlayer)player);
        Collection classes = playerData.getClasses();
        double amount = 0.0;
        for (PlayerClass c : classes) {
            if (!c.getData().hasManaRegen()) continue;
            amount += c.getData().getManaRegen();
        }
        return (int)amount;
    }

    @Override
    public float getMana(Player player) {
        PlayerData playerData = SkillAPI.getPlayerData((OfflinePlayer)player);
        return (float)playerData.getMana();
    }

    @Override
    public void removeMana(Player player, float amount) {
        PlayerData playerData = SkillAPI.getPlayerData((OfflinePlayer)player);
        playerData.useMana((double)amount);
    }

    @Override
    public void setMana(Player player, float amount) {
        PlayerData playerData = SkillAPI.getPlayerData((OfflinePlayer)player);
        playerData.setMana((double)amount);
    }

    public boolean hasSkill(Player player, String name) {
        PlayerData playerData = SkillAPI.getPlayerData((OfflinePlayer)player);
        return playerData.hasSkill(name);
    }

    public boolean hasClass(Player player, String name) {
        PlayerData playerData = SkillAPI.getPlayerData((OfflinePlayer)player);
        return playerData.hasClass(name);
    }

    @Override
    public boolean checkRequirement(@Nonnull CastContext castContext, @Nonnull Requirement requirement) {
        Mage mage = castContext.getMage();
        if (!mage.isPlayer()) {
            return false;
        }
        ConfigurationSection configuration = requirement.getConfiguration();
        if (configuration.contains("skill")) {
            String skillKey = configuration.getString("skill");
            return this.hasSkill(mage.getPlayer(), skillKey);
        }
        if (configuration.contains("class")) {
            String classKey = configuration.getString("class");
            return this.hasClass(mage.getPlayer(), classKey);
        }
        return true;
    }

    protected String getMessage(CastContext context, String key) {
        return context.getMessage(key, context.getController().getMessages().get("skillapi." + key));
    }

    @Override
    @Nullable
    public String getRequirementDescription(@Nonnull CastContext context, @Nonnull Requirement requirement) {
        ConfigurationSection configuration = requirement.getConfiguration();
        if (configuration.contains("skill")) {
            return this.getMessage(context, "required_skill").replace("$skill", configuration.getString("skill"));
        }
        if (configuration.contains("class")) {
            return this.getMessage(context, "required_class").replace("$class", configuration.getString("class"));
        }
        return null;
    }
}

