/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.CastingCost;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;

public class WandLevel {
    private final WandUpgradePath path;
    private LinkedList<WeightedPair<Integer>> spellCountProbability = new LinkedList();
    private LinkedList<WeightedPair<Integer>> materialCountProbability = new LinkedList();
    private LinkedList<WeightedPair<String>> spellProbability = new LinkedList();
    private LinkedList<WeightedPair<String>> materialProbability = new LinkedList();
    private LinkedList<WeightedPair<Integer>> useProbability = new LinkedList();
    private LinkedList<WeightedPair<Integer>> addUseProbability = new LinkedList();
    private LinkedList<WeightedPair<Integer>> propertyCountProbability = new LinkedList();
    private Map<String, LinkedList<WeightedPair<Float>>> propertiesProbability = new HashMap<String, LinkedList<WeightedPair<Float>>>();
    private LinkedList<WeightedPair<Integer>> manaRegenerationProbability = new LinkedList();
    private LinkedList<WeightedPair<Integer>> manaMaxProbability = new LinkedList();

    protected WandLevel(WandUpgradePath path, MageController controller, ConfigurationSection template, int levelIndex, int nextLevelIndex, float distance) {
        this.path = path;
        LinkedList<WeightedPair<String>> spells = new LinkedList<WeightedPair<String>>();
        RandomUtils.populateStringProbabilityMap(spells, template, "spells", levelIndex, nextLevelIndex, distance);
        for (WeightedPair weightedPair : spells) {
            if (controller.getSpellTemplate((String)weightedPair.getValue()) == null) continue;
            this.spellProbability.add(weightedPair);
        }
        RandomUtils.populateIntegerProbabilityMap(this.spellCountProbability, template, "spell_count", levelIndex, nextLevelIndex, distance);
        RandomUtils.populateStringProbabilityMap(this.materialProbability, template, "materials", levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.materialCountProbability, template.getConfigurationSection("material_count"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.useProbability, template, "uses", levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.addUseProbability, template, "add_uses", levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.propertyCountProbability, template, "property_count", levelIndex, nextLevelIndex, distance);
        ConfigurationSection propertiesConfig = template.getConfigurationSection("properties");
        if (propertiesConfig != null) {
            for (String propertyKey : propertiesConfig.getKeys(false)) {
                LinkedList<WeightedPair<Float>> propertyProbability = new LinkedList<WeightedPair<Float>>();
                RandomUtils.populateFloatProbabilityMap(propertyProbability, propertiesConfig, propertyKey, levelIndex, nextLevelIndex, distance);
                propertyKey = propertyKey.replace("|", ".");
                this.propertiesProbability.put(propertyKey, propertyProbability);
            }
        }
        RandomUtils.populateIntegerProbabilityMap(this.manaRegenerationProbability, template, "mana_regeneration", levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.manaMaxProbability, template, "mana_max", levelIndex, nextLevelIndex, distance);
    }

    public void add(WandLevel other) {
        this.spellProbability = RandomUtils.merge(this.spellProbability, other.spellProbability);
        this.materialProbability = RandomUtils.merge(this.materialProbability, other.materialProbability);
        this.materialCountProbability = this.materialCountProbability.isEmpty() ? other.materialCountProbability : this.materialCountProbability;
        this.spellCountProbability = this.spellCountProbability.isEmpty() ? other.spellCountProbability : this.spellCountProbability;
        this.useProbability = this.useProbability.isEmpty() ? other.useProbability : this.useProbability;
        this.addUseProbability = this.addUseProbability.isEmpty() ? other.addUseProbability : this.addUseProbability;
        this.propertyCountProbability = this.propertyCountProbability.isEmpty() ? other.propertyCountProbability : this.propertyCountProbability;
        for (Map.Entry<String, LinkedList<WeightedPair<Float>>> entry : other.propertiesProbability.entrySet()) {
            LinkedList<WeightedPair<Float>> thisOne = this.propertiesProbability.get(entry.getKey());
            if (thisOne != null && !thisOne.isEmpty()) continue;
            this.propertiesProbability.put(entry.getKey(), entry.getValue());
        }
        this.manaRegenerationProbability = this.manaRegenerationProbability.isEmpty() ? other.manaRegenerationProbability : this.manaRegenerationProbability;
        this.manaMaxProbability = this.manaMaxProbability.isEmpty() ? other.manaMaxProbability : this.manaMaxProbability;
    }

    public int getSpellCount() {
        int count = 0;
        for (WeightedPair weightedPair : this.spellCountProbability) {
            if ((Integer)weightedPair.getValue() <= count) continue;
            count = (Integer)weightedPair.getValue();
        }
        return count;
    }

    public int getMaterialCount() {
        int count = 0;
        for (WeightedPair weightedPair : this.materialCountProbability) {
            if ((Integer)weightedPair.getValue() <= count) continue;
            count = (Integer)weightedPair.getValue();
        }
        return count;
    }

    public LinkedList<WeightedPair<String>> getRemainingSpells(CasterProperties properties) {
        LinkedList<WeightedPair<String>> remainingSpells = new LinkedList<WeightedPair<String>>();
        for (WeightedPair weightedPair : this.spellProbability) {
            if (!(weightedPair.getRawThreshold().floatValue() >= 1.0f) || properties.hasSpell((String)weightedPair.getValue())) continue;
            remainingSpells.add(weightedPair);
        }
        return remainingSpells;
    }

    public LinkedList<WeightedPair<String>> getRemainingMaterials(Wand wand) {
        LinkedList<WeightedPair<String>> remainingMaterials = new LinkedList<WeightedPair<String>>();
        for (WeightedPair weightedPair : this.materialProbability) {
            String materialKey = (String)weightedPair.getValue();
            if (wand.hasBrush(materialKey = materialKey.replace("|", ":")) || !MaterialBrush.isValidMaterial(materialKey, false)) continue;
            remainingMaterials.add(weightedPair);
        }
        return remainingMaterials;
    }

    public boolean randomizeWand(com.elmakers.mine.bukkit.api.magic.Mage mage, Wand wand, boolean additive, boolean hasUpgrade, boolean addSpells) {
        Mage activeMage = wand.getActiveMage();
        if (mage == null) {
            mage = activeMage;
        }
        wand.setActiveMage(mage);
        boolean addedSpells = false;
        LinkedList remainingSpells = this.getRemainingSpells(wand);
        if (addSpells && remainingSpells.size() > 0) {
            Integer spellCount = (Integer)RandomUtils.weightedRandom(this.spellCountProbability);
            for (int i = 0; spellCount != null && i < spellCount; ++i) {
                String spellKey = (String)RandomUtils.weightedRandom(remainingSpells);
                if (!wand.addSpell(spellKey)) continue;
                addedSpells = true;
            }
        }
        boolean needsMaterials = false;
        int maxManaCost = 0;
        Collection spells = wand.getSpells();
        for (String spellName : spells) {
            SpellTemplate spell = wand.getController().getSpellTemplate(spellName);
            if (spell == null) continue;
            boolean bl = needsMaterials = needsMaterials || spell.usesBrush();
            Collection<CastingCost> costs = spell.getCosts();
            if (costs == null) continue;
            for (CastingCost cost : costs) {
                maxManaCost = Math.max(maxManaCost, cost.getMana());
            }
        }
        boolean addedMaterials = false;
        LinkedList remainingMaterials = this.getRemainingMaterials(wand);
        if (needsMaterials && remainingMaterials.size() > 0) {
            int currentMaterialCount = wand.getBrushes().size();
            Integer materialCount = (Integer)RandomUtils.weightedRandom(this.materialCountProbability);
            if (materialCount == null) {
                materialCount = 0;
            }
            if (currentMaterialCount == 0) {
                materialCount = Math.max(1, materialCount);
            }
            int retries = 100;
            for (int i = 0; i < materialCount; ++i) {
                String materialKey = (String)RandomUtils.weightedRandom(remainingMaterials);
                if (!wand.addBrush(materialKey = materialKey.replace("|", ":"))) {
                    if (retries-- <= 0) continue;
                    --i;
                    continue;
                }
                addedMaterials = true;
            }
        }
        if (hasUpgrade && addSpells && (!addedMaterials || !needsMaterials) && !addedSpells && (this.getSpellCount() > 0 && this.spellProbability.size() > 0 || this.getMaterialCount() > 0 && this.materialProbability.size() > 0)) {
            if (mage != null && mage.getDebugLevel() > 0) {
                mage.sendDebugMessage("Has upgrade: " + hasUpgrade);
                mage.sendDebugMessage("Added spells: " + addedSpells + " (" + addSpells + ")");
                mage.sendDebugMessage("Spells per enchant: " + this.getSpellCount());
                mage.sendDebugMessage("Spells in list: " + this.spellProbability.size());
                mage.sendDebugMessage("Added brushes: " + addedMaterials + ", needed: " + needsMaterials);
            }
            wand.setActiveMage(activeMage);
            return false;
        }
        boolean addedProperties = false;
        Integer propertyCount = this.propertyCountProbability.size() == 0 ? Integer.valueOf(0) : (Integer)RandomUtils.weightedRandom(this.propertyCountProbability);
        MemoryConfiguration wandProperties = new MemoryConfiguration();
        ArrayList<String> propertyKeys = new ArrayList<String>(this.propertiesProbability.keySet());
        ArrayList<String> propertiesAvailable = new ArrayList<String>();
        for (String string : propertyKeys) {
            double maxValue;
            double currentValue = wand.getDouble(string);
            if (!(currentValue < (maxValue = this.path.getMaxProperty(string)))) continue;
            propertiesAvailable.add(string);
        }
        if (propertiesAvailable.size() > 0 && !addedMaterials && !addedSpells && propertyCount == 0) {
            propertyCount = 1;
        }
        while (propertyCount != null) {
            Integer n = propertyCount;
            Integer n2 = propertyCount = Integer.valueOf(propertyCount - 1);
            if (n <= 0 || propertiesAvailable.size() <= 0) break;
            int randomPropertyIndex = (int)(Math.random() * (double)propertiesAvailable.size());
            String string = (String)propertiesAvailable.get(randomPropertyIndex);
            LinkedList probabilities = this.propertiesProbability.get(string);
            double current = wand.getDouble(string);
            double maxValue = this.path.getMaxProperty(string);
            if (probabilities.size() <= 0 || !(current < maxValue)) continue;
            addedProperties = true;
            current = Math.min(maxValue, current + (double)((Float)RandomUtils.weightedRandom(probabilities)).floatValue());
            wandProperties.set(string, (Object)current);
        }
        if (wand.isCostFree()) {
            wandProperties.set("mana_regeneration", (Object)0);
            wandProperties.set("mana_max", (Object)0);
            wandProperties.set("mana", (Object)0);
        } else {
            int n;
            int manaRegeneration = wand.getManaRegeneration();
            if (this.manaRegenerationProbability.size() > 0 && manaRegeneration < this.path.getMaxManaRegeneration()) {
                addedProperties = true;
                manaRegeneration = Math.min(this.path.getMaxManaRegeneration(), manaRegeneration + (Integer)RandomUtils.weightedRandom(this.manaRegenerationProbability));
                wandProperties.set("mana_regeneration", (Object)manaRegeneration);
            }
            int n3 = wand.getManaMax();
            if (this.manaMaxProbability.size() > 0 && n3 < this.path.getMaxMaxMana()) {
                int n4 = Math.min(this.path.getMaxMaxMana(), n3 + (Integer)RandomUtils.weightedRandom(this.manaMaxProbability));
                if (this.path.getMatchSpellMana()) {
                    n = Math.max(maxManaCost, n4);
                }
                wandProperties.set("mana_max", (Object)n);
                addedProperties = true;
            }
            wandProperties.set("mana", (Object)n);
        }
        if (additive) {
            int wandUses = wand.getRemainingUses();
            if (wandUses > 0 && wandUses < this.path.getMaxUses() && this.addUseProbability.size() > 0) {
                wandProperties.set("uses", (Object)Math.min(this.path.getMaxUses(), wandUses + (Integer)RandomUtils.weightedRandom(this.addUseProbability)));
                addedProperties = true;
            }
        } else if (this.useProbability.size() > 0) {
            wandProperties.set("uses", (Object)Math.min(this.path.getMaxUses(), (Integer)RandomUtils.weightedRandom(this.useProbability)));
        }
        wand.upgrade((ConfigurationSection)wandProperties);
        wand.setActiveMage(activeMage);
        return addedMaterials || addedSpells || addedProperties;
    }

    public int getSpellProbabilityCount() {
        return this.spellProbability.size();
    }

    public int getMaterialProbabilityCount() {
        return this.materialProbability.size();
    }
}

