/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.block.BlockData;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.utility.Targeting;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class EntityController
implements Listener {
    private final MagicController controller;
    private double meleeDamageReduction = 0.0;
    private boolean preventMeleeDamage = false;
    private boolean keepWandsOnDeath = true;
    private boolean disableItemSpawn = false;
    private boolean forceSpawn = false;
    private boolean preventWandMeleeDamage = true;
    private int ageDroppedItems = 0;
    private Map<EntityType, Double> entityDamageReduction;

    public void loadProperties(ConfigurationSection properties) {
        this.preventMeleeDamage = properties.getBoolean("prevent_melee_damage", false);
        this.meleeDamageReduction = properties.getDouble("melee_damage_reduction", 0.0);
        this.keepWandsOnDeath = properties.getBoolean("keep_wands_on_death", true);
        this.preventWandMeleeDamage = properties.getBoolean("prevent_wand_melee_damage", true);
        this.ageDroppedItems = properties.getInt("age_dropped_items", 0);
        ConfigurationSection entityReduction = properties.getConfigurationSection("entity_damage_reduction");
        if (entityReduction != null) {
            Set keys = entityReduction.getKeys(false);
            this.entityDamageReduction = new HashMap<EntityType, Double>();
            for (String key : keys) {
                try {
                    EntityType entityType = EntityType.valueOf((String)key.toUpperCase());
                    this.entityDamageReduction.put(entityType, entityReduction.getDouble(key));
                }
                catch (Exception ex) {
                    this.controller.getLogger().warning("Invalid entity type found in entity_damage_reduction: " + key);
                }
            }
        } else {
            this.entityDamageReduction = null;
        }
    }

    public EntityController(MagicController controller) {
        this.controller = controller;
    }

    public void setDisableItemSpawn(boolean disable) {
        this.disableItemSpawn = disable;
    }

    public void setForceSpawn(boolean forceSpawn) {
        this.forceSpawn = forceSpawn;
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.HIGHEST)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (this.forceSpawn) {
            event.setCancelled(false);
        }
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        Projectile projectile = event.getEntity();
        Targeting.checkTracking((Plugin)this.controller.getPlugin(), (Entity)projectile, null);
    }

    @EventHandler
    public void onEntityCombust(EntityCombustEvent event) {
        com.elmakers.mine.bukkit.api.block.UndoList undoList;
        Entity entity = event.getEntity();
        Mage apiMage = this.controller.getRegisteredMage(entity);
        if (apiMage != null && apiMage instanceof Mage) {
            Mage mage = apiMage;
            mage.onPlayerCombust(event);
        }
        if (!event.isCancelled() && (undoList = this.controller.getPendingUndo(entity.getLocation())) != null) {
            undoList.modify(entity);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Projectile || entity instanceof TNTPrimed) {
            return;
        }
        Entity damager = event.getDamager();
        com.elmakers.mine.bukkit.api.block.UndoList undoList = this.controller.getEntityUndo(damager);
        if (undoList != null) {
            if (event.getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK || undoList.isScheduled()) {
                undoList.damage(entity);
                if (!entity.isValid()) {
                    event.setCancelled(true);
                }
            } else {
                undoList.modify(entity);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityPreDamageByEntity(EntityDamageByEntityEvent event) {
        Double reduction;
        Entity entity = event.getEntity();
        if (entity instanceof Projectile || entity instanceof TNTPrimed) {
            return;
        }
        Mage entityMage = this.controller.getRegisteredMage(entity);
        if (entityMage != null) {
            com.elmakers.mine.bukkit.api.wand.Wand damagedWand;
            Player damaged;
            entityMage.damagedBy(event.getDamager(), event.getDamage());
            if (entity instanceof Player && (damaged = (Player)entity).isBlocking() && (damagedWand = entityMage.getActiveWand()) != null) {
                damagedWand.playEffects("hit_blocked");
            }
            if (entityMage.isSuperProtected()) {
                event.setCancelled(true);
                return;
            }
        }
        Entity damager = event.getDamager();
        if (this.entityDamageReduction != null && (reduction = this.entityDamageReduction.get(damager.getType())) != null) {
            if (reduction >= 1.0) {
                event.setCancelled(true);
                return;
            }
            event.setDamage(event.getDamage() * (1.0 - reduction));
        }
        if (damager instanceof Player) {
            boolean isMelee;
            Mage damagerMage = this.controller.getRegisteredMage(damager);
            com.elmakers.mine.bukkit.api.wand.Wand activeWand = null;
            boolean bl = isMelee = event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK && !CompatibilityUtils.isDamaging;
            if (isMelee && this.meleeDamageReduction > 0.0) {
                if (this.meleeDamageReduction >= 1.0) {
                    event.setCancelled(true);
                    return;
                }
                event.setDamage(event.getDamage() * (1.0 - this.meleeDamageReduction));
            }
            if (isMelee && damagerMage != null && (activeWand = damagerMage.getActiveWand()) != null) {
                activeWand.playEffects("hit_entity");
                activeWand.damageDealt(event.getDamage(), entity);
            }
            if (this.preventWandMeleeDamage) {
                boolean hasWand = activeWand != null;
                Player player = (Player)damager;
                ItemStack itemInHand = player.getInventory().getItemInMainHand();
                boolean isMeleeWeapon = this.controller.isMeleeWeapon(itemInHand);
                if (isMelee && hasWand && !isMeleeWeapon) {
                    event.setCancelled(true);
                    CompatibilityUtils.isDamaging = true;
                    activeWand.performAction(activeWand.getLeftClickAction());
                    CompatibilityUtils.isDamaging = false;
                } else if (!hasWand && this.preventMeleeDamage && isMelee && !isMeleeWeapon) {
                    event.setCancelled(true);
                }
            }
        } else {
            Targeting.checkTracking((Plugin)this.controller.getPlugin(), damager, entity);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDeath(EntityDeathEvent event) {
        Mage apiMage;
        LivingEntity entity = event.getEntity();
        if (entity.hasMetadata("nodrops")) {
            event.setDroppedExp(0);
            event.getDrops().clear();
            entity.removeMetadata("nodrops", (Plugin)this.controller.getPlugin());
        }
        if ((apiMage = this.controller.getRegisteredMage((Entity)entity)) == null) {
            return;
        }
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = apiMage;
        mage.deactivateAllSpells();
        mage.onDeath(event);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        String rule = entity.getWorld().getGameRuleValue("keepInventory");
        if (rule.equals("true")) {
            return;
        }
        List drops = event.getDrops();
        Wand wand = mage.getActiveWand();
        if (wand != null) {
            if (mage.hasStoredInventory()) {
                ItemStack[] stored;
                drops.removeAll(Arrays.asList(player.getInventory().getContents()));
                wand.deactivate();
                for (ItemStack stack : stored = player.getInventory().getContents()) {
                    if (stack == null) continue;
                    drops.add(stack);
                }
            } else {
                wand.deactivate();
            }
        }
        ArrayList<ItemStack> removeDrops = new ArrayList<ItemStack>();
        PlayerInventory inventory = player.getInventory();
        ItemStack[] contents = inventory.getContents();
        for (int index = 0; index < contents.length; ++index) {
            ItemStack itemStack = contents[index];
            if (itemStack == null || itemStack.getType() == Material.AIR) continue;
            if (NMSUtils.isTemporary(itemStack) || Wand.isSkill(itemStack)) {
                removeDrops.add(itemStack);
                continue;
            }
            boolean keepItem = false;
            if (Wand.isWand(itemStack)) {
                keepItem = this.keepWandsOnDeath;
                if (!keepItem) {
                    Wand testWand = this.controller.getWand(itemStack);
                    keepItem = testWand.keepOnDeath();
                }
            } else if (InventoryUtils.isKeep(itemStack)) {
                keepItem = true;
            }
            if (!keepItem) continue;
            mage.addToRespawnInventory(index, itemStack);
            removeDrops.add(itemStack);
        }
        ItemStack[] armor = player.getInventory().getArmorContents();
        for (int index = 0; index < armor.length; ++index) {
            ItemStack itemStack = armor[index];
            if (itemStack == null || itemStack.getType() == Material.AIR) continue;
            if (NMSUtils.isTemporary(itemStack) || Wand.isSkill(itemStack)) {
                removeDrops.add(itemStack);
                continue;
            }
            boolean keepItem = false;
            if (Wand.isWand(itemStack)) {
                keepItem = this.keepWandsOnDeath;
                if (!keepItem) {
                    Wand testWand = this.controller.getWand(itemStack);
                    keepItem = testWand.keepOnDeath();
                }
            } else if (InventoryUtils.isKeep(itemStack)) {
                keepItem = true;
            }
            if (!keepItem) continue;
            mage.addToRespawnArmor(index, itemStack);
            removeDrops.add(itemStack);
        }
        drops.removeAll(removeDrops);
    }

    @EventHandler
    public void onItemDespawn(ItemDespawnEvent event) {
        Item entity = event.getEntity();
        ItemStack itemStack = entity.getItemStack();
        if (Wand.isWand(itemStack)) {
            boolean immortal = this.controller.getWandProperty(itemStack, "immortal", false);
            if (immortal) {
                event.getEntity().setTicksLived(1);
                event.setCancelled(true);
            } else {
                this.controller.removeLostWand(Wand.getWandId(itemStack));
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onItemSpawn(ItemSpawnEvent event) {
        boolean isBreaking;
        if (this.disableItemSpawn) {
            event.setCancelled(true);
            return;
        }
        Item itemEntity = event.getEntity();
        ItemStack spawnedItem = itemEntity.getItemStack();
        Block block = itemEntity.getLocation().getBlock();
        BlockData undoData = UndoList.getBlockData(block.getLocation());
        boolean bl = isBreaking = block.getType() != Material.AIR;
        if (!isBreaking) {
            Set<Material> doubleAttachables = this.controller.getMaterialSet("attachable_double");
            isBreaking = doubleAttachables.contains(spawnedItem.getType());
        }
        if (undoData != null && isBreaking) {
            if (undoData.getMaterial() != Material.AIR) {
                com.elmakers.mine.bukkit.api.block.UndoList undoList = undoData.getUndoList();
                if (undoList != null) {
                    undoList.add(block);
                } else {
                    this.controller.getLogger().warning("Block broken into item under undo at " + block + ", but no undo list was assigned");
                }
                event.setCancelled(true);
                return;
            }
            Collection drops = block.getDrops();
            if (drops != null) {
                for (ItemStack drop : drops) {
                    if (drop.getType() != spawnedItem.getType()) continue;
                    UndoList.commit(undoData);
                    event.setCancelled(true);
                    return;
                }
            }
        }
        if (Wand.isSkill(spawnedItem)) {
            event.setCancelled(true);
            return;
        }
        if (Wand.isWand(spawnedItem)) {
            boolean trackWand;
            boolean invulnerable = this.controller.getWandProperty(spawnedItem, "invulnerable", false);
            if (invulnerable) {
                CompatibilityUtils.setInvulnerable((Entity)event.getEntity());
            }
            if (trackWand = this.controller.getWandProperty(spawnedItem, "track", false).booleanValue()) {
                Wand wand = this.controller.getWand(spawnedItem);
                this.controller.addLostWand(wand, event.getEntity().getLocation());
            }
        } else if (this.ageDroppedItems > 0) {
            int ticks = this.ageDroppedItems * 20 / 1000;
            Item item = event.getEntity();
            CompatibilityUtils.ageItem(item, ticks);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        try {
            Item item;
            ItemStack itemStack;
            Entity entity = event.getEntity();
            Mage apiMage = this.controller.getRegisteredMage(event.getEntity());
            if (apiMage != null) {
                if (!(apiMage instanceof Mage)) {
                    return;
                }
                Mage mage = apiMage;
                mage.onDamage(event);
            } else {
                Entity passenger = entity.getPassenger();
                Mage apiMountMage = this.controller.getRegisteredMage(passenger);
                if (apiMountMage != null) {
                    if (!(apiMountMage instanceof Mage)) {
                        return;
                    }
                    Mage mage = apiMountMage;
                    mage.onDamage(event);
                }
            }
            if (entity instanceof Item && Wand.isWand(itemStack = (item = (Item)entity).getItemStack())) {
                boolean invulnerable = this.controller.getWandProperty(itemStack, "invulnerable", false);
                if (invulnerable) {
                    event.setCancelled(true);
                } else if (event.getDamage() >= (double)itemStack.getDurability()) {
                    String wandId = Wand.getWandId(itemStack);
                    this.controller.removeLostWand(wandId);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @EventHandler
    public void onEntityTarget(EntityTargetLivingEntityEvent event) {
        LivingEntity target = event.getTarget();
        if (target == null) {
            return;
        }
        if (!(target instanceof Player)) {
            return;
        }
        Mage mage = this.controller.getRegisteredMage((Entity)target);
        if (mage == null) {
            return;
        }
        if (mage.isSuperProtected()) {
            event.setCancelled(true);
        }
    }
}

