/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.BlockData;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.block.UndoQueue;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class BlockController
implements Listener {
    private final MagicController controller;
    private boolean undoOnWorldSave = false;
    private int creativeBreakFrequency = 0;
    static final List<BlockFace> blockBurnDirections = Arrays.asList(BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN);

    public BlockController(MagicController controller) {
        this.controller = controller;
    }

    public void setUndoOnWorldSave(boolean undo) {
        this.undoOnWorldSave = undo;
    }

    public void setCreativeBreakFrequency(int frequency) {
        this.creativeBreakFrequency = frequency;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        UndoList undoList;
        BlockData modifiedBlock;
        String lockKey;
        Mage mage;
        Mage apiMage;
        Block block = event.getBlock();
        Player player = event.getPlayer();
        if (this.creativeBreakFrequency > 0 && player.getGameMode() == GameMode.CREATIVE && (apiMage = this.controller.getMage(event.getPlayer())) instanceof Mage && (mage = apiMage).checkLastClick(this.creativeBreakFrequency)) {
            event.setCancelled(true);
            return;
        }
        if (this.controller.areLocksProtected() && this.controller.isContainer(block) && !event.getPlayer().hasPermission("Magic.bypass") && (lockKey = CompatibilityUtils.getLock(block)) != null && !lockKey.isEmpty()) {
            PlayerInventory inventory = player.getInventory();
            Mage mage2 = this.controller.getRegisteredMage((Entity)event.getPlayer());
            if (mage2 != null) {
                inventory = mage2.getInventory();
            }
            if (!InventoryUtils.hasItem((Inventory)inventory, lockKey)) {
                String message = this.controller.getMessages().get("general.locked_chest");
                if (mage2 != null) {
                    mage2.sendMessage(message);
                } else {
                    player.sendMessage(message);
                }
                event.setCancelled(true);
                return;
            }
        }
        if ((modifiedBlock = com.elmakers.mine.bukkit.block.UndoList.getBlockData(block.getLocation())) != null && (undoList = modifiedBlock.getUndoList()) != null) {
            if (!undoList.isConsumed()) {
                event.setCancelled(true);
                block.setType(Material.AIR);
            }
            com.elmakers.mine.bukkit.block.UndoList.commit(modifiedBlock);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        ItemStack itemStack = event.getItemInHand();
        if (NMSUtils.isTemporary(itemStack)) {
            event.setCancelled(true);
            player.getInventory().setItemInMainHand(null);
            return;
        }
        if (NMSUtils.isUnplaceable(itemStack) || Wand.isSpecial(itemStack)) {
            event.setCancelled(true);
            return;
        }
        Mage apiMage = this.controller.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = apiMage;
        if (mage.getBlockPlaceTimeout() > System.currentTimeMillis()) {
            event.setCancelled(true);
        }
        if (Wand.isSpecial(itemStack)) {
            event.setCancelled(true);
        }
        if (!event.isCancelled()) {
            Block block = event.getBlock();
            BlockData modifiedBlock = com.elmakers.mine.bukkit.block.UndoList.getBlockData(block.getLocation());
            if (modifiedBlock != null) {
                com.elmakers.mine.bukkit.block.UndoList.commit(modifiedBlock);
            }
            if (block.getType() == Material.MOB_SPAWNER && event.getItemInHand() != null && event.getItemInHand().getType() == Material.MOB_SPAWNER && player.hasPermission("Magic.spawners")) {
                CompatibilityUtils.applyItemData(event.getItemInHand(), block);
            }
        }
    }

    @EventHandler
    public void onBlockFade(BlockFadeEvent event) {
        Block block = event.getBlock();
        UndoList undoList = this.controller.getPendingUndo(block.getLocation());
        if (undoList != null) {
            undoList.add(block);
        }
    }

    @EventHandler
    public void onPistonExtend(BlockPistonExtendEvent event) {
        Block piston = event.getBlock();
        Block block = piston.getRelative(event.getDirection());
        UndoList undoList = this.controller.getPendingUndo(block.getLocation());
        if (undoList != null) {
            undoList.add(block);
            undoList.add(piston);
        }
    }

    @EventHandler
    public void onBlockFromTo(BlockFromToEvent event) {
        Block targetBlock = event.getToBlock();
        Block sourceBlock = event.getBlock();
        UndoList undoList = this.controller.getPendingUndo(sourceBlock.getLocation());
        if (undoList != null) {
            undoList.add(targetBlock);
        } else {
            undoList = this.controller.getPendingUndo(targetBlock.getLocation());
            if (undoList != null) {
                undoList.add(targetBlock);
            }
        }
        if (undoList != null && undoList.isScheduled()) {
            Set<Material> doubles = com.elmakers.mine.bukkit.block.UndoList.attachablesDouble;
            if (doubles != null && doubles.contains(targetBlock.getType())) {
                Block upBlock = targetBlock.getRelative(BlockFace.UP);
                while (doubles.contains(upBlock.getType())) {
                    undoList.add(upBlock);
                    DeprecatedUtils.setTypeIdAndData(upBlock, Material.AIR.ordinal(), (byte)0, false);
                    upBlock = upBlock.getRelative(BlockFace.UP);
                }
                Block downBlock = targetBlock.getRelative(BlockFace.DOWN);
                while (doubles.contains(downBlock.getType())) {
                    undoList.add(downBlock);
                    DeprecatedUtils.setTypeIdAndData(downBlock, Material.AIR.ordinal(), (byte)0, false);
                    downBlock = downBlock.getRelative(BlockFace.DOWN);
                }
            }
            DeprecatedUtils.setTypeIdAndData(targetBlock, Material.AIR.ordinal(), (byte)0, false);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockBurn(BlockBurnEvent event) {
        Block targetBlock = event.getBlock();
        UndoList undoList = this.controller.getPendingUndo(targetBlock.getLocation());
        if (undoList == null) {
            BlockFace face;
            Block sourceBlock;
            Iterator<BlockFace> iterator = blockBurnDirections.iterator();
            while (iterator.hasNext() && ((sourceBlock = targetBlock.getRelative(face = iterator.next())).getType() != Material.FIRE || (undoList = this.controller.getPendingUndo(sourceBlock.getLocation())) == null)) {
            }
        }
        if (undoList != null) {
            undoList.add(targetBlock);
        }
    }

    @EventHandler
    public void onBlockIgnite(BlockIgniteEvent event) {
        UndoList undoList;
        BlockIgniteEvent.IgniteCause cause = event.getCause();
        if (cause == BlockIgniteEvent.IgniteCause.ENDER_CRYSTAL || cause == BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL) {
            return;
        }
        Entity entity = event.getIgnitingEntity();
        UndoList entityList = this.controller.getEntityUndo(entity);
        if (entityList != null) {
            entityList.add(event.getBlock());
            return;
        }
        Block ignitingBlock = event.getIgnitingBlock();
        Block targetBlock = event.getBlock();
        if (ignitingBlock != null && (undoList = this.controller.getPendingUndo(ignitingBlock.getLocation())) != null) {
            undoList.add(event.getBlock());
            return;
        }
        undoList = this.controller.getPendingUndo(targetBlock.getLocation());
        if (undoList != null) {
            undoList.add(targetBlock);
        }
    }

    @EventHandler
    public void onBlockDamage(BlockDamageEvent event) {
        com.elmakers.mine.bukkit.api.wand.Wand activeWand;
        Player damager = event.getPlayer();
        Mage damagerMage = this.controller.getRegisteredMage((Entity)damager);
        if (damagerMage != null && (activeWand = damagerMage.getActiveWand()) != null) {
            activeWand.playEffects("hit_block");
        }
    }

    @EventHandler
    public void onEntityChangeBlockEvent(EntityChangeBlockEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof FallingBlock) {
            if (event.getTo() == Material.AIR) {
                this.controller.registerFallingBlock(entity, event.getBlock());
            } else {
                UndoList blockList = com.elmakers.mine.bukkit.block.UndoList.getUndoList(entity);
                if (blockList != null) {
                    CastContext context = blockList.getContext();
                    if (context != null && !context.hasBuildPermission(entity.getLocation().getBlock())) {
                        event.setCancelled(true);
                    } else {
                        Block block = event.getBlock();
                        blockList.convert(entity, block);
                        if (!blockList.getApplyPhysics()) {
                            FallingBlock falling = (FallingBlock)entity;
                            DeprecatedUtils.setTypeIdAndData(block, DeprecatedUtils.getId(falling.getMaterial()), DeprecatedUtils.getBlockData(falling), false);
                            event.setCancelled(true);
                        }
                    }
                }
            }
        }
    }

    @EventHandler
    public void onWorldSaveEvent(WorldSaveEvent event) {
        World world = event.getWorld();
        List players = world.getPlayers();
        for (Player player : players) {
            int undone;
            UndoQueue queue;
            Mage mage = this.controller.getRegisteredMage((Entity)player);
            if (mage == null) continue;
            this.controller.saveMage(mage, true);
            if (!this.undoOnWorldSave || (queue = mage.getUndoQueue()) == null || (undone = queue.undoScheduled()) <= 0) continue;
            this.controller.info("Undid " + undone + " spells for " + player.getName() + " prior to save of world " + world.getName());
        }
    }
}

