/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.slikey.effectlib.util.MathUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class SourceLocation {
    private LocationType locationType;
    private boolean orientToTarget;
    private boolean isSource;

    public SourceLocation(ConfigurationSection configuration) {
        this(configuration, "source_location", true);
    }

    public SourceLocation(ConfigurationSection configuration, String sourceKey, boolean isSource) {
        this.isSource = isSource;
        String locationTypeString = configuration.getString(sourceKey, "");
        if (!locationTypeString.isEmpty()) {
            try {
                this.locationType = LocationType.valueOf(locationTypeString.toUpperCase());
            }
            catch (Exception ex) {
                Bukkit.getLogger().warning("Invalid location type specified in source_location parameter: " + locationTypeString);
            }
        }
        if (this.locationType == null) {
            if (configuration.getBoolean("use_block_location", false)) {
                this.locationType = LocationType.BLOCK;
            } else if (configuration.getBoolean("use_eye_location", false)) {
                this.locationType = LocationType.EYES;
            } else if (configuration.getBoolean("use_cast_location", false)) {
                this.locationType = LocationType.CAST;
            } else if (isSource) {
                if (configuration.getBoolean("use_hit_location", false)) {
                    this.locationType = LocationType.HIT;
                } else if (configuration.getBoolean("use_wand_location", true)) {
                    this.locationType = LocationType.WAND;
                } else if (configuration.getBoolean("use_eye_location", true)) {
                    this.locationType = LocationType.EYES;
                }
            } else if (configuration.getBoolean("use_wand_location", false)) {
                this.locationType = LocationType.WAND;
            } else if (configuration.getBoolean("use_hit_location", true)) {
                this.locationType = LocationType.HIT;
            } else if (configuration.getBoolean("use_eye_location", true)) {
                this.locationType = LocationType.EYES;
            }
            if (this.locationType == null) {
                this.locationType = LocationType.FEET;
            }
        }
        this.orientToTarget = configuration.getBoolean("use_target_location", configuration.getBoolean("orient", isSource));
        if (configuration.getBoolean("reorient", false)) {
            this.orientToTarget = false;
        }
    }

    public Location getLocation(CastContext context) {
        Vector direction;
        Location targetLocation;
        Location feetLocation;
        Location eyeLocation;
        Mage mage;
        if (this.isSource) {
            mage = context.getMage();
            eyeLocation = context.getEyeLocation();
            feetLocation = context.getLocation();
        } else {
            Entity targetEntity = context.getTargetEntity();
            if (targetEntity == null) {
                mage = null;
                feetLocation = context.getTargetLocation();
                eyeLocation = context.getTargetLocation();
            } else {
                mage = context.getController().getRegisteredMage(targetEntity);
                feetLocation = targetEntity.getLocation();
                Location location = eyeLocation = targetEntity instanceof LivingEntity ? ((LivingEntity)targetEntity).getEyeLocation() : targetEntity.getLocation();
            }
        }
        if (mage == null && (this.locationType == LocationType.CAST || this.locationType == LocationType.WAND)) {
            this.locationType = LocationType.EYES;
        }
        Location location = null;
        switch (this.locationType) {
            case CAST: {
                if (this.isSource) {
                    location = context.getCastLocation();
                    break;
                }
                location = mage.getCastLocation();
                break;
            }
            case EYES: {
                location = eyeLocation;
                break;
            }
            case FEET: {
                location = feetLocation;
                break;
            }
            case WAND: {
                if (this.isSource) {
                    location = context.getWandLocation();
                    break;
                }
                location = mage.getWandLocation();
                break;
            }
            case BODY: {
                if (eyeLocation == null || feetLocation == null) break;
                location = eyeLocation.clone().add(feetLocation).multiply(0.5);
                break;
            }
            case HIT: {
                location = context.getTargetLocation();
                break;
            }
            case BLOCK: {
                if (feetLocation == null) break;
                location = feetLocation.getBlock().getLocation();
            }
        }
        if (location == null) {
            location = feetLocation;
        }
        Location location2 = targetLocation = this.isSource ? context.getTargetLocation() : context.getLocation();
        if (this.orientToTarget && targetLocation != null && location != null && MathUtils.isFinite((direction = targetLocation.toVector().subtract(location.toVector()).normalize()).getX()) && MathUtils.isFinite(direction.getY()) && MathUtils.isFinite(direction.getZ())) {
            location.setDirection(direction);
        }
        return location;
    }

    public boolean shouldUseWandLocation() {
        return this.locationType == LocationType.WAND;
    }

    public boolean shouldUseCastLocation() {
        return this.locationType == LocationType.CAST;
    }

    public boolean shouldUseEyeLocation() {
        return this.locationType == LocationType.EYES;
    }

    public boolean shouldUseHitLocation() {
        return this.locationType == LocationType.HIT;
    }

    public boolean shouldUseBlockLocation() {
        return this.locationType == LocationType.BLOCK;
    }

    private static enum LocationType {
        CAST,
        EYES,
        FEET,
        WAND,
        BODY,
        HIT,
        BLOCK;

    }
}

