/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.ProgressionPath;
import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.magic.BaseMagicConfigurable;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicPropertyType;
import com.elmakers.mine.bukkit.magic.ManaController;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;

public abstract class CasterProperties
extends BaseMagicConfigurable
implements com.elmakers.mine.bukkit.api.magic.CasterProperties {
    protected int effectiveManaMax = 0;
    protected int effectiveManaRegeneration = 0;

    public CasterProperties(MagicPropertyType type, MageController controller) {
        super(type, controller);
    }

    public boolean hasOwnMana() {
        MagicPropertyType propertyType = (MagicPropertyType)((Object)this.propertyRoutes.get("mana"));
        return propertyType == null || propertyType == this.type;
    }

    @Override
    public int getManaRegeneration() {
        ManaController manaController = this.controller.getManaController();
        if (manaController != null && this.isPlayer()) {
            return manaController.getManaRegen(this.getPlayer());
        }
        return this.getInt("mana_regeneration", this.getInt("xp_regeneration"));
    }

    @Override
    public int getManaMax() {
        ManaController manaController = this.controller.getManaController();
        if (manaController != null && this.isPlayer()) {
            return manaController.getMaxMana(this.getPlayer());
        }
        return this.getInt("mana_max", this.getInt("xp_max"));
    }

    @Override
    public void setMana(float mana) {
        if (this.isCostFree()) {
            this.setProperty("mana", null);
        } else {
            ManaController manaController = this.controller.getManaController();
            if (manaController != null && this.isPlayer()) {
                manaController.setMana(this.getPlayer(), mana);
                return;
            }
            this.setProperty("mana", Float.valueOf(Math.max(0.0f, mana)));
        }
    }

    @Override
    public void setManaMax(int manaMax) {
        this.setProperty("mana_max", Math.max(0, manaMax));
    }

    @Override
    public void setManaRegeneration(int manaRegeneration) {
        this.setProperty("mana_regeneration", Math.max(0, manaRegeneration));
    }

    @Override
    public float getMana() {
        ManaController manaController = this.controller.getManaController();
        if (manaController != null && this.isPlayer()) {
            return manaController.getMana(this.getPlayer());
        }
        return this.getFloat("mana", this.getFloat("xp"));
    }

    public void removeMana(float amount) {
        ManaController manaController = this.controller.getManaController();
        if (manaController != null && this.isPlayer()) {
            manaController.removeMana(this.getPlayer(), amount);
            return;
        }
        this.setMana(this.getMana() - amount);
    }

    public float getManaRegenerationBoost() {
        return this.getFloat("mana_regeneration_boost", this.getFloat("xp_regeneration_boost"));
    }

    public float getManaMaxBoost() {
        return this.getFloat("mana_max_boost", this.getFloat("xp_max_boost"));
    }

    public boolean isCostFree() {
        return this.getFloat("cost_reduction") > 1.0f;
    }

    public int getEffectiveManaMax() {
        ManaController manaController = this.controller.getManaController();
        if (manaController != null && this.isPlayer()) {
            return manaController.getMaxMana(this.getPlayer());
        }
        return this.effectiveManaMax;
    }

    public int getEffectiveManaRegeneration() {
        ManaController manaController = this.controller.getManaController();
        if (manaController != null && this.isPlayer()) {
            return manaController.getManaRegen(this.getPlayer());
        }
        return this.effectiveManaRegeneration;
    }

    protected long getLastManaRegeneration() {
        return this.getLong("mana_timestamp");
    }

    public void armorUpdated() {
    }

    public boolean updateMaxMana(Mage mage) {
        if (!this.usesMana()) {
            return false;
        }
        int currentMana = this.effectiveManaMax;
        int currentManaRegen = this.effectiveManaRegeneration;
        float effectiveBoost = this.getManaMaxBoost();
        float effectiveRegenBoost = this.getManaRegenerationBoost();
        if (mage != null) {
            Wand offhandWand;
            Collection<Wand> activeArmor = mage.getActiveArmor();
            for (Wand armorWand : activeArmor) {
                effectiveBoost += armorWand.getManaMaxBoost();
                effectiveRegenBoost += armorWand.getManaRegenerationBoost();
            }
            Wand activeWand = mage.getActiveWand();
            if (activeWand != null && !activeWand.isPassive()) {
                effectiveBoost += activeWand.getManaMaxBoost();
                effectiveRegenBoost += activeWand.getManaRegenerationBoost();
            }
            if ((offhandWand = mage.getOffhandWand()) != null && !offhandWand.isPassive()) {
                effectiveBoost += offhandWand.getManaMaxBoost();
                effectiveRegenBoost += offhandWand.getManaRegenerationBoost();
            }
        }
        boolean boostable = this.getBoolean("boostable", true);
        this.effectiveManaMax = this.getManaMax();
        if (boostable && effectiveBoost != 0.0f) {
            this.effectiveManaMax = (int)Math.ceil((float)this.effectiveManaMax + effectiveBoost * (float)this.effectiveManaMax);
        }
        this.effectiveManaRegeneration = this.getManaRegeneration();
        if (boostable && effectiveRegenBoost != 0.0f) {
            this.effectiveManaRegeneration = (int)Math.ceil((float)this.effectiveManaRegeneration + effectiveRegenBoost * (float)this.effectiveManaRegeneration);
        }
        return currentMana != this.effectiveManaMax || this.effectiveManaRegeneration != currentManaRegen;
    }

    public boolean usesMana() {
        if (this.isCostFree()) {
            return false;
        }
        return this.getManaMax() > 0;
    }

    public boolean tickMana() {
        boolean updated = false;
        if (this.usesMana() && this.hasOwnMana()) {
            long now = System.currentTimeMillis();
            long lastManaRegeneration = this.getLastManaRegeneration();
            int effectiveManaRegeneration = this.getEffectiveManaRegeneration();
            if (lastManaRegeneration > 0L && effectiveManaRegeneration > 0) {
                long delta = now - lastManaRegeneration;
                int effectiveManaMax = this.getEffectiveManaMax();
                int manaMax = this.getManaMax();
                float mana = this.getMana();
                if (effectiveManaMax == 0 && manaMax > 0) {
                    effectiveManaMax = manaMax;
                }
                this.setMana(Math.min((float)effectiveManaMax, mana + (float)effectiveManaRegeneration * (float)delta / 1000.0f));
                updated = true;
            }
            lastManaRegeneration = now;
            this.setProperty("mana_timestamp", lastManaRegeneration);
        }
        return updated;
    }

    public void tick() {
        this.tickMana();
    }

    @Override
    public boolean addSpell(String spellKey) {
        SpellKey key;
        Collection<String> spells = this.getSpells();
        boolean modified = spells.add((key = new SpellKey(spellKey)).getBaseKey());
        if (modified) {
            this.setProperty("spells", new ArrayList<String>(spells));
        }
        boolean levelModified = false;
        if (key.getLevel() > 1) {
            levelModified = this.upgradeSpellLevel(key.getBaseKey(), key.getLevel());
        }
        return modified || levelModified;
    }

    @Override
    public boolean addBrush(String brushKey) {
        Collection<String> brushes = this.getBrushes();
        boolean modified = brushes.add(brushKey);
        if (modified) {
            this.setProperty("brushes", new ArrayList<String>(brushes));
        }
        return modified;
    }

    public boolean removeSpell(String spellKey) {
        SpellKey key;
        Collection<String> spells = this.getSpells();
        boolean modified = spells.remove((key = new SpellKey(spellKey)).getBaseKey());
        if (modified) {
            this.setProperty("spells", new ArrayList<String>(spells));
            Map<String, Object> spellLevels = this.getSpellLevels();
            if (spellLevels.remove(key.getBaseKey()) != null) {
                this.setProperty("spell_levels", spellLevels);
            }
        }
        return modified;
    }

    public boolean removeBrush(String brushKey) {
        Collection<String> brushes = this.getBrushes();
        boolean modified = brushes.remove(brushKey);
        if (modified) {
            this.setProperty("brushes", new ArrayList<String>(brushes));
        }
        return modified;
    }

    public int getSpellLevel(String spellKey) {
        Map<String, Object> spellLevels = this.getSpellLevels();
        Object level = spellLevels.get(spellKey);
        return level == null || !(level instanceof Integer) ? 1 : (Integer)level;
    }

    public SpellTemplate getBaseSpell(String spellKey) {
        SpellKey key = new SpellKey(spellKey);
        Collection<String> spells = this.getSpells();
        if (!spells.contains(key.getBaseKey())) {
            return null;
        }
        SpellKey baseKey = new SpellKey(key.getBaseKey(), this.getSpellLevel(key.getBaseKey()));
        return this.controller.getSpellTemplate(baseKey.getKey());
    }

    public void updateMana() {
    }

    @Override
    public boolean hasSpell(String spellKey) {
        return this.getSpells().contains(spellKey);
    }

    @Override
    public Collection<String> getSpells() {
        Object existingSpells = this.getObject("spells");
        HashSet<String> spells = new HashSet<String>();
        if (existingSpells != null) {
            if (!(existingSpells instanceof List)) {
                this.controller.getLogger().warning("Spell list in " + (Object)((Object)this.type) + " is " + existingSpells.getClass().getName() + ", expected List");
            } else {
                List existingList = (List)existingSpells;
                spells.addAll(existingList);
            }
        }
        return spells;
    }

    public Collection<String> getBrushes() {
        Object existingBrushes = this.getObject("brushes");
        HashSet<String> brushes = new HashSet<String>();
        if (existingBrushes != null) {
            if (!(existingBrushes instanceof List)) {
                this.controller.getLogger().warning("Brush list in " + (Object)((Object)this.type) + " is " + existingBrushes.getClass().getName() + ", expected List");
            } else {
                List existingList = (List)existingBrushes;
                brushes.addAll(existingList);
            }
        }
        return brushes;
    }

    @Override
    public ProgressionPath getPath() {
        String pathKey = this.getString("path");
        if (pathKey != null && !pathKey.isEmpty()) {
            return this.controller.getPath(pathKey);
        }
        return null;
    }

    @Override
    public boolean canProgress() {
        ProgressionPath path = this.getPath();
        return path != null && path.canProgress(this);
    }

    public abstract boolean isPlayer();

    public abstract Player getPlayer();

    @Override
    public abstract Mage getMage();
}

