/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration.skript;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageClass;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Active Spell")
@Description(value={"The active spell for a player"})
@Examples(value={"active spell of player"})
public class ExprActiveSpell
extends SimplePropertyExpression<Player, String> {
    public static void register() {
        ExprActiveSpell.register(ExprActiveSpell.class, String.class, (String)"active spell", (String)"players");
    }

    protected String[] get(Event e, Player[] source) {
        return (String[])super.get((Object[])source, (Converter)new Converter<Player, String>(){

            public String convert(Player p) {
                Mage mage = MagicPlugin.getAPI().getController().getRegisteredMage((Entity)p);
                if (mage == null) {
                    return "";
                }
                Wand wand = mage.getActiveWand();
                if (wand != null) {
                    return wand.getActiveSpellKey();
                }
                MageClass mageClass = mage.getActiveClass();
                if (mageClass != null) {
                    return mageClass.getProperty("active_spell", "");
                }
                return mage.getProperties().getProperty("active_spell", "");
            }
        });
    }

    @Nullable
    public String convert(Player p) {
        assert (false);
        return null;
    }

    public Class<String> getReturnType() {
        return String.class;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.SET && mode != Changer.ChangeMode.REMOVE_ALL) {
            return null;
        }
        return new Class[]{String.class};
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        assert (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE_ALL);
        block4: for (Player p : (Player[])this.getExpr().getArray(e)) {
            Wand wand;
            Mage mage = MagicPlugin.getAPI().getController().getRegisteredMage((Entity)p);
            if (mage == null || (wand = mage.getActiveWand()) == null) continue;
            String newSpell = delta == null ? null : (String)delta[0];
            int level = this.getTime() > 0 && e instanceof PlayerDeathEvent && ((PlayerDeathEvent)e).getEntity() == p && !Delay.isDelayed((Event)e) ? ((PlayerDeathEvent)e).getNewLevel() : p.getLevel();
            switch (mode) {
                case SET: {
                    wand.setActiveSpell(newSpell);
                    continue block4;
                }
                case REMOVE_ALL: {
                    wand.setActiveSpell(null);
                    continue block4;
                }
                default: {
                    assert (false);
                    continue block4;
                }
            }
        }
    }

    protected String getPropertyName() {
        return "active spell";
    }
}

