/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.api.requirements;

import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.ConfigurationSection;

public class Requirement {
    public static final String DEFAULT_TYPE = "magic";
    private final String type;
    private final ConfigurationSection configuration;

    public Requirement(ConfigurationSection configuration) {
        this.configuration = configuration;
        this.type = configuration.getString("type", DEFAULT_TYPE);
    }

    @Nonnull
    public String getType() {
        return this.type;
    }

    @Nonnull
    public ConfigurationSection getConfiguration() {
        return this.configuration;
    }

    public String toString() {
        ArrayList<String> pairs = new ArrayList<String>();
        Set keys = this.configuration.getKeys(true);
        for (String key : keys) {
            pairs.add(key + ":" + this.configuration.getString(key));
        }
        return "{" + StringUtils.join(pairs, (String)",") + "}";
    }
}

