/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;

public class MultiplyAction
extends CompoundAction {
    private List<ActionHandler> remaining = null;
    private List<ActionHandler> multiplied = null;
    private int multiply;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.multiply = ConfigurationUtils.getInteger(parameters, "multiply", ConfigurationUtils.getInteger(parameters, "repeat", 2));
        this.multiplied = new ArrayList<ActionHandler>();
        ActionHandler base = this.getHandler("actions");
        if (base != null) {
            ConfigurationSection initialParameters = ConfigurationUtils.getConfigurationSection(parameters, "first");
            if (initialParameters != null) {
                ConfigurationSection combined = ConfigurationUtils.addConfigurations((ConfigurationSection)new MemoryConfiguration(), parameters);
                initialParameters = ConfigurationUtils.addConfigurations(combined, initialParameters);
            }
            for (int i = 0; i < this.multiply; ++i) {
                ActionHandler handler = (ActionHandler)base.clone();
                if (i == 0 && initialParameters != null) {
                    handler.prepare(context, initialParameters);
                } else {
                    handler.prepare(context, parameters);
                }
                this.multiplied.add(handler);
            }
        }
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.remaining = new ArrayList<ActionHandler>(this.multiplied);
        for (ActionHandler handler : this.remaining) {
            handler.reset(context);
        }
    }

    @Override
    public void finish(CastContext context) {
        super.reset(context);
        for (ActionHandler handler : this.multiplied) {
            handler.finish(context);
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        SpellResult result = SpellResult.NO_ACTION;
        if (this.remaining.size() == 0) {
            return result;
        }
        int startingWork = context.getWorkAllowed();
        ArrayList<ActionHandler> subActions = new ArrayList<ActionHandler>(this.remaining);
        this.remaining.clear();
        context.setWorkAllowed(0);
        int splitWork = Math.max(1, startingWork / subActions.size());
        for (ActionHandler action : subActions) {
            context.setWorkAllowed(context.getWorkAllowed() + splitWork);
            SpellResult actionResult = action.perform(context);
            context.addResult(actionResult);
            if (actionResult.isStop()) {
                this.remaining.add(action);
            }
            result = result.min(actionResult);
        }
        return result;
    }
}

