/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class BrushAction
extends CompoundAction {
    private List<String> brushes = new ArrayList<String>();
    private boolean sample = false;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        List brushList;
        super.prepare(context, parameters);
        this.brushes.clear();
        String materialKey = parameters.getString("brush", null);
        if (materialKey != null) {
            this.addBrush(materialKey);
        }
        if ((brushList = parameters.getStringList("brushes")) != null) {
            for (String brushKey : brushList) {
                this.addBrush(brushKey);
            }
        }
        this.sample = parameters.getBoolean("sample", false);
    }

    protected void addBrush(String brushKey) {
        this.brushes.add(brushKey);
    }

    @Override
    public SpellResult step(CastContext context) {
        if (this.brushes.size() == 0 && !this.sample) {
            return this.startActions();
        }
        if (this.sample) {
            Block targetBlock = context.getTargetBlock();
            if (targetBlock != null) {
                Mage mage = context.getMage();
                MaterialBrush brush = new MaterialBrush(mage, targetBlock);
                this.actionContext.setBrush(brush);
            }
        } else {
            String brushKey = this.brushes.get(context.getRandom().nextInt(this.brushes.size()));
            MaterialBrush brush = new MaterialBrush(context.getMage(), context.getLocation(), brushKey);
            this.actionContext.setBrush(brush);
        }
        return this.startActions();
    }

    @Override
    public boolean usesBrush() {
        return false;
    }
}

