/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.utility.Targeting;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public abstract class BaseProjectileAction
extends CompoundAction {
    private long lifetime;
    private boolean setTarget;
    private String projectileEffectsKey;
    protected boolean track = false;
    private Set<Entity> tracking;
    private long expiration;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.lifetime = parameters.getLong("lifetime", 10000L);
        this.setTarget = parameters.getBoolean("set_target", false);
        this.track = parameters.getBoolean("track_projectile", this.track);
        this.projectileEffectsKey = parameters.getString("projectile_effects", "projectile");
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.expiration = System.currentTimeMillis() + this.lifetime;
        this.tracking = null;
    }

    @Override
    public SpellResult step(CastContext context) {
        if (this.tracking == null || this.tracking.size() == 0) {
            this.tracking = null;
            return SpellResult.CAST;
        }
        if (System.currentTimeMillis() > this.expiration) {
            for (Entity entity : this.tracking) {
                entity.removeMetadata("track", context.getPlugin());
                entity.removeMetadata("damaged", context.getPlugin());
                entity.removeMetadata("hit", context.getPlugin());
                entity.remove();
            }
            context.getMage().sendDebugMessage(ChatColor.DARK_GRAY + "Projectiles expired", 4);
            this.tracking = null;
            return SpellResult.NO_TARGET;
        }
        for (Entity entity : this.tracking) {
            if (entity.isValid() && !entity.hasMetadata("hit")) continue;
            this.tracking.remove(entity);
            Plugin plugin = context.getPlugin();
            entity.removeMetadata("track", plugin);
            Entity targetEntity = null;
            Location targetLocation = entity.getLocation();
            List metadata = entity.getMetadata("hit");
            for (MetadataValue value : metadata) {
                Object o;
                if (!value.getOwningPlugin().equals(plugin) || (o = value.value()) == null || !(o instanceof WeakReference)) continue;
                WeakReference reference = (WeakReference)o;
                if ((o = reference.get()) == null || !(o instanceof Entity)) break;
                targetEntity = (Entity)o;
                targetLocation = targetEntity.getLocation();
                break;
            }
            if (targetEntity == null) {
                context.getMage().sendDebugMessage(ChatColor.GRAY + "Projectile missed", 4);
            } else {
                context.getMage().sendDebugMessage(ChatColor.GREEN + "Projectile hit " + ChatColor.GOLD + targetEntity.getType());
            }
            entity.removeMetadata("hit", plugin);
            this.createActionContext(context, context.getMage().getEntity(), entity.getLocation(), targetEntity, targetLocation);
            this.actionContext.playEffects("hit");
            SpellResult result = this.startActions();
            result = targetEntity != null ? result.min(SpellResult.CAST) : result.min(SpellResult.NO_TARGET);
            context.addResult(result);
            return result;
        }
        return SpellResult.PENDING;
    }

    @Override
    public boolean next(CastContext context) {
        return this.tracking != null && this.tracking.size() > 0;
    }

    protected void track(CastContext context, Entity entity) {
        if (this.tracking == null) {
            this.tracking = new HashSet<Entity>();
        }
        this.tracking.add(entity);
        context.registerForUndo(entity);
        if (this.setTarget) {
            context.setTargetEntity(entity);
        }
        Collection<EffectPlayer> projectileEffects = context.getEffects(this.projectileEffectsKey);
        for (EffectPlayer effectPlayer : projectileEffects) {
            effectPlayer.start(entity.getLocation(), entity, null, null);
        }
        if (this.track) {
            Targeting.track(context.getPlugin(), entity);
        }
    }

    protected SpellResult checkTracking(CastContext context) {
        if (this.tracking == null) {
            return SpellResult.FAIL;
        }
        if (!this.track && !this.hasActions()) {
            if (!context.hasEffects("hit")) {
                this.tracking = null;
            }
            return SpellResult.CAST;
        }
        return SpellResult.NO_TARGET;
    }
}

