/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class TowerSpell
extends BlockSpell {
    private static final int MAX_HEIGHT = 255;
    private int blocksCreated;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        int i;
        this.blocksCreated = 0;
        Block target = this.getTargetBlock();
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(target)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int height = 16;
        int maxHeight = 255;
        int material = 20;
        int midX = target.getX();
        int midY = target.getY();
        int midZ = target.getZ();
        for (i = height; i < maxHeight; ++i) {
            int y = midY + i;
            if (y > 255) {
                maxHeight = 255 - midY;
                height = height > maxHeight ? maxHeight : height;
                break;
            }
            Block block = target.getWorld().getBlockAt(midX, y, midZ);
            if (block.getType() == Material.AIR) continue;
            height = i;
            break;
        }
        for (i = 0; i < height; ++i) {
            ++midY;
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    Block block;
                    int x = midX + dx;
                    int y = midY;
                    int z = midZ + dz;
                    if (dx == 0 && dz == 0 || !this.isDestructible(block = target.getWorld().getBlockAt(x, y, z)) || !this.hasBuildPermission(block)) continue;
                    ++this.blocksCreated;
                    this.registerForUndo(block);
                    block.setTypeId(material);
                }
            }
        }
        this.registerForUndo();
        return SpellResult.CAST;
    }

    @Override
    public String getMessage(String messageKey, String def) {
        String message = super.getMessage(messageKey, def);
        return message.replace("$count", Integer.toString(this.blocksCreated));
    }
}

