/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.api.batch.Batch;
import com.elmakers.mine.bukkit.api.batch.SpellBatch;
import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;

public class ActionSpell
extends BrushSpell {
    private Map<String, ActionHandler> actions = new HashMap<String, ActionHandler>();
    private boolean undoable = false;
    private boolean requiresBuildPermission = false;
    private boolean requiresBreakPermission = false;
    private ActionHandler currentHandler = null;
    private Map<String, ConfigurationSection> handlerParameters = new HashMap<String, ConfigurationSection>();
    private int workThreshold = 500;

    @Override
    protected void processResult(SpellResult result, ConfigurationSection castParameters) {
        ActionHandler handler;
        if (!result.isSuccess() && (handler = this.actions.get(result.name().toLowerCase())) != null) {
            handler.start(this.currentCast, castParameters);
        }
        super.processResult(result, castParameters);
    }

    @Override
    protected boolean isLegacy() {
        return false;
    }

    @Override
    protected boolean isBatched() {
        return true;
    }

    @Override
    public boolean hasHandlerParameters(String handlerKey) {
        return this.handlerParameters.containsKey(handlerKey);
    }

    @Override
    public ConfigurationSection getHandlerParameters(String handlerKey) {
        return this.handlerParameters.get(handlerKey);
    }

    @Override
    public void processParameters(ConfigurationSection parameters) {
        ConfigurationSection alternateParameters = null;
        if (this.isLookingDown()) {
            alternateParameters = this.getHandlerParameters("alternate_down");
        } else if (this.isLookingUp()) {
            alternateParameters = this.getHandlerParameters("alternate_down");
        } else if (this.mage.isSneaking()) {
            alternateParameters = this.getHandlerParameters("alternate_sneak");
        } else if (this.mage.isJumping()) {
            alternateParameters = this.getHandlerParameters("alternate_jumping");
        }
        if (alternateParameters != null) {
            parameters = parameters == null ? alternateParameters : ConfigurationUtils.addConfigurations(parameters, alternateParameters, true);
        }
        super.processParameters(parameters);
    }

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        this.currentCast.setWorkAllowed(this.workThreshold);
        SpellResult result = SpellResult.CAST;
        this.currentHandler = this.actions.get("cast");
        ActionHandler downHandler = this.actions.get("alternate_down");
        ActionHandler upHandler = this.actions.get("alternate_up");
        ActionHandler sneakHandler = this.actions.get("alternate_sneak");
        ActionHandler jumpHandler = this.actions.get("alternate_jumping");
        this.workThreshold = parameters.getInt("work_threshold", 500);
        if (downHandler != null && this.isLookingDown()) {
            result = SpellResult.ALTERNATE_DOWN;
            this.currentHandler = downHandler;
        } else if (upHandler != null && this.isLookingUp()) {
            result = SpellResult.ALTERNATE_UP;
            this.currentHandler = upHandler;
        } else if (sneakHandler != null && this.mage.isSneaking()) {
            result = SpellResult.ALTERNATE_SNEAK;
            this.currentHandler = sneakHandler;
        } else if (jumpHandler != null && this.mage.isJumping()) {
            result = SpellResult.ALTERNATE_JUMPING;
            this.currentHandler = jumpHandler;
        }
        if (this.isUndoable()) {
            this.getMage().prepareForUndo(this.getUndoList());
        }
        this.target();
        this.playEffects("precast");
        if (this.currentHandler != null) {
            this.currentHandler = (ActionHandler)this.currentHandler.clone();
            try {
                result = result.max(this.currentHandler.start(this.currentCast, parameters));
                this.currentCast.setInitialResult(result);
            }
            catch (Exception ex) {
                this.controller.getLogger().log(Level.WARNING, "Spell cast failed for " + this.getKey(), ex);
                result = SpellResult.FAIL;
                try {
                    this.currentHandler.finish(this.currentCast);
                }
                catch (Exception finishException) {
                    this.controller.getLogger().log(Level.WARNING, "Failed to clean up failed spell " + this.getKey(), finishException);
                }
            }
        }
        return result;
    }

    @Override
    public void onLoad(ConfigurationSection data) {
        super.onLoad(data);
        for (ActionHandler handler : this.actions.values()) {
            handler.loadData(this.getMage(), data);
        }
    }

    @Override
    public void onSave(ConfigurationSection data) {
        super.onSave(data);
        for (ActionHandler handler : this.actions.values()) {
            handler.saveData(this.getMage(), data);
        }
    }

    @Override
    protected void loadTemplate(ConfigurationSection template) {
        this.castOnNoTarget = true;
        super.loadTemplate(template);
        this.undoable = false;
        this.requiresBuildPermission = false;
        this.requiresBreakPermission = false;
        this.usesBrush = template.getBoolean("uses_brush", false);
        ConfigurationSection actionsNode = template.getConfigurationSection("actions");
        if (actionsNode != null) {
            ConfigurationSection parameters = template.getConfigurationSection("parameters");
            Object baseActions = actionsNode.get("cast");
            Set templateKeys = template.getKeys(false);
            for (String templateKey : templateKeys) {
                if (!templateKey.endsWith("_parameters")) continue;
                ConfigurationSection overrides = ConfigurationUtils.cloneConfiguration(template.getConfigurationSection(templateKey));
                String handlerKey = templateKey.substring(0, templateKey.length() - 11);
                this.handlerParameters.put(handlerKey, overrides);
                if (baseActions == null || actionsNode.contains(handlerKey) || !handlerKey.startsWith("alternate_")) continue;
                actionsNode.set(handlerKey, baseActions);
            }
            if ((actionsNode = ConfigurationUtils.replaceParameters(actionsNode, parameters)) != null) {
                Set actionKeys = actionsNode.getKeys(false);
                for (String actionKey : actionKeys) {
                    ActionHandler handler = new ActionHandler();
                    handler.load(this, actionsNode, actionKey);
                    handler.initialize(this, parameters);
                    this.usesBrush = this.usesBrush || handler.usesBrush();
                    this.undoable = this.undoable || handler.isUndoable();
                    this.requiresBuildPermission = this.requiresBuildPermission || handler.requiresBuildPermission();
                    this.requiresBreakPermission = this.requiresBreakPermission || handler.requiresBreakPermission();
                    this.actions.put(actionKey, handler);
                }
            }
        }
        this.undoable = template.getBoolean("undoable", this.undoable);
        this.requiresBreakPermission = template.getBoolean("require_break", this.requiresBreakPermission);
        this.requiresBuildPermission = template.getBoolean("require_build", this.requiresBuildPermission);
    }

    @Override
    public boolean isUndoable() {
        return this.undoable;
    }

    @Override
    public void getParameters(Collection<String> parameters) {
        super.getParameters(parameters);
        for (ActionHandler handler : this.actions.values()) {
            handler.getParameterNames(this, parameters);
        }
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        super.getParameterOptions(examples, parameterKey);
        for (ActionHandler handler : this.actions.values()) {
            handler.getParameterOptions(this, parameterKey, examples);
        }
    }

    @Override
    public String getMessage(String messageKey, String def) {
        String message = super.getMessage(messageKey, def);
        if (this.currentHandler != null) {
            message = this.currentHandler.transformMessage(message);
        }
        return message;
    }

    @Override
    public boolean requiresBuildPermission() {
        return this.requiresBuildPermission && !this.brushIsErase();
    }

    @Override
    public boolean requiresBreakPermission() {
        return this.requiresBreakPermission || this.requiresBuildPermission && this.brushIsErase();
    }

    @Override
    @Nullable
    public MaterialAndData getEffectMaterial() {
        if (!this.usesBrush) {
            return null;
        }
        return super.getEffectMaterial();
    }

    @Override
    public boolean isActive() {
        if (this.mage == null) {
            return false;
        }
        if (this.toggle == BaseSpell.ToggleType.UNDO && this.toggleUndo != null && !this.toggleUndo.isUndone()) {
            return true;
        }
        Collection<Batch> pendingBatches = this.mage.getPendingBatches();
        for (Batch batch : pendingBatches) {
            if (!(batch instanceof SpellBatch) || ((SpellBatch)batch).getSpell() != this) continue;
            return true;
        }
        return false;
    }
}

