/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.requirements;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageClass;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.ProgressionPath;
import com.elmakers.mine.bukkit.api.requirements.Requirement;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.api.wand.WandUpgradePath;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class MagicRequirement {
    @Nonnull
    private final MageController controller;
    @Nullable
    private String permissionNode = null;
    @Nullable
    private String requiredPath = null;
    @Nullable
    private String requiredTemplate = null;
    @Nullable
    private Set<String> requiredTemplates = null;
    @Nullable
    private String requiresCompletedPath = null;
    @Nullable
    private String exactPath = null;
    @Nullable
    private String mageClass = null;
    @Nullable
    private List<PropertyRequirement> wandProperties = null;
    @Nullable
    private List<PropertyRequirement> classProperties = null;
    @Nullable
    private List<PropertyRequirement> attributes = null;
    private boolean requireWand = false;

    public MagicRequirement(@Nonnull MageController controller, @Nonnull Requirement requirement) {
        this.controller = controller;
        ConfigurationSection configuration = requirement.getConfiguration();
        this.permissionNode = configuration.getString("permission");
        this.requiredPath = configuration.getString("path");
        this.exactPath = configuration.getString("path_exact");
        this.requiresCompletedPath = configuration.getString("path_end");
        this.requiredTemplate = configuration.getString("wand");
        this.requireWand = configuration.getBoolean("holding_wand");
        this.mageClass = configuration.getString("class");
        if (configuration.contains("wands")) {
            this.requiredTemplates = new HashSet<String>(ConfigurationUtils.getStringList(configuration, "wands"));
        }
        this.wandProperties = this.parsePropertyRequirements(configuration, "wand_properties", "property");
        this.classProperties = this.parsePropertyRequirements(configuration, "class_properties", "property");
        this.attributes = this.parsePropertyRequirements(configuration, "attributes", "attribute");
        if (this.requiresCompletedPath != null) {
            this.requiredPath = this.requiresCompletedPath;
            this.exactPath = this.requiresCompletedPath;
        }
        if (this.requiredTemplate != null || this.requiredTemplates != null || this.wandProperties != null) {
            this.requireWand = true;
        }
    }

    @Nullable
    private List<PropertyRequirement> parsePropertyRequirements(ConfigurationSection configuration, String section, String type) {
        if (!configuration.contains(section)) {
            return null;
        }
        ArrayList<PropertyRequirement> requirements = new ArrayList<PropertyRequirement>();
        Collection<ConfigurationSection> propertyConfigs = ConfigurationUtils.getNodeList(configuration, section);
        for (ConfigurationSection propertyConfig : propertyConfigs) {
            if (!propertyConfig.contains(type)) {
                this.controller.getLogger().warning("Property requirement missing " + type + " parameter");
                continue;
            }
            PropertyRequirement requirement = new PropertyRequirement(type, propertyConfig);
            requirements.add(requirement);
        }
        return requirements;
    }

    public boolean checkRequirement(@Nonnull CastContext context) {
        String template;
        Mage mage = context.getMage();
        Player player = mage.getPlayer();
        if (!(this.permissionNode == null || player != null && player.hasPermission(this.permissionNode))) {
            return false;
        }
        Wand wand = context.getWand();
        if (wand == null && this.requireWand) {
            return false;
        }
        if (!(this.requiredTemplate == null || (template = wand.getTemplateKey()) != null && template.equals(this.requiredTemplate))) {
            return false;
        }
        if (!(this.requiredTemplates == null || (template = wand.getTemplateKey()) != null && this.requiredTemplates.contains(template))) {
            return false;
        }
        CasterProperties checkProperties = context.getActiveProperties();
        ProgressionPath path = checkProperties.getPath();
        if (this.mageClass != null && !this.mageClass.isEmpty() && !mage.hasClassUnlocked(this.mageClass)) {
            return false;
        }
        if (this.requiredPath != null || this.exactPath != null) {
            if (path == null) {
                return false;
            }
            if (this.requiredPath != null && !path.hasPath(this.requiredPath)) {
                return false;
            }
            if (this.exactPath != null && !this.exactPath.equals(path.getKey())) {
                return false;
            }
            if (this.requiresCompletedPath != null) {
                boolean hasPathCompleted = false;
                if (path.hasPath(this.requiresCompletedPath)) {
                    hasPathCompleted = path.getKey().equals(this.requiresCompletedPath) ? !path.canProgress(checkProperties) : true;
                }
                if (!hasPathCompleted) {
                    return false;
                }
            }
        }
        if (this.wandProperties != null && !this.checkProperties(wand, this.wandProperties)) {
            return false;
        }
        if (this.classProperties != null) {
            MageClass activeClass;
            MageClass mageClass = activeClass = this.mageClass == null ? mage.getActiveClass() : mage.getClass(this.mageClass);
            if (activeClass == null) {
                return false;
            }
            if (!this.checkProperties(activeClass, this.classProperties)) {
                return false;
            }
        }
        if (this.attributes != null) {
            for (PropertyRequirement requirement : this.attributes) {
                String key;
                Double value;
                if (this.checkProperty(requirement, value = mage.getAttribute(key = requirement.key))) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean checkProperties(CasterProperties properties, List<PropertyRequirement> requirements) {
        for (PropertyRequirement requirement : requirements) {
            String key;
            Double value;
            if (this.checkProperty(requirement, value = properties.hasProperty(key = requirement.key) ? properties.getProperty(key, 0.0) : null)) continue;
            return false;
        }
        return true;
    }

    protected boolean checkProperty(PropertyRequirement requirement, Double value) {
        if (!(requirement.value == null || value != null && value.equals(requirement.value))) {
            return false;
        }
        if (requirement.min != null && (value == null || value <= requirement.min)) {
            return false;
        }
        return requirement.max == null || value == null || !(value >= requirement.max);
    }

    protected String getMessage(CastContext context, String key) {
        return context.getMessage(key, this.getDefaultMessage(context, key));
    }

    protected String getDefaultMessage(CastContext context, String key) {
        return context.getController().getMessages().get("requirements." + key);
    }

    @Nullable
    public String getRequirementDescription(@Nonnull CastContext context) {
        String message;
        String template;
        Mage mage = context.getMage();
        MageController controller = mage.getController();
        Player player = mage.getPlayer();
        if (!(this.permissionNode == null || player != null && player.hasPermission(this.permissionNode))) {
            return context.getMessage(SpellResult.INSUFFICIENT_PERMISSION.name().toLowerCase());
        }
        Wand wand = context.getWand();
        if (wand == null && this.requireWand) {
            return this.getMessage(context, "no_wand");
        }
        if (!(this.requiredTemplate == null || (template = wand.getTemplateKey()) != null && template.equals(this.requiredTemplate))) {
            return this.getMessage(context, "no_template").replace("$wand", wand.getName());
        }
        if (!(this.requiredTemplates == null || (template = wand.getTemplateKey()) != null && this.requiredTemplates.contains(template))) {
            return this.getMessage(context, "no_template").replace("$wand", wand.getName());
        }
        if (this.mageClass != null && !this.mageClass.isEmpty() && mage.hasClassUnlocked(this.mageClass)) {
            return this.getMessage(context, "no_class").replace("$class", this.mageClass);
        }
        CasterProperties checkProperties = context.getActiveProperties();
        ProgressionPath path = checkProperties.getPath();
        if (this.requiredPath != null || this.exactPath != null) {
            if (path == null) {
                return this.getMessage(context, "no_path");
            }
            if (this.requiredPath != null && !path.hasPath(this.requiredPath)) {
                WandUpgradePath requiresPath = controller.getPath(this.requiredPath);
                String pathName = this.requiredPath;
                if (requiresPath != null) {
                    pathName = requiresPath.getName();
                } else {
                    context.getLogger().warning("Invalid path specified in requirement " + this.requiredPath);
                }
                return this.getMessage(context, "no_required_path").replace("$path", pathName);
            }
            if (this.exactPath != null && !this.exactPath.equals(path.getKey())) {
                WandUpgradePath requiresPath = controller.getPath(this.exactPath);
                String pathName = this.exactPath;
                if (requiresPath != null) {
                    pathName = requiresPath.getName();
                } else {
                    context.getLogger().warning("Invalid path specified in requirement: " + this.exactPath);
                }
                return this.getMessage(context, "no_path_exact").replace("$path", pathName);
            }
            if (this.requiresCompletedPath != null) {
                boolean hasPathCompleted = false;
                if (path.hasPath(this.requiresCompletedPath)) {
                    hasPathCompleted = path.getKey().equals(this.requiresCompletedPath) ? !path.canProgress(checkProperties) : true;
                }
                if (!hasPathCompleted) {
                    WandUpgradePath requiresPath = controller.getPath(this.requiresCompletedPath);
                    String pathName = this.requiresCompletedPath;
                    if (requiresPath != null) {
                        pathName = requiresPath.getName();
                    } else {
                        context.getLogger().warning("Invalid path specified in requirement: " + this.exactPath);
                    }
                    return this.getMessage(context, "no_path_end").replace("$path", pathName);
                }
            }
        }
        if (this.wandProperties != null && (message = this.getRequiredProperty(context, wand, this.wandProperties)) != null) {
            return message;
        }
        if (this.classProperties != null) {
            MageClass activeClass;
            MageClass mageClass = activeClass = this.mageClass == null ? mage.getActiveClass() : mage.getClass(this.mageClass);
            if (activeClass == null) {
                return this.getMessage(context, "no_path");
            }
            String message2 = this.getRequiredProperty(context, activeClass, this.classProperties);
            if (message2 != null) {
                return message2;
            }
        }
        if (this.attributes != null) {
            for (PropertyRequirement requirement : this.attributes) {
                Double value;
                String key;
                String message3 = this.checkRequiredProperty(context, requirement, key = requirement.key, value = mage.getAttribute(key));
                if (message3 == null) continue;
                return message3;
            }
        }
        return null;
    }

    @Nullable
    protected String getRequiredProperty(CastContext context, CasterProperties properties, List<PropertyRequirement> requirements) {
        for (PropertyRequirement requirement : requirements) {
            String message;
            String key = requirement.key;
            Double value = properties.hasProperty(key) ? properties.getProperty(key, 0.0) : null;
            String messageKey = "wand." + key;
            String name = key;
            if (this.controller.getMessages().containsKey(messageKey)) {
                name = this.controller.getMessages().getLevelString(messageKey, value == null ? 0.0f : (float)value.doubleValue());
            }
            if ((message = this.checkRequiredProperty(context, requirement, name, value)) == null) continue;
            return message;
        }
        return null;
    }

    @Nullable
    protected String checkRequiredProperty(CastContext context, PropertyRequirement requirement, String name, Double value) {
        if (!(requirement.value == null || value != null && value.equals(requirement.value))) {
            return this.getMessage(context, "property_requirement").replace("$property", name).replace("$value", Double.toString(requirement.value));
        }
        if (requirement.min != null && (value == null || value <= requirement.min)) {
            return this.getMessage(context, "property_min").replace("$property", name).replace("$value", Double.toString(requirement.min));
        }
        if (requirement.max != null && value != null && value >= requirement.max) {
            return this.getMessage(context, "property_max").replace("$property", name).replace("$value", Double.toString(requirement.max));
        }
        return null;
    }

    private static class PropertyRequirement {
        public final String key;
        public Double max;
        public Double min;
        public Double value;

        public PropertyRequirement(String type, ConfigurationSection configuration) {
            this.key = configuration.getString(type);
            if (configuration.contains("min")) {
                this.min = configuration.getDouble("min");
            }
            if (configuration.contains("max")) {
                this.max = configuration.getDouble("max");
            }
            if (configuration.contains("value")) {
                this.value = configuration.getDouble("value");
            }
        }

        public String toString() {
            return "[Require " + this.key + "=" + this.value + " from (" + this.min + " to " + this.max + ")]";
        }
    }
}

