/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.protection;

import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.protection.WGCustomFlagsManager;
import com.elmakers.mine.bukkit.protection.WorldGuardFlags;
import com.elmakers.mine.bukkit.protection.WorldGuardFlagsManager;
import com.sk89q.worldguard.bukkit.RegionContainer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.domains.Association;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.Associables;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WorldGuardAPI {
    private final Plugin owningPlugin;
    private WorldGuardPlugin worldGuard = null;
    private WorldGuardFlags customFlags = null;

    public boolean isEnabled() {
        return this.worldGuard != null;
    }

    public WorldGuardAPI(Plugin plugin, Plugin owningPlugin) {
        this.owningPlugin = owningPlugin;
        if (plugin instanceof WorldGuardPlugin) {
            this.worldGuard = (WorldGuardPlugin)plugin;
            try {
                owningPlugin.getLogger().info("Pre-check for WorldGuard custom flag registration");
                this.customFlags = new WorldGuardFlagsManager(owningPlugin, (Plugin)this.worldGuard);
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            catch (Throwable ex) {
                owningPlugin.getLogger().log(Level.WARNING, "Unexpected error setting up custom flags, please make sure you are on WorldGuard 6.2 or above", ex);
            }
        }
    }

    public void checkFlagSupport() {
        if (this.customFlags == null) {
            try {
                Plugin customFlagsPlugin = this.owningPlugin.getServer().getPluginManager().getPlugin("WGCustomFlags");
                if (customFlagsPlugin != null) {
                    this.customFlags = new WGCustomFlagsManager(customFlagsPlugin);
                }
            }
            catch (Throwable ex) {
                this.owningPlugin.getLogger().log(Level.WARNING, "Error integration with WGCustomFlags", ex);
            }
            if (this.customFlags != null) {
                this.owningPlugin.getLogger().info("WGCustomFlags found, added custom flags");
            } else {
                this.owningPlugin.getLogger().log(Level.WARNING, "Failed to set up custom flags, please make sure you are on WorldGuard 6.2 or above, or use the WGCustomFlags plugin");
            }
        }
    }

    protected RegionAssociable getAssociable(Player player) {
        Object associable = player == null ? Associables.constant((Association)Association.NON_MEMBER) : this.worldGuard.wrapPlayer(player);
        return associable;
    }

    public boolean isPVPAllowed(Player player, Location location) {
        if (this.worldGuard == null || location == null) {
            return true;
        }
        RegionManager regionManager = this.worldGuard.getRegionManager(location.getWorld());
        if (regionManager == null) {
            return true;
        }
        ApplicableRegionSet checkSet = regionManager.getApplicableRegions(location);
        if (checkSet == null) {
            return true;
        }
        return checkSet.queryState(this.getAssociable(player), new StateFlag[]{DefaultFlag.PVP}) != StateFlag.State.DENY;
    }

    public boolean isExitAllowed(Player player, Location location) {
        if (this.worldGuard == null || location == null) {
            return true;
        }
        RegionManager regionManager = this.worldGuard.getRegionManager(location.getWorld());
        if (regionManager == null) {
            return true;
        }
        ApplicableRegionSet checkSet = regionManager.getApplicableRegions(location);
        if (checkSet == null) {
            return true;
        }
        return checkSet.queryState(this.getAssociable(player), new StateFlag[]{DefaultFlag.EXIT}) != StateFlag.State.DENY;
    }

    public boolean hasBuildPermission(Player player, Block block) {
        if (block != null && this.worldGuard != null) {
            RegionContainer container = this.worldGuard.getRegionContainer();
            return container.createQuery().testState(block.getLocation(), this.getAssociable(player), new StateFlag[]{DefaultFlag.BUILD});
        }
        return true;
    }

    @Nullable
    public Boolean getCastPermission(Player player, SpellTemplate spell, Location location) {
        if (location != null && this.worldGuard != null && this.customFlags != null) {
            RegionManager regionManager = this.worldGuard.getRegionManager(location.getWorld());
            if (regionManager == null) {
                return null;
            }
            ApplicableRegionSet checkSet = regionManager.getApplicableRegions(location);
            if (checkSet == null) {
                return null;
            }
            return this.customFlags.getCastPermission(this.getAssociable(player), checkSet, spell);
        }
        return null;
    }

    @Nullable
    public Boolean getWandPermission(Player player, Wand wand, Location location) {
        if (location != null && this.worldGuard != null && this.customFlags != null) {
            RegionManager regionManager = this.worldGuard.getRegionManager(location.getWorld());
            if (regionManager == null) {
                return null;
            }
            ApplicableRegionSet checkSet = regionManager.getApplicableRegions(location);
            if (checkSet == null) {
                return null;
            }
            return this.customFlags.getWandPermission(this.getAssociable(player), checkSet, wand);
        }
        return null;
    }

    @Nullable
    public String getReflective(Player player, Location location) {
        if (location != null && this.worldGuard != null && this.customFlags != null) {
            RegionManager regionManager = this.worldGuard.getRegionManager(location.getWorld());
            if (regionManager == null) {
                return null;
            }
            ApplicableRegionSet checkSet = regionManager.getApplicableRegions(location);
            if (checkSet == null) {
                return null;
            }
            return this.customFlags.getReflective(this.getAssociable(player), checkSet);
        }
        return null;
    }

    @Nullable
    public Set<String> getSpellOverrides(Player player, Location location) {
        if (location != null && this.worldGuard != null && this.customFlags != null) {
            RegionManager regionManager = this.worldGuard.getRegionManager(location.getWorld());
            if (regionManager == null) {
                return null;
            }
            ApplicableRegionSet checkSet = regionManager.getApplicableRegions(location);
            if (checkSet == null) {
                return null;
            }
            return this.customFlags.getSpellOverrides(this.getAssociable(player), checkSet);
        }
        return null;
    }

    @Nullable
    public String getDestructible(Player player, Location location) {
        if (location != null && this.worldGuard != null && this.customFlags != null) {
            RegionManager regionManager = this.worldGuard.getRegionManager(location.getWorld());
            if (regionManager == null) {
                return null;
            }
            ApplicableRegionSet checkSet = regionManager.getApplicableRegions(location);
            if (checkSet == null) {
                return null;
            }
            return this.customFlags.getDestructible(this.getAssociable(player), checkSet);
        }
        return null;
    }
}

