/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.batch.Batch;
import com.elmakers.mine.bukkit.api.block.BlockData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.LostWand;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.command.MagicMapExecutor;
import com.elmakers.mine.bukkit.utility.BoundingBox;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.HitboxUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.utility.RunnableJob;
import com.elmakers.mine.bukkit.wand.WandCleanupRunnable;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.CodeSource;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public class MagicCommandExecutor
extends MagicMapExecutor {
    private RunnableJob runningTask = null;

    public MagicCommandExecutor(MagicAPI api) {
        super(api);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        if (args.length == 0) {
            if (!this.api.hasPermission(sender, "Magic.commands.magic")) {
                this.sendNoPermission(sender);
                return true;
            }
            sender.sendMessage("Magic " + this.getMagicVersion());
            sender.sendMessage("Use /magic help for more info");
            return true;
        }
        String subCommand = args[0];
        if (sender instanceof Player && !this.api.hasPermission(sender, "Magic.commands.magic." + subCommand)) {
            this.sendNoPermission(sender);
            return true;
        }
        if (subCommand.equalsIgnoreCase("help")) {
            sender.sendMessage(ChatColor.AQUA + "See help information for Magic commands with /help <command>");
            sender.sendMessage("wand     Create or modify wand items");
            sender.sendMessage("mage     Inspect or modify mage data");
            sender.sendMessage("mconfig  Configure Magic in-game");
            sender.sendMessage("magic    Reload configs and other admin functions");
            sender.sendMessage("mitem    Create or modify vanilla items");
            sender.sendMessage("mmob     Spwan vanilla or magic mobs");
            sender.sendMessage("cast     Cast spells and test parameter changes");
            sender.sendMessage("mtrait   Create or modify Magic Citizens NPCs");
            sender.sendMessage("mmap     Create maps from images or players");
            sender.sendMessage("castp    Cast spells as another player");
            sender.sendMessage("wandp    Modify other players' wands");
            sender.sendMessage("mskills  Show the skill selector");
            return true;
        }
        if (subCommand.equalsIgnoreCase("rpcheck")) {
            this.api.getController().checkResourcePack(sender);
            return true;
        }
        if (subCommand.equalsIgnoreCase("rpsend")) {
            this.api.getController().sendResourcePackToAllPlayers(sender);
            return true;
        }
        if (subCommand.equalsIgnoreCase("save")) {
            this.api.save();
            sender.sendMessage("Data saved.");
            return true;
        }
        if (subCommand.equalsIgnoreCase("load") || subCommand.equalsIgnoreCase("reload")) {
            this.api.reload(sender);
            return true;
        }
        if (subCommand.equalsIgnoreCase("clearcache")) {
            this.api.clearCache();
            sender.sendMessage("Image map cache cleared.");
            return true;
        }
        if (subCommand.equalsIgnoreCase("commit")) {
            if (this.api.commit()) {
                sender.sendMessage("All changes committed");
            } else {
                sender.sendMessage("Nothing to commit");
            }
            return true;
        }
        if (subCommand.equalsIgnoreCase("give") || subCommand.equalsIgnoreCase("sell")) {
            player = null;
            int argStart = 1;
            if (sender instanceof Player) {
                if (args.length > 1) {
                    player = DeprecatedUtils.getPlayer(args[1]);
                }
                if (player == null) {
                    player = (Player)sender;
                } else {
                    argStart = 2;
                }
            } else {
                if (args.length <= 1) {
                    sender.sendMessage("Must specify a player name");
                    return true;
                }
                argStart = 2;
                player = DeprecatedUtils.getPlayer(args[1]);
                if (player == null) {
                    sender.sendMessage("Can't find player " + args[1]);
                    return true;
                }
                if (!player.isOnline()) {
                    sender.sendMessage("Player " + args[1] + " is not online");
                    return true;
                }
            }
            String[] args2 = Arrays.copyOfRange(args, argStart, args.length);
            if (subCommand.equalsIgnoreCase("give") || subCommand.equalsIgnoreCase("sell")) {
                return this.onMagicGive(sender, player, subCommand, args2);
            }
        }
        if (subCommand.equalsIgnoreCase("worth")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("This command may only be used in-game");
                return true;
            }
            player = (Player)sender;
            ItemStack item = player.getInventory().getItemInMainHand();
            if (item == null || item.getType() == Material.AIR) {
                player.sendMessage("You must be holding an item");
                return true;
            }
            this.showWorth((CommandSender)player, item);
            return true;
        }
        if (subCommand.equalsIgnoreCase("list")) {
            return this.onMagicList(sender, subCommand, args);
        }
        if (subCommand.equalsIgnoreCase("cancel")) {
            this.checkRunningTask();
            if (this.runningTask != null) {
                this.runningTask.cancel();
                this.runningTask = null;
                sender.sendMessage("Job cancelled");
            }
            int stoppedPending = 0;
            for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.controller.getMages()) {
                while (mage.cancelPending() != null) {
                    ++stoppedPending;
                }
            }
            sender.sendMessage("Stopped " + stoppedPending + " pending spell casts");
            return true;
        }
        if (subCommand.equalsIgnoreCase("clean")) {
            String ownerName;
            this.checkRunningTask();
            if (this.runningTask != null) {
                sender.sendMessage("Cancel current job first");
                return true;
            }
            World world = null;
            String owner = null;
            if (args.length > 1) {
                owner = args[1];
            }
            if (sender instanceof Player) {
                world = ((Player)sender).getWorld();
            } else if (args.length > 2) {
                String worldName = args[2];
                world = Bukkit.getWorld((String)worldName);
            }
            boolean check = false;
            if (owner != null && owner.equals("check")) {
                check = true;
                owner = "ALL";
            }
            String description = check ? "Checking for" : "Cleaning up";
            String string = ownerName = owner == null ? "(Unowned)" : owner;
            if (world == null) {
                sender.sendMessage(description + " lost wands in all worlds for owner: " + ownerName);
            } else if (ownerName.equals("ALL")) {
                sender.sendMessage(description + " lost wands in world '" + world.getName() + "' for ALL owners");
            } else {
                sender.sendMessage(description + " lost wands in world '" + world.getName() + "' for owner " + ownerName);
            }
            this.runningTask = new WandCleanupRunnable(this.api, world, owner, check);
            this.runningTask.runTaskTimer(this.api.getPlugin(), 5L, 5L);
            return true;
        }
        sender.sendMessage("Unknown magic command: " + subCommand);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean onMagicList(CommandSender sender, String subCommand, String[] args) {
        String usage = "Usage: magic list <wands|map|automata|tasks|schematics|entities|blocks>";
        String listCommand = "";
        if (args.length > 1) {
            listCommand = args[1];
            if (!this.api.hasPermission(sender, "Magic.commands.magic." + subCommand + "." + listCommand)) {
                this.sendNoPermission(sender);
                return false;
            }
        } else {
            sender.sendMessage(ChatColor.GRAY + "For more specific information, add 'tasks', 'wands', 'maps', 'schematics', 'entities', 'blocks' or 'automata' parameter.");
            MageController apiController = this.api.getController();
            if (apiController != null && apiController instanceof MagicController) {
                MagicController controller = (MagicController)apiController;
                long timeout = controller.getPhysicsTimeout();
                if (timeout > 0L) {
                    long seconds = (timeout - System.currentTimeMillis()) / 1000L;
                    sender.sendMessage(ChatColor.GREEN + "Physics handler active for another " + ChatColor.DARK_GREEN + seconds + ChatColor.GREEN + " seconds");
                } else {
                    sender.sendMessage(ChatColor.GRAY + "Physics handler inactive");
                }
            }
            Collection<com.elmakers.mine.bukkit.api.magic.Mage> mages = this.controller.getMages();
            sender.sendMessage(ChatColor.AQUA + "Modified blocks (" + ChatColor.LIGHT_PURPLE + UndoList.getRegistry().getModified().size() + ChatColor.AQUA + ")");
            sender.sendMessage(ChatColor.AQUA + "Watching blocks (" + ChatColor.LIGHT_PURPLE + UndoList.getRegistry().getWatching().size() + ChatColor.AQUA + ")");
            sender.sendMessage(ChatColor.AQUA + "Registered breaking (" + ChatColor.LIGHT_PURPLE + UndoList.getRegistry().getBreaking().size() + ChatColor.AQUA + ")");
            sender.sendMessage(ChatColor.AQUA + "Registered breakable (" + ChatColor.LIGHT_PURPLE + UndoList.getRegistry().getBreakable().size() + ChatColor.AQUA + ")");
            sender.sendMessage(ChatColor.AQUA + "Registered reflective (" + ChatColor.LIGHT_PURPLE + UndoList.getRegistry().getReflective().size() + ChatColor.AQUA + ")");
            sender.sendMessage(ChatColor.LIGHT_PURPLE + "Active mages: " + ChatColor.LIGHT_PURPLE + mages.size());
            Collection<com.elmakers.mine.bukkit.api.block.UndoList> pendingUndo = this.api.getPendingUndo();
            sender.sendMessage(ChatColor.AQUA + "Pending undo (" + ChatColor.LIGHT_PURPLE + pendingUndo.size() + ChatColor.AQUA + "): ");
            long now = System.currentTimeMillis();
            for (com.elmakers.mine.bukkit.api.block.UndoList undoList : pendingUndo) {
                long remainingTime = (undoList.getScheduledTime() - now) / 1000L;
                sender.sendMessage(ChatColor.AQUA + undoList.getName() + ChatColor.GRAY + " will undo in " + ChatColor.WHITE + "" + remainingTime + "" + ChatColor.GRAY + " seconds");
            }
            Collection<com.elmakers.mine.bukkit.api.magic.Mage> pending = this.api.getMagesWithPendingBatches();
            sender.sendMessage(ChatColor.AQUA + "Pending casts (" + ChatColor.LIGHT_PURPLE + pending.size() + ChatColor.AQUA + "): ");
            for (com.elmakers.mine.bukkit.api.magic.Mage mage : pending) {
                int totalSize = 0;
                int totalRemaining = 0;
                Collection<Batch> pendingBatches = mage.getPendingBatches();
                String names = "";
                if (pendingBatches.size() > 0) {
                    for (Batch batch : pendingBatches) {
                        names = names + batch.getName() + " ";
                        totalSize += batch.size();
                        totalRemaining += batch.remaining();
                    }
                }
                sender.sendMessage(ChatColor.AQUA + mage.getName() + ChatColor.GRAY + " has " + ChatColor.WHITE + "" + pendingBatches.size() + "" + ChatColor.GRAY + " pending (" + ChatColor.WHITE + "" + totalRemaining + "/" + totalSize + "" + ChatColor.GRAY + ") (" + names + ")");
            }
            return true;
        }
        if (listCommand.equalsIgnoreCase("schematics")) {
            ArrayList<String> schematics = new ArrayList<String>();
            try {
                File file;
                String string;
                File file2;
                File magicSchematicFolder;
                Plugin plugin = (Plugin)this.api;
                MagicController controller = (MagicController)this.api.getController();
                CodeSource src = MagicAPI.class.getProtectionDomain().getCodeSource();
                if (src != null) {
                    URL uRL = src.getLocation();
                    Throwable throwable = null;
                    try (InputStream is = uRL.openStream();
                         ZipInputStream zipInputStream = new ZipInputStream(is);){
                        ZipEntry e;
                        while ((e = zipInputStream.getNextEntry()) != null) {
                            String name = e.getName();
                            if (!name.startsWith("schematics/")) continue;
                            schematics.add(name.replace("schematics/", ""));
                        }
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                }
                if ((magicSchematicFolder = new File(file2 = plugin.getDataFolder(), "schematics")).exists()) {
                    for (File nextFile : magicSchematicFolder.listFiles()) {
                        schematics.add(nextFile.getName());
                    }
                }
                if ((string = controller.getExtraSchematicFilePath()) != null && string.length() > 0 && (file = new File(file2, "../" + string)).exists() && !file.equals(magicSchematicFolder)) {
                    for (File nextFile : file.listFiles()) {
                        schematics.add(nextFile.getName());
                    }
                }
            }
            catch (Exception ex) {
                sender.sendMessage("Error loading schematics: " + ex.getMessage());
                ex.printStackTrace();
            }
            sender.sendMessage(ChatColor.DARK_AQUA + "Found " + ChatColor.LIGHT_PURPLE + schematics.size() + ChatColor.DARK_AQUA + " schematics");
            Collections.sort(schematics);
            for (String schematic : schematics) {
                if (schematic.indexOf(".schematic") <= 0) continue;
                sender.sendMessage(ChatColor.AQUA + schematic.replace(".schematic", ""));
            }
            return true;
        }
        if (listCommand.equalsIgnoreCase("tasks")) {
            String pluginName;
            List tasks = Bukkit.getScheduler().getPendingTasks();
            HashMap<String, Integer> pluginCounts = new HashMap<String, Integer>();
            HashMap taskCounts = new HashMap();
            for (BukkitTask bukkitTask : tasks) {
                void var19_66;
                void var16_50;
                Integer count;
                pluginName = bukkitTask.getOwner().getName();
                HashMap hashMap = (HashMap)taskCounts.get(pluginName);
                if (hashMap == null) {
                    HashMap hashMap2 = new HashMap();
                    taskCounts.put(pluginName, hashMap2);
                }
                String string = "(Unknown)";
                Runnable taskRunnable = CompatibilityUtils.getTaskRunnable(bukkitTask);
                if (taskRunnable != null) {
                    Class<?> taskClass = taskRunnable.getClass();
                    String string2 = taskClass.getName();
                }
                if ((count = (Integer)var16_50.get(var19_66)) == null) {
                    count = 0;
                }
                Integer name = count;
                Integer nextFile = count = Integer.valueOf(count + 1);
                var16_50.put(var19_66, count);
                Integer totalCount = (Integer)pluginCounts.get(pluginName);
                if (totalCount == null) {
                    totalCount = 0;
                }
                nextFile = totalCount;
                Integer n = totalCount = Integer.valueOf(totalCount + 1);
                pluginCounts.put(pluginName, totalCount);
            }
            sender.sendMessage(ChatColor.LIGHT_PURPLE + "Active tasks: " + tasks.size());
            for (Map.Entry entry : taskCounts.entrySet()) {
                pluginName = (String)entry.getKey();
                sender.sendMessage(" " + ChatColor.DARK_PURPLE + pluginName + ": " + ChatColor.LIGHT_PURPLE + pluginCounts.get(pluginName));
                for (Map.Entry entry2 : ((HashMap)entry.getValue()).entrySet()) {
                    sender.sendMessage("  " + ChatColor.DARK_PURPLE + (String)entry2.getKey() + ": " + ChatColor.LIGHT_PURPLE + entry2.getValue());
                }
            }
            return true;
        }
        if (listCommand.equalsIgnoreCase("wands")) {
            String owner = "";
            if (args.length > 2) {
                owner = args[2];
            }
            Collection<LostWand> lostWands = this.api.getLostWands();
            int shown = 0;
            for (LostWand lostWand : lostWands) {
                Location location = lostWand.getLocation();
                if (location == null || owner.length() > 0 && !owner.equalsIgnoreCase(lostWand.getOwner())) continue;
                ++shown;
                sender.sendMessage(ChatColor.AQUA + lostWand.getName() + ChatColor.WHITE + " (" + lostWand.getOwner() + ") @ " + ChatColor.BLUE + location.getWorld().getName() + " " + location.getBlockX() + " " + location.getBlockY() + " " + location.getBlockZ());
            }
            sender.sendMessage(shown + " lost wands found" + (owner.length() > 0 ? " for " + owner : ""));
            return true;
        }
        if (listCommand.equalsIgnoreCase("automata")) {
            Collection<com.elmakers.mine.bukkit.api.magic.Mage> automata = this.api.getAutomata();
            for (com.elmakers.mine.bukkit.api.magic.Mage automaton : automata) {
                Location location = automaton.getLocation();
                String string = location.getWorld().getName();
                boolean isOnline = false;
                World world = Bukkit.getWorld((String)string);
                if (string != null) {
                    isOnline = world.isChunkLoaded(location.getBlockX() >> 4, location.getBlockZ() >> 4);
                }
                ChatColor chatColor = isOnline ? ChatColor.AQUA : ChatColor.GRAY;
                sender.sendMessage(chatColor + automaton.getName() + ChatColor.WHITE + " @ " + ChatColor.BLUE + string + " " + location.getBlockX() + " " + location.getBlockY() + " " + location.getBlockZ());
            }
            sender.sendMessage(automata.size() + " automata active");
            return true;
        }
        if (listCommand.equalsIgnoreCase("maps")) {
            String keyword = "";
            for (int i = 2; i < args.length; ++i) {
                if (i != 2) {
                    keyword = keyword + " ";
                }
                keyword = keyword + args[i];
            }
            this.onMapList(sender, keyword);
            return true;
        }
        if (listCommand.equalsIgnoreCase("blocks")) {
            for (BlockData blockData : UndoList.getRegistry().getModified().values()) {
                BlockVector blockLocation = blockData.getLocation();
                Block block = blockData.getBlock();
                sender.sendMessage(ChatColor.BLUE + "Block at " + ChatColor.GRAY + blockLocation.getBlockX() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + blockLocation.getBlockY() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + blockLocation.getBlockZ() + ChatColor.BLUE + " stored as " + ChatColor.AQUA + blockData.getMaterial() + ChatColor.BLUE + " is currently " + ChatColor.AQUA + block.getType() + ChatColor.BLUE + " from " + ChatColor.GOLD + blockData.getUndoList().getName());
            }
            return true;
        }
        if (listCommand.equalsIgnoreCase("mages")) {
            for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.api.getController().getMages()) {
                void var16_56;
                void var27_121;
                Entity mageEntity = mage.getEntity();
                Location location = mage.getLocation();
                ChatColor chatColor = ChatColor.YELLOW;
                if (mage instanceof Mage && ((Mage)mage).isForget()) {
                    ChatColor chatColor2 = ChatColor.RED;
                } else if (mage.isAutomaton()) {
                    ChatColor chatColor3 = ChatColor.GOLD;
                }
                String mageType = mageEntity == null ? "Non-Entity" : mageEntity.getType().name();
                String string = ChatColor.AQUA + "Mage " + var27_121 + mage.getId() + ChatColor.GRAY + " (" + mage.getName() + ")" + ChatColor.AQUA + " of type " + ChatColor.DARK_AQUA + mageType + ChatColor.AQUA;
                if (location != null) {
                    String string3 = location.getWorld() != null ? location.getWorld().getName() : "(Unknown world)";
                    String string4 = string + " is at " + ChatColor.BLUE + string3 + " " + ChatColor.DARK_PURPLE + " " + location.getBlockX() + " " + location.getBlockY() + " " + location.getBlockZ();
                }
                sender.sendMessage((String)var16_56);
            }
            return true;
        }
        if (listCommand.equalsIgnoreCase("entities")) {
            World world = (World)Bukkit.getWorlds().get(0);
            DecimalFormat formatter = new DecimalFormat("#0.0");
            List<EntityType> types = Arrays.asList(EntityType.values());
            Collections.sort(types, new Comparator<EntityType>(){

                @Override
                public int compare(EntityType o1, EntityType o2) {
                    return o1.name().compareTo(o2.name());
                }
            });
            Collection players = Bukkit.getServer().getOnlinePlayers();
            Iterator iterator = players.iterator();
            if (iterator.hasNext()) {
                Player player = (Player)iterator.next();
                this.showEntityInfo(sender, (Entity)player, EntityType.PLAYER.name() + ChatColor.GRAY + " (" + player.getName() + " [" + (player.isSneaking() ? "sneaking" : "standing") + "])", formatter);
            }
            Class<?> clazz = NMSUtils.getBukkitClass("net.minecraft.server.World");
            for (EntityType entityType : types) {
                Slime slime;
                void var19_73;
                String errorMessage;
                block92: {
                    if (!entityType.isSpawnable()) continue;
                    Object var19_74 = null;
                    errorMessage = null;
                    String entityName = "Entity" + entityType.getEntityClass().getSimpleName();
                    if (entityName.equals("EntityGiant")) {
                        entityName = "EntityGiantZombie";
                    } else if (entityName.equals("EntityLeashHitch")) {
                        entityName = "EntityLeash";
                    } else if (entityName.equals("EntityStorageMinecart")) {
                        entityName = "EntityMinecartChest";
                    } else if (entityName.equals("EntitySpawnerMinecart")) {
                        entityName = "EntityMinecartMobSpawner";
                    } else if (entityName.equals("EntityCommandMinecart")) {
                        entityName = "EntityMinecartCommandBlock";
                    } else if (entityName.equals("EntityPoweredMinecart")) {
                        entityName = "EntityMinecartFurnace";
                    } else if (entityName.equals("EntityExplosiveMinecart")) {
                        entityName = "EntityMinecartTNT";
                    } else if (entityName.contains("Minecart")) {
                        entityName = entityType.getEntityClass().getSimpleName();
                        entityName = entityName.replace("Minecart", "");
                        entityName = "EntityMinecart" + entityName;
                    }
                    try {
                        Class<?> entityClass = NMSUtils.getBukkitClass("net.minecraft.server." + entityName);
                        if (entityClass != null) {
                            Object nmsWorld;
                            Constructor<?> constructor = entityClass.getConstructor(clazz);
                            Object nmsEntity = constructor.newInstance(nmsWorld = NMSUtils.getHandle(world));
                            Entity entity = NMSUtils.getBukkitEntity(nmsEntity);
                            if (entity == null) {
                                errorMessage = "Failed to get Bukkit entity for class " + entityName;
                            }
                        } else {
                            errorMessage = "Could not load class " + entityName;
                        }
                    }
                    catch (Exception ex) {
                        Object var19_77 = null;
                        errorMessage = ex.getClass().getSimpleName() + " [" + entityName + "]";
                        String message = ex.getMessage();
                        if (message == null || message.isEmpty()) break block92;
                        errorMessage = errorMessage + ": " + message;
                    }
                }
                if (var19_73 == null) {
                    sender.sendMessage(ChatColor.BLACK + entityType.name() + ": " + ChatColor.RED + "Spawning error " + ChatColor.DARK_RED + "(" + errorMessage + ")");
                    continue;
                }
                String label = entityType.name();
                Ageable ageable = var19_73 instanceof Ageable ? (Ageable)var19_73 : null;
                Zombie zombie = var19_73 instanceof Zombie ? (Zombie)var19_73 : null;
                Skeleton skeleton = var19_73 instanceof Skeleton ? (Skeleton)var19_73 : null;
                Slime slime2 = slime = var19_73 instanceof Slime ? (Slime)var19_73 : null;
                if (ageable != null) {
                    label = label + ChatColor.GRAY + " (Adult)";
                    ageable.setAdult();
                } else if (zombie != null) {
                    label = label + ChatColor.GRAY + " (Adult)";
                    zombie.setBaby(false);
                } else if (skeleton != null) {
                    label = label + ChatColor.GRAY + " (NORMAL)";
                    skeleton.setSkeletonType(Skeleton.SkeletonType.NORMAL);
                } else if (slime != null) {
                    label = label + ChatColor.GRAY + " (Size 1)";
                    slime.setSize(1);
                }
                this.showEntityInfo(sender, (Entity)var19_73, label, formatter);
                if (ageable != null) {
                    label = entityType.name() + ChatColor.GRAY + " (Baby)";
                    ageable.setBaby();
                    this.showEntityInfo(sender, (Entity)var19_73, label, formatter);
                    continue;
                }
                if (zombie != null) {
                    label = entityType.name() + ChatColor.GRAY + " (Baby)";
                    zombie.setBaby(true);
                    this.showEntityInfo(sender, (Entity)var19_73, label, formatter);
                    continue;
                }
                if (skeleton != null) {
                    label = entityType.name() + ChatColor.GRAY + " (WITHER)";
                    skeleton.setSkeletonType(Skeleton.SkeletonType.WITHER);
                    this.showEntityInfo(sender, (Entity)var19_73, label, formatter);
                    continue;
                }
                if (slime == null) continue;
                label = entityType.name() + ChatColor.GRAY + " (Size 2)";
                slime.setSize(2);
                this.showEntityInfo(sender, (Entity)var19_73, label, formatter);
                label = entityType.name() + ChatColor.GRAY + " (Size 4)";
                slime.setSize(4);
                this.showEntityInfo(sender, (Entity)var19_73, label, formatter);
                label = entityType.name() + ChatColor.GRAY + " (Size 8)";
                slime.setSize(8);
                this.showEntityInfo(sender, (Entity)var19_73, label, formatter);
                label = entityType.name() + ChatColor.GRAY + " (Size 16)";
                slime.setSize(16);
                this.showEntityInfo(sender, (Entity)var19_73, label, formatter);
            }
            return true;
        }
        sender.sendMessage(usage);
        return true;
    }

    private void showEntityInfo(CommandSender sender, Entity entity, String label, NumberFormat formatter) {
        BoundingBox hitbox = HitboxUtils.getHitbox(entity);
        Vector size = hitbox.size();
        String message = ChatColor.BLACK + label + ": " + ChatColor.AQUA + formatter.format(size.getX()) + ChatColor.DARK_GRAY + "x" + ChatColor.AQUA + formatter.format(size.getY()) + ChatColor.DARK_GRAY + "x" + ChatColor.AQUA + formatter.format(size.getZ());
        if (entity instanceof LivingEntity) {
            LivingEntity li = (LivingEntity)entity;
            message = message + ChatColor.DARK_GRAY + ", " + ChatColor.GREEN + (int)li.getMaxHealth() + "hp";
        }
        sender.sendMessage(message);
    }

    protected boolean onMagicGive(CommandSender sender, Player player, String command, String[] args) {
        String playerCommand = sender instanceof Player ? "" : "<player> ";
        String usageString = "Usage: /magic give " + playerCommand + "<spellname|'material'|'upgrade'|'wand'> [materialname|wandname]";
        if (args.length == 0) {
            sender.sendMessage(usageString);
            return true;
        }
        String key = "";
        boolean isMaterial = false;
        boolean isWand = false;
        boolean isUpgrade = false;
        if (!(args.length <= 1 || args[0].equals("material") || args[0].equals("wand") || args[0].equals("upgrade"))) {
            sender.sendMessage(usageString);
            return true;
        }
        if (args[0].equals("wand")) {
            isWand = true;
            key = args.length > 1 ? args[1] : "";
        } else if (args[0].equals("upgrade")) {
            isUpgrade = true;
            key = args.length > 1 ? args[1] : "";
        } else if (args[0].equals("material")) {
            if (args.length < 2) {
                sender.sendMessage(usageString);
                return true;
            }
            isMaterial = true;
            key = args[1];
        } else {
            key = args[0];
        }
        boolean giveItem = command.equals("give") || command.equals("sell");
        boolean showWorth = command.equals("worth") || command.equals("sell");
        boolean giveValue = command.equals("sell");
        if (isWand) {
            this.giveWand(sender, player, key, false, giveItem, giveValue, showWorth);
        } else if (isMaterial) {
            this.onGiveBrush(sender, player, key, false, giveItem, giveValue, showWorth);
        } else if (isUpgrade) {
            this.onGiveUpgrade(sender, player, key, false, giveItem, giveValue, showWorth);
        } else {
            this.onGive(sender, player, key, giveItem, giveValue, showWorth);
        }
        return true;
    }

    protected void onGive(CommandSender sender, Player player, String key, boolean giveItem, boolean giveValue, boolean showWorth) {
        if (!(this.onGiveSpell(sender, player, key, true, giveItem, giveValue, showWorth) || this.onGiveBrush(sender, player, key, true, giveItem, giveValue, showWorth) || this.giveWand(sender, player, key, true, giveItem, giveValue, showWorth))) {
            sender.sendMessage("Failed to create a spell, brush or wand item for " + key);
        }
    }

    protected boolean onGiveSpell(CommandSender sender, Player player, String spellKey, boolean quiet, boolean giveItem, boolean giveValue, boolean showWorth) {
        ItemStack itemStack = this.api.createSpellItem(spellKey);
        if (itemStack == null) {
            if (!quiet) {
                sender.sendMessage("Failed to create spell item for " + spellKey);
            }
            return false;
        }
        if (giveItem) {
            this.api.giveItemToPlayer(player, itemStack);
            if (sender != player && !quiet) {
                sender.sendMessage("Gave spell " + spellKey + " to " + player.getName());
            }
        }
        if (showWorth) {
            this.showWorth(sender, itemStack);
        }
        return true;
    }

    protected boolean onGiveBrush(CommandSender sender, Player player, String materialKey, boolean quiet, boolean giveItem, boolean giveValue, boolean showWorth) {
        ItemStack itemStack = this.api.createBrushItem(materialKey);
        if (itemStack == null) {
            if (!quiet) {
                sender.sendMessage("Failed to create material item for " + materialKey);
            }
            return false;
        }
        if (giveItem) {
            this.api.giveItemToPlayer(player, itemStack);
            if (sender != player && !quiet) {
                sender.sendMessage("Gave brush " + materialKey + " to " + player.getName());
            }
        }
        if (showWorth) {
            this.showWorth(sender, itemStack);
        }
        return true;
    }

    protected boolean onGiveUpgrade(CommandSender sender, Player player, String wandKey, boolean quiet, boolean giveItem, boolean giveValue, boolean showWorth) {
        Wand wand;
        com.elmakers.mine.bukkit.api.magic.Mage mage = this.controller.getMage(player);
        Wand currentWand = mage.getActiveWand();
        if (currentWand != null) {
            currentWand.closeInventory();
        }
        if ((wand = this.api.createWand(wandKey)) != null) {
            wand.makeUpgrade();
            if (giveItem) {
                this.api.giveItemToPlayer(player, wand.getItem());
                if (sender != player && !quiet) {
                    sender.sendMessage("Gave upgrade " + wand.getName() + " to " + player.getName());
                }
            }
            if (showWorth) {
                this.showWorth(sender, wand.getItem());
            }
        } else {
            if (!quiet) {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.unknown_template", "$name", wandKey));
            }
            return false;
        }
        return true;
    }

    protected void checkRunningTask() {
        if (this.runningTask != null && this.runningTask.isFinished()) {
            this.runningTask = null;
        }
    }

    @Override
    public Collection<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        ArrayList<String> options = new ArrayList<String>();
        if (args.length == 1) {
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "clean");
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "clearcache");
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "cancel");
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "load");
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "save");
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "commit");
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "give");
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "worth");
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "sell");
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "list");
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "rpcheck");
            this.addIfPermissible(sender, options, "Magic.commands.magic.", "rpsend");
        } else if (args.length == 2) {
            if (args[0].equalsIgnoreCase("list")) {
                this.addIfPermissible(sender, options, "Magic.commands.magic.list", "maps");
                this.addIfPermissible(sender, options, "Magic.commands.magic.list", "wands");
                this.addIfPermissible(sender, options, "Magic.commands.magic.list", "automata");
                this.addIfPermissible(sender, options, "Magic.commands.magic.list", "schematics");
                this.addIfPermissible(sender, options, "Magic.commands.magic.list", "entities");
                this.addIfPermissible(sender, options, "Magic.commands.magic.list", "tasks");
                this.addIfPermissible(sender, options, "Magic.commands.magic.list", "blocks");
                this.addIfPermissible(sender, options, "Magic.commands.magic.list", "mages");
            } else if (args[0].equalsIgnoreCase("give") || args[0].equalsIgnoreCase("worth") || args[0].equalsIgnoreCase("sell")) {
                options.add("wand");
                options.add("material");
                options.add("upgrade");
                Collection<SpellTemplate> spellList = this.api.getSpellTemplates(sender.hasPermission("Magic.bypass_hidden"));
                for (SpellTemplate spellTemplate : spellList) {
                    options.add(spellTemplate.getKey());
                }
                Collection<String> allWands = this.api.getWandKeys();
                for (String wandKey : allWands) {
                    options.add(wandKey);
                }
                options.addAll(this.api.getBrushes());
            }
        } else if (args.length == 3) {
            Player player;
            if (args[0].equalsIgnoreCase("give") || args[0].equalsIgnoreCase("sell")) {
                if (args[1].equalsIgnoreCase("upgrade") || args[1].equalsIgnoreCase("wand")) {
                    Collection<String> allWands = this.api.getWandKeys();
                    for (String string : allWands) {
                        options.add(string);
                    }
                } else if (args[1].equalsIgnoreCase("material")) {
                    options.addAll(this.api.getBrushes());
                }
            } else if ((args[0].equalsIgnoreCase("configure") || args[0].equalsIgnoreCase("describe")) && (player = DeprecatedUtils.getPlayer(args[1])) != null) {
                com.elmakers.mine.bukkit.api.magic.Mage mage = this.controller.getMage(player);
                ConfigurationSection configurationSection = mage.getData();
                options.addAll(configurationSection.getKeys(false));
            }
        }
        return options;
    }
}

