/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class CastCommandExecutor
extends MagicTabExecutor {
    public CastCommandExecutor(MagicAPI api) {
        super(api);
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        String commandName = command.getName();
        if (commandName.equalsIgnoreCase("castp")) {
            if (!this.api.hasPermission(sender, "Magic.commands.castp")) {
                this.sendNoPermission(sender);
                return true;
            }
            if (args.length < 1) {
                if (sender != null) {
                    sender.sendMessage("Usage: /castp [player] [spell] <parameters>");
                }
                return true;
            }
            String playerName = args[0];
            Mage mage = null;
            if (playerName.contains(",")) {
                String[] idPieces = StringUtils.split((String)playerName, (char)',');
                if (idPieces.length == 4 || idPieces.length == 2) {
                    try {
                        String worldName = idPieces[0];
                        String entityId = idPieces[idPieces.length - 1];
                        World world = Bukkit.getWorld((String)worldName);
                        if (world == null) {
                            if (sender != null) {
                                sender.sendMessage("Unknown world: " + worldName);
                            }
                            return false;
                        }
                        Entity entity = NMSUtils.getEntity(world, UUID.fromString(entityId));
                        if (entity == null) {
                            if (sender != null) {
                                sender.sendMessage("Entity not found with id " + entityId + " in " + world.getName());
                            }
                            return false;
                        }
                        MageController controller = this.api.getController();
                        mage = controller.getMage(entity);
                        sender = null;
                    }
                    catch (Throwable ex) {
                        if (sender != null) {
                            sender.sendMessage("Your spell failed (badly... check server logs)");
                        }
                        ex.printStackTrace();
                        return false;
                    }
                }
            } else if (playerName.contains(":")) {
                String[] pieces = StringUtils.split((String)playerName, (char)':');
                String mageId = pieces[0];
                String mageName = pieces.length > 0 ? pieces[1] : mageId;
                MageController controller = this.api.getController();
                mage = controller.getMage(mageId, mageName);
            }
            if (mage != null && !mage.isLoading()) {
                String[] castParameters = Arrays.copyOfRange(args, 1, args.length);
                if (castParameters.length < 1) {
                    if (sender != null) {
                        sender.sendMessage("Invalid command line, expecting more parameters");
                    }
                    return false;
                }
                String spellName = castParameters[0];
                MageSpell spell = mage.getSpell(spellName);
                if (spell == null) {
                    if (sender != null) {
                        sender.sendMessage("Unknown spell " + spellName);
                    }
                    return false;
                }
                String[] parameters = new String[castParameters.length - 1];
                for (int i = 1; i < castParameters.length; ++i) {
                    parameters[i - 1] = castParameters[i];
                }
                if (spell.cast(parameters)) {
                    if (sender != null) {
                        sender.sendMessage("Cast " + spell.getName() + " as " + mage.getName());
                    }
                } else if (sender != null) {
                    sender.sendMessage("Failed to cast " + spell.getName() + " as " + mage.getName());
                }
                return true;
            }
            Player player = DeprecatedUtils.getPlayer(playerName);
            if (player == null) {
                if (sender != null) {
                    sender.sendMessage("Can't find player " + playerName);
                }
                return true;
            }
            if (!player.isOnline()) {
                if (sender != null) {
                    sender.sendMessage("Player " + playerName + " is not online");
                }
                return true;
            }
            String[] args2 = Arrays.copyOfRange(args, 1, args.length);
            return this.processCastCommand(sender, (Entity)player, args2);
        }
        if (commandName.equalsIgnoreCase("cast")) {
            if (!this.api.hasPermission(sender, "Magic.commands.cast")) {
                this.sendNoPermission(sender);
                return true;
            }
            Player player = null;
            if (sender instanceof Player) {
                player = (Player)sender;
            }
            return this.processCastCommand(sender, (Entity)player, args);
        }
        return false;
    }

    public boolean processCastCommand(CommandSender sender, Entity entity, String[] castParameters) {
        if (castParameters.length < 1) {
            return false;
        }
        String spellName = castParameters[0];
        String[] parameters = null;
        if (sender.hasPermission("Magic.commands.cast.parameters")) {
            parameters = new String[castParameters.length - 1];
            for (int i = 1; i < castParameters.length; ++i) {
                parameters[i - 1] = castParameters[i];
            }
        }
        this.api.cast(spellName, parameters, sender, entity);
        return true;
    }

    @Override
    public Collection<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        String spellName;
        SpellTemplate spell;
        HashSet<String> options = new HashSet<String>();
        String permissionKey = "cast";
        if (commandName.contains("castp")) {
            permissionKey = "castp";
            if (args.length == 1) {
                options.addAll(this.api.getPlayerNames());
                return options;
            }
            if (args.length > 1) {
                args = Arrays.copyOfRange(args, 1, args.length);
            }
        }
        if (args.length == 1) {
            Collection<SpellTemplate> spellList = this.api.getController().getSpellTemplates(true);
            for (SpellTemplate spell2 : spellList) {
                this.addIfPermissible(sender, options, "Magic." + permissionKey + ".", spell2.getKey());
            }
        }
        if (args.length > 1 && sender.hasPermission("Magic.commands.cast.parameters") && (spell = this.api.getSpellTemplate(spellName = args[0])) != null) {
            if (args.length % 2 == 0) {
                spell.getParameters(options);
            } else {
                spell.getParameterOptions(options, args[args.length - 2]);
            }
        }
        return options;
    }
}

