/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.magic.MaterialSetManager;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.magic.MaterialSets;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;

final class SimpleMaterialSetManager
implements MaterialSetManager {
    private Map<String, MaterialSet> materialSets = new HashMap<String, MaterialSet>();
    private Set<String> unmodifiableMaterialSetKeys = Collections.unmodifiableSet(this.materialSets.keySet());

    SimpleMaterialSetManager() {
    }

    @Override
    public Collection<String> getMaterialSets() {
        return this.unmodifiableMaterialSetKeys;
    }

    @Override
    public MaterialSet getMaterialSet(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"fallback");
        return this.materialSets.get(name);
    }

    @Override
    public MaterialSet getMaterialSet(String name, MaterialSet fallback) {
        Preconditions.checkNotNull((Object)fallback, (Object)"fallback");
        MaterialSet set = this.getMaterialSet(name);
        return set != null ? set : fallback;
    }

    @Override
    public MaterialSet getMaterialSetEmpty(String name) {
        return this.getMaterialSet(name, MaterialSets.empty());
    }

    @Override
    @Nullable
    public MaterialSet fromConfig(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        MaterialSet materials = this.materialSets.get(name);
        if (materials == null) {
            materials = this.createMaterialSetFromString(name);
            this.materialSets.put(name, materials);
        }
        return materials;
    }

    @Override
    public MaterialSet fromConfig(String name, MaterialSet fallback) {
        MaterialSet v = this.fromConfig(name);
        return v != null ? v : fallback;
    }

    @Override
    public MaterialSet fromConfigEmpty(String name) {
        return this.fromConfig(name, MaterialSets.empty());
    }

    void loadMaterials(ConfigurationSection materialNode) {
        Set keys = materialNode.getKeys(false);
        for (String key : keys) {
            MaterialSet set = this.createMaterialSet(materialNode, key);
            if (set == null) continue;
            this.materialSets.put(key, set);
        }
    }

    private MaterialSet createMaterialSetFromString(String materialSet) {
        boolean negate;
        String materialString;
        if (materialSet.equals("*")) {
            return MaterialSets.wildcard();
        }
        if (materialSet.startsWith("!")) {
            materialString = materialSet.substring(1);
            negate = true;
        } else {
            materialString = materialSet;
            negate = false;
        }
        String[] names = StringUtils.split((String)materialString, (char)',');
        MaterialSet created = this.createMaterialSetFromStringList(Arrays.asList(names), true);
        return negate ? created.not() : created;
    }

    @Nullable
    private MaterialSet createMaterialSet(ConfigurationSection node, String key) {
        if (node.isString(key)) {
            return this.createMaterialSetFromString(node.getString(key));
        }
        List materialData = node.getStringList(key);
        if (materialData == null) {
            return null;
        }
        return this.createMaterialSetFromStringList(materialData, false);
    }

    private MaterialSet createMaterialSetFromStringList(List<String> names, boolean resolveNames) {
        MaterialSets.Union union = MaterialSets.unionBuilder();
        for (String matName : names) {
            MaterialAndData material;
            MaterialSet resolved;
            if (resolveNames && (resolved = this.materialSets.get(matName)) != null) {
                union.add(resolved);
                continue;
            }
            if (matName.contains("|")) {
                material = ConfigurationUtils.toMaterialAndData(matName);
                if (material == null || !material.isValid()) continue;
                union.add(material);
                continue;
            }
            material = ConfigurationUtils.toMaterial(matName);
            if (material == null) continue;
            union.add((Material)material);
        }
        return union.build();
    }
}

