/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public class MaterialSets {
    @Nullable
    public static Set<Material> toLegacy(@Nullable MaterialSet v) {
        return v == null ? null : MaterialSets.toLegacyNN(v);
    }

    @Nonnull
    public static Set<Material> toLegacyNN(@Nonnull MaterialSet v) {
        return ImmutableSet.copyOf(v.getMaterials());
    }

    public static MaterialSet wildcard() {
        return WildcardMaterialSet.INSTANCE;
    }

    public static MaterialSet empty() {
        return EmptyMaterialSet.INSTANCE;
    }

    public static MaterialSet union(MaterialSet left, MaterialSet right) {
        if (left == MaterialSets.empty()) {
            return right;
        }
        if (right == MaterialSets.empty()) {
            return left;
        }
        return MaterialSets.unionBuilder().add(left).add(right).build();
    }

    public static MaterialSet union(MaterialSet left, MaterialAndData right) {
        return MaterialSets.unionBuilder().add(left).add(right).build();
    }

    public static MaterialSet union(MaterialSet left, Material ... materials) {
        return MaterialSets.unionBuilder().add(left).addAll(materials).build();
    }

    public static Union unionBuilder() {
        return new Union();
    }

    public static final class Union {
        private boolean wildcard = false;
        private final List<MaterialSet> sets = new ArrayList<MaterialSet>();
        private final List<MaterialAndData> materialAndDatas = new ArrayList<MaterialAndData>();
        private final Set<Material> materials = new HashSet<Material>();

        private Union() {
        }

        public Union add(MaterialSet set) {
            Preconditions.checkNotNull((Object)set, (Object)"set");
            if (set instanceof EmptyMaterialSet) {
                return this;
            }
            if (set instanceof WildcardMaterialSet) {
                this.wildcard = true;
                return this;
            }
            if (set instanceof SimpleMaterialSet) {
                SimpleMaterialSet simpleSet = (SimpleMaterialSet)set;
                this.sets.addAll((Collection<MaterialSet>)simpleSet.parents);
                this.materialAndDatas.addAll((Collection<MaterialAndData>)simpleSet.materialAndDatas);
                this.materials.addAll((Collection<Material>)simpleSet.materials);
            } else {
                this.sets.add(set);
            }
            return this;
        }

        public Union add(Material material) {
            Preconditions.checkNotNull((Object)material, (Object)"material");
            this.materials.add(material);
            return this;
        }

        public Union add(MaterialAndData materialAndData) {
            Preconditions.checkNotNull((Object)materialAndData, (Object)"materialAndData");
            Preconditions.checkArgument((boolean)materialAndData.isValid(), (String)"Material data is not valid: %s", (Object[])new Object[]{materialAndData});
            this.materialAndDatas.add(materialAndData);
            return this;
        }

        public Union addAll(Material ... materials) {
            for (Material material : materials) {
                Preconditions.checkNotNull((Object)material, (Object)"material");
                this.materials.add(material);
            }
            return this;
        }

        public MaterialSet build() {
            ImmutableList newMaterialAndDatas;
            ImmutableSet newMaterials;
            boolean needMaterialList = !this.materials.isEmpty();
            for (MaterialSet set : this.sets) {
                needMaterialList |= !set.getMaterials().isEmpty();
            }
            if (!needMaterialList) {
                if (this.wildcard) {
                    return MaterialSets.wildcard();
                }
                if (this.sets.isEmpty() && this.materialAndDatas.isEmpty()) {
                    return MaterialSets.empty();
                }
            }
            if (needMaterialList) {
                ImmutableSet.Builder materialsBuilder = ImmutableSet.builder();
                materialsBuilder.addAll(this.materials);
                for (MaterialSet set : this.sets) {
                    materialsBuilder.addAll(set.getMaterials());
                }
                newMaterials = materialsBuilder.build();
            } else {
                newMaterials = ImmutableSet.of();
            }
            if (!this.materialAndDatas.isEmpty()) {
                ImmutableList.Builder materialsBuilder = ImmutableList.builder();
                for (MaterialAndData materialAndData : this.materialAndDatas) {
                    if (newMaterials.contains((Object)materialAndData.getMaterial())) continue;
                    materialsBuilder.add((Object)materialAndData);
                }
                newMaterialAndDatas = materialsBuilder.build();
            } else {
                newMaterialAndDatas = ImmutableList.of();
            }
            return new SimpleMaterialSet((ImmutableList<MaterialSet>)ImmutableList.copyOf(this.sets), (ImmutableSet<Material>)newMaterials, (ImmutableList<MaterialAndData>)newMaterialAndDatas);
        }
    }

    private static final class SimpleMaterialSet
    implements MaterialSet {
        @Nonnull
        private final ImmutableList<MaterialSet> parents;
        @Nonnull
        private final ImmutableSet<Material> materials;
        @Nonnull
        private final ImmutableList<MaterialAndData> materialAndDatas;
        private transient MaterialSet inverse;

        public SimpleMaterialSet(@Nonnull ImmutableList<MaterialSet> parents, @Nonnull ImmutableSet<Material> materials, @Nonnull ImmutableList<MaterialAndData> materialAndDatas) {
            this.materialAndDatas = materialAndDatas;
            this.parents = parents;
            this.materials = (ImmutableSet)Preconditions.checkNotNull(materials);
        }

        @Override
        public MaterialSet not() {
            if (this.inverse != null) {
                return this.inverse;
            }
            this.inverse = new NegatedMaterialSet(this);
            return this.inverse;
        }

        @Override
        public Collection<Material> getMaterials() {
            return this.materials;
        }

        @Override
        public boolean testMaterial(Material material) {
            if (this.materials.contains((Object)material)) {
                return true;
            }
            for (MaterialSet parent : this.parents) {
                if (!parent.testMaterial(material)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean testBlock(Block block) {
            if (this.materials.contains((Object)block.getType())) {
                return true;
            }
            for (MaterialSet parent : this.parents) {
                if (!parent.testBlock(block)) continue;
                return true;
            }
            for (MaterialAndData materialAndData : this.materialAndDatas) {
                if (!materialAndData.is(block)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean testItem(ItemStack item) {
            if (this.materials.contains((Object)item.getType())) {
                return true;
            }
            for (MaterialSet parent : this.parents) {
                if (!parent.testItem(item)) continue;
                return true;
            }
            for (MaterialAndData materialAndData : this.materialAndDatas) {
                if (materialAndData.getMaterial() != item.getType() || materialAndData.getData().shortValue() != item.getDurability()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean testMaterialAndData(MaterialAndData targetMaterial) {
            if (this.materials.contains((Object)targetMaterial.getMaterial())) {
                return true;
            }
            for (MaterialSet parent : this.parents) {
                if (!parent.testMaterialAndData(targetMaterial)) continue;
                return true;
            }
            for (MaterialAndData materialAndData : this.materialAndDatas) {
                if (!materialAndData.equals(targetMaterial)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            boolean first = true;
            StringBuilder sb = new StringBuilder().append('(');
            for (MaterialSet parent : this.parents) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(parent);
            }
            for (Object material : this.materials) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(material.name().toLowerCase());
            }
            for (Object material : this.materialAndDatas) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(material.getKey());
            }
            return sb.append(')').toString();
        }
    }

    private static final class NegatedMaterialSet
    implements MaterialSet {
        @Nonnull
        private final MaterialSet delegate;

        public NegatedMaterialSet(MaterialSet delegate) {
            this.delegate = (MaterialSet)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        }

        @Override
        public MaterialSet not() {
            return this.delegate;
        }

        @Override
        public Collection<Material> getMaterials() {
            return this.delegate.getMaterials();
        }

        @Override
        public boolean testMaterial(Material material) {
            return !this.delegate.testMaterial(material);
        }

        @Override
        public boolean testBlock(Block testBlock) {
            return !this.delegate.testBlock(testBlock);
        }

        @Override
        public boolean testItem(ItemStack item) {
            return !this.delegate.testItem(item);
        }

        @Override
        public boolean testMaterialAndData(MaterialAndData targetMaterial) {
            return !this.delegate.testMaterialAndData(targetMaterial);
        }

        public String toString() {
            return "!(" + this.delegate + ")";
        }
    }

    private static enum EmptyMaterialSet implements MaterialSet
    {
        INSTANCE;


        @Override
        public Collection<Material> getMaterials() {
            return Collections.emptyList();
        }

        @Override
        public MaterialSet not() {
            return MaterialSets.wildcard();
        }

        @Override
        public boolean testMaterial(Material material) {
            return false;
        }

        @Override
        public boolean testBlock(Block testBlock) {
            return false;
        }

        @Override
        public boolean testItem(ItemStack item) {
            return false;
        }

        @Override
        public boolean testMaterialAndData(MaterialAndData targetMaterial) {
            return false;
        }

        public String toString() {
            return "()";
        }
    }

    private static enum WildcardMaterialSet implements MaterialSet
    {
        INSTANCE;


        @Override
        public Collection<Material> getMaterials() {
            return Collections.emptyList();
        }

        @Override
        public MaterialSet not() {
            return MaterialSets.empty();
        }

        @Override
        public boolean testMaterial(Material material) {
            return true;
        }

        @Override
        public boolean testBlock(Block testBlock) {
            return true;
        }

        @Override
        public boolean testItem(ItemStack item) {
            return true;
        }

        @Override
        public boolean testMaterialAndData(MaterialAndData targetMaterial) {
            return true;
        }

        public String toString() {
            return "(*)";
        }
    }
}

