/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class MageTrigger {
    protected MageTriggerType type;
    protected Deque<WeightedPair<String>> spells;
    protected List<String> commands;
    protected double maxHealth;
    protected double minHealth;
    protected double maxHealthPercentage;
    protected double minHealthPercentage;
    protected double maxDamage;
    protected double minDamage;

    public MageTrigger(@Nonnull MageController controller, @Nonnull String key, @Nonnull ConfigurationSection configuration) {
        String typeString = configuration.getString("type", key);
        try {
            this.type = MageTriggerType.valueOf(typeString.toUpperCase());
        }
        catch (Exception ex) {
            controller.getLogger().warning("Invalid mage trigger type: " + typeString);
            this.type = null;
        }
        if (configuration.contains("cast")) {
            this.spells = new ArrayDeque<WeightedPair<String>>();
            RandomUtils.populateStringProbabilityMap(this.spells, configuration.getConfigurationSection("cast"));
        }
        this.commands = ConfigurationUtils.getStringList(configuration, "commands");
        this.maxHealth = configuration.getDouble("max_health");
        this.minHealth = configuration.getDouble("min_health");
        this.maxHealthPercentage = configuration.getDouble("max_health_percentage");
        this.minHealthPercentage = configuration.getDouble("min_health_percentage");
        this.maxDamage = configuration.getDouble("max_damage");
        this.minDamage = configuration.getDouble("min_damage");
    }

    public boolean isValid() {
        return this.type != null;
    }

    public MageTriggerType getType() {
        return this.type;
    }

    private void cast(Mage mage, String castSpell) {
        if (castSpell.length() > 0) {
            String[] parameters = null;
            Spell spell = null;
            if (!castSpell.equalsIgnoreCase("none")) {
                if (castSpell.contains(" ")) {
                    parameters = StringUtils.split((String)castSpell, (char)' ');
                    castSpell = parameters[0];
                    parameters = Arrays.copyOfRange(parameters, 1, parameters.length);
                }
                spell = mage.getSpell(castSpell);
            }
            if (spell != null) {
                spell.cast(parameters);
            }
        }
    }

    public void execute(Mage mage) {
        this.execute(mage, 0.0);
    }

    public void execute(Mage mage, double damage) {
        if (this.minDamage > 0.0 && damage < this.minDamage) {
            return;
        }
        if (this.maxDamage > 0.0 && damage > this.maxDamage) {
            return;
        }
        LivingEntity li = mage.getLivingEntity();
        if (this.minHealth > 0.0 && (li == null || li.getHealth() < this.minHealth)) {
            return;
        }
        if (this.maxHealth > 0.0 && (li == null || li.getHealth() > this.maxHealth)) {
            return;
        }
        if (this.minHealthPercentage > 0.0 && (li == null || li.getHealth() * 100.0 / li.getMaxHealth() < this.minHealthPercentage)) {
            return;
        }
        if (this.maxHealthPercentage > 0.0 && (li == null || li.getHealth() * 100.0 / li.getMaxHealth() > this.maxHealthPercentage)) {
            return;
        }
        if (this.spells != null && !this.spells.isEmpty()) {
            String deathSpell = (String)RandomUtils.weightedRandom(this.spells);
            this.cast(mage, deathSpell);
        }
        if (this.commands != null) {
            Entity topDamager = mage.getTopDamager();
            Entity killer = mage.getLastDamager();
            Collection<Entity> damagers = mage.getDamagers();
            Location location = mage.getLocation();
            for (String command : this.commands) {
                boolean allDamagers;
                if (command.contains("@killer")) {
                    if (killer == null) continue;
                    command = command.replace("@killer", killer.getName());
                }
                if (command.contains("@damager")) {
                    if (topDamager == null) continue;
                    command = command.replace("@damager", topDamager.getName());
                }
                if ((allDamagers = command.contains("@damagers")) && damagers == null) continue;
                command = command.replace("@name", mage.getName()).replace("@world", location.getWorld().getName()).replace("@x", Double.toString(location.getX())).replace("@y", Double.toString(location.getY())).replace("@z", Double.toString(location.getZ()));
                if (allDamagers) {
                    for (Entity damager : damagers) {
                        String damagerCommand = command.replace("@damagers", damager.getName());
                        mage.getController().getPlugin().getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), damagerCommand);
                    }
                    continue;
                }
                mage.getController().getPlugin().getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), command);
            }
        }
    }

    public static enum MageTriggerType {
        INTERVAL,
        DEATH,
        DAMAGE;

    }
}

