/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.entity;

import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.magic.MageTrigger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Creature;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

public class EntityMageData {
    private static final String[] MAGE_PROPERTIES = new String[]{"protection", "weakness", "strength"};
    protected long tickInterval;
    protected Map<MageTrigger.MageTriggerType, List<MageTrigger>> triggers;
    protected ConfigurationSection mageProperties;
    protected boolean requiresTarget;
    protected ItemData requiresWand;
    protected boolean aggro;
    protected double trackRadiusSquared;

    public EntityMageData(@Nonnull MageController controller, @Nonnull ConfigurationSection parameters) {
        Set triggerKeys;
        this.requiresWand = controller.getOrCreateItem(parameters.getString("cast_requires_item"));
        this.mageProperties = parameters.getConfigurationSection("mage");
        for (String mageProperty : MAGE_PROPERTIES) {
            ConfigurationSection mageConfig = parameters.getConfigurationSection(mageProperty);
            if (mageConfig == null) continue;
            if (this.mageProperties == null) {
                this.mageProperties = new MemoryConfiguration();
            }
            this.mageProperties.set(mageProperty, (Object)mageConfig);
        }
        this.tickInterval = parameters.getLong("interval", parameters.getLong("cast_interval", 0L));
        this.requiresTarget = parameters.getBoolean("cast_requires_target", true);
        this.trackRadiusSquared = parameters.getDouble("track_radius", 128.0);
        this.trackRadiusSquared *= this.trackRadiusSquared;
        ConfigurationSection triggerConfig = parameters.getConfigurationSection("triggers");
        if (parameters.contains("cast")) {
            if (triggerConfig == null) {
                triggerConfig = new MemoryConfiguration();
            }
            ConfigurationSection castSection = triggerConfig.createSection("interval");
            castSection.set("cast", (Object)parameters.getConfigurationSection("cast"));
        }
        Set set = triggerKeys = triggerConfig == null ? null : triggerConfig.getKeys(false);
        if (triggerKeys != null) {
            this.triggers = new HashMap<MageTrigger.MageTriggerType, List<MageTrigger>>();
            for (String triggerKey : triggerKeys) {
                MageTrigger trigger = new MageTrigger(controller, triggerKey, triggerConfig.getConfigurationSection(triggerKey));
                if (!trigger.isValid()) continue;
                List<MageTrigger> typeTriggers = this.triggers.get((Object)trigger.getType());
                if (typeTriggers == null) {
                    typeTriggers = new ArrayList<MageTrigger>();
                    this.triggers.put(trigger.getType(), typeTriggers);
                }
                typeTriggers.add(trigger);
            }
        }
        if (this.triggers != null && this.tickInterval <= 0L && this.triggers.containsKey((Object)MageTrigger.MageTriggerType.INTERVAL)) {
            this.tickInterval = 1000L;
        }
        this.aggro = parameters.getBoolean("aggro", !this.isEmpty());
    }

    public boolean isEmpty() {
        boolean hasTriggers = this.triggers != null;
        boolean hasProperties = this.mageProperties != null;
        return !hasProperties && !hasTriggers && !this.aggro;
    }

    @Nullable
    private List<MageTrigger> getTriggers(MageTrigger.MageTriggerType type) {
        return this.triggers == null ? null : this.triggers.get((Object)type);
    }

    public void onDeath(Mage mage) {
        List<MageTrigger> deathTriggers = this.getTriggers(MageTrigger.MageTriggerType.DEATH);
        if (deathTriggers == null) {
            return;
        }
        for (MageTrigger trigger : deathTriggers) {
            trigger.execute(mage);
        }
    }

    public void onDamage(Mage mage, double damage) {
        List<MageTrigger> damageTriggers = this.getTriggers(MageTrigger.MageTriggerType.DAMAGE);
        if (damageTriggers == null) {
            return;
        }
        for (MageTrigger trigger : damageTriggers) {
            trigger.execute(mage, damage);
        }
    }

    public void tick(Mage mage) {
        LivingEntity li;
        ItemStack itemInHand;
        Creature creature;
        List<MageTrigger> intervalTriggers = this.getTriggers(MageTrigger.MageTriggerType.INTERVAL);
        if (intervalTriggers == null) {
            return;
        }
        LivingEntity entity = mage.getLivingEntity();
        Creature creature2 = creature = entity instanceof Creature ? (Creature)entity : null;
        if (this.requiresTarget && (creature == null || creature.getTarget() == null)) {
            return;
        }
        if (this.requiresWand != null && entity instanceof LivingEntity && ((itemInHand = (li = entity).getEquipment().getItemInMainHand()) == null || itemInHand.getType() != this.requiresWand.getType())) {
            return;
        }
        for (MageTrigger trigger : intervalTriggers) {
            trigger.execute(mage);
        }
    }

    public double getTrackRadiusSquared() {
        return this.trackRadiusSquared;
    }
}

