/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.entity;

import com.elmakers.mine.bukkit.entity.EntityExtraData;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;

public class EntityArmorStandData
extends EntityExtraData {
    public ItemStack itemInHand;
    public ItemStack boots;
    public ItemStack leggings;
    public ItemStack chestplate;
    public ItemStack helmet;
    public EulerAngle bodyPose;
    public EulerAngle leftArmPose;
    public EulerAngle rightArmPose;
    public EulerAngle leftLegPose;
    public EulerAngle rightLegPose;
    public EulerAngle headPose;
    public boolean isMarker;
    public boolean hasGravity;
    public boolean isVisible;
    public boolean hasArms;
    public boolean isSmall;
    public boolean hasBasePlate;
    public int disabledSlots;

    public EntityArmorStandData() {
    }

    public EntityArmorStandData(ArmorStand armorStand) {
        this.itemInHand = armorStand.getItemInHand();
        if (this.itemInHand != null) {
            this.itemInHand = this.itemInHand.clone();
        }
        this.boots = armorStand.getBoots();
        if (this.boots != null) {
            this.boots = this.boots.clone();
        }
        this.leggings = armorStand.getLeggings();
        if (this.leggings != null) {
            this.leggings = this.leggings.clone();
        }
        this.chestplate = armorStand.getChestplate();
        if (this.chestplate != null) {
            this.chestplate = this.chestplate.clone();
        }
        this.helmet = armorStand.getHelmet();
        if (this.helmet != null) {
            this.helmet = this.helmet.clone();
        }
        this.bodyPose = armorStand.getBodyPose();
        this.leftArmPose = armorStand.getLeftArmPose();
        this.rightArmPose = armorStand.getRightArmPose();
        this.leftLegPose = armorStand.getLeftLegPose();
        this.rightLegPose = armorStand.getRightLegPose();
        this.headPose = armorStand.getHeadPose();
        this.hasGravity = armorStand.hasGravity();
        this.isVisible = armorStand.isVisible();
        this.hasArms = armorStand.hasArms();
        this.isSmall = armorStand.isSmall();
        this.hasBasePlate = armorStand.hasBasePlate();
        this.isMarker = armorStand.isMarker();
        this.disabledSlots = CompatibilityUtils.getDisabledSlots(armorStand);
    }

    public EntityArmorStandData(ConfigurationSection parameters) {
        this.isSmall = parameters.getBoolean("small", false);
        this.isVisible = !parameters.getBoolean("invisible", false);
        this.hasBasePlate = !parameters.getBoolean("baseplate", true);
        this.hasGravity = parameters.getBoolean("gravity", true);
        this.isMarker = parameters.getBoolean("marker", false);
        this.hasArms = parameters.getBoolean("arms", false);
        this.disabledSlots = parameters.getInt("disabled_slots", 0);
    }

    @Override
    public void apply(Entity entity) {
        if (!(entity instanceof ArmorStand)) {
            return;
        }
        ArmorStand armorStand = (ArmorStand)entity;
        armorStand.setItemInHand(this.itemInHand);
        armorStand.setBoots(this.boots);
        armorStand.setLeggings(this.leggings);
        armorStand.setChestplate(this.chestplate);
        armorStand.setHelmet(this.helmet);
        if (this.bodyPose != null) {
            armorStand.setBodyPose(this.bodyPose);
        }
        if (this.leftArmPose != null) {
            armorStand.setLeftArmPose(this.leftArmPose);
        }
        if (this.rightArmPose != null) {
            armorStand.setRightArmPose(this.rightArmPose);
        }
        if (this.leftLegPose != null) {
            armorStand.setLeftLegPose(this.leftLegPose);
        }
        if (this.rightLegPose != null) {
            armorStand.setRightLegPose(this.rightLegPose);
        }
        if (this.headPose != null) {
            armorStand.setHeadPose(this.headPose);
        }
        armorStand.setGravity(this.hasGravity);
        armorStand.setVisible(this.isVisible);
        armorStand.setArms(this.hasArms);
        armorStand.setSmall(this.isSmall);
        armorStand.setBasePlate(this.hasBasePlate);
        armorStand.setMarker(this.isMarker);
        CompatibilityUtils.setDisabledSlots(armorStand, this.disabledSlots);
    }

    @Override
    public EntityExtraData clone() {
        EntityArmorStandData copy = new EntityArmorStandData();
        copy.itemInHand = this.itemInHand == null ? null : this.itemInHand.clone();
        copy.boots = this.boots == null ? null : this.boots.clone();
        copy.leggings = this.leggings == null ? null : this.leggings.clone();
        copy.chestplate = this.chestplate == null ? null : this.chestplate.clone();
        copy.helmet = this.helmet == null ? null : this.helmet.clone();
        copy.bodyPose = this.bodyPose == null ? null : new EulerAngle(this.bodyPose.getX(), this.bodyPose.getY(), this.bodyPose.getZ());
        copy.leftArmPose = this.leftArmPose == null ? null : new EulerAngle(this.leftArmPose.getX(), this.leftArmPose.getY(), this.leftArmPose.getZ());
        copy.rightArmPose = this.rightArmPose == null ? null : new EulerAngle(this.rightArmPose.getX(), this.rightArmPose.getY(), this.rightArmPose.getZ());
        copy.leftLegPose = this.leftLegPose == null ? null : new EulerAngle(this.leftLegPose.getX(), this.leftLegPose.getY(), this.leftLegPose.getZ());
        copy.rightLegPose = this.rightLegPose == null ? null : new EulerAngle(this.rightLegPose.getX(), this.rightLegPose.getY(), this.rightLegPose.getZ());
        copy.headPose = this.headPose == null ? null : new EulerAngle(this.headPose.getX(), this.headPose.getY(), this.headPose.getZ());
        copy.hasGravity = this.hasGravity;
        copy.isVisible = this.isVisible;
        copy.hasArms = this.hasArms;
        copy.isSmall = this.isSmall;
        copy.hasBasePlate = this.hasBasePlate;
        copy.isMarker = this.isMarker;
        copy.disabledSlots = this.disabledSlots;
        return copy;
    }

    @Override
    public void removed(Entity entity) {
        if (!(entity instanceof ArmorStand)) {
            return;
        }
        ArmorStand armorStand = (ArmorStand)entity;
        armorStand.setItemInHand(null);
        armorStand.setHelmet(null);
        armorStand.setChestplate(null);
        armorStand.setLeggings(null);
        armorStand.setBoots(null);
    }
}

