/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.block.ModifyType;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.block.BlockBanner;
import com.elmakers.mine.bukkit.block.BlockCommand;
import com.elmakers.mine.bukkit.block.BlockExtraData;
import com.elmakers.mine.bukkit.block.BlockMobSpawner;
import com.elmakers.mine.bukkit.block.BlockSign;
import com.elmakers.mine.bukkit.block.BlockSkull;
import com.elmakers.mine.bukkit.block.BlockTileEntity;
import com.elmakers.mine.bukkit.block.LeatherArmorData;
import com.elmakers.mine.bukkit.integration.VaultController;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.utility.SkinUtils;
import com.google.common.base.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.SkullType;
import org.bukkit.TreeSpecies;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CommandBlock;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.material.MaterialData;

public class MaterialAndData
implements com.elmakers.mine.bukkit.api.block.MaterialAndData {
    protected Material material;
    protected Short data;
    protected BlockExtraData extraData;
    protected boolean isValid = true;
    public static final Material DEFAULT_MATERIAL = Material.AIR;

    public MaterialAndData() {
        this.material = DEFAULT_MATERIAL;
        this.data = 0;
    }

    public MaterialAndData(Material material) {
        this.material = material;
        this.data = 0;
    }

    public MaterialAndData(Material material, short data) {
        this.material = material;
        this.data = data;
    }

    public MaterialAndData(ItemStack item) {
        ItemMeta meta;
        this.material = item.getType();
        this.data = item.getDurability();
        if (this.material == Material.SKULL_ITEM) {
            ItemMeta meta2 = item.getItemMeta();
            Object profile = InventoryUtils.getSkullProfile(meta2);
            SkullType skullType = SkullType.PLAYER;
            try {
                skullType = SkullType.values()[this.data];
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.extraData = new BlockSkull(profile, skullType);
        } else if (this.material == Material.STANDING_BANNER || this.material == Material.WALL_BANNER || this.material == Material.BANNER) {
            ItemMeta meta3 = item.getItemMeta();
            if (meta3 != null && meta3 instanceof BannerMeta) {
                BannerMeta banner = (BannerMeta)meta3;
                this.extraData = new BlockBanner(banner.getPatterns(), banner.getBaseColor());
            }
        } else if ((this.material == Material.LEATHER_BOOTS || this.material == Material.LEATHER_CHESTPLATE || this.material == Material.LEATHER_HELMET || this.material == Material.LEATHER_LEGGINGS) && (meta = item.getItemMeta()) != null && meta instanceof LeatherArmorMeta) {
            this.extraData = new LeatherArmorData(((LeatherArmorMeta)meta).getColor());
        }
    }

    public MaterialAndData(Block block) {
        this.updateFrom(block);
    }

    public MaterialAndData(com.elmakers.mine.bukkit.api.block.MaterialAndData other) {
        this.updateFrom(other);
    }

    public MaterialAndData(String materialKey) {
        this();
        this.update(materialKey);
    }

    public void update(String materialKey) {
        BlockExtraData extraData;
        Material material;
        Short data;
        block32: {
            if (materialKey == null || materialKey.length() == 0) {
                this.isValid = false;
                return;
            }
            String[] pieces = MaterialAndData.splitMaterialKey(materialKey);
            data = 0;
            material = null;
            extraData = null;
            try {
                if (pieces.length > 0 && !pieces[0].equals("*")) {
                    try {
                        Integer id = Integer.parseInt(pieces[0]);
                        material = DeprecatedUtils.getMaterial(id);
                    }
                    catch (Exception ex) {
                        material = Material.getMaterial((String)pieces[0].toUpperCase());
                    }
                }
            }
            catch (Exception ex) {
                material = null;
            }
            try {
                if (pieces.length <= 1) break block32;
                if (pieces[1].equals("*")) {
                    data = null;
                    break block32;
                }
                if (material == Material.MOB_SPAWNER) {
                    extraData = new BlockMobSpawner(pieces[1]);
                    break block32;
                }
                if (material == Material.SKULL_ITEM) {
                    if (pieces.length > 2) {
                        data = 3;
                        String dataString = pieces[1];
                        for (int i = 2; i < pieces.length; ++i) {
                            dataString = dataString + ":" + pieces[i];
                        }
                        ItemStack item = InventoryUtils.getURLSkull(dataString);
                        extraData = new BlockSkull(InventoryUtils.getSkullProfile(item.getItemMeta()), SkullType.PLAYER);
                    } else {
                        try {
                            data = Short.parseShort(pieces[1]);
                        }
                        catch (Exception ex) {
                            data = 3;
                            extraData = new BlockSkull(pieces[1]);
                        }
                    }
                    break block32;
                }
                if (material == Material.STANDING_BANNER || material == Material.WALL_BANNER || material == Material.BANNER) {
                    String[] color = null;
                    try {
                        short colorIndex = Short.parseShort(pieces[1]);
                        data = colorIndex;
                        color = DyeColor.values()[colorIndex];
                    }
                    catch (Exception ex) {
                        color = null;
                    }
                    if (color != null) {
                        extraData = new BlockBanner((DyeColor)color);
                    }
                    break block32;
                }
                if (material == Material.LEATHER_BOOTS || material == Material.LEATHER_CHESTPLATE || material == Material.LEATHER_HELMET || material == Material.LEATHER_LEGGINGS) {
                    StringUtils.split((String)pieces[1], (char)',');
                    for (String piece : pieces) {
                        if (piece.startsWith("#")) {
                            try {
                                Color color = Color.fromRGB((int)Integer.parseInt(piece.substring(1), 16));
                                extraData = new LeatherArmorData(color);
                            }
                            catch (Exception ex) {
                                extraData = null;
                            }
                            continue;
                        }
                        try {
                            data = Short.parseShort(pieces[1]);
                        }
                        catch (Exception ex) {
                            data = 0;
                        }
                    }
                    break block32;
                }
                try {
                    data = Short.parseShort(pieces[1]);
                }
                catch (Exception ex) {
                    data = 0;
                }
            }
            catch (Exception ex) {
                material = null;
            }
        }
        if (material == null) {
            this.setMaterial(null, null);
            this.isValid = false;
        } else {
            this.setMaterial(material, data);
        }
        if (this.isValid) {
            this.extraData = extraData;
        }
    }

    public int hashCode() {
        return (this.material == null ? -1 : this.material.getId() << 16) | (this.data == null ? -1 : (int)this.data.shortValue());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof com.elmakers.mine.bukkit.api.block.MaterialAndData)) {
            return false;
        }
        com.elmakers.mine.bukkit.api.block.MaterialAndData other = (com.elmakers.mine.bukkit.api.block.MaterialAndData)obj;
        return Objects.equal((Object)other.getData(), (Object)this.data) && other.getMaterial() == this.material;
    }

    @Override
    public void updateFrom(com.elmakers.mine.bukkit.api.block.MaterialAndData other) {
        this.material = other.getMaterial();
        this.data = other.getData();
        if (other instanceof MaterialAndData) {
            MaterialAndData o = (MaterialAndData)other;
            this.extraData = o.extraData != null ? o.extraData.clone() : null;
            this.isValid = o.isValid;
        }
    }

    @Override
    public void updateFrom(Block block) {
        this.updateFromBlock(block, null);
    }

    @Override
    public void setMaterial(Material material, short data) {
        this.setMaterial(material, (Short)data);
    }

    public void setMaterial(Material material, Short data) {
        this.material = material;
        this.data = data;
        this.extraData = null;
        this.isValid = true;
    }

    @Override
    public void setMaterial(Material material) {
        this.setMaterial(material, (short)0);
    }

    public void setMaterialId(int id) {
        this.material = Material.getMaterial((int)id);
    }

    public void updateFromBlock(Block block, @Nullable MaterialSet restrictedMaterials) {
        Material blockMaterial;
        if (block == null) {
            this.isValid = false;
            return;
        }
        if (!block.getChunk().isLoaded()) {
            block.getChunk().load(true);
            return;
        }
        if (restrictedMaterials != null && restrictedMaterials.testBlock(block)) {
            this.isValid = false;
            return;
        }
        this.extraData = null;
        this.material = blockMaterial = block.getType();
        this.data = block.getData();
        try {
            BlockState blockState = block.getState();
            if (this.material == Material.FLOWER_POT || blockState instanceof InventoryHolder || blockState instanceof Sign) {
                this.extraData = new BlockTileEntity(NMSUtils.getTileEntityData(block.getLocation()));
            } else if (blockState instanceof CommandBlock) {
                CommandBlock command = (CommandBlock)blockState;
                this.extraData = new BlockCommand(command.getCommand(), command.getName());
            } else if (blockState instanceof Skull) {
                Skull skull = (Skull)blockState;
                this.data = (short)skull.getSkullType().ordinal();
                this.extraData = new BlockSkull(InventoryUtils.getSkullProfile(skull), skull.getSkullType(), skull.getRotation());
            } else if (blockState instanceof CreatureSpawner) {
                CreatureSpawner spawner = (CreatureSpawner)blockState;
                this.extraData = new BlockMobSpawner(spawner.getCreatureTypeName());
            } else if ((blockMaterial == Material.STANDING_BANNER || blockMaterial == Material.WALL_BANNER) && blockState != null && blockState instanceof Banner) {
                Banner banner = (Banner)blockState;
                DyeColor color = banner.getBaseColor();
                this.extraData = new BlockBanner(banner.getPatterns(), color);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.isValid = true;
    }

    public static void clearItems(BlockState block) {
        if (block != null && (block instanceof InventoryHolder || block.getType() == Material.FLOWER_POT)) {
            NMSUtils.clearItems(block.getLocation());
        }
    }

    public void modifyFast(Block block) {
        short data;
        Material material = this.material == null ? block.getType() : this.material;
        short s = data = this.data == null ? block.getData() : this.data.shortValue();
        if (material != block.getType() || data != block.getData()) {
            CompatibilityUtils.setBlockFast(block, material, data);
        }
    }

    @Override
    public void modify(Block block) {
        this.modify(block, false);
    }

    @Override
    public void modify(Block block, ModifyType modifyType) {
        switch (modifyType) {
            case FAST: {
                this.modifyFast(block);
                break;
            }
            case NORMAL: {
                this.modify(block, true);
                break;
            }
            case NO_PHYSICS: {
                this.modify(block, false);
            }
        }
    }

    @Override
    public void modify(Block block, boolean applyPhysics) {
        if (!this.isValid) {
            return;
        }
        try {
            BlockState blockState = block.getState();
            if (this.material != null) {
                byte blockData;
                byte by = blockData = this.data != null ? (byte)this.data.shortValue() : block.getData();
                if (this.material == Material.AIR) {
                    MaterialAndData.clearItems(blockState);
                }
                block.setTypeIdAndData(this.material.getId(), blockData, applyPhysics);
                blockState = block.getState();
            }
            if (blockState != null && blockState instanceof CommandBlock && this.extraData != null && this.extraData instanceof BlockCommand) {
                CommandBlock command = (CommandBlock)blockState;
                BlockCommand commandData = (BlockCommand)this.extraData;
                command.setCommand(commandData.command);
                if (commandData.customName != null) {
                    command.setName(commandData.customName);
                }
                command.update();
            } else if (this.extraData != null && this.extraData instanceof BlockTileEntity) {
                NMSUtils.setTileEntityData(block.getLocation(), ((BlockTileEntity)this.extraData).data);
            } else if (blockState != null && (this.material == Material.STANDING_BANNER || this.material == Material.WALL_BANNER) && this.extraData != null && this.extraData instanceof BlockBanner) {
                if (blockState instanceof Banner) {
                    BlockBanner bannerData = (BlockBanner)this.extraData;
                    Banner banner = (Banner)blockState;
                    if (bannerData.patterns != null) {
                        banner.setPatterns(bannerData.patterns);
                    }
                    if (bannerData.baseColor != null) {
                        banner.setBaseColor(bannerData.baseColor);
                    }
                }
                blockState.update(true, false);
            } else if (blockState != null && blockState instanceof Skull && this.extraData != null && this.extraData instanceof BlockSkull) {
                Skull skull = (Skull)blockState;
                BlockSkull skullData = (BlockSkull)this.extraData;
                if (skullData.skullType != null) {
                    skull.setSkullType(skullData.skullType);
                }
                if (skullData.rotation != null) {
                    skull.setRotation(skullData.rotation);
                }
                if (skullData.profile != null) {
                    InventoryUtils.setSkullProfile(skull, skullData.profile);
                } else if (skullData.playerName != null) {
                    skull.setOwner(skullData.playerName);
                }
                skull.update(true, false);
            } else if (blockState != null && blockState instanceof CreatureSpawner && this.extraData != null && this.extraData instanceof BlockMobSpawner) {
                BlockMobSpawner spawnerData = (BlockMobSpawner)this.extraData;
                if (spawnerData.mobName != null && !spawnerData.mobName.isEmpty()) {
                    CreatureSpawner spawner = (CreatureSpawner)blockState;
                    spawner.setCreatureTypeByName(spawnerData.mobName);
                    spawner.update();
                }
            } else if (blockState != null && blockState instanceof Sign && this.extraData != null && this.extraData instanceof BlockSign) {
                BlockSign signData = (BlockSign)this.extraData;
                Sign sign = (Sign)blockState;
                for (int i = 0; i < signData.lines.length; ++i) {
                    sign.setLine(i, signData.lines[i]);
                }
                sign.update();
            }
        }
        catch (Exception ex) {
            Bukkit.getLogger().warning("[Magic] Error updating block state");
            ex.printStackTrace();
        }
    }

    @Override
    public Short getData() {
        return this.data;
    }

    @Override
    @Nullable
    public Byte getBlockData() {
        return this.data == null ? null : Byte.valueOf((byte)this.data.shortValue());
    }

    @Override
    public Material getMaterial() {
        return this.material;
    }

    @Override
    public String getKey() {
        return this.getKey(this.data);
    }

    public String getKey(Short data) {
        String materialKey;
        String string = materialKey = this.material == null ? "*" : this.material.name().toLowerCase();
        if (data == null) {
            materialKey = materialKey + ":*";
        } else if (this.material == Material.SKULL_ITEM && this.extraData != null && this.extraData instanceof BlockSkull) {
            BlockSkull skullData = (BlockSkull)this.extraData;
            materialKey = skullData.playerName != null ? materialKey + ":" + skullData.playerName : materialKey + ":" + SkinUtils.getProfileURL(skullData.profile);
        } else if (this.material == Material.MOB_SPAWNER && this.extraData != null && this.extraData instanceof BlockMobSpawner) {
            BlockMobSpawner spawnerData = (BlockMobSpawner)this.extraData;
            if (spawnerData.mobName != null && !spawnerData.mobName.isEmpty()) {
                materialKey = materialKey + ":" + spawnerData.mobName;
            }
        } else if ((this.material == Material.STANDING_BANNER || this.material == Material.WALL_BANNER || this.material == Material.BANNER) && this.extraData != null && this.extraData instanceof BlockBanner && ((BlockBanner)this.extraData).baseColor != null) {
            materialKey = materialKey + ":" + ((BlockBanner)this.extraData).baseColor.ordinal();
        } else if (this.material == Material.LEATHER_BOOTS || this.material == Material.LEATHER_CHESTPLATE || this.material == Material.LEATHER_HELMET || this.material == Material.LEATHER_LEGGINGS) {
            if (data != 0) {
                materialKey = materialKey + ":" + data;
            }
            if (this.extraData != null && this.extraData instanceof LeatherArmorData) {
                Color color = ((LeatherArmorData)this.extraData).getColor();
                materialKey = data != 0 ? materialKey + ",#" + Integer.toHexString(color.asRGB()) : materialKey + ":#" + Integer.toHexString(color.asRGB());
            }
        } else if (data != 0) {
            materialKey = materialKey + ":" + data;
        }
        return materialKey;
    }

    public String getWildDataKey() {
        return this.getKey(null);
    }

    @Override
    public boolean is(Block block) {
        return this.material == block.getType() && this.data.shortValue() == block.getData();
    }

    @Override
    public boolean isDifferent(Block block) {
        CommandBlock command;
        Material blockMaterial = block.getType();
        byte blockData = block.getData();
        if (this.material != null && blockMaterial != this.material || this.data != null && blockData != this.data) {
            return true;
        }
        if (this.material == Material.WALL_BANNER || this.material == Material.STANDING_BANNER) {
            return true;
        }
        BlockState blockState = block.getState();
        if (blockState instanceof Sign) {
            return true;
        }
        return blockState instanceof CommandBlock && this.extraData != null && this.extraData instanceof BlockCommand ? !(command = (CommandBlock)blockState).getCommand().equals(((BlockCommand)this.extraData).command) : blockState instanceof InventoryHolder;
    }

    @Override
    @Nullable
    public ItemStack getItemStack(int amount) {
        if (this.material == null) {
            return null;
        }
        this.convertToItemStackMaterial();
        ItemStack stack = new ItemStack(this.material, amount, this.data == null ? (short)0 : this.data);
        this.applyToItem(stack);
        return stack;
    }

    private Material convertToItemStackMaterial() {
        switch (this.material) {
            case SKULL: {
                this.material = Material.SKULL_ITEM;
                return this.material;
            }
            case WALL_BANNER: {
                this.material = Material.BANNER;
                return this.material;
            }
            case STANDING_BANNER: {
                this.material = Material.BANNER;
                return this.material;
            }
            case WOODEN_DOOR: {
                this.material = Material.WOOD_DOOR;
                return this.material;
            }
            case IRON_DOOR_BLOCK: {
                this.material = Material.IRON_DOOR;
                return this.material;
            }
            case WALL_SIGN: {
                this.material = Material.SIGN;
                return this.material;
            }
            case SIGN_POST: {
                this.material = Material.SIGN;
                return this.material;
            }
            case ACACIA_DOOR: {
                this.material = Material.ACACIA_DOOR_ITEM;
                return this.material;
            }
            case JUNGLE_DOOR: {
                this.material = Material.JUNGLE_DOOR_ITEM;
                return this.material;
            }
            case DARK_OAK_DOOR: {
                this.material = Material.DARK_OAK_DOOR_ITEM;
                return this.material;
            }
            case BIRCH_DOOR: {
                this.material = Material.BIRCH_DOOR_ITEM;
                return this.material;
            }
            case SPRUCE_DOOR: {
                this.material = Material.SPRUCE_DOOR_ITEM;
                return this.material;
            }
        }
        return this.material;
    }

    @Override
    public ItemStack applyToItem(ItemStack stack) {
        stack.setType(this.material);
        if (this.data != null) {
            stack.setDurability(this.data.shortValue());
        }
        if (this.material == Material.SKULL_ITEM) {
            ItemMeta meta = stack.getItemMeta();
            if (meta != null && meta instanceof SkullMeta && this.extraData != null && this.extraData instanceof BlockSkull) {
                BlockSkull skullData = (BlockSkull)this.extraData;
                if (skullData.skullType == SkullType.PLAYER && skullData.profile != null) {
                    SkullMeta skullMeta = (SkullMeta)meta;
                    InventoryUtils.setSkullProfile((ItemMeta)skullMeta, ((BlockSkull)this.extraData).profile);
                    stack.setItemMeta(meta);
                } else if (skullData.skullType == SkullType.PLAYER && skullData.playerName != null) {
                    SkullMeta skullMeta = (SkullMeta)meta;
                    skullMeta.setOwner(skullData.playerName);
                    stack.setItemMeta(meta);
                }
            }
        } else if (this.material == Material.STANDING_BANNER || this.material == Material.WALL_BANNER || this.material == Material.BANNER) {
            ItemMeta meta = stack.getItemMeta();
            if (meta != null && meta instanceof BannerMeta && this.extraData != null && this.extraData instanceof BlockBanner) {
                BannerMeta banner = (BannerMeta)meta;
                BlockBanner bannerData = (BlockBanner)this.extraData;
                if (bannerData.patterns != null) {
                    banner.setPatterns(bannerData.patterns);
                }
                if (bannerData.baseColor != null) {
                    banner.setBaseColor(bannerData.baseColor);
                }
                stack.setItemMeta(meta);
            }
        } else if (this.material == Material.LEATHER_BOOTS || this.material == Material.LEATHER_CHESTPLATE || this.material == Material.LEATHER_HELMET || this.material == Material.LEATHER_LEGGINGS) {
            ItemMeta meta = stack.getItemMeta();
            if (this.extraData != null && this.extraData instanceof LeatherArmorData && meta != null && meta instanceof LeatherArmorMeta) {
                ((LeatherArmorMeta)meta).setColor(((LeatherArmorData)this.extraData).getColor());
                stack.setItemMeta(meta);
            }
        }
        return stack;
    }

    public static String[] splitMaterialKey(String materialKey) {
        if (materialKey.contains("|")) {
            return StringUtils.split((String)materialKey, (String)"|", (int)3);
        }
        if (materialKey.contains(":")) {
            return StringUtils.split((String)materialKey, (String)":", (int)3);
        }
        return new String[]{materialKey};
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public static String getMaterialName(ItemStack item) {
        MaterialAndData material = new MaterialAndData(item);
        return material.getName();
    }

    public static String getMaterialName(Block block) {
        MaterialAndData material = new MaterialAndData(block);
        return material.getName();
    }

    @Override
    @Nullable
    public String getBaseName() {
        if (this.material == null) {
            return null;
        }
        return this.material.name().toLowerCase().replace('_', ' ');
    }

    @Override
    public String getName() {
        return this.getName(null);
    }

    @Override
    public String getName(Messages messages) {
        if (!this.isValid()) {
            return "";
        }
        VaultController controller = VaultController.getInstance();
        if (controller != null && this.data != null) {
            try {
                String vaultName = controller.getItemName(this.material, this.data);
                if (vaultName != null && !vaultName.isEmpty()) {
                    return vaultName;
                }
            }
            catch (Throwable vaultName) {
                // empty catch block
            }
        }
        String materialName = this.material.name();
        if (this.data != null) {
            DyeColor color;
            if (this.material == Material.CARPET || this.material == Material.STAINED_GLASS || this.material == Material.STAINED_CLAY || this.material == Material.STAINED_GLASS_PANE || this.material == Material.WOOL) {
                DyeColor color2 = DyeColor.getByWoolData((byte)((byte)this.data.shortValue()));
                if (color2 != null) {
                    materialName = color2.name().toLowerCase().replace('_', ' ') + " " + materialName;
                }
            } else if (this.material == Material.WOOD || this.material == Material.LOG || this.material == Material.SAPLING || this.material == Material.LEAVES || this.material == Material.LOG_2 || this.material == Material.LEAVES_2) {
                TreeSpecies treeSpecies = TreeSpecies.getByData((byte)((byte)this.data.shortValue()));
                if (treeSpecies != null) {
                    materialName = treeSpecies.name().toLowerCase().replace('_', ' ') + " " + materialName;
                }
            } else if (this.material == Material.MOB_SPAWNER && this.extraData != null && this.extraData instanceof BlockMobSpawner) {
                BlockMobSpawner spawnerData = (BlockMobSpawner)this.extraData;
                if (spawnerData.mobName != null && !spawnerData.mobName.isEmpty()) {
                    materialName = materialName + " (" + spawnerData.mobName + ")";
                }
            } else if ((this.material == Material.STANDING_BANNER || this.material == Material.WALL_BANNER || this.material == Material.BANNER) && this.extraData != null && this.extraData instanceof BlockBanner && (color = ((BlockBanner)this.extraData).baseColor) != null) {
                materialName = color.name().toLowerCase() + " " + materialName;
            }
        } else if (messages != null) {
            materialName = materialName + messages.get("material.wildcard");
        }
        materialName = materialName.toLowerCase().replace('_', ' ');
        return materialName;
    }

    @Override
    public void setCustomName(String customName) {
        if (this.extraData != null && this.extraData instanceof BlockCommand) {
            ((BlockCommand)this.extraData).customName = customName;
        } else {
            this.extraData = new BlockCommand(null, customName);
        }
    }

    @Override
    public void setCommandLine(String command) {
        if (this.extraData != null && this.extraData instanceof BlockCommand) {
            ((BlockCommand)this.extraData).command = command;
        } else {
            this.extraData = new BlockCommand(command);
        }
    }

    @Override
    @Nullable
    public String getCommandLine() {
        if (this.extraData != null && this.extraData instanceof BlockCommand) {
            return ((BlockCommand)this.extraData).command;
        }
        return null;
    }

    @Override
    public void setData(Short data) {
        this.data = data;
    }

    @Override
    public void setRawData(Object data) {
        this.extraData = this.material == Material.SIGN_POST || this.material == Material.WALL_SIGN ? new BlockSign(data) : new BlockTileEntity(data);
    }

    public String toString() {
        return this.isValid() ? this.material + (this.data != 0 ? "@" + this.data : "") : "invalid";
    }

    @Override
    @Nullable
    public MaterialData getMaterialData() {
        if (this.material == null) {
            return null;
        }
        byte dataByte = this.data == null ? (byte)0 : (byte)this.data.shortValue();
        return new MaterialData(this.material, dataByte);
    }
}

