/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.block.BoundingBox;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public class BlockList
implements com.elmakers.mine.bukkit.api.block.BlockList {
    protected BoundingBox area;
    @Nullable
    protected String worldName;
    protected Deque<com.elmakers.mine.bukkit.api.block.BlockData> blockList;
    protected HashSet<Long> blockIdMap;

    public BlockList() {
    }

    public BlockList(BlockList other) {
        this.worldName = other.worldName;
        for (com.elmakers.mine.bukkit.api.block.BlockData block : other) {
            BlockData newBlock = new BlockData(block);
            this.add(newBlock);
        }
    }

    @Override
    public boolean add(Block block) {
        if (this.contains(block)) {
            return false;
        }
        BlockData newBlock = new BlockData(block);
        return this.add(newBlock);
    }

    @Override
    public boolean add(com.elmakers.mine.bukkit.api.block.BlockData blockData) {
        if (!this.contain(blockData)) {
            return false;
        }
        if (this.blockIdMap == null) {
            this.blockIdMap = new HashSet();
        }
        if (this.blockList == null) {
            this.blockList = new ArrayDeque<com.elmakers.mine.bukkit.api.block.BlockData>();
        }
        this.blockIdMap.add(blockData.getId());
        this.blockList.addLast(blockData);
        return true;
    }

    public boolean contain(com.elmakers.mine.bukkit.api.block.BlockData blockData) {
        if (this.contains(blockData)) {
            return false;
        }
        if (this.worldName != null && !this.worldName.equals(blockData.getWorldName())) {
            return false;
        }
        if (this.worldName == null || this.worldName.length() == 0) {
            this.worldName = blockData.getWorldName();
        }
        BlockVector blockLocation = blockData.getPosition();
        this.contain((Vector)blockLocation);
        return true;
    }

    @Override
    public void contain(Vector vector) {
        if (this.area == null) {
            this.area = new BoundingBox(vector, vector);
        } else {
            this.area.contain(vector);
        }
    }

    @Override
    public boolean addAll(Collection<? extends com.elmakers.mine.bukkit.api.block.BlockData> blocks) {
        boolean added = true;
        for (com.elmakers.mine.bukkit.api.block.BlockData blockData : blocks) {
            added = added && this.add(blockData);
        }
        return added;
    }

    @Override
    public void clear() {
        if (this.blockIdMap != null) {
            this.blockIdMap.clear();
        }
        if (this.blockList == null) {
            return;
        }
        this.blockList.clear();
    }

    @Override
    public boolean contains(Block block) {
        if (this.blockIdMap == null) {
            return false;
        }
        return this.blockIdMap.contains(BlockData.getBlockId(block));
    }

    public boolean contains(com.elmakers.mine.bukkit.api.block.BlockData blockData) {
        if (this.blockIdMap == null || blockData == null) {
            return false;
        }
        return this.blockIdMap.contains(blockData.getId());
    }

    @Override
    public boolean contains(Object arg0) {
        if (arg0 instanceof Block) {
            return this.contains((Block)arg0);
        }
        if (arg0 instanceof com.elmakers.mine.bukkit.api.block.BlockData) {
            return this.contains((com.elmakers.mine.bukkit.api.block.BlockData)arg0);
        }
        return this.blockIdMap == null ? false : this.blockIdMap.contains(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        if (this.blockIdMap == null) {
            return false;
        }
        return this.blockIdMap.containsAll(arg0);
    }

    @Override
    public BoundingBox getArea() {
        return this.area;
    }

    public Collection<com.elmakers.mine.bukkit.api.block.BlockData> getBlockList() {
        return this.blockList;
    }

    @Override
    public int size() {
        return this.blockList == null ? 0 : this.blockList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.blockList == null || this.blockList.isEmpty();
    }

    @Override
    public Iterator<com.elmakers.mine.bukkit.api.block.BlockData> iterator() {
        if (this.blockList == null) {
            return Collections.emptyList().iterator();
        }
        return this.blockList.iterator();
    }

    @Override
    public boolean remove(Object removeObject) {
        if (this.blockList == null) {
            return false;
        }
        if (removeObject instanceof com.elmakers.mine.bukkit.api.block.BlockData) {
            this.blockIdMap.remove(((com.elmakers.mine.bukkit.api.block.BlockData)removeObject).getId());
        }
        return this.blockList.remove(removeObject);
    }

    @Override
    public boolean removeAll(Collection<?> removeCollection) {
        if (this.blockList == null) {
            return false;
        }
        for (Object removeObject : removeCollection) {
            if (!(removeObject instanceof com.elmakers.mine.bukkit.api.block.BlockData)) continue;
            this.blockIdMap.remove(((com.elmakers.mine.bukkit.api.block.BlockData)removeObject).getId());
        }
        return this.blockList.removeAll(removeCollection);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        if (this.blockList == null) {
            return false;
        }
        return this.blockList.retainAll(arg0);
    }

    public void setArea(BoundingBox area) {
        this.area = area;
    }

    public void setBlockList(Collection<com.elmakers.mine.bukkit.api.block.BlockData> blockList) {
        this.blockList = null;
        if (blockList != null) {
            this.blockList = new ArrayDeque<com.elmakers.mine.bukkit.api.block.BlockData>(blockList);
            this.blockIdMap = new HashSet();
            for (com.elmakers.mine.bukkit.api.block.BlockData block : blockList) {
                this.blockIdMap.add(block.getId());
            }
        }
    }

    @Override
    @Nullable
    public Object[] toArray() {
        if (this.blockList == null) {
            return null;
        }
        return this.blockList.toArray();
    }

    @Override
    @Nullable
    public <T> T[] toArray(T[] arg0) {
        if (this.blockList == null) {
            return null;
        }
        return this.blockList.toArray(arg0);
    }

    @Override
    public void load(ConfigurationSection node) {
        this.worldName = node.getString("world");
        List blockData = node.getStringList("blocks");
        if (blockData != null) {
            for (String blockString : blockData) {
                BlockData deserialized = BlockData.fromString(blockString);
                if (this.worldName == null) {
                    this.worldName = deserialized.getWorldName();
                }
                this.add(deserialized);
            }
        }
    }

    @Override
    public void save(ConfigurationSection node) {
        node.set("world", (Object)this.worldName);
        ArrayList<String> blockData = new ArrayList<String>();
        if (this.blockList != null) {
            for (com.elmakers.mine.bukkit.api.block.BlockData block : this.blockList) {
                blockData.add(block.toString());
            }
            node.set("blocks", blockData);
        }
    }

    @Override
    @Nullable
    public String getWorldName() {
        return this.worldName;
    }
}

